/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.AbstractApVerifyService;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class ApPurinVerifyService
extends AbstractApVerifyService {
    protected List<BillVerifyVO> getMainListVO(DynamicObject[] mains) {
        ArrayList<BillVerifyVO> mainList = new ArrayList<BillVerifyVO>();
        HashMap<String, BigDecimal> unitrateCache = new HashMap<String, BigDecimal>();
        for (DynamicObject main : mains) {
            BigDecimal mainAmount = BigDecimal.ZERO;
            DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection("billentry");
            for (DynamicObject mainEntry : mainEntrys) {
                mainAmount = mainAmount.add(mainEntry.getBigDecimal("amount"));
            }
            for (DynamicObject mainEntry : mainEntrys) {
                if (BigDecimal.ZERO.compareTo(mainEntry.getBigDecimal("unverifyqty")) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(main.getLong("id"));
                vo.setOrgId(mainEntry.getLong("entrysettleorg.id"));
                vo.setBillNo(main.getString("billno"));
                vo.setCurrencyId(main.getLong("settlecurrency.id"));
                vo.setBillType(main.getDataEntityType().getName());
                vo.setBizdate(main.getDate("biztime"));
                vo.setPayableAmt(mainAmount);
                vo.setAsstActType("bd_supplier");
                Long entrySupplierId = mainEntry.getLong("invoicesupplier.id");
                if (entrySupplierId == null || entrySupplierId == 0L) {
                    vo.setAsstActId(main.getLong("supplier.id"));
                } else {
                    vo.setAsstActId(entrySupplierId.longValue());
                }
                long entryId = mainEntry.getLong("id");
                vo.setEntryId(entryId);
                BigDecimal amount = mainEntry.getBigDecimal("amount");
                vo.setEntryPayableAmt(amount);
                vo.setEntryUnSettleAmt(amount);
                vo.setEntryMaterialId(mainEntry.getLong("material.masterid.id"));
                String key = vo.getEntryMaterialId() + "-" + mainEntry.getLong("unit.id") + "-" + mainEntry.getLong("baseunit.id");
                BigDecimal unitrate = BigDecimal.ONE;
                BigDecimal target = (BigDecimal)unitrateCache.get(key);
                if (target != null) {
                    unitrate = target;
                } else {
                    unitrate = UnitConvertHelper.getUnitRateConv((Long)vo.getEntryMaterialId(), (Long)mainEntry.getLong("unit.id"), (Long)mainEntry.getLong("baseunit.id"));
                    unitrateCache.put(key, unitrate);
                }
                vo.setUnitCoefficient(unitrate);
                BigDecimal qty = mainEntry.getBigDecimal("qty");
                vo.setEntryQty(qty);
                vo.setPrice(mainEntry.getBigDecimal("actualprice"));
                vo.setEntryMeasureUnitId(mainEntry.getLong("unit.id"));
                vo.setEntryMeasureUnit(mainEntry.getDynamicObject("unit"));
                vo.setEntryBaseUnitId(mainEntry.getLong("baseunit.id"));
                vo.setEntryBaseUnit(mainEntry.getDynamicObject("baseunit"));
                vo.setBaseUnitQty(mainEntry.getBigDecimal("baseqty"));
                vo.setEntryUnSettleQty(mainEntry.getBigDecimal("unverifyqty"));
                vo.setPresent(mainEntry.getBoolean("ispresent"));
                vo.setBaseCurrencyId(main.getLong("currency.id"));
                vo.setQuotation(main.getString("quotation"));
                vo.setExchangeRate(main.getBigDecimal("exchangerate"));
                vo.setEntryCoreBillNum(mainEntry.getString("mainbillnumber"));
                vo.setEntryCoreBillseq(mainEntry.getString("mainbillentryseq"));
                vo.setPriceTax(mainEntry.getBigDecimal("actualtaxprice"));
                vo.setPrecision(Integer.valueOf(main.getInt("settlecurrency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(main.getInt("currency.amtprecision")));
                vo.setEntryEntityName(mainEntry.getDataEntityType().getName());
                vo.setEntryMaterialVersion(mainEntry.getLong("mversion.id"));
                vo.setEntryMaterialSpecType(mainEntry.getString("material.masterid.modelnum") != null ? mainEntry.getString("material.masterid.modelnum") : "");
                vo.setEntryMaterialAuxProp(mainEntry.getString("auxpty") != null ? mainEntry.getString("auxpty") : "");
                vo.setEntryMaterialConfigNumber(mainEntry.getLong("configuredcode.id"));
                vo.setEntryMaterialTrackNumber(mainEntry.getLong("tracknumber.id"));
                mainList.add(vo);
            }
        }
        return mainList;
    }

    protected void disposeMainBill(List<VerifyRecordVO> voList, SettleSchemeVO scheme) {
        if (voList != null && voList.size() > 0) {
            VerifyRecordVO verifyRecordVO;
            VerifyRecordEntryVO verifyRecordEntryVO;
            Long asstBillId;
            Map upBillMaps;
            if (!scheme.isSettle() && (upBillMaps = BOTPHelper.loadNearUpBillIds((String)"ap_finapbill", (String)"im_purinbill", (Long[])new Long[]{asstBillId = Long.valueOf((verifyRecordEntryVO = (VerifyRecordEntryVO)(verifyRecordVO = voList.get(0)).getVrEntrys().get(0)).getBillId())})) != null && upBillMaps.size() > 0) {
                scheme.setOnlyByBotp(true);
            }
            ArrayList<Map<String, Object>> disposeList = new ArrayList<Map<String, Object>>(voList.size());
            for (VerifyRecordVO vo : voList) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("entity", vo.getBillType());
                rowMap.put("orgid", vo.getOrgId());
                rowMap.put("pk", vo.getMainBillId());
                rowMap.put("entrypk", vo.getMainBillEntryId());
                rowMap.put("measureunit", vo.getMeasureunitId());
                rowMap.put("verifyqty", vo.getVerifyQty());
                rowMap.put("verifybaseqty", vo.getVerifyBaseQty());
                boolean needDisposeRemain = !VerifyModeEnum.AUTO.getValue().equals(vo.getSettleType());
                rowMap.put("needDisposeRemain", needDisposeRemain);
                rowMap.put("verifyrelation", this.getSettleRelation());
                rowMap.put("verifytype", vo.getSettleType());
                rowMap.put("verifyamt", vo.getVerifyAmt());
                rowMap.put("isbotp", scheme.isOnlyByBotp());
                List vrEntrys = vo.getVrEntrys();
                ArrayList asstDataList = new ArrayList(vrEntrys.size());
                if (scheme.isRedVerifyRecord()) {
                    rowMap.put("iswrittenoffverify", Boolean.TRUE);
                } else {
                    rowMap.put("iswrittenoffverify", Boolean.FALSE);
                }
                for (VerifyRecordEntryVO entryVO : vrEntrys) {
                    HashMap<String, Object> asstData = new HashMap<String, Object>();
                    asstData.put("asstentity", entryVO.getBillType());
                    asstData.put("asstentrypk", entryVO.getBillEntryId());
                    asstData.put("asstmeasureunit", entryVO.getMeasureunitId());
                    asstData.put("asstverifyqty", entryVO.getVerifyQty());
                    asstData.put("asstverifybaseqty", entryVO.getVerifyBaseQty());
                    asstDataList.add(asstData);
                }
                rowMap.put("asstdata", asstDataList);
                disposeList.add(rowMap);
            }
            if (this.getSettleRelation().equals(VerifyRelationEnum.APOMIN.getValue()) || this.getSettleRelation().equals(VerifyRelationEnum.APOMINRETURN.getValue()) || this.getSettleRelation().equals(VerifyRelationEnum.OMINSELF.getValue())) {
                VerifyServiceHelper.invokeDisposeMdc(disposeList, scheme.isSettle());
            } else {
                VerifyServiceHelper.invokeDisposeScmc(voList, disposeList, scheme);
                VerifyServiceHelper.invokeDisposeScm(disposeList, scheme);
            }
        }
    }

    protected String getSettleRelation() {
        return VerifyRelationEnum.APPURIN.getValue();
    }
}

