/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.verify.ApPurManualVrifyService;
import kd.fi.ap.vo.ManualVerifyParam;
import kd.fi.arapcommon.vo.BillVerifyVO;

public class ApSelfManualVerifyService
extends ApPurManualVrifyService {
    @Override
    protected List<BillVerifyVO> getMainVOList(DynamicObject[] mainRows, ManualVerifyParam manualParam) {
        ArrayList<BillVerifyVO> mainList = new ArrayList<BillVerifyVO>();
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("main_id"));
            mainEntryIdSet.add(main.getLong("main_entryid"));
        }
        String selector = "id,asstacttype,detailentry.id,detailentry.e_pricetaxtotal,detailentry.quantity,detailentry.e_baseunitqty,detailentry.unverifyquantity,detailentry.e_unverifyamount,detailentry.ispresent,detailentry.actpricetax";
        DataSet mainDS = QueryServiceHelper.queryDataSet((String)"manual_reloadmain", (String)"ap_finapbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIdSet), new QFilter("detailentry.id", "in", mainEntryIdSet), new QFilter("billstatus", "=", (Object)"C")}, (String)"bizdate,detailentry.material");
        if (mainDS.hasNext()) {
            for (Row dataSetRow : mainDS) {
                for (DynamicObject mainRow : mainRows) {
                    long entryId = mainRow.getLong("main_entryid");
                    if (entryId != dataSetRow.getLong("detailentry.id")) continue;
                    BillVerifyVO vo = new BillVerifyVO();
                    vo.setOrgId(manualParam.getOrgId());
                    vo.setAsstActType("bd_supplier");
                    vo.setAsstActId(manualParam.getSupplierId());
                    vo.setEntryId(entryId);
                    vo.setBillType("ap_finapbill");
                    vo.setId(mainRow.getLong("main_id"));
                    vo.setBillNo(mainRow.getString("main_billno"));
                    vo.setBizdate(mainRow.getDate("main_bizdate"));
                    vo.setCurrencyId(mainRow.getLong("main_currency.id"));
                    vo.setEntryUnSettleAmt(mainRow.getBigDecimal("main_curverifyamt"));
                    vo.setEntryMaterialId(mainRow.getLong("main_material.id"));
                    vo.setEntryMeasureUnitId(mainRow.getLong("main_measureunit.id"));
                    vo.setEntryMeasureUnit(mainRow.getDynamicObject("main_measureunit"));
                    vo.setEntryBaseUnitId(mainRow.getLong("main_baseunit.id"));
                    vo.setEntryBaseUnit(mainRow.getDynamicObject("main_baseunit"));
                    vo.setUnitCoefficient(mainRow.getBigDecimal("main_convertrate"));
                    vo.setPrice(mainRow.getBigDecimal("main_unitprice"));
                    vo.setEntryUnSettleQty(mainRow.getBigDecimal("main_curverifyamt"));
                    vo.setEntryPayableAmt(dataSetRow.getBigDecimal("detailentry.e_pricetaxtotal"));
                    vo.setEntryQty(dataSetRow.getBigDecimal("detailentry.quantity"));
                    vo.setBaseUnitQty(dataSetRow.getBigDecimal("detailentry.e_baseunitqty"));
                    BigDecimal curVerifyQty = mainRow.getBigDecimal("main_curverifyqty");
                    BigDecimal remainQty = dataSetRow.getBigDecimal("detailentry.unverifyquantity");
                    if (remainQty.abs().compareTo(curVerifyQty.abs()) < 0) {
                        curVerifyQty = remainQty;
                    }
                    vo.setEntryUnSettleQty(curVerifyQty);
                    vo.setPresent(dataSetRow.getBoolean("detailentry.ispresent").booleanValue());
                    vo.setQuotation(mainRow.getString("main_quotation"));
                    vo.setExchangeRate(mainRow.getBigDecimal("main_exchangerate"));
                    vo.setBaseCurrencyId(mainRow.getLong("main_basecurrency.id"));
                    vo.setPriceTax(dataSetRow.getBigDecimal("detailentry.actpricetax"));
                    vo.setPrecision(Integer.valueOf(mainRow.getInt("main_currency.amtprecision")));
                    vo.setBasePrecision(Integer.valueOf(mainRow.getInt("main_basecurrency.amtprecision")));
                    vo.setEntryEntityName(mainRow.getDataEntityType().getName());
                    vo.setEntryMaterialVersion(mainRow.getLong("main_materialversion.id"));
                    vo.setEntryMaterialSpecType(mainRow.getString("main_modelnum"));
                    vo.setEntryMaterialAuxProp(mainRow.getString("main_assistantattr"));
                    vo.setEntryMaterialConfigNumber(mainRow.getLong("main_configuredcode.id"));
                    vo.setEntryMaterialTrackNumber(mainRow.getLong("main_tracknumber.id"));
                    mainList.add(vo);
                }
            }
        }
        return mainList;
    }
}

