/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.ApPurinVerifyService;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class PurSelfVerifyService
extends ApPurinVerifyService {
    public void autoVerifyById(List<Long> mainIds, List<Long> asstIds) {
        logger.info("PurSelfVerifyService-autoVerifyById");
        if (mainIds == null || mainIds.size() == 0 || asstIds == null || asstIds.size() == 0) {
            this.addLogInfo("mainIds or asstIds is null");
            return;
        }
        DynamicObject[] mainBills = BusinessDataServiceHelper.load((String)"im_purinbill", (String)VerifyServiceHelper.getPurSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", mainIds), new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE)});
        DynamicObject[] asstBills = BusinessDataServiceHelper.load((String)"im_purinbill", (String)VerifyServiceHelper.getPurSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds), new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE)});
        if (mainBills == null || asstBills == null || mainBills.length == 0 || asstBills.length == 0) {
            this.addLogInfo("mainBills or asstBills is logisticsbill");
            return;
        }
        try (TXHandle tx = TX.required((String)"PurSelf-autoVerifyById");){
            CommonVerifyServiceHelper.verifyAddMutexCtrlInTX(new HashSet<Long>(mainIds), (String)"im_purinbill", new HashSet<Long>(asstIds), (String)"im_purinbill", (boolean)false);
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setOnlyByBotp(true);
            this.addLogInfo(mainBills[0].getPkValue() + " " + asstBills[0].getPkValue());
            this.verify(mainBills, asstBills, scheme, VerifyModeEnum.AUTO.getValue());
        }
    }

    @Deprecated
    public void autoVerify(DynamicObject[] mains, DynamicObject[] assts) {
        logger.info("PurSelfVerifyService-autoVerify");
        if (mains == null || assts == null || mains.length == 0 || assts.length == 0) {
            this.addLogInfo("mains or assts is null");
            return;
        }
        List<Long> mainIds = Arrays.stream(mains).map(main -> main.getLong("id")).collect(Collectors.toList());
        List<Long> asstIds = Arrays.stream(assts).map(asst -> asst.getLong("id")).collect(Collectors.toList());
        this.autoVerifyById(mainIds, asstIds);
    }

    @Override
    protected List<BillVerifyVO> getMainListVO(DynamicObject[] mains) {
        ArrayList<BillVerifyVO> mainList = new ArrayList<BillVerifyVO>();
        HashMap<String, BigDecimal> unitrateCache = new HashMap<String, BigDecimal>();
        for (DynamicObject main : mains) {
            BigDecimal mainAmount = BigDecimal.ZERO;
            DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection("billentry");
            for (DynamicObject mainEntry : mainEntrys) {
                mainAmount = mainAmount.add(mainEntry.getBigDecimal("amount"));
            }
            for (DynamicObject mainEntry : mainEntrys) {
                if (BigDecimal.ZERO.compareTo(mainEntry.getBigDecimal("unverifyqty")) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(main.getLong("id"));
                vo.setOrgId(mainEntry.getLong("entrysettleorg.id"));
                vo.setBillNo(main.getString("billno"));
                vo.setCurrencyId(main.getLong("settlecurrency.id"));
                vo.setBillType(main.getDataEntityType().getName());
                vo.setBizdate(main.getDate("biztime"));
                vo.setPayableAmt(mainAmount);
                vo.setAsstActType("bd_supplier");
                vo.setAsstActId(main.getLong("supplier.id"));
                long entryId = mainEntry.getLong("id");
                vo.setEntryId(entryId);
                BigDecimal amount = mainEntry.getBigDecimal("amount");
                vo.setEntryPayableAmt(amount);
                vo.setEntryUnSettleAmt(amount);
                vo.setEntryMaterialId(mainEntry.getLong("material.masterid.id"));
                String key = vo.getEntryMaterialId() + "-" + mainEntry.getLong("unit.id") + "-" + mainEntry.getLong("baseunit.id");
                BigDecimal unitrate = BigDecimal.ONE;
                BigDecimal target = (BigDecimal)unitrateCache.get(key);
                if (target != null) {
                    unitrate = target;
                } else {
                    unitrate = UnitConvertHelper.getUnitRateConv((Long)vo.getEntryMaterialId(), (Long)mainEntry.getLong("unit.id"), (Long)mainEntry.getLong("baseunit.id"));
                    unitrateCache.put(key, unitrate);
                }
                vo.setUnitCoefficient(unitrate);
                BigDecimal qty = mainEntry.getBigDecimal("qty");
                vo.setEntryQty(qty);
                vo.setBaseUnitQty(mainEntry.getBigDecimal("baseqty"));
                vo.setPrice(mainEntry.getBigDecimal("actualprice"));
                vo.setEntryMeasureUnitId(mainEntry.getLong("unit.id"));
                vo.setEntryMeasureUnit(mainEntry.getDynamicObject("unit"));
                vo.setEntryBaseUnitId(mainEntry.getLong("baseunit.id"));
                vo.setEntryBaseUnit(mainEntry.getDynamicObject("baseunit"));
                vo.setEntryUnSettleQty(mainEntry.getBigDecimal("unverifyqty"));
                vo.setPresent(mainEntry.getBoolean("ispresent"));
                vo.setBaseCurrencyId(main.getLong("currency.id"));
                vo.setQuotation(main.getString("quotation"));
                vo.setExchangeRate(main.getBigDecimal("exchangerate"));
                vo.setEntryCoreBillNum(mainEntry.getString("mainbillnumber"));
                vo.setEntryCoreBillseq(mainEntry.getString("mainbillentryseq"));
                vo.setPriceTax(mainEntry.getBigDecimal("actualtaxprice"));
                vo.setPrecision(Integer.valueOf(main.getInt("settlecurrency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(main.getInt("currency.amtprecision")));
                vo.setEntryEntityName(mainEntry.getDataEntityType().getName());
                vo.setEntryMaterialVersion(mainEntry.getLong("mversion.id"));
                vo.setEntryMaterialSpecType(mainEntry.getString("material.masterid.modelnum") != null ? mainEntry.getString("material.masterid.modelnum") : "");
                vo.setEntryMaterialAuxProp(mainEntry.getString("auxpty") != null ? mainEntry.getString("auxpty") : "");
                vo.setEntryMaterialConfigNumber(mainEntry.getLong("configuredcode.id"));
                vo.setEntryMaterialTrackNumber(mainEntry.getLong("tracknumber.id"));
                mainList.add(vo);
            }
        }
        return mainList;
    }

    @Override
    protected List<BillVerifyVO> getAsstListVO(DynamicObject[] assts) {
        ArrayList<BillVerifyVO> asstList = new ArrayList<BillVerifyVO>();
        for (DynamicObject asst : assts) {
            BigDecimal mainAmount = BigDecimal.ZERO;
            DynamicObjectCollection asstEntrys = asst.getDynamicObjectCollection("billentry");
            for (DynamicObject asstEntry : asstEntrys) {
                mainAmount = mainAmount.add(asstEntry.getBigDecimal("amount"));
            }
            for (DynamicObject asstEntry : asstEntrys) {
                if (BigDecimal.ZERO.compareTo(asstEntry.getBigDecimal("unverifyqty")) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(asst.getLong("id"));
                vo.setOrgId(asstEntry.getLong("entrysettleorg.id"));
                vo.setBillNo(asst.getString("billno"));
                vo.setCurrencyId(asst.getLong("settlecurrency.id"));
                vo.setBillType(asst.getDataEntityType().getName());
                vo.setBizdate(asst.getDate("biztime"));
                vo.setPayableAmt(mainAmount);
                vo.setAsstActType("bd_supplier");
                vo.setAsstActId(asst.getLong("supplier.id"));
                vo.setEntryId(asstEntry.getLong("id"));
                vo.setEntrySouBillId(asstEntry.getLong("srcbillentryid"));
                BigDecimal amount = asstEntry.getBigDecimal("amount");
                vo.setEntryPayableAmt(amount);
                vo.setEntryMaterialId(asstEntry.getLong("material.masterid.id"));
                BigDecimal unitrate = UnitConvertHelper.getUnitRateConv((Long)vo.getEntryMaterialId(), (Long)asstEntry.getLong("unit.id"), (Long)asstEntry.getLong("baseunit.id"));
                vo.setUnitCoefficient(unitrate);
                BigDecimal qty = asstEntry.getBigDecimal("qty");
                vo.setEntryQty(qty);
                vo.setBaseUnitQty(asstEntry.getBigDecimal("baseqty"));
                vo.setPrice(amount.divide(qty, 10, RoundingMode.HALF_UP));
                vo.setEntryMeasureUnitId(asstEntry.getLong("unit.id"));
                vo.setEntryMeasureUnit(asstEntry.getDynamicObject("unit"));
                vo.setEntryBaseUnitId(asstEntry.getLong("baseunit.id"));
                vo.setEntryBaseUnit(asstEntry.getDynamicObject("baseunit"));
                vo.setEntryUnSettleQty(asstEntry.getBigDecimal("unverifyqty"));
                vo.setPresent(asstEntry.getBoolean("ispresent"));
                vo.setBaseCurrencyId(asst.getLong("currency.id"));
                vo.setQuotation(asst.getString("quotation"));
                vo.setExchangeRate(asst.getBigDecimal("exchangerate"));
                vo.setPriceTax(asstEntry.getBigDecimal("actualtaxprice"));
                vo.setPrecision(Integer.valueOf(asst.getInt("settlecurrency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(asst.getInt("currency.amtprecision")));
                vo.setEntryEntityName(asstEntry.getDataEntityType().getName());
                vo.setEntryMaterialVersion(asstEntry.getLong("mversion.id"));
                vo.setEntryMaterialSpecType(asstEntry.getString("material.masterid.modelnum") != null ? asstEntry.getString("material.masterid.modelnum") : "");
                vo.setEntryMaterialAuxProp(asstEntry.getString("auxpty") != null ? asstEntry.getString("auxpty") : "");
                vo.setEntryMaterialConfigNumber(asstEntry.getLong("configuredcode.id"));
                vo.setEntryMaterialTrackNumber(asstEntry.getLong("tracknumber.id"));
                asstList.add(vo);
            }
        }
        return asstList;
    }

    @Override
    protected void disposeMainBill(List<VerifyRecordVO> voList, SettleSchemeVO scheme) {
        if (voList != null && voList.size() > 0) {
            ArrayList<Map<String, Object>> disposeList = new ArrayList<Map<String, Object>>(voList.size());
            for (VerifyRecordVO vo : voList) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("entity", vo.getBillType());
                rowMap.put("orgid", vo.getOrgId());
                rowMap.put("pk", vo.getMainBillId());
                rowMap.put("entrypk", vo.getMainBillEntryId());
                rowMap.put("measureunit", vo.getMeasureunitId());
                rowMap.put("verifyqty", vo.getVerifyQty());
                rowMap.put("verifybaseqty", vo.getVerifyBaseQty());
                boolean needDisposeRemain = !VerifyModeEnum.AUTO.getValue().equals(vo.getSettleType());
                rowMap.put("needDisposeRemain", needDisposeRemain);
                rowMap.put("verifyrelation", this.getSettleRelation());
                rowMap.put("verifytype", vo.getSettleType());
                rowMap.put("verifyamt", vo.getVerifyAmt());
                if (scheme.isRedVerifyRecord()) {
                    rowMap.put("iswrittenoffverify", Boolean.TRUE);
                } else {
                    rowMap.put("iswrittenoffverify", Boolean.FALSE);
                }
                disposeList.add(rowMap);
                List vrEntrys = vo.getVrEntrys();
                for (VerifyRecordEntryVO entryVo : vrEntrys) {
                    HashMap<String, Object> entryRowMap = new HashMap<String, Object>();
                    entryRowMap.put("entity", entryVo.getBillType());
                    entryRowMap.put("orgid", vo.getOrgId());
                    entryRowMap.put("pk", entryVo.getBillId());
                    entryRowMap.put("entrypk", entryVo.getBillEntryId());
                    entryRowMap.put("measureunit", entryVo.getMeasureunitId());
                    entryRowMap.put("verifyqty", entryVo.getVerifyQty());
                    entryRowMap.put("verifybaseqty", entryVo.getVerifyBaseQty());
                    entryRowMap.put("needDisposeRemain", needDisposeRemain);
                    entryRowMap.put("verifyrelation", this.getSettleRelation());
                    entryRowMap.put("verifytype", vo.getSettleType());
                    entryRowMap.put("verifyamt", entryVo.getVerifyAmt());
                    disposeList.add(entryRowMap);
                }
            }
            VerifyServiceHelper.invokeDisposeScmc(voList, disposeList, scheme);
            VerifyServiceHelper.invokeDisposeScm(disposeList, scheme);
        }
    }

    @Override
    protected void disposeAsstBill(List<VerifyRecordEntryVO> entryList, SettleSchemeVO scheme) {
    }

    @Override
    protected String getSettleRelation() {
        return VerifyRelationEnum.PURSELF.getValue();
    }

    protected void addLogInfo(String opDescription) {
        try {
            AppLogInfo appLogInfo = new AppLogInfo();
            appLogInfo.setBizAppID("+HKZHSKFXOX");
            appLogInfo.setBizObjID("ap_verifyrecord");
            appLogInfo.setOpName("purselfautoVerify");
            appLogInfo.setOpDescription(opDescription == null ? RequestContext.get().getTraceId() : opDescription + " traceid:" + RequestContext.get().getTraceId());
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
        catch (Exception e) {
            logger.info("autoVerify-addLogInfo:" + e);
        }
    }
}

