/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.fin.PlanEntryDisposer;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.arapcommon.dev.beanfactory.Scope;
import kd.fi.arapcommon.dev.beanfactory.Service;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

@KSObject
@Service(scope=Scope.Prototype)
public class PayTransfer {
    private static final Log logger = LogFactory.getLog(PayTransfer.class);
    private String ruleId = "707702118542230528";
    private boolean isPlanSettle;
    private final Map<Long, DynamicObject> finApEntryMap = new HashMap<Long, DynamicObject>(32);
    private final Map<Long, Boolean> srcBillIdToSettleVersion = new HashMap<Long, Boolean>(8);

    @KSMethod
    public DynamicObject transferSummly(DynamicObject transferInfo) {
        this.initTransferArgs(transferInfo);
        DynamicObjectCollection transferDetailEntry = transferInfo.getDynamicObjectCollection("entry");
        DynamicObjectCollection transferPlanEntry = transferInfo.getDynamicObjectCollection("planentry");
        DynamicObject transferBill = this.transfer(transferInfo, (List<DynamicObject>)transferDetailEntry, (List<DynamicObject>)transferPlanEntry, Boolean.TRUE);
        if (this.isPlanSettle) {
            this.reSetSplitDimensionId(transferBill);
            this.reSetPlanEntryLocalAmt(transferBill);
        }
        return transferBill;
    }

    @KSMethod
    public List<DynamicObject> transferDispersedly(DynamicObject transferInfo) {
        this.initTransferArgs(transferInfo);
        DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entry");
        DynamicObjectCollection planEntry = transferInfo.getDynamicObjectCollection("planentry");
        Map<Long, List<DynamicObject>> groupByDetailEntry = entry.stream().collect(Collectors.groupingBy(row -> Long.parseLong(row.getString("finbillid"))));
        Map<Long, List<DynamicObject>> groupByPlanEntry = planEntry.stream().collect(Collectors.groupingBy(row -> row.getLong("p_billid")));
        ArrayList<DynamicObject> finBills = new ArrayList<DynamicObject>(32);
        for (Map.Entry<Long, List<DynamicObject>> entrySet : groupByDetailEntry.entrySet()) {
            Long srcBillId = entrySet.getKey();
            DynamicObject transferBill = this.transfer(transferInfo, entrySet.getValue(), groupByPlanEntry.get(srcBillId), Boolean.FALSE);
            if (this.isPlanSettle) {
                this.reSetSplitDimensionId(transferBill);
                this.reSetPlanEntryLocalAmt(transferBill);
            }
            finBills.add(transferBill);
        }
        return finBills;
    }

    private DynamicObject transfer(DynamicObject transferInfo, List<DynamicObject> transferDetailEntry, List<DynamicObject> transferPlanEntry, Boolean isSummly) {
        HashSet<Long> srcIds = new HashSet<Long>();
        if (Boolean.TRUE.equals(isSummly)) {
            DynamicObjectCollection allTransferInfoEntry = transferInfo.getDynamicObjectCollection("entry");
            if (!ObjectUtils.isEmpty((Object)allTransferInfoEntry)) {
                for (DynamicObject transferRow : allTransferInfoEntry) {
                    long srcbillId = transferRow.getLong("finbillid");
                    srcIds.add(srcbillId);
                }
            }
        } else if (this.isPlanSettle) {
            srcIds.add(transferPlanEntry.get(0).getLong("p_billid"));
        } else {
            srcIds.add(transferDetailEntry.get(0).getLong("finbillid"));
        }
        List tarBills = BOTPHelper.push((String)"ap_finapbill", (String)"ap_finapbill", (String)this.ruleId, new ArrayList(srcIds), (String)ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u201c\u6309\u884c\u8f6c\u4ed8\u201d\u5931\u8d25\u3002", (String)"PayTransfer_1", (String)"fi-ap-business", (Object[])new Object[0]));
        DynamicObject finBill = (DynamicObject)tarBills.get(0);
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"transferpaybill");
        this.createFinBill(transferInfo, finBill, transferDetailEntry, extendFieldMap);
        DynamicObjectCollection detailCollection = new DynamicObjectCollection();
        for (DynamicObject transferDetailRow : transferDetailEntry) {
            this.addDetailNewEntryRow(finBill, transferDetailRow, detailCollection, extendFieldMap);
        }
        finBill.set("detailentry", (Object)detailCollection);
        this.calculate(finBill);
        if (this.isPlanSettle) {
            DynamicObjectCollection planCollection = new DynamicObjectCollection();
            for (DynamicObject transferPlan : transferPlanEntry) {
                this.addPlanNewEntryRow(finBill, transferPlan, planCollection, extendFieldMap);
            }
            finBill.set("planentity", (Object)planCollection);
        } else {
            this.addPlanEntry(finBill);
        }
        this.setHeadDueDate(finBill);
        return finBill;
    }

    private void addPlanNewEntryRow(DynamicObject finApBill, DynamicObject transferPlan, DynamicObjectCollection planCollection, Map<String, Set<String>> extendFieldMap) {
        DynamicObjectCollection newPlanEntity = finApBill.getDynamicObjectCollection("planentity");
        DynamicObject transferInfo = (DynamicObject)transferPlan.getParent();
        int precision = 2;
        DynamicObject currency = finApBill.getDynamicObject("basecurrency");
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        BigDecimal exchangeRate = transferInfo.getBigDecimal("head_exchangerate");
        String quotation = transferInfo.getString("quotation");
        Date dueDate = transferInfo.getDate("duedate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        Set<String> planExtendFields = extendFieldMap.get("planentity");
        for (DynamicObject transPlanNewRow : newPlanEntity) {
            long pSrcBillPlanId = transPlanNewRow.getLong("p_sourcebillentryid");
            if (transferPlan.getLong("p_entryid") != pSrcBillPlanId) continue;
            BigDecimal pPriceTaxTotal = transferPlan.getBigDecimal("p_transpricetaxtotal");
            BigDecimal pPriceTaxTotalBase = BigDecimal.ZERO;
            pPriceTaxTotalBase = "1".equals(quotation) ? pPriceTaxTotal.divide(exchangeRate, precision, RoundingMode.HALF_UP) : pPriceTaxTotal.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            transPlanNewRow.set("planpricetax", (Object)pPriceTaxTotal);
            transPlanNewRow.set("planpricetaxloc", (Object)pPriceTaxTotalBase);
            transPlanNewRow.set("unplanlockamt", (Object)pPriceTaxTotal);
            transPlanNewRow.set("unplansettleamt", (Object)pPriceTaxTotal);
            transPlanNewRow.set("unplansettlelocamt", (Object)pPriceTaxTotalBase);
            transPlanNewRow.set("p_splitdimensionid", (Object)transferPlan.getInt("p_splitdimensionid"));
            transPlanNewRow.set("p_payrate", transferPlan.get("p_payrate"));
            for (String planExtendField : planExtendFields) {
                if ("planpricetax".equals(planExtendField) || "unplanlockamt".equals(planExtendField)) continue;
                Object planExtendValue = transferPlan.get(planExtendField);
                if ("planduedate".equals(planExtendField)) {
                    transPlanNewRow.set("planduedate", dueDate == null ? planExtendValue : dueDate);
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)planExtendValue)) continue;
                transPlanNewRow.set(planExtendField, planExtendValue);
            }
            planCollection.add((Object)transPlanNewRow);
        }
    }

    private void reSetSplitDimensionId(DynamicObject transferBill) {
        String key;
        Boolean isOldVersion;
        long srcBillId;
        DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntries = transferBill.getDynamicObjectCollection("planentity");
        int splitDimensionIdIndex = 0;
        HashMap<String, Integer> planSrcIdToSplitDimensionId = new HashMap<String, Integer>(8);
        for (DynamicObject planEntry : planEntries) {
            srcBillId = planEntry.getLong("p_sourcebillid");
            isOldVersion = this.srcBillIdToSettleVersion.get(srcBillId);
            if (isOldVersion.booleanValue()) {
                key = String.valueOf(srcBillId);
            } else {
                int planSplitDimensionId = planEntry.getInt("p_splitdimensionid");
                key = srcBillId + "_" + planSplitDimensionId;
            }
            Integer newSplitDimensionId = (Integer)planSrcIdToSplitDimensionId.get(key);
            if (newSplitDimensionId == null) {
                planSrcIdToSplitDimensionId.put(key, splitDimensionIdIndex);
                planEntry.set("p_splitdimensionid", (Object)splitDimensionIdIndex);
                ++splitDimensionIdIndex;
                continue;
            }
            planEntry.set("p_splitdimensionid", (Object)newSplitDimensionId);
        }
        for (DynamicObject detailEntry : detailEntries) {
            srcBillId = detailEntry.getLong("e_sourcebillid");
            isOldVersion = this.srcBillIdToSettleVersion.get(srcBillId);
            if (isOldVersion.booleanValue()) {
                key = String.valueOf(srcBillId);
            } else {
                int detailOldSplitDimensionId = detailEntry.getInt("e_splitdimensionid");
                key = srcBillId + "_" + detailOldSplitDimensionId;
            }
            detailEntry.set("e_splitdimensionid", planSrcIdToSplitDimensionId.get(key));
        }
    }

    private void reSetPlanEntryLocalAmt(DynamicObject transferBill) {
        DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection("detailentry");
        HashMap<Integer, BigDecimal> detailEntrySplitDimensionIdToLocalAmt = new HashMap<Integer, BigDecimal>(8);
        for (DynamicObject detailEntry : detailEntries) {
            int splitdimensionId = detailEntry.getInt("e_splitdimensionid");
            BigDecimal localAmt = detailEntry.getBigDecimal("e_pricetaxtotalbase");
            detailEntrySplitDimensionIdToLocalAmt.merge(splitdimensionId, localAmt, BigDecimal::add);
        }
        DynamicObjectCollection planEntries = transferBill.getDynamicObjectCollection("planentity");
        HashMap<Integer, ArrayList<DynamicObject>> planEntrySplitDimensionIdToEntries = new HashMap<Integer, ArrayList<DynamicObject>>(8);
        for (DynamicObject planEntry : planEntries) {
            int planSplitDimensionId = planEntry.getInt("p_splitdimensionid");
            ArrayList<DynamicObject> remainPlanEntries = (ArrayList<DynamicObject>)planEntrySplitDimensionIdToEntries.get(planSplitDimensionId);
            if (remainPlanEntries == null) {
                remainPlanEntries = new ArrayList<DynamicObject>(1);
                remainPlanEntries.add(planEntry);
                planEntrySplitDimensionIdToEntries.put(planSplitDimensionId, remainPlanEntries);
                continue;
            }
            remainPlanEntries.add(planEntry);
        }
        for (Map.Entry entrySet : detailEntrySplitDimensionIdToLocalAmt.entrySet()) {
            Integer key = (Integer)entrySet.getKey();
            BigDecimal value = (BigDecimal)entrySet.getValue();
            List remainPlanEntries = (List)planEntrySplitDimensionIdToEntries.get(key);
            BigDecimal remainPlanEntryLocalAmtTotal = BigDecimal.ZERO;
            int count = 0;
            for (DynamicObject remainPlanEntry : remainPlanEntries) {
                if (++count == remainPlanEntries.size()) {
                    BigDecimal localAmt = value.subtract(remainPlanEntryLocalAmtTotal);
                    remainPlanEntry.set("planpricetaxloc", (Object)localAmt);
                    remainPlanEntry.set("unplansettlelocamt", (Object)localAmt);
                    continue;
                }
                remainPlanEntryLocalAmtTotal = remainPlanEntryLocalAmtTotal.add(remainPlanEntry.getBigDecimal("planpricetaxloc"));
            }
        }
    }

    private void setHeadDueDate(DynamicObject finApBill) {
        Date planMaxDuedate = finApBill.getDate("duedate");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finApBill.set("duedate", (Object)planMaxDuedate);
    }

    private void addDetailNewEntryRow(DynamicObject finapbill, DynamicObject transferEntryRow, DynamicObjectCollection dynamicObjectCollection, Map<String, Set<String>> extendFieldMap) {
        DynamicObject transferBillNewEntryRow = null;
        DynamicObjectCollection newFinBillEntry = finapbill.getDynamicObjectCollection("detailentry");
        if (this.isPlanSettle) {
            transferBillNewEntryRow = newFinBillEntry.addNew();
            Long srcEntryId = Long.valueOf(transferEntryRow.getString("finentryid"));
            DynamicObject srcDetail = this.finApEntryMap.get(srcEntryId);
            if (srcDetail == null) {
                return;
            }
            Set<String> carryFieldByPlan = this.getCarryFieldByPlan();
            for (String fieldName : carryFieldByPlan) {
                transferBillNewEntryRow.set(fieldName, srcDetail.get(fieldName));
            }
            transferBillNewEntryRow.set("e_baseunitqty", (Object)srcDetail.getBigDecimal("quantity").multiply(srcDetail.getBigDecimal("e_unitconvertrate")));
            transferBillNewEntryRow.set("e_sourcebillid", (Object)transferEntryRow.getLong("finbillid"));
            transferBillNewEntryRow.set("e_sourcebillentryid", (Object)srcEntryId);
            transferBillNewEntryRow.set("e_splitdimensionid", (Object)transferEntryRow.getInt("e_splitdimensionid"));
        } else {
            for (DynamicObject detailRow : newFinBillEntry) {
                String sBillEntryId;
                DynamicObjectCollection entryLk = detailRow.getDynamicObjectCollection("detailentry_lk");
                if (entryLk.isEmpty() || !(sBillEntryId = ((DynamicObject)entryLk.get(0)).getString("detailentry_lk_sid")).equals(transferEntryRow.getString("finentryid"))) continue;
                transferBillNewEntryRow = detailRow;
                break;
            }
        }
        if (transferBillNewEntryRow == null) {
            return;
        }
        DynamicObject transferInfo = (DynamicObject)transferEntryRow.getParent();
        int precision = 2;
        DynamicObject currency = finapbill.getDynamicObject("basecurrency");
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        Set<String> materialExtendFields = extendFieldMap.get("detailentry");
        BigDecimal priceTaxTotal = transferEntryRow.getBigDecimal("transpricetaxtotal");
        BigDecimal quantity = transferEntryRow.getBigDecimal("transqty");
        BigDecimal apAmount = transferEntryRow.getBigDecimal("transamount");
        BigDecimal taxUnitPrice = priceTaxTotal.divide(quantity, 10, RoundingMode.HALF_UP);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_tax", (Object)transferEntryRow.get("transtax"));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"discountmode", (Object)DiscountModeEnum.NULL.getValue());
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"discountrate", (Object)BigDecimal.ZERO);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_sourcebillentryid", (Object)transferEntryRow.get("finentryid"));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_sourcebillid", (Object)transferEntryRow.get("finbillid"));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"quantity", (Object)quantity);
        DynamicObject taxrate = transferEntryRow.getDynamicObject("taxrateid");
        if (!ObjectUtils.isEmpty((Object)taxrate)) {
            taxrate = BusinessDataServiceHelper.loadSingleFromCache((Object)taxrate.getPkValue(), (String)taxrate.getDynamicObjectType().getName(), (String)"taxrate");
            ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"taxrate", (Object)taxrate.get("taxrate"));
            transferBillNewEntryRow.set("taxrateid", (Object)taxrate);
        }
        if (quantity == null) {
            quantity = BigDecimal.ZERO;
        }
        BigDecimal covertRate = transferBillNewEntryRow.getBigDecimal("e_unitconvertrate");
        DynamicObject material = transferBillNewEntryRow.getDynamicObject("material");
        DynamicObject measureUnit = transferBillNewEntryRow.getDynamicObject("measureunit");
        DynamicObject baseUnit = null;
        if (!ObjectUtils.isEmpty((Object)material)) {
            baseUnit = material.getDynamicObject("baseunit");
            ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_baseunit", (Object)baseUnit);
            if (measureUnit == null) {
                measureUnit = baseUnit;
            }
            if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = UnitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureUnit.getLong("id"), (Long)baseUnit.getLong("id"));
                covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
            }
        } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        if (EmptyUtils.isEmpty((Object)transferBillNewEntryRow.getBigDecimal("e_unitconvertrate"))) {
            ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unitconvertrate", (Object)covertRate);
        }
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"unlockamt", (Object)priceTaxTotal);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"unsettleamt", (Object)priceTaxTotal);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"pricetax", (Object)taxUnitPrice);
        BigDecimal price = apAmount.divide(quantity, 10, RoundingMode.HALF_UP);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"price", (Object)price);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"actprice", (Object)price);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"actpricetax", (Object)taxUnitPrice);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_pricetaxtotal", (Object)priceTaxTotal);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_uninvoicedamt", (Object)priceTaxTotal);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"discountamount", (Object)BigDecimal.ZERO);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_amount", (Object)apAmount);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"discountlocalamt", (Object)BigDecimal.ZERO);
        BigDecimal exchangeRate = transferInfo.getBigDecimal("head_exchangerate");
        String quotation = transferInfo.getString("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal e_pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal e_amountbase = BigDecimal.ZERO;
        BigDecimal unsettleamtbase = BigDecimal.ZERO;
        BigDecimal e_taxlocalamt = BigDecimal.ZERO;
        if ("1".equals(quotation)) {
            e_amountbase = apAmount.divide(exchangeRate, precision, RoundingMode.HALF_UP);
            e_pricetaxtotalbase = transferBillNewEntryRow.getBigDecimal("e_pricetaxtotal").divide(exchangeRate, precision, RoundingMode.HALF_UP);
            unsettleamtbase = transferBillNewEntryRow.getBigDecimal("unsettleamt").divide(exchangeRate, precision, RoundingMode.HALF_UP);
        } else {
            e_amountbase = apAmount.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            e_pricetaxtotalbase = transferBillNewEntryRow.getBigDecimal("e_pricetaxtotal").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            unsettleamtbase = transferBillNewEntryRow.getBigDecimal("unsettleamt").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
        }
        e_taxlocalamt = e_pricetaxtotalbase.subtract(e_amountbase);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_amountbase", (Object)e_amountbase);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"unsettleamtbase", (Object)unsettleamtbase);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_taxlocalamt", (Object)e_taxlocalamt);
        for (String materialExtendField : materialExtendFields) {
            Object materialExtendValue = transferEntryRow.get(materialExtendField);
            if (ObjectUtils.isEmpty((Object)materialExtendValue)) continue;
            transferBillNewEntryRow.set(materialExtendField, materialExtendValue);
        }
        dynamicObjectCollection.add((Object)transferBillNewEntryRow);
    }

    private void createFinBill(DynamicObject transpayInfo, DynamicObject finapbill, List<DynamicObject> transferEntry, Map<String, Set<String>> extendFieldMap) {
        String sourcebillno;
        finapbill.set("sourcebilltype", (Object)"ap_finapbill");
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"istanspay", (Object)Boolean.TRUE);
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"bizdate", (Object)transpayInfo.getDate("transdate"));
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"duedate", (Object)transpayInfo.getDate("duedate"));
        finapbill.set("exratetable", (Object)transpayInfo.getDynamicObject("exratetable"));
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"exratedate", (Object)transpayInfo.get("exratedate"));
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"quotation", (Object)transpayInfo.getString("quotation"));
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"exchangerate", (Object)transpayInfo.getBigDecimal("head_exchangerate"));
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"settlestatus", (Object)"unsettle");
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"verifystatus", (Object)"10");
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"asstacttype", (Object)transpayInfo.get("asstacttype"));
        finapbill.set("asstact", (Object)transpayInfo.getDynamicObject("asstact"));
        finapbill.set("currency", (Object)transpayInfo.getDynamicObject("fincurrency"));
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"asstactname", (Object)transpayInfo.getDynamicObject("asstact").get("name"));
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"sourcebilltype", (Object)"ap_finapbill");
        ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"payeebanknum", (Object)transpayInfo.get("payeebanknum"));
        finapbill.set("bebank", (Object)transpayInfo.getDynamicObject("bebank"));
        if (!ObjectUtils.isEmpty((Object)transpayInfo.get("paycond"))) {
            finapbill.set("paycond", transpayInfo.get("paycond"));
        }
        if (!ObjectUtils.isEmpty((Object)transpayInfo.get("settlementtype"))) {
            finapbill.set("settlementtype", transpayInfo.get("settlementtype"));
        }
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        finapbill.set("modifier", (Object)user);
        finapbill.set("modifytime", (Object)new Date());
        if (transferEntry.size() > 0) {
            finapbill.set("sourcebillid", transferEntry.get(0).get("finbillid"));
        }
        if ((sourcebillno = finapbill.getString("sourcebillno")).length() > 255) {
            sourcebillno = sourcebillno.substring(0, 252) + "...";
            finapbill.set("sourcebillno", (Object)sourcebillno);
        }
        if ("bd_supplier".equals(transpayInfo.get("asstacttype"))) {
            DynamicObject asstact = (DynamicObject)transpayInfo.get("asstact");
            Object asstactPk = asstact.getPkValue();
            Map asstactFieldMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"paymentcurrency,invoicesupplierid,deliversupplierid,receivingsupplierid,bizfunction", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)});
            DynamicObject asstactFieldValue = (DynamicObject)asstactFieldMap.get(asstactPk);
            DynamicObject paymentCurrencyId = asstactFieldValue.getDynamicObject("paymentcurrency");
            if (paymentCurrencyId != null) {
                ArApHelper.setFieldValue((DynamicObject)finapbill, (String)"paymentcurrency", (Object)paymentCurrencyId);
            }
            finapbill.set("receivingsupplierid", asstactFieldValue.get("receivingsupplierid"));
            DynamicObjectCollection entryColls = finapbill.getDynamicObjectCollection("detailentry");
            if (entryColls != null && entryColls.size() > 0) {
                String bizFunction = asstactFieldValue.getString("bizfunction");
                for (DynamicObject entry : entryColls) {
                    if (bizFunction.contains("1")) {
                        entry.set("e_invoicesupplierid", asstactFieldValue.get("invoicesupplierid"));
                    }
                    entry.set("e_deliversupplierid", asstactFieldValue.get("deliversupplierid"));
                }
            }
        }
        Set<String> headExtendFields = extendFieldMap.get("head");
        for (String headExtendField : headExtendFields) {
            Object headExtendValue = transpayInfo.get(headExtendField);
            if (headExtendValue == null) continue;
            ArApHelper.setFieldValue((DynamicObject)finapbill, (String)headExtendField, (Object)headExtendValue);
        }
    }

    private void addPlanEntry(DynamicObject transferBill) {
        PlanSplitAndBuilder.splitAndBuild((DynamicObject)transferBill);
    }

    private void calculate(DynamicObject finBill) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        DynamicObjectCollection entry = finBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject row : entry) {
            amount = amount.add(row.getBigDecimal("e_amount"));
            tax = tax.add(row.getBigDecimal("e_tax"));
            taxlocamt = taxlocamt.add(row.getBigDecimal("e_taxlocalamt"));
            BigDecimal e_pricetaxtotal = row.getBigDecimal("e_pricetaxtotal");
            pricetaxtotal = pricetaxtotal.add(e_pricetaxtotal);
            BigDecimal e_pricetaxtotalbase = row.getBigDecimal("e_pricetaxtotalbase");
            logger.info("PayTransfer calculate---e_pricetaxtotalbase:" + e_pricetaxtotalbase);
            pricetaxtotalbase = pricetaxtotalbase.add(e_pricetaxtotalbase);
        }
        finBill.set("amount", (Object)amount);
        finBill.set("tax", (Object)tax);
        finBill.set("taxlocamt", (Object)taxlocamt);
        finBill.set("pricetaxtotal", (Object)pricetaxtotal);
        finBill.set("uninvoicedamt", (Object)pricetaxtotal);
        finBill.set("unsettleamount", (Object)pricetaxtotal);
        BigDecimal rate = finBill.getBigDecimal("exchangerate");
        String quotation = finBill.getString("quotation");
        int precision = 2;
        DynamicObject currency = finBill.getDynamicObject("basecurrency");
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        BigDecimal locpricetaxtotal = pricetaxtotalbase;
        logger.info("PayTransfer calculate---locpricetaxtotal:" + locpricetaxtotal);
        if ("1".equals(quotation)) {
            finBill.set("amountbase", (Object)amount.divide(rate, precision, RoundingMode.HALF_UP));
        } else {
            finBill.set("amountbase", (Object)amount.multiply(rate).setScale(precision, RoundingMode.HALF_UP));
        }
        finBill.set("pricetaxtotalbase", (Object)locpricetaxtotal);
        finBill.set("unsettleamountbase", (Object)locpricetaxtotal);
    }

    @KSMethod
    public void dispose(DynamicObject transferInfo, DynamicObject[] sourceFinBills) {
        DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> billGroupedEntry = entry.stream().collect(Collectors.groupingBy(row -> row.getLong("finbillid")));
        PlanEntryDisposer planEntryDisposer = new PlanEntryDisposer();
        for (Map.Entry<Long, List<DynamicObject>> groupedTransferEntry : billGroupedEntry.entrySet()) {
            Long billId = groupedTransferEntry.getKey();
            DynamicObject sourceFinBill = this.matchSourceFinBill(billId, sourceFinBills);
            if (sourceFinBill == null) continue;
            BigDecimal totalDisposeAmount = BigDecimal.ZERO;
            DynamicObjectCollection sourceEntry = sourceFinBill.getDynamicObjectCollection("detailentry");
            List<DynamicObject> transferEntry = groupedTransferEntry.getValue();
            for (DynamicObject transferRow : transferEntry) {
                long sourceEntryId = transferRow.getLong("finentryid");
                DynamicObject sourceEntryRow = this.matchSourceEntryRow(sourceEntryId, sourceEntry);
                if (sourceEntryRow == null) continue;
                BigDecimal rowDisposeAmount = transferRow.getBigDecimal("transpricetaxtotal");
                this.increaseAmount(sourceEntryRow, "lockedamt", rowDisposeAmount);
                this.reduceAmount(sourceEntryRow, "unlockamt", rowDisposeAmount);
                totalDisposeAmount = totalDisposeAmount.add(rowDisposeAmount);
            }
            planEntryDisposer.saveDispose(sourceFinBill, totalDisposeAmount);
        }
    }

    private DynamicObject matchSourceFinBill(Long billId, DynamicObject[] sourceFinBills) {
        List matchedBills = Arrays.stream(sourceFinBills).filter(finBill -> finBill.getLong("id") == billId.longValue()).collect(Collectors.toList());
        if (matchedBills.isEmpty()) {
            return null;
        }
        return (DynamicObject)matchedBills.get(0);
    }

    private DynamicObject matchSourceEntryRow(Long entryId, DynamicObjectCollection transferEntry) {
        for (DynamicObject row : transferEntry) {
            if (row.getLong("id") != entryId.longValue()) continue;
            return row;
        }
        return null;
    }

    private void increaseAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.add(amount);
        row.set(amountKey, (Object)result);
    }

    private void reduceAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.subtract(amount);
        row.set(amountKey, (Object)result);
    }

    protected Map<Long, Map<String, Object>> getAsstactInfo(List<DynamicObject> asstacts) {
        if (asstacts.size() == 0) {
            throw new KDBizException("asstacts size is 0");
        }
        HashMap<Long, Map<String, Object>> asstactInfo = new HashMap<Long, Map<String, Object>>(asstacts.size());
        String asstactType = asstacts.get(0).getDataEntityType().getName();
        Set asstactIds = asstacts.stream().map(asstact -> asstact.getLong("id")).collect(Collectors.toSet());
        if ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) {
            Map asstactDOs = BusinessDataServiceHelper.loadFromCache((Object[])asstactIds.toArray(), (String)asstactType);
            asstactDOs.forEach((key, asstact) -> {
                HashMap<String, String> infoMap = new HashMap<String, String>(4);
                DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
                String accountOb = null;
                DynamicObject bebankOb = null;
                for (int i = 0; i < bankColls.size(); ++i) {
                    DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                    if (bankInfo.getBoolean("isdefault_bank")) {
                        accountOb = bankInfo.getString("bankaccount");
                        bebankOb = bankInfo.getDynamicObject("bank");
                        break;
                    }
                    if (i != 0) continue;
                    accountOb = bankInfo.getString("bankaccount");
                    bebankOb = bankInfo.getDynamicObject("bank");
                }
                infoMap.put("accountOb", accountOb);
                infoMap.put("bebankOb", (String)bebankOb);
                if ("bd_supplier".equals(asstactType)) {
                    infoMap.put("paycond", (String)asstact.getDynamicObject("paycond"));
                } else {
                    infoMap.put("paycond", null);
                }
                infoMap.put("settlementtypeid", (String)asstact.getDynamicObject("settlementtypeid"));
                asstactInfo.put((Long)key, infoMap);
            });
        } else if ("bos_user".equals(asstactType)) {
            Map asstactDOs = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)"id,payer,payerbank,payeraccount", (QFilter[])new QFilter[]{new QFilter("payer", "in", asstactIds)}, (String)"isdefault desc");
            HashMap<Long, DynamicObject> asstactMap = new HashMap<Long, DynamicObject>(asstactDOs.size());
            asstactDOs.forEach((key, value) -> asstactMap.put(value.getLong("payer.id"), (DynamicObject)value));
            asstactMap.forEach((key, value) -> {
                HashMap<String, String> infoMap = new HashMap<String, String>(4);
                String accountOb = value.getString("payeraccount");
                DynamicObject bebankOb = value.getDynamicObject("payerbank");
                infoMap.put("accountOb", accountOb);
                infoMap.put("bebankOb", (String)bebankOb);
                infoMap.put("paycond", null);
                infoMap.put("settlementtypeid", null);
                asstactInfo.put((Long)key, (Map<String, Object>)infoMap);
            });
        }
        return asstactInfo;
    }

    private void initTransferArgs(DynamicObject transferInfo) {
        this.isPlanSettle = SystemParameterHelper.isPlanSettle((long)transferInfo.getLong("org.id"), (boolean)false);
        if (this.isPlanSettle) {
            DynamicObject[] finApBills;
            this.ruleId = "1626919231126078464";
            DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entry");
            HashSet<Long> billIds = new HashSet<Long>(32);
            HashSet<Long> billEntryIds = new HashSet<Long>(32);
            for (DynamicObject row : entry) {
                billIds.add(Long.valueOf(row.getString("finbillid")));
                billEntryIds.add(Long.valueOf(row.getString("finentryid")));
            }
            QFilter filter = new QFilter("id", "in", billIds);
            filter.and(new QFilter("detailentry.id", "in", billEntryIds));
            HashSet<String> selectors = new HashSet<String>(32);
            for (String fieldName : this.getCarryFieldByPlan()) {
                selectors.add("detailentry." + fieldName);
            }
            selectors.add("org");
            selectors.add("settleversion");
            for (DynamicObject finApBill : finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detail : detailEntry) {
                    this.finApEntryMap.put(detail.getLong("id"), detail);
                }
                this.srcBillIdToSettleVersion.put(finApBill.getLong("id"), SettleVersionServiceHelper.isOldVersion((DynamicObject)finApBill));
            }
        }
    }

    private Set<String> getCarryFieldByPlan() {
        HashSet<String> materialFields = new HashSet<String>(32);
        materialFields.add("expenseitem");
        materialFields.add("taxrate");
        materialFields.add("corebillno");
        materialFields.add("corebillid");
        materialFields.add("corebillentryid");
        materialFields.add("corebillentryseq");
        materialFields.add("corebilltype");
        materialFields.add("measureunit");
        materialFields.add("quantity");
        materialFields.add("material");
        materialFields.add("price");
        materialFields.add("ispresent");
        materialFields.add("actprice");
        materialFields.add("actpricetax");
        materialFields.add("spectype");
        materialFields.add("e_remark");
        materialFields.add("pricetax");
        materialFields.add("e_baseunit");
        materialFields.add("e_unitconvertrate");
        materialFields.add("taxrateid");
        materialFields.add("e_premiumrate");
        materialFields.add("e_assistantattr");
        materialFields.add("e_materialversion");
        materialFields.add("linetype");
        materialFields.add("materialname");
        materialFields.add("configuredcode");
        materialFields.add("tracknumber");
        materialFields.add("e_conbillentity");
        materialFields.add("e_conbillnumber");
        materialFields.add("e_conbillrownum");
        materialFields.add("e_conbillid");
        materialFields.add("e_conbillentryid");
        materialFields.add("e_costcenter");
        materialFields.add("e_productline");
        return materialFields;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }
}

