/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.helper.PushApSetSupplierFiledHelper;
import kd.fi.arapcommon.service.fin.TransferAllService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.service.plan.split.PlanSplitService;
import kd.fi.arapcommon.service.plan.split.entity.DetailGroupData;
import kd.fi.arapcommon.service.plan.split.entity.PlanRowData;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.ApTransferWBFinBillServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class PayTransferAll
extends TransferAllService {
    private final Map<Long, Boolean> srcBillIdToSettleVersion = new HashMap<Long, Boolean>(8);

    public PayTransferAll(DynamicObject transferInfo) {
        super(transferInfo);
    }

    protected void initParams() {
        this.finBillKey = "ap_finapbill";
        this.ruleId = "1352921980365449216";
        this.finDetailEntryKey = "detailentry";
        this.finPlanEntryKey = "planentity";
        this.finDetailEntryUnLockKey = "unlockamt";
        this.finHeadPriceTaxTotalLocalKey = "pricetaxtotalbase";
        this.finHeadDueDate = "duedate";
        this.extendFields = ArApTransferHelper.getTransferExtendFields((String)"ap_transferall");
        this.isMaterialSettle = ArApHelper.getApSettleParam((Object)this.transferInfo.getLong("org.id")) == 1;
    }

    protected void fillHead(DynamicObject transferBill, DynamicObject transferTagInfo, BigDecimal priceTaxTotal, BigDecimal amount) {
        DynamicObject transferPageInfo = this.transferInfo;
        transferBill.set("asstacttype", (Object)transferPageInfo.getString("head_asstacttype"));
        transferBill.set("asstact", (Object)transferTagInfo.getDynamicObject("t_asstact"));
        transferBill.set("asstactname", (Object)transferTagInfo.getString("t_asstact.name"));
        transferBill.set("payeebanknum", (Object)transferTagInfo.getString("t_payeebanknum"));
        transferBill.set("bebank", (Object)transferTagInfo.getDynamicObject("t_bebank"));
        transferBill.set("bizdate", (Object)transferPageInfo.getDate("transdate"));
        transferBill.set("duedate", (Object)transferPageInfo.getDate("duedate"));
        transferBill.set("currency", (Object)transferPageInfo.getDynamicObject("fincurrency"));
        transferBill.set("basecurrency", (Object)transferPageInfo.getDynamicObject("basecurrency"));
        transferBill.set("exratetable", (Object)transferPageInfo.getDynamicObject("exratetable"));
        transferBill.set("exratedate", (Object)transferPageInfo.getDate("exratedate"));
        transferBill.set("exchangerate", (Object)transferPageInfo.getBigDecimal("head_exchangerate"));
        transferBill.set("quotation", (Object)transferPageInfo.getString("quotation"));
        transferBill.set("payproperty", (Object)transferTagInfo.getDynamicObject("t_payproperty"));
        transferBill.set("remark", (Object)transferTagInfo.getString("remark"));
        transferBill.set("istanspay", (Object)Boolean.TRUE);
        DynamicObject payCond = transferTagInfo.getDynamicObject("paycond");
        if (!ObjectUtils.isEmpty((Object)payCond)) {
            Long payCondId = payCond.getLong("id");
            payCond = BusinessDataServiceHelper.loadSingleFromCache((Object)payCondId, (String)"bd_paycondition");
            transferBill.set("paycond", (Object)payCond);
        }
        if (!ObjectUtils.isEmpty((Object)transferTagInfo.getDynamicObject("settlementtype"))) {
            transferBill.set("settlementtype", (Object)transferTagInfo.getDynamicObject("settlementtype"));
        }
        if (!ObjectUtils.isEmpty((Object)transferTagInfo.getDynamicObject("purorg"))) {
            transferBill.set("purorg", (Object)transferTagInfo.getDynamicObject("purorg"));
        }
        if (!ObjectUtils.isEmpty((Object)transferTagInfo.getDynamicObject("purchaser"))) {
            transferBill.set("purchaser", (Object)transferTagInfo.getDynamicObject("purchaser"));
        }
        if (!ObjectUtils.isEmpty((Object)transferTagInfo.getDynamicObject("purdept"))) {
            transferBill.set("purdept", (Object)transferTagInfo.getDynamicObject("purdept"));
        }
        BigDecimal transferTax = priceTaxTotal.subtract(amount).setScale(this.currencyPrecison, RoundingMode.HALF_UP);
        BigDecimal transferBillPriceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal transferBillAmountBase = BigDecimal.ZERO;
        BigDecimal transferBillTaxLocAmt = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection(this.finDetailEntryKey);
        for (Object detailEntry : detailEntries) {
            transferBillPriceTaxTotalBase = transferBillPriceTaxTotalBase.add(detailEntry.getBigDecimal("e_pricetaxtotalbase"));
            transferBillAmountBase = transferBillAmountBase.add(detailEntry.getBigDecimal("e_amountbase"));
            transferBillTaxLocAmt = transferBillTaxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
        }
        transferBill.set("tax", (Object)transferTax);
        transferBill.set("taxlocamt", (Object)transferBillTaxLocAmt);
        transferBill.set("amount", (Object)amount);
        transferBill.set("amountbase", (Object)transferBillAmountBase);
        transferBill.set("pricetaxtotal", (Object)priceTaxTotal);
        transferBill.set("pricetaxtotalbase", (Object)transferBillPriceTaxTotalBase);
        transferBill.set("unsettleamount", (Object)priceTaxTotal);
        transferBill.set("unsettleamountbase", (Object)transferBillPriceTaxTotalBase);
        transferBill.set("uninvoicedamt", (Object)priceTaxTotal);
        Set headExtendFields = (Set)this.extendFields.get("head");
        for (String headExtendField : headExtendFields) {
            Object headExtendValue = this.transferInfo.get(headExtendField);
            if (headExtendValue == null) continue;
            transferBill.set(headExtendField, headExtendValue);
        }
        Set detailExtendFields = (Set)this.extendFields.get("detailentry");
        for (String detailExtendField : detailExtendFields) {
            Object headExtendValue = transferTagInfo.get(detailExtendField);
            if (headExtendValue == null) continue;
            transferBill.set(detailExtendField, headExtendValue);
        }
    }

    protected void fillDetailEntry(DynamicObject detailEntry, BigDecimal detailEntryPriceTaxTotal, BigDecimal detailEntryAmount) {
        BigDecimal detailEntryTax = detailEntryPriceTaxTotal.subtract(detailEntryAmount).setScale(this.currencyPrecison, RoundingMode.HALF_UP);
        BigDecimal detailEntryPriceTaxTotalBase = this.getLocalAmt(detailEntryPriceTaxTotal, this.exchange, this.localCurrencyPrecison);
        BigDecimal detailEntryAmountBase = this.getLocalAmt(detailEntryAmount, this.exchange, this.localCurrencyPrecison);
        BigDecimal detailEntryTaxLocAmt = detailEntryPriceTaxTotalBase.subtract(detailEntryAmountBase);
        BigDecimal qty = detailEntry.getBigDecimal("quantity");
        if (BigDecimal.ZERO.compareTo(qty) == 0) {
            qty = BigDecimal.ONE;
        }
        BigDecimal price = detailEntryAmount.divide(qty, 10, RoundingMode.HALF_UP);
        BigDecimal pricetax = detailEntryPriceTaxTotal.divide(qty, 10, RoundingMode.HALF_UP);
        detailEntry.set("price", (Object)price);
        detailEntry.set("pricetax", (Object)pricetax);
        detailEntry.set("actprice", (Object)price);
        detailEntry.set("actpricetax", (Object)pricetax);
        detailEntry.set("discountmode", (Object)"NULL");
        detailEntry.set("discountrate", (Object)BigDecimal.ZERO);
        detailEntry.set("discountamount", (Object)BigDecimal.ZERO);
        detailEntry.set("discountlocalamt", (Object)BigDecimal.ZERO);
        detailEntry.set("unverifyquantity", (Object)BigDecimal.ZERO);
        detailEntry.set("verifyquantity", (Object)BigDecimal.ZERO);
        detailEntry.set("e_unverifyamount", (Object)BigDecimal.ZERO);
        detailEntry.set("verifyamount", (Object)BigDecimal.ZERO);
        detailEntry.set("e_tax", (Object)detailEntryTax);
        detailEntry.set("e_taxlocalamt", (Object)detailEntryTaxLocAmt);
        detailEntry.set("e_amount", (Object)detailEntryAmount);
        detailEntry.set("e_amountbase", (Object)detailEntryAmountBase);
        detailEntry.set("e_pricetaxtotal", (Object)detailEntryPriceTaxTotal);
        detailEntry.set("e_pricetaxtotalbase", (Object)detailEntryPriceTaxTotalBase);
        detailEntry.set("unsettleamt", (Object)detailEntryPriceTaxTotal);
        detailEntry.set("unsettleamtbase", (Object)detailEntryPriceTaxTotalBase);
        detailEntry.set("e_uninvoicedamt", (Object)detailEntryPriceTaxTotal);
        detailEntry.set("unlockamt", (Object)detailEntryPriceTaxTotal);
    }

    protected void fillPlanEntry(DynamicObject transferBill, DynamicObject planEntry, BigDecimal transferBillPriceTaxTotal, BigDecimal transferBillPriceTaxTotalLocal, Date dueDate) {
        planEntry.set("planduedate", (Object)dueDate);
        planEntry.set("plansettletype", transferBill.get("settlementtype"));
        planEntry.set("planpricetax", (Object)transferBillPriceTaxTotal);
        planEntry.set("planpricetaxloc", (Object)transferBillPriceTaxTotalLocal);
        planEntry.set("unplansettleamt", (Object)transferBillPriceTaxTotal);
        planEntry.set("unplansettlelocamt", (Object)transferBillPriceTaxTotalLocal);
        planEntry.set("unplanlockamt", (Object)transferBillPriceTaxTotal);
        planEntry.set("e_freezestate", (Object)"unfreeze");
    }

    protected void postProcessTransferBill(List<Long> transferFromIds, List<DynamicObject> transferBills) {
        List asstacts = transferBills.stream().map(transferBill -> transferBill.getDynamicObject("asstact")).collect(Collectors.toList());
        Map asstactInfoMap = this.getAsstactInfo(asstacts);
        for (DynamicObject transferBill2 : transferBills) {
            Object recSupplierid;
            long asstactId = transferBill2.getLong("asstact.id");
            Map asstactInfo = (Map)asstactInfoMap.get(asstactId);
            if (asstactInfo == null || EmptyUtils.isEmpty(recSupplierid = asstactInfo.get("receivingsupplierid"))) continue;
            transferBill2.set("receivingsupplierid", recSupplierid);
            DynamicObjectCollection entryColls = transferBill2.getDynamicObjectCollection("detailentry");
            if (entryColls == null || entryColls.size() <= 0) continue;
            String bizFunction = asstactInfo.get("bizfunction").toString();
            for (DynamicObject entry : entryColls) {
                if (bizFunction.contains("1")) {
                    entry.set("e_invoicesupplierid", asstactInfo.get("e_invoicesupplierid"));
                }
                entry.set("e_deliversupplierid", asstactInfo.get("e_deliversupplierid"));
            }
        }
        PushApSetSupplierFiledHelper.setInvoiceType((DynamicObject[])transferBills.toArray(new DynamicObject[0]), (boolean)true);
        if (this.isMaterialSettle) {
            PlanSplitAndBuilder.splitAndBuild((DynamicObject[])transferBills.toArray(new DynamicObject[0]));
        } else {
            this.setSrcIdAndEntryIdForPlanSettle(transferFromIds, transferBills);
        }
        for (DynamicObject transferBill2 : transferBills) {
            this.setHeadDueDate(transferBill2);
        }
    }

    protected void disposeSrcBills(List<Long> transferFromIds, List<DynamicObject> transferBills) {
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(new HashSet<Long>(transferFromIds), (String)"ap_finapbill", (boolean)false);
        String selectors = String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector());
        DynamicObject[] srcFinBills = BusinessDataServiceHelper.load((String)this.finBillKey, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{new QFilter("id", "in", transferFromIds)});
        this.validateSrcLockedAmtOver(srcFinBills, transferBills);
        ApTransferWBFinBillServiceHelper.directWriteBack((DynamicObject[])srcFinBills, transferBills);
    }

    /*
     * WARNING - void declaration
     */
    private void validateSrcLockedAmtOver(DynamicObject[] sourceBills, List<DynamicObject> transferBills) {
        void var6_8;
        HashMap<Long, BigDecimal> srcEntryIdToUnLockAmt = new HashMap<Long, BigDecimal>(sourceBills.length);
        DynamicObject[] dynamicObjectArray = sourceBills;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            DynamicObject sourceBill = dynamicObjectArray[var6_8];
            DynamicObjectCollection detailEntries = sourceBill.getDynamicObjectCollection("detailentry");
            Iterator iterator = detailEntries.iterator();
            while (iterator.hasNext()) {
                DynamicObject detailEntry = (DynamicObject)iterator.next();
                srcEntryIdToUnLockAmt.put(detailEntry.getLong("id"), detailEntry.getBigDecimal("unlockamt"));
            }
            ++var6_8;
        }
        HashMap<Long, BigDecimal> transferSrcEntryIdToNeedWBAmt = new HashMap<Long, BigDecimal>(transferBills.size());
        for (DynamicObject dynamicObject : transferBills) {
            DynamicObjectCollection detailEntries = dynamicObject.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailEntry : detailEntries) {
                long srcEntryId = detailEntry.getLong("e_sourcebillentryid");
                BigDecimal detailEntryPriceTaxTotal = detailEntry.getBigDecimal("e_pricetaxtotal");
                transferSrcEntryIdToNeedWBAmt.merge(srcEntryId, detailEntryPriceTaxTotal, BigDecimal::add);
            }
        }
        for (Map.Entry entry : transferSrcEntryIdToNeedWBAmt.entrySet()) {
            Long srcEntryId = (Long)entry.getKey();
            BigDecimal needWBAmt = (BigDecimal)entry.getValue();
            BigDecimal unLockAmt = (BigDecimal)srcEntryIdToUnLockAmt.get(srcEntryId);
            if (unLockAmt == null || needWBAmt.abs().compareTo(unLockAmt.abs()) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u4ed8\u5355\u7684\u5e94\u4ed8\u91d1\u989d\u8d85\u8fc7\u4e86\u6e90\u5355\u7684\u672a\u9501\u5b9a\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApTransferServiceImpl_13", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
    }

    private void setSrcIdAndEntryIdForPlanSettle(List<Long> transferFromIds, List<DynamicObject> transferBills) {
        DynamicObject[] srcFinBills = BusinessDataServiceHelper.load((String)this.finBillKey, (String)String.join((CharSequence)",", "id,org,unplanlockamt,planduedate,e_splitdimensionid,p_splitdimensionid,settleversion"), (QFilter[])new QFilter[]{new QFilter("id", "in", new HashSet<Long>(transferFromIds))});
        HashMap<Long, DynamicObject> srcFinBillMap = new HashMap<Long, DynamicObject>(srcFinBills.length);
        HashMap<Long, Integer> srcEntryIdToDimensionId = new HashMap<Long, Integer>(8);
        for (DynamicObject srcFinBill : srcFinBills) {
            srcFinBillMap.put(srcFinBill.getLong("id"), srcFinBill);
            DynamicObjectCollection detailEntries = srcFinBill.getDynamicObjectCollection(this.finDetailEntryKey);
            for (DynamicObject detailEntry : detailEntries) {
                srcEntryIdToDimensionId.put(detailEntry.getLong("id"), detailEntry.getInt("e_splitdimensionid"));
            }
            this.srcBillIdToSettleVersion.put(srcFinBill.getLong("id"), SettleVersionServiceHelper.isOldVersion((DynamicObject)srcFinBill));
        }
        for (DynamicObject transferBill : transferBills) {
            DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection(this.finDetailEntryKey);
            for (DynamicObject detailEntry : detailEntries) {
                long srcEntryId = detailEntry.getLong("e_sourcebillentryid");
                detailEntry.set("e_splitdimensionid", srcEntryIdToDimensionId.get(srcEntryId));
            }
        }
        this.splitPlanEntryBySrcIdAndDimensionId(transferBills);
        this.setSrcIdAndEntryId(transferBills, srcFinBillMap);
        this.reSetSplitDimensionId(transferBills);
        for (DynamicObject transferBill : transferBills) {
            this.setHeadDueDate(transferBill);
        }
    }

    private void splitPlanEntryBySrcIdAndDimensionId(List<DynamicObject> transferBills) {
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(2);
        ArrayList<String> dimensions = new ArrayList<String>(2);
        dimensionMappings.put("e_sourcebillid", "p_sourcebillid");
        dimensionMappings.put("e_splitdimensionid", "p_splitdimensionid");
        dimensionMappings.put("corebillid", "plancorebillid");
        dimensionMappings.put("corebillno", "plancorebillno");
        dimensions.add("e_sourcebillid");
        dimensions.add("e_splitdimensionid");
        dimensions.add("corebillid");
        dimensions.add("corebillno");
        for (DynamicObject transferBill : transferBills) {
            PlanSplitService splitService = new PlanSplitService(transferBill, dimensions);
            List planRowDatas = splitService.execute();
            DynamicObjectCollection planEntries = transferBill.getDynamicObjectCollection(this.finPlanEntryKey);
            planEntries.clear();
            DynamicObject settlementType = transferBill.getDynamicObject("settlementtype");
            for (int i = 0; i < planRowDatas.size(); ++i) {
                PlanRowData planRowData = (PlanRowData)planRowDatas.get(i);
                DetailGroupData groupData = planRowData.getGroupData();
                Map dimensionMap = groupData.getDimensionMap();
                DynamicObject planEntry = new DynamicObject(planEntries.getDynamicObjectType());
                planEntry.set("seq", (Object)(i + 1));
                for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                    String detailKey = (String)dimensionMapping.getKey();
                    String planKey = (String)dimensionMapping.getValue();
                    Object dimensionValue = dimensionMap.get(detailKey);
                    planEntry.set(planKey, dimensionValue);
                }
                BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
                planEntry.set("planpricetax", (Object)priceTaxTotal);
                planEntry.set("unplanlockamt", (Object)priceTaxTotal);
                planEntry.set("unplansettleamt", (Object)priceTaxTotal);
                BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
                planEntry.set("planpricetaxloc", (Object)priceTaxTotalLocal);
                planEntry.set("unplansettlelocamt", (Object)priceTaxTotalLocal);
                planEntry.set("planduedate", (Object)planRowData.getDueDate());
                planEntry.set("plansettletype", (Object)settlementType);
                planEntry.set("e_freezestate", (Object)"unfreeze");
                planEntry.set("p_payrate", (Object)planRowData.getRate());
                planEntries.add((Object)planEntry);
            }
        }
    }

    private void setSrcIdAndEntryId(List<DynamicObject> transferBills, Map<Long, DynamicObject> srcFinBillMap) {
        for (DynamicObject transferBill : transferBills) {
            DynamicObjectCollection transferPlanEntries = transferBill.getDynamicObjectCollection("planentity");
            ArrayList<DynamicObject> newPlanEntries = new ArrayList<DynamicObject>(transferPlanEntries.size());
            int seqCount = 0;
            CloneUtils clone = new CloneUtils(true, true);
            block1: for (DynamicObject transferPlanEntry : transferPlanEntries) {
                BigDecimal planEntryPriceTaxTotal = transferPlanEntry.getBigDecimal("planpricetax");
                if (planEntryPriceTaxTotal.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal planEntryPriceTaxLocalTotal = transferPlanEntry.getBigDecimal("planpricetaxloc");
                BigDecimal planPayRate = transferPlanEntry.getBigDecimal("p_payrate");
                BigDecimal remainAmt = planEntryPriceTaxTotal;
                BigDecimal remainLocalAmt = BigDecimal.ZERO;
                BigDecimal remainRate = BigDecimal.ZERO;
                long srcBillId = transferPlanEntry.getLong("p_sourcebillid");
                DynamicObject sourceBill = srcFinBillMap.get(srcBillId);
                DynamicObjectCollection sourcePlanEntries = sourceBill.getDynamicObjectCollection("planentity");
                for (DynamicObject sourcePlanEntry : sourcePlanEntries) {
                    BigDecimal planUnLockAmt;
                    int transferPlanSplitDimensionId;
                    int srcPlanSplitDimensionId;
                    Boolean isOldVersion = this.srcBillIdToSettleVersion.get(srcBillId);
                    if (!isOldVersion.booleanValue() && (srcPlanSplitDimensionId = sourcePlanEntry.getInt("p_splitdimensionid")) != (transferPlanSplitDimensionId = transferPlanEntry.getInt("p_splitdimensionid")) || (planUnLockAmt = sourcePlanEntry.getBigDecimal("unplanlockamt")).compareTo(BigDecimal.ZERO) == 0) continue;
                    DynamicObject planEntry = (DynamicObject)clone.clone((IDataEntityBase)transferPlanEntry);
                    BigDecimal curEntryAmt = remainAmt.abs().compareTo(planUnLockAmt.abs()) > 0 ? planUnLockAmt : remainAmt;
                    BigDecimal curEntryLocalAmt = this.getLocalAmt(curEntryAmt, this.exchange, this.localCurrencyPrecison);
                    planEntry.set("seq", (Object)(++seqCount));
                    planEntry.set("planpricetax", (Object)curEntryAmt);
                    planEntry.set("planpricetaxloc", (Object)curEntryLocalAmt);
                    planEntry.set("unplansettleamt", (Object)curEntryAmt);
                    planEntry.set("unplansettlelocamt", (Object)curEntryLocalAmt);
                    planEntry.set("unplanlockamt", (Object)curEntryAmt);
                    planEntry.set("planduedate", this.transferInfo.getDate("duedate") == null ? sourcePlanEntry.get("planduedate") : this.transferInfo.getDate("duedate"));
                    planEntry.set("plansettletype", transferBill.get("settlementtype"));
                    planEntry.set("e_freezestate", (Object)"unfreeze");
                    BigDecimal payRate = curEntryAmt.multiply(planPayRate).divide(planEntryPriceTaxTotal, 2, RoundingMode.HALF_UP);
                    planEntry.set("p_payrate", (Object)payRate);
                    planEntry.set("p_sourcebillid", (Object)srcBillId);
                    planEntry.set("p_sourcebillentryid", (Object)sourcePlanEntry.getLong("id"));
                    if (curEntryAmt.signum() != 0) {
                        newPlanEntries.add(planEntry);
                    }
                    remainAmt = remainAmt.subtract(curEntryAmt);
                    sourcePlanEntry.set("unplanlockamt", (Object)planUnLockAmt.subtract(curEntryAmt));
                    if (remainAmt.compareTo(BigDecimal.ZERO) == 0) {
                        curEntryLocalAmt = planEntryPriceTaxLocalTotal.subtract(remainLocalAmt);
                        planEntry.set("planpricetaxloc", (Object)curEntryLocalAmt);
                        planEntry.set("unplansettlelocamt", (Object)curEntryLocalAmt);
                        planEntry.set("p_payrate", (Object)planPayRate.subtract(remainRate));
                        continue block1;
                    }
                    remainLocalAmt = remainLocalAmt.add(curEntryLocalAmt);
                    remainRate = remainRate.add(payRate);
                }
            }
            transferPlanEntries.clear();
            transferPlanEntries.addAll(newPlanEntries);
        }
    }

    private void reSetSplitDimensionId(List<DynamicObject> transferBills) {
        for (DynamicObject transferBill : transferBills) {
            String key;
            Boolean isOldVersion;
            long srcBillId;
            DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection("detailentry");
            DynamicObjectCollection planEntries = transferBill.getDynamicObjectCollection("planentity");
            int splitDimensionIdIndex = 0;
            HashMap<String, Integer> planSrcIdToSplitDimensionId = new HashMap<String, Integer>(8);
            for (DynamicObject planEntry : planEntries) {
                srcBillId = planEntry.getLong("p_sourcebillid");
                isOldVersion = this.srcBillIdToSettleVersion.get(srcBillId);
                if (isOldVersion.booleanValue()) {
                    key = String.valueOf(srcBillId);
                } else {
                    int planSplitDimensionId = planEntry.getInt("p_splitdimensionid");
                    key = srcBillId + "_" + planSplitDimensionId;
                }
                Integer newSplitDimensionId = (Integer)planSrcIdToSplitDimensionId.get(key);
                if (newSplitDimensionId == null) {
                    planSrcIdToSplitDimensionId.put(key, splitDimensionIdIndex);
                    planEntry.set("p_splitdimensionid", (Object)splitDimensionIdIndex);
                    ++splitDimensionIdIndex;
                    continue;
                }
                planEntry.set("p_splitdimensionid", (Object)newSplitDimensionId);
            }
            for (DynamicObject detailEntry : detailEntries) {
                srcBillId = detailEntry.getLong("e_sourcebillid");
                isOldVersion = this.srcBillIdToSettleVersion.get(srcBillId);
                if (isOldVersion.booleanValue()) {
                    key = String.valueOf(srcBillId);
                } else {
                    int detailOldSplitDimensionId = detailEntry.getInt("e_splitdimensionid");
                    key = srcBillId + "_" + detailOldSplitDimensionId;
                }
                detailEntry.set("e_splitdimensionid", planSrcIdToSplitDimensionId.get(key));
            }
        }
    }

    private void setHeadDueDate(DynamicObject finApBill) {
        Date planMaxDuedate = finApBill.getDate("duedate");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finApBill.set("duedate", (Object)planMaxDuedate);
    }
}

