/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class InvoiceCardHelper {
    private static final String ADDS = "flex_addseller";
    private static final String SINFO = "flex_sellerinfo";
    private static final String ADDB = "flex_addbuyer";
    private static final String BINFO = "flex_buyerinfo";

    public static Map<String, Object> initSellerParamMap(IDataModel m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object asstact = m.getValue("asstact");
        if (asstact != null) {
            DynamicObject obj = (DynamicObject)asstact;
            asstact = obj.getPkValue();
        }
        map.put("asstactname", m.getValue("asstactname"));
        map.put("asstact", asstact);
        map.put("asstacttype", m.getValue("asstacttype"));
        map.put("sellertin", m.getValue("sellertin"));
        map.put("selleraddr", m.getValue("selleraddr"));
        map.put("sellertel", m.getValue("sellertel"));
        map.put("sellerbank", m.getValue("sellerbank"));
        map.put("selleracct", m.getValue("selleracct"));
        return map;
    }

    public static void setSellerInfo(AbstractBillPlugIn form, Map<String, Object> map) {
        IDataModel model = form.getView().getModel();
        model.setValue("asstactname", map.get("asstactname"));
        if (!ObjectUtils.isEmpty((Object)map.get("asstact"))) {
            model.setValue("receivablessupp", map.get("asstact"));
        }
        model.setValue("asstact", map.get("asstact"));
        model.setValue("sellertin", map.get("sellertin"));
        model.setValue("selleraddr", map.get("selleraddr"));
        model.setValue("sellertel", map.get("sellertel"));
        model.setValue("sellerbank", map.get("sellerbank"));
        model.setValue("selleracct", map.get("selleracct"));
        InvoiceCardHelper.setSellerLabel(form);
    }

    public static void setSellerLabel(AbstractBillPlugIn form) {
        IDataModel model = form.getView().getModel();
        if (EmptyUtils.isEmpty((Object)model.getValue("asstactname"))) {
            form.getView().setVisible(Boolean.TRUE, new String[]{ADDS});
            form.getView().setVisible(Boolean.FALSE, new String[]{SINFO});
        } else {
            ((Label)form.getControl("sellerv")).setText(model.getValue("asstactname").toString());
            ((Label)form.getControl("stin")).setText(model.getValue("sellertin").toString());
            ((Label)form.getControl("saddr")).setText(model.getValue("selleraddr").toString());
            ((Label)form.getControl("stel")).setText(model.getValue("sellertel").toString());
            ((Label)form.getControl("sbank")).setText(model.getValue("sellerbank").toString());
            ((Label)form.getControl("sacct")).setText(model.getValue("selleracct").toString());
            form.getView().setVisible(Boolean.FALSE, new String[]{ADDS});
            form.getView().setVisible(Boolean.TRUE, new String[]{SINFO});
        }
    }

    public static void fillBuyerInfo(IDataModel m, DynamicObject org) {
        m.setValue("buyer", org.getPkValue());
        if (StringUtils.isEmpty((String)org.getString("ffirmname"))) {
            m.setValue("buyername", (Object)org.getString("name"));
        } else {
            m.setValue("buyername", (Object)org.getString("ffirmname"));
        }
        m.setValue("buyertin", org.get("ftaxregnum"));
        m.setValue("buyeraddr", (Object)org.getString("faddress"));
        m.setValue("buyertel", org.get("phone"));
        m.setValue("buyerbank", (Object)org.getString("depositbank"));
        m.setValue("buyeracct", org.get("bankaccount"));
    }

    public static Map<String, Object> initBuyerParamMap(IDataModel m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object buyer = m.getValue("buyer");
        if (buyer != null) {
            DynamicObject obj = (DynamicObject)buyer;
            buyer = obj.getPkValue();
        }
        map.put("buyer", buyer);
        map.put("buyername", m.getValue("buyername"));
        map.put("buyertin", m.getValue("buyertin"));
        map.put("buyeraddr", m.getValue("buyeraddr"));
        map.put("buyertel", m.getValue("buyertel"));
        map.put("buyerbank", m.getValue("buyerbank"));
        map.put("buyeracct", m.getValue("buyeracct"));
        return map;
    }

    public static void setBuyerInfo(AbstractBillPlugIn form, Map<String, Object> map) {
        IDataModel model = form.getView().getModel();
        model.setValue("buyer", map.get("buyer"));
        model.setValue("buyername", map.get("buyername"));
        model.setValue("buyertin", map.get("buyertin"));
        model.setValue("buyeraddr", map.get("buyeraddr"));
        model.setValue("buyertel", map.get("buyertel"));
        model.setValue("buyerbank", map.get("buyerbank"));
        model.setValue("buyeracct", map.get("buyeracct"));
        InvoiceCardHelper.setBuyerLabel(form);
    }

    public static void setBuyerLabel(AbstractBillPlugIn form) {
        IDataModel model = form.getView().getModel();
        if (model.getValue("buyername") == null || "".equals(model.getValue("buyername").toString().trim())) {
            form.getView().setVisible(Boolean.TRUE, new String[]{ADDB});
            form.getView().setVisible(Boolean.FALSE, new String[]{BINFO});
        } else {
            ((Label)form.getControl("bname")).setText(model.getValue("buyername").toString());
            ((Label)form.getControl("btin")).setText(model.getValue("buyertin").toString());
            ((Label)form.getControl("baddr")).setText(model.getValue("buyeraddr").toString());
            ((Label)form.getControl("btel")).setText(model.getValue("buyertel").toString());
            ((Label)form.getControl("bbank")).setText(model.getValue("buyerbank").toString());
            ((Label)form.getControl("bacct")).setText(model.getValue("buyeracct").toString());
            form.getView().setVisible(Boolean.FALSE, new String[]{ADDB});
            form.getView().setVisible(Boolean.TRUE, new String[]{BINFO});
        }
    }
}

