/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.ap.business.init.impl.InitAsstactPaidAmtDetail;
import kd.fi.ap.business.init.impl.InitAsstactPayAmtDetail;
import kd.fi.ap.business.init.info.InitAmtPair;
import kd.fi.arapcommon.init.IInitAsstactDetail;
import kd.fi.arapcommon.init.info.AmtPair;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;

public class ApInitHelper {
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ApInitHelper.getInitEntryList", (int)3);

    public static List<InitEntryInfo> getInitEntryList(long orgPk) {
        List<InitEntryInfo> entryList = null;
        try {
            InitAsstactPayAmtDetail finAmtDetail = new InitAsstactPayAmtDetail("ap_finapbill", orgPk);
            InitAsstactPayAmtDetail bizAmtDetail = new InitAsstactPayAmtDetail("ap_busbill", orgPk);
            InitAsstactPaidAmtDetail paidAmtDetail = new InitAsstactPaidAmtDetail(orgPk);
            Future fin = threadPool.submit(() -> ((IInitAsstactDetail)finAmtDetail).getAsstDetail(), RequestContext.get());
            Future bus = threadPool.submit(() -> ((IInitAsstactDetail)bizAmtDetail).getAsstDetail(), RequestContext.get());
            Future paid = threadPool.submit(() -> ((IInitAsstactDetail)paidAmtDetail).getAsstDetail(), RequestContext.get());
            List finDetail = (List)fin.get();
            List busDetail = (List)bus.get();
            List paidDetail = (List)paid.get();
            entryList = ApInitHelper.merge(finDetail, busDetail, paidDetail);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return entryList;
    }

    public static List<InitEntryInfo> merge(List<InitEntryInfo> finAmtDetail, List<InitEntryInfo> bizAmtDetail, List<InitEntryInfo> paidAmtDetail) {
        InitAmtPair pair;
        MergeKey key;
        HashMap<MergeKey, InitAmtPair> mergeResult = new HashMap<MergeKey, InitAmtPair>();
        for (InitEntryInfo info : finAmtDetail) {
            key = info.getMergeKey();
            pair = (InitAmtPair)((Object)mergeResult.get(key));
            if (pair == null) {
                mergeResult.put(key, (InitAmtPair)info.getAmtPair());
                continue;
            }
            pair.addAndGetFinAmt(((InitAmtPair)info.getAmtPair()).getFinAmt());
        }
        for (InitEntryInfo info : bizAmtDetail) {
            key = info.getMergeKey();
            pair = (InitAmtPair)((Object)mergeResult.get(key));
            if (pair == null) {
                mergeResult.put(key, (InitAmtPair)info.getAmtPair());
                continue;
            }
            pair.addAndGetBizAmt(((InitAmtPair)info.getAmtPair()).getBizAmt());
        }
        for (InitEntryInfo info : paidAmtDetail) {
            key = info.getMergeKey();
            pair = (InitAmtPair)((Object)mergeResult.get(key));
            if (pair == null) {
                mergeResult.put(key, (InitAmtPair)info.getAmtPair());
                continue;
            }
            pair.addAndGetPaidAmt(((InitAmtPair)info.getAmtPair()).getPaidAmt());
        }
        ArrayList<InitEntryInfo> result = new ArrayList<InitEntryInfo>(mergeResult.size());
        for (Map.Entry entry : mergeResult.entrySet()) {
            MergeKey key2 = (MergeKey)entry.getKey();
            InitAmtPair pair2 = (InitAmtPair)((Object)entry.getValue());
            InitEntryInfo info = new InitEntryInfo(key2, (AmtPair)pair2);
            result.add(info);
        }
        Collections.sort(result, (o1, o2) -> {
            if (o1.getMergeKey().getAsst() > o2.getMergeKey().getAsst()) {
                return 1;
            }
            if (o1.getMergeKey().getAsst() == o2.getMergeKey().getAsst()) {
                return 0;
            }
            return -1;
        });
        return result;
    }
}

