/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.init.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.init.impl.InitAsstactPayAmtDetail;
import kd.fi.ap.business.init.info.InitAmtPair;
import kd.fi.arapcommon.init.AbstractInitAsstactDetail;
import kd.fi.arapcommon.init.info.AmtPair;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;

public class InitAsstactPaidAmtDetail
extends AbstractInitAsstactDetail {
    public InitAsstactPaidAmtDetail(long orgPk) {
        super("ap_paidbill", orgPk);
    }

    public String getSelector() {
        return "payeetype, payee, currency, actpayamt";
    }

    public String[] getGroupBys() {
        return new String[]{"payeetype", "payee", "currency"};
    }

    protected String getAmountField() {
        return "actpayamt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InitEntryInfo> getAsstDetail() {
        ArrayList<InitEntryInfo> result = new ArrayList<InitEntryInfo>();
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)this.orgPk), new QFilter("billstatus", "!=", (Object)"A")};
        try (DataSet ds = null;){
            DataSet bizDS = QueryServiceHelper.queryDataSet((String)InitAsstactPayAmtDetail.class.toString(), (String)this.entityName, (String)this.getSelector(), (QFilter[])filters, null);
            bizDS = bizDS.groupBy(new String[]{"payeetype", "payee", "currency"}).sum("actpayamt").finish();
            ArrayList asstTypes = new ArrayList();
            DataSet asstactTypeDS = bizDS.copy();
            asstactTypeDS = asstactTypeDS.groupBy(new String[]{"payeetype"}).finish();
            asstactTypeDS.forEach(row -> asstTypes.add(row.getString("payeetype")));
            if (!asstTypes.isEmpty()) {
                DataSet bdDS = this.getAsstDataSet(asstTypes);
                DataSet dataSet = bizDS.leftJoin(bdDS).on("payee", "id").select(new String[]{"payeetype", "masterid", "currency", "actpayamt"}).finish();
                ds = dataSet.groupBy(new String[]{"payeetype", "masterid", "currency"}).sum("actpayamt").finish();
                ds.forEach(row -> {
                    String asstactType = row.getString("payeetype");
                    long asstact = row.getLong("masterid");
                    long currency = row.getLong("currency");
                    BigDecimal paidAmt = row.getBigDecimal("actpayamt");
                    MergeKey mergeKey = new MergeKey(asstactType, asstact, currency);
                    InitAmtPair pair = new InitAmtPair(null, null, paidAmt);
                    InitEntryInfo info = new InitEntryInfo(mergeKey, (AmtPair)pair);
                    result.add(info);
                });
            }
        }
        return result;
    }
}

