/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.enums.InvoiceAdjustEnum;
import kd.fi.ap.enums.InvoiceAdjustFilterEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.vo.InvoiceAdjustDiffVO;
import kd.fi.ap.vo.InvoiceAdjustParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.helper.ApFarmTaxAmtHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.util.AllocationUtils;

public class InvoiceAdjustDiffService {
    private static final Log logger = LogFactory.getLog(InvoiceAdjustDiffService.class);
    private InvoiceAdjustParam invoiceAdjustParam;
    private final Map<Long, Map<String, Object>> appParameters = new HashMap<Long, Map<String, Object>>(64);
    private Map<Long, DynamicObject> handAdjustInvoiceMap = new HashMap<Long, DynamicObject>(8);

    public void executeAdjustDiff(DynamicObject[] finApBills, InvoiceAdjustParam invoiceAdjustParam) {
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return;
        }
        logger.info("InvoiceAdjustDiffService_executeAdjustDiff finApBills.size = " + finApBills.length);
        List<InvoiceAdjustDiffVO> adjustDiffVOS = this.preAdjustDiff(finApBills, invoiceAdjustParam);
        this.calculateFinApBill(finApBills, adjustDiffVOS);
    }

    public List<InvoiceAdjustDiffVO> preAdjustDiff(DynamicObject[] finApBills, InvoiceAdjustParam invoiceAdjustParam) {
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return new ArrayList<InvoiceAdjustDiffVO>(2);
        }
        Map<InvoiceAdjustFilterEnum, Set<String>> notAdjustApBillMap = this.preValidateFinApBills(finApBills, invoiceAdjustParam);
        Object[] canAdjustDiffBills = this.filterFinApBills(finApBills, notAdjustApBillMap);
        if (ObjectUtils.isEmpty((Object[])canAdjustDiffBills)) {
            logger.info("InvoiceAdjustDiffService_preAdjustDiff filtered is null.");
            return new ArrayList<InvoiceAdjustDiffVO>(2);
        }
        List<InvoiceAdjustDiffVO> adjustDiffVOS = this.processAdjustDiffAmount((DynamicObject[])canAdjustDiffBills);
        logger.info("InvoiceAdjustDiffService_preAdjustDiff adjustDiffVOS : " + adjustDiffVOS);
        this.addAdjustLog(finApBills[0].getString("billno"), adjustDiffVOS, invoiceAdjustParam);
        return adjustDiffVOS;
    }

    public Map<InvoiceAdjustFilterEnum, Set<String>> preValidateFinApBills(DynamicObject[] finApBills, InvoiceAdjustParam invoiceAdjustParam) {
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return new HashMap<InvoiceAdjustFilterEnum, Set<String>>(8);
        }
        this.init(finApBills, invoiceAdjustParam);
        return this.getNotAdjustFinApBillMap(finApBills, false);
    }

    private void init(DynamicObject[] finApBills, InvoiceAdjustParam invoiceAdjustParam) {
        if (invoiceAdjustParam == null) {
            return;
        }
        ArrayList<Long> needQueryOrgIds = new ArrayList<Long>(64);
        for (DynamicObject finApBill : finApBills) {
            long orgId = finApBill.getLong("org.id");
            if (!ObjectUtils.isEmpty(this.appParameters.get(orgId))) continue;
            needQueryOrgIds.add(orgId);
        }
        if (!needQueryOrgIds.isEmpty()) {
            Map tempAppParameters = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.FALSE, needQueryOrgIds, (String[])new String[]{"ap_024", "ap_022", "ap022_condition"});
            this.appParameters.putAll(tempAppParameters);
        }
        this.invoiceAdjustParam = invoiceAdjustParam;
        if (ObjectUtils.isEmpty((Object[])invoiceAdjustParam.getInvoices())) {
            HashSet<Long> invoiceIds = new HashSet<Long>(8);
            for (DynamicObject finApBill : finApBills) {
                DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    invoiceIds.add(invRow.getLong("invid"));
                }
            }
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"invoicestatus,amount,tax,pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
            this.handAdjustInvoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
        }
    }

    private void calculateFinApBill(DynamicObject[] finApBills, List<InvoiceAdjustDiffVO> adjustDiffVOS) {
        if (ObjectUtils.isEmpty((Object[])finApBills) || ObjectUtils.isEmpty(adjustDiffVOS)) {
            return;
        }
        Map<Long, InvoiceAdjustDiffVO> adjustDiffVOMap = adjustDiffVOS.stream().collect(Collectors.toMap(InvoiceAdjustDiffVO::getBillId, Function.identity()));
        ArrayList<DynamicObject> hasAdjustBills = new ArrayList<DynamicObject>(64);
        for (DynamicObject finApBill : finApBills) {
            InvoiceAdjustDiffVO adjustDiffVO = (InvoiceAdjustDiffVO)adjustDiffVOMap.get(finApBill.getLong("id"));
            if (adjustDiffVO == null || adjustDiffVO.getDetailRow() == null) continue;
            DynamicObject detailRow = adjustDiffVO.getDetailRow();
            detailRow.set("e_amount", (Object)adjustDiffVO.getNewAmount());
            detailRow.set("e_tax", (Object)adjustDiffVO.getNewTax());
            detailRow.set("e_pricetaxtotal", (Object)adjustDiffVO.getNewPriceTax());
            detailRow.set("e_taxdiffamt", (Object)adjustDiffVO.getTaxDiffAmt());
            detailRow.set("e_amountdiffamt", (Object)adjustDiffVO.getAmountDiffAmt());
            detailRow.set("e_pricetaxdiffamt", (Object)adjustDiffVO.getPriceTaxDiffAmt());
            detailRow.set("e_amountbase", (Object)adjustDiffVO.getNewLocalAmount());
            detailRow.set("e_taxlocalamt", (Object)adjustDiffVO.getNewLocalTax());
            detailRow.set("e_pricetaxtotalbase", (Object)adjustDiffVO.getNewLocalPriceTax());
            detailRow.set("e_unverifyamount", (Object)adjustDiffVO.getNewAmount().subtract(detailRow.getBigDecimal("verifyamount")));
            detailRow.set("unlockamt", (Object)adjustDiffVO.getNewPriceTax().subtract(detailRow.getBigDecimal("lockedamt")));
            detailRow.set("unsettleamt", (Object)adjustDiffVO.getNewPriceTax().subtract(detailRow.getBigDecimal("settledamt")));
            detailRow.set("unsettleamtbase", (Object)adjustDiffVO.getNewLocalPriceTax().subtract(detailRow.getBigDecimal("settledamtbase")));
            detailRow.set("e_uninvoicedamt", (Object)adjustDiffVO.getNewPriceTax().subtract(detailRow.getBigDecimal("e_invoicedamt")));
            hasAdjustBills.add(finApBill);
        }
        logger.info("InvoiceAdjustDiffService_calculateFinApBill hasAdjustBills.size = " + hasAdjustBills.size());
        if (hasAdjustBills.isEmpty()) {
            return;
        }
        this.calculateHeadAndPlanEntry(hasAdjustBills, adjustDiffVOMap);
        this.afterAdjustDiff(hasAdjustBills);
    }

    private List<InvoiceAdjustDiffVO> processAdjustDiffAmount(DynamicObject[] finApBills) {
        ArrayList<InvoiceAdjustDiffVO> adjustDiffVOS = new ArrayList<InvoiceAdjustDiffVO>(64);
        InvoiceAdjustEnum invoiceAdjustEnum = this.invoiceAdjustParam.getInvoiceAdjustEnum();
        for (DynamicObject finApBill : finApBills) {
            DynamicObject needAdjustDetail;
            boolean isCanForwardAdjust = false;
            if (InvoiceAdjustEnum.ROLLBACKTHENADJUST == invoiceAdjustEnum) {
                Map<InvoiceAdjustFilterEnum, Set<String>> notAdjustApBillMap = this.getNotAdjustFinApBillMap(new DynamicObject[]{finApBill}, true);
                Object[] canForwardAdjust = this.filterFinApBills(new DynamicObject[]{finApBill}, notAdjustApBillMap);
                boolean bl = isCanForwardAdjust = !ObjectUtils.isEmpty((Object[])canForwardAdjust);
            }
            if ((needAdjustDetail = this.getHasAdjustDetailRow(finApBill)) == null) {
                needAdjustDetail = this.findNeedAdjustDetail(finApBill);
            }
            if (needAdjustDetail == null) continue;
            InvoiceAdjustDiffVO adjustDiffVO = this.getInvoiceAmount(finApBill);
            String quotation = finApBill.getString("quotation");
            BigDecimal exchangeRate = finApBill.getBigDecimal("exchangerate");
            int basePrecision = finApBill.getInt("basecurrency.amtprecision");
            if (basePrecision == 0) {
                basePrecision = 2;
            }
            adjustDiffVO.setBillId(finApBill.getLong("id"));
            adjustDiffVO.setDetailRow(needAdjustDetail);
            BigDecimal newHeadAmount = finApBill.getBigDecimal("amount");
            BigDecimal newHeadTax = finApBill.getBigDecimal("tax");
            BigDecimal newHeadPriceTax = finApBill.getBigDecimal("pricetaxtotal");
            BigDecimal newEAmount = needAdjustDetail.getBigDecimal("e_amount");
            BigDecimal newETax = needAdjustDetail.getBigDecimal("e_tax");
            BigDecimal newEPriceTax = needAdjustDetail.getBigDecimal("e_pricetaxtotal");
            BigDecimal taxDiffAmt = BigDecimal.ZERO;
            BigDecimal amountDiffAmt = BigDecimal.ZERO;
            BigDecimal priceTaxDiffAmt = BigDecimal.ZERO;
            if (InvoiceAdjustEnum.ROLLBACK == invoiceAdjustEnum || InvoiceAdjustEnum.ROLLBACKTHENADJUST == invoiceAdjustEnum) {
                newEAmount = newEAmount.subtract(needAdjustDetail.getBigDecimal("e_amountdiffamt"));
                newETax = newETax.subtract(needAdjustDetail.getBigDecimal("e_taxdiffamt"));
                newEPriceTax = newEPriceTax.subtract(needAdjustDetail.getBigDecimal("e_pricetaxdiffamt"));
                newHeadAmount = newHeadAmount.subtract(needAdjustDetail.getBigDecimal("e_amountdiffamt"));
                newHeadTax = newHeadTax.subtract(needAdjustDetail.getBigDecimal("e_taxdiffamt"));
                newHeadPriceTax = newHeadPriceTax.subtract(needAdjustDetail.getBigDecimal("e_pricetaxdiffamt"));
            }
            if (isCanForwardAdjust && !this.isInAdjustDiffRange(finApBill.getLong("org.id"), adjustDiffVO, newHeadAmount, newHeadTax, newHeadPriceTax)) {
                isCanForwardAdjust = false;
            }
            if (!(InvoiceAdjustEnum.ADJUST != invoiceAdjustEnum && !isCanForwardAdjust || adjustDiffVO.getInvTax().signum() == 0 && adjustDiffVO.getInvAmount().signum() == 0 && adjustDiffVO.getInvPriceTax().signum() == 0)) {
                taxDiffAmt = adjustDiffVO.getInvTax().subtract(newHeadTax);
                amountDiffAmt = adjustDiffVO.getInvAmount().subtract(newHeadAmount);
                priceTaxDiffAmt = adjustDiffVO.getInvPriceTax().subtract(newHeadPriceTax);
                newETax = newETax.add(taxDiffAmt);
                newEAmount = newEAmount.add(amountDiffAmt);
                newEPriceTax = newEPriceTax.add(priceTaxDiffAmt);
            }
            adjustDiffVO.setTaxDiffAmt(taxDiffAmt);
            adjustDiffVO.setAmountDiffAmt(amountDiffAmt);
            adjustDiffVO.setPriceTaxDiffAmt(priceTaxDiffAmt);
            adjustDiffVO.setOldAmount(needAdjustDetail.getBigDecimal("e_amount"));
            adjustDiffVO.setOldTax(needAdjustDetail.getBigDecimal("e_tax"));
            adjustDiffVO.setOldPriceTax(needAdjustDetail.getBigDecimal("e_pricetaxtotal"));
            adjustDiffVO.setNewAmount(newEAmount);
            adjustDiffVO.setNewTax(newETax);
            adjustDiffVO.setNewPriceTax(newEPriceTax);
            BigDecimal eLocalAmount = BigDecimal.ZERO;
            BigDecimal eLocalTax = BigDecimal.ZERO;
            BigDecimal eLocalPriceTax = BigDecimal.ZERO;
            if ("0".equals(quotation)) {
                eLocalAmount = adjustDiffVO.getNewAmount().multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
                eLocalTax = adjustDiffVO.getNewTax().multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
                eLocalPriceTax = adjustDiffVO.getNewPriceTax().multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
            } else {
                eLocalAmount = adjustDiffVO.getNewAmount().divide(exchangeRate, basePrecision, RoundingMode.HALF_UP);
                eLocalTax = adjustDiffVO.getNewTax().divide(exchangeRate, basePrecision, RoundingMode.HALF_UP);
                eLocalPriceTax = adjustDiffVO.getNewPriceTax().divide(exchangeRate, basePrecision, RoundingMode.HALF_UP);
            }
            adjustDiffVO.setOldLocalAmount(needAdjustDetail.getBigDecimal("e_amountbase"));
            adjustDiffVO.setOldLocalTax(needAdjustDetail.getBigDecimal("e_taxlocalamt"));
            adjustDiffVO.setOldLocalPriceTax(needAdjustDetail.getBigDecimal("e_pricetaxtotalbase"));
            adjustDiffVO.setNewLocalAmount(eLocalAmount);
            adjustDiffVO.setNewLocalTax(eLocalTax);
            adjustDiffVO.setNewLocalPriceTax(eLocalPriceTax);
            adjustDiffVOS.add(adjustDiffVO);
        }
        adjustDiffVOS.removeIf(diffVO -> diffVO.getOldPriceTax().compareTo(diffVO.getNewPriceTax()) == 0 && diffVO.getOldTax().compareTo(diffVO.getNewTax()) == 0 && diffVO.getOldAmount().compareTo(diffVO.getNewAmount()) == 0);
        return adjustDiffVOS;
    }

    private Map<InvoiceAdjustFilterEnum, Set<String>> getNotAdjustFinApBillMap(DynamicObject[] finApBills, boolean isSecond) {
        HashMap<InvoiceAdjustFilterEnum, Set<String>> notAdjustApBillMap = new HashMap<InvoiceAdjustFilterEnum, Set<String>>(8);
        if (this.invoiceAdjustParam == null) {
            return notAdjustApBillMap;
        }
        Set dataNotInRangeBillNos = notAdjustApBillMap.getOrDefault(InvoiceAdjustFilterEnum.DATANOTINRANGE, new HashSet(8));
        Set otherApOccupyBillNos = notAdjustApBillMap.getOrDefault(InvoiceAdjustFilterEnum.OTHERBILLOCCUPY, new HashSet(8));
        Set otherFilterBillNos = notAdjustApBillMap.getOrDefault(InvoiceAdjustFilterEnum.OTHERS, new HashSet(8));
        InvoiceAdjustEnum invoiceAdjustEnum = this.invoiceAdjustParam.getInvoiceAdjustEnum();
        DynamicObject[] invoices = this.invoiceAdjustParam.getInvoices();
        Set<String> invHasMoreFinBillNos = this.getInvoiceAssignOthers(finApBills);
        for (DynamicObject finApBill : finApBills) {
            String billNo = finApBill.getString("billno");
            long orgId = finApBill.getLong("org.id");
            String billStatus = finApBill.getString("billstatus");
            String sourceBillType = finApBill.getString("sourcebilltype");
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            Map<String, Object> parameterMap = this.appParameters.get(orgId);
            if (!(this.invoiceAdjustParam.isIgnoreSysParam() || InvoiceAdjustEnum.ADJUST != invoiceAdjustEnum && (InvoiceAdjustEnum.ROLLBACKTHENADJUST != invoiceAdjustEnum || !isSecond) || parameterMap != null && ((Boolean)parameterMap.get("ap_024")).booleanValue())) {
                otherFilterBillNos.add(billNo);
                continue;
            }
            if ("C".equals(billStatus)) {
                otherFilterBillNos.add(billNo);
                continue;
            }
            if (finApBill.getDynamicObjectCollection("detailentry").isEmpty()) {
                otherFilterBillNos.add(billNo);
                continue;
            }
            if (InvoiceAdjustEnum.ADJUST == invoiceAdjustEnum && (invoices == null || invoices.length == 0)) {
                ArrayList<DynamicObject> canAdjustInvRows = new ArrayList<DynamicObject>(8);
                for (DynamicObject invRow : invEntry) {
                    DynamicObject invoice = this.handAdjustInvoiceMap.get(invRow.getLong("invid"));
                    if (invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
                    canAdjustInvRows.add(invRow);
                }
                if (canAdjustInvRows.isEmpty()) {
                    otherFilterBillNos.add(billNo);
                    continue;
                }
            }
            if (!"antiassign".equals(this.invoiceAdjustParam.getOperateKey()) && !"deleteinventry".equals(this.invoiceAdjustParam.getOperateKey()) && finApBill.getBigDecimal("settleamount").signum() != 0) {
                otherFilterBillNos.add(billNo);
                continue;
            }
            if (finApBill.getBoolean("istanspay") || finApBill.getBoolean("iswrittenoff") || finApBill.getBoolean("ispremium") || finApBill.getBoolean("isvoucher")) {
                otherFilterBillNos.add(billNo);
                continue;
            }
            if (finApBill.getBoolean("relationpay") && "ar_finarbill".equals(sourceBillType)) {
                otherFilterBillNos.add(billNo);
                continue;
            }
            if (this.isNormalFinApBill(finApBill)) {
                otherFilterBillNos.add(billNo);
                continue;
            }
            if (InvoiceAdjustEnum.ADJUST == invoiceAdjustEnum) {
                BigDecimal priceTaxTotal;
                BigDecimal tax;
                BigDecimal amount;
                List<InvoiceAdjustDiffVO> invoiceAdjustDiffVOS = this.processAdjustDiffAmount(new DynamicObject[]{finApBill});
                if (invoiceAdjustDiffVOS.isEmpty()) {
                    otherFilterBillNos.add(billNo);
                    continue;
                }
                InvoiceAdjustDiffVO adjustDiffVO = invoiceAdjustDiffVOS.get(0);
                if (!this.isInAdjustDiffRange(orgId, adjustDiffVO, amount = finApBill.getBigDecimal("amount"), tax = finApBill.getBigDecimal("tax"), priceTaxTotal = finApBill.getBigDecimal("pricetaxtotal"))) {
                    dataNotInRangeBillNos.add(billNo);
                    continue;
                }
            }
            if (!invHasMoreFinBillNos.contains(finApBill.getString("billno"))) continue;
            otherApOccupyBillNos.add(billNo);
        }
        notAdjustApBillMap.put(InvoiceAdjustFilterEnum.DATANOTINRANGE, dataNotInRangeBillNos);
        notAdjustApBillMap.put(InvoiceAdjustFilterEnum.OTHERBILLOCCUPY, otherApOccupyBillNos);
        notAdjustApBillMap.put(InvoiceAdjustFilterEnum.OTHERS, otherFilterBillNos);
        return notAdjustApBillMap;
    }

    private InvoiceAdjustDiffVO getInvoiceAmount(DynamicObject finApBill) {
        InvoiceAdjustDiffVO adjustDiffVO = new InvoiceAdjustDiffVO();
        BigDecimal totalInvAmount = BigDecimal.ZERO;
        BigDecimal totalInvTax = BigDecimal.ZERO;
        BigDecimal totalInvPriceTaxAmt = BigDecimal.ZERO;
        DynamicObject[] invoices = this.invoiceAdjustParam.getInvoices();
        if (invoices != null) {
            for (DynamicObject invoice : invoices) {
                totalInvAmount = totalInvAmount.add(invoice.getBigDecimal("amount"));
                totalInvTax = totalInvTax.add(invoice.getBigDecimal("tax"));
                totalInvPriceTaxAmt = totalInvPriceTaxAmt.add(invoice.getBigDecimal("pricetaxtotal"));
            }
        } else {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            if (!invEntry.isEmpty()) {
                Set srcTypeEnums = Arrays.stream(InvoiceSrcTypeEnum.values()).map(InvoiceSrcTypeEnum::getValue).collect(Collectors.toSet());
                for (DynamicObject invRow : invEntry) {
                    DynamicObject invoice = this.handAdjustInvoiceMap.get(invRow.getLong("invid"));
                    if (!srcTypeEnums.contains(invRow.getString("i_srctype")) || invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
                    totalInvAmount = totalInvAmount.add(invRow.getBigDecimal("i_amount"));
                    totalInvTax = totalInvTax.add(invRow.getBigDecimal("i_tax"));
                    totalInvPriceTaxAmt = totalInvPriceTaxAmt.add(invRow.getBigDecimal("i_pricetaxtotal"));
                }
            }
        }
        adjustDiffVO.setInvAmount(totalInvAmount);
        adjustDiffVO.setInvTax(totalInvTax);
        adjustDiffVO.setInvPriceTax(totalInvPriceTaxAmt);
        return adjustDiffVO;
    }

    private DynamicObject getHasAdjustDetailRow(DynamicObject finApBill) {
        if (InvoiceAdjustEnum.ADJUST == this.invoiceAdjustParam.getInvoiceAdjustEnum()) {
            return null;
        }
        DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailRow : detailEntry) {
            if (detailRow.getBigDecimal("e_taxdiffamt").signum() == 0 && detailRow.getBigDecimal("e_amountdiffamt").signum() == 0 && detailRow.getBigDecimal("e_pricetaxdiffamt").signum() == 0) continue;
            return detailRow;
        }
        return null;
    }

    private void calculateHeadAndPlanEntry(List<DynamicObject> finApBills, Map<Long, InvoiceAdjustDiffVO> adjustDiffVOMap) {
        if (ObjectUtils.isEmpty(finApBills)) {
            return;
        }
        for (DynamicObject finApBill : finApBills) {
            InvoiceAdjustDiffVO adjustDiffVO = adjustDiffVOMap.get(finApBill.getLong("id"));
            if (adjustDiffVO == null) continue;
            BigDecimal amountDiff = adjustDiffVO.getNewAmount().subtract(adjustDiffVO.getOldAmount());
            BigDecimal amountLocalDiff = adjustDiffVO.getNewLocalAmount().subtract(adjustDiffVO.getOldLocalAmount());
            BigDecimal taxDiff = adjustDiffVO.getNewTax().subtract(adjustDiffVO.getOldTax());
            BigDecimal taxLocalDiff = adjustDiffVO.getNewLocalTax().subtract(adjustDiffVO.getOldLocalTax());
            BigDecimal priceTaxDiff = adjustDiffVO.getNewPriceTax().subtract(adjustDiffVO.getOldPriceTax());
            BigDecimal priceTaxLocalDiff = adjustDiffVO.getNewLocalPriceTax().subtract(adjustDiffVO.getOldLocalPriceTax());
            finApBill.set("amount", (Object)finApBill.getBigDecimal("amount").add(amountDiff));
            finApBill.set("amountbase", (Object)finApBill.getBigDecimal("amountbase").add(amountLocalDiff));
            finApBill.set("tax", (Object)finApBill.getBigDecimal("tax").add(taxDiff));
            finApBill.set("taxlocamt", (Object)finApBill.getBigDecimal("taxlocamt").add(taxLocalDiff));
            finApBill.set("pricetaxtotal", (Object)finApBill.getBigDecimal("pricetaxtotal").add(priceTaxDiff));
            finApBill.set("pricetaxtotalbase", (Object)finApBill.getBigDecimal("pricetaxtotalbase").add(priceTaxLocalDiff));
            finApBill.set("unsettleamount", (Object)finApBill.getBigDecimal("unsettleamount").add(priceTaxDiff));
            finApBill.set("unsettleamountbase", (Object)finApBill.getBigDecimal("unsettleamountbase").add(priceTaxLocalDiff));
            finApBill.set("unverifyamount", (Object)finApBill.getBigDecimal("unverifyamount").add(amountDiff));
            finApBill.set("uninvoicedamt", (Object)finApBill.getBigDecimal("uninvoicedamt").add(priceTaxDiff));
        }
        PlanSplitAndBuilder.splitAndBuild((DynamicObject[])finApBills.toArray(new DynamicObject[0]));
    }

    private void afterAdjustDiff(List<DynamicObject> finApBills) {
        if (ObjectUtils.isEmpty(finApBills)) {
            return;
        }
        for (DynamicObject finApBill : finApBills) {
            BigDecimal billLocAmt;
            BigDecimal priceTaxTotal = finApBill.getBigDecimal("pricetaxtotal");
            BigDecimal amount = finApBill.getBigDecimal("amount");
            BigDecimal pricetaxTotalBase = finApBill.getBigDecimal("pricetaxtotalbase");
            BigDecimal amountBase = finApBill.getBigDecimal("amountbase");
            BigDecimal premiumRate = finApBill.getBigDecimal("premiumrate");
            int precision = finApBill.getInt("currency.amtprecision");
            if (precision == 0) {
                precision = 2;
            }
            finApBill.set("premiumamt", (Object)priceTaxTotal.multiply(premiumRate.divide(new BigDecimal(100))).setScale(precision, 4));
            boolean isInTax = finApBill.getBoolean("isintax");
            BigDecimal billAmt = isInTax ? priceTaxTotal : amount;
            BigDecimal bigDecimal = billLocAmt = isInTax ? pricetaxTotalBase : amountBase;
            boolean needRecalculate = AllocationUtils.isNeedRecalculate((BigDecimal)billAmt, (DynamicObject)finApBill);
            if (!needRecalculate) continue;
            AllocationUtils.executeCalculation((BigDecimal)billAmt, (BigDecimal)billLocAmt, (DynamicObject)finApBill);
        }
        ApFarmTaxAmtHelper.setFinDecuAmt((DynamicObject[])finApBills.toArray(new DynamicObject[0]));
        this.putUnallocatedAmt(finApBills.toArray(new DynamicObject[0]));
    }

    private DynamicObject[] filterFinApBills(DynamicObject[] finApBills, Map<InvoiceAdjustFilterEnum, Set<String>> notAdjustApBillMap) {
        if (ObjectUtils.isEmpty(notAdjustApBillMap)) {
            return finApBills;
        }
        HashSet notAdjustApBillIds = new HashSet(8);
        for (Map.Entry<InvoiceAdjustFilterEnum, Set<String>> entrySet : notAdjustApBillMap.entrySet()) {
            notAdjustApBillIds.addAll(entrySet.getValue());
        }
        ArrayList<DynamicObject> canAdjustDiffBills = new ArrayList<DynamicObject>(64);
        for (DynamicObject finApBill : finApBills) {
            if (notAdjustApBillIds.contains(finApBill.getString("billno"))) continue;
            canAdjustDiffBills.add(finApBill);
        }
        return canAdjustDiffBills.toArray(new DynamicObject[0]);
    }

    private Set<String> getInvoiceAssignOthers(DynamicObject[] finApBills) {
        Set<Object> invoiceIds = new HashSet(64);
        DynamicObject[] invoices = this.invoiceAdjustParam.getInvoices();
        if (invoices != null) {
            invoiceIds = Arrays.stream(invoices).map(inv -> inv.getLong("id")).collect(Collectors.toSet());
        }
        Map moreOccupyFinMap = InvoiceHelper.getInvoiceOtherOccupyMap((DynamicObject[])finApBills, invoiceIds);
        return moreOccupyFinMap.keySet();
    }

    private boolean isInAdjustDiffRange(long orgId, InvoiceAdjustDiffVO adjustDiffVO, BigDecimal eAmount, BigDecimal eTax, BigDecimal ePriceTaxAmt) {
        Map parameterMap = this.appParameters.getOrDefault(orgId, new HashMap(2));
        BigDecimal diffRang = ArApHelper.getBigDecimal(parameterMap.get("ap022_condition"));
        BigDecimal invAmount = adjustDiffVO.getInvAmount();
        BigDecimal invTax = adjustDiffVO.getInvTax();
        BigDecimal invPriceTaxAmt = adjustDiffVO.getInvPriceTax();
        return (Boolean)parameterMap.get("ap_022") == false || invAmount.subtract(eAmount).abs().compareTo(diffRang) <= 0 && invTax.subtract(eTax).abs().compareTo(diffRang) <= 0 && invPriceTaxAmt.subtract(ePriceTaxAmt).abs().compareTo(diffRang) <= 0;
    }

    private DynamicObject findNeedAdjustDetail(DynamicObject finApBill) {
        BigDecimal priceTaxTotal = finApBill.getBigDecimal("pricetaxtotal");
        DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
        List sameDirectionDetailRows = detailEntry.stream().filter(row -> row.getBigDecimal("e_pricetaxtotal").signum() == priceTaxTotal.signum()).collect(Collectors.toList());
        ArrayList<DynamicObject> maxTaxRows = new ArrayList<DynamicObject>(64);
        for (DynamicObject sameDirectionDetailRow : sameDirectionDetailRows) {
            if (maxTaxRows.isEmpty()) {
                maxTaxRows.add(sameDirectionDetailRow);
                continue;
            }
            BigDecimal maxTax = ((DynamicObject)maxTaxRows.get(0)).getBigDecimal("e_tax").abs();
            BigDecimal eTax = sameDirectionDetailRow.getBigDecimal("e_tax").abs();
            if (eTax.compareTo(maxTax) > 0) {
                maxTaxRows.clear();
                maxTaxRows.add(sameDirectionDetailRow);
                continue;
            }
            if (eTax.compareTo(maxTax) != 0) continue;
            maxTaxRows.add(sameDirectionDetailRow);
        }
        if (maxTaxRows.size() == 1) {
            return (DynamicObject)maxTaxRows.get(0);
        }
        ArrayList<DynamicObject> maxPriceTaxRows = new ArrayList<DynamicObject>(64);
        for (DynamicObject maxTaxRow : maxTaxRows) {
            if (maxPriceTaxRows.isEmpty()) {
                maxPriceTaxRows.add(maxTaxRow);
                continue;
            }
            BigDecimal maxPriceTax = ((DynamicObject)maxPriceTaxRows.get(0)).getBigDecimal("e_pricetaxtotal").abs();
            BigDecimal ePriceTax = maxTaxRow.getBigDecimal("e_pricetaxtotal").abs();
            if (ePriceTax.compareTo(maxPriceTax) > 0) {
                maxPriceTaxRows.clear();
                maxPriceTaxRows.add(maxTaxRow);
                continue;
            }
            if (ePriceTax.compareTo(maxPriceTax) != 0) continue;
            maxPriceTaxRows.add(maxTaxRow);
        }
        if (!maxPriceTaxRows.isEmpty()) {
            return (DynamicObject)maxPriceTaxRows.get(0);
        }
        return null;
    }

    private boolean isNormalFinApBill(DynamicObject finApBill) {
        if (InvoiceAdjustEnum.ROLLBACK == this.invoiceAdjustParam.getInvoiceAdjustEnum()) {
            boolean isDiffAmtAllZero = true;
            DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailRow : detailEntry) {
                if (detailRow.getBigDecimal("e_taxdiffamt").signum() == 0 && detailRow.getBigDecimal("e_amountdiffamt").signum() == 0 && detailRow.getBigDecimal("e_pricetaxdiffamt").signum() == 0) continue;
                isDiffAmtAllZero = false;
                break;
            }
            return isDiffAmtAllZero;
        }
        if (InvoiceAdjustEnum.ADJUST == this.invoiceAdjustParam.getInvoiceAdjustEnum()) {
            InvoiceAdjustDiffVO adjustDiffVO = this.getInvoiceAmount(finApBill);
            BigDecimal invAmount = adjustDiffVO.getInvAmount();
            BigDecimal invTax = adjustDiffVO.getInvTax();
            BigDecimal invPriceTaxAmt = adjustDiffVO.getInvPriceTax();
            return invAmount.compareTo(finApBill.getBigDecimal("amount")) == 0 && invTax.compareTo(finApBill.getBigDecimal("tax")) == 0 && invPriceTaxAmt.compareTo(finApBill.getBigDecimal("pricetaxtotal")) == 0;
        }
        return false;
    }

    private void putUnallocatedAmt(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection detailentries = dataEntity.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : detailentries) {
                BigDecimal interCostAmt = entry.getBigDecimal("intercostamt");
                if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                    entry.set("e_unallocatedamt", (Object)entry.getBigDecimal("e_amountbase"));
                    continue;
                }
                entry.set("e_unallocatedamt", (Object)interCostAmt);
            }
        }
    }

    private void addAdjustLog(String billNo, List<InvoiceAdjustDiffVO> adjustDiffVOS, InvoiceAdjustParam invoiceAdjustParam) {
        if (ObjectUtils.isEmpty(adjustDiffVOS)) {
            return;
        }
        ArrayList<String> logInfos = new ArrayList<String>(2);
        logInfos.add(invoiceAdjustParam.toString());
        logInfos.add(adjustDiffVOS.toString());
        LogUtil.addOpLog((String)"ap_finapbill", (Object)billNo, (String)ApInvoiceServiceEnum.INVOCIEADJUST.getValue(), (String)SerializationUtils.toJsonString(logInfos), (boolean)true);
    }
}

