/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.assign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public abstract class AbstractAssignInvoiceService
implements IAssignInvoiceService {
    protected static final Log logger = LogFactory.getLog(AbstractAssignInvoiceService.class);

    @Override
    public void assign(AssignInvoiceParam assignInvoiceParam) {
        if (ObjectUtils.isEmpty((Object)assignInvoiceParam)) {
            return;
        }
        logger.info("AbstractAssignInvoiceService assign assignInvoiceParam is :" + assignInvoiceParam);
        try (TXHandle txHandle = TX.required();){
            try {
                this.addCtrlControl(assignInvoiceParam, "ap_assign_invoice");
                if (assignInvoiceParam.isAutoAssign()) {
                    this.autoAssign(assignInvoiceParam);
                } else {
                    this.handleAssign(assignInvoiceParam);
                }
            }
            catch (Exception ex) {
                txHandle.markRollback();
                throw ex;
            }
        }
        logger.info("AbstractAssignInvoiceService assign end ");
    }

    @Override
    public void antiAssign(AssignInvoiceParam assignInvoiceParam) {
        if (ObjectUtils.isEmpty((Object)assignInvoiceParam)) {
            return;
        }
        logger.info("AbstractAssignInvoiceService antiAssign assignInvoiceParam is :" + assignInvoiceParam);
        try (TXHandle txHandle = TX.required();){
            try {
                this.addCtrlControl(assignInvoiceParam, "ap_assign_invoice");
                if (assignInvoiceParam.isAutoAssign()) {
                    this.autoAntiAssign(assignInvoiceParam);
                } else {
                    this.handleAntiAssign(assignInvoiceParam);
                }
            }
            catch (Exception ex) {
                txHandle.markRollback();
                throw ex;
            }
        }
        logger.info("AbstractAssignInvoiceService antiAssign end ");
    }

    protected void addCtrlControl(AssignInvoiceParam assignInvoiceParam, String bizString) {
        if (!ObjectUtils.isEmpty(assignInvoiceParam.getInvoiceIds())) {
            ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_invoice", (String)bizString, new HashSet<Long>(assignInvoiceParam.getInvoiceIds()), (boolean)false);
        }
    }

    protected abstract void autoAssign(AssignInvoiceParam var1);

    protected abstract void handleAssign(AssignInvoiceParam var1);

    protected abstract void autoAntiAssign(AssignInvoiceParam var1);

    protected abstract void handleAntiAssign(AssignInvoiceParam var1);

    protected Map<Long, DynamicObject> getInvoiceMap(List<Long> invoiceIds) {
        String selectors = "id,serialno,isreffin,businesssource,synstatus,changesynstatustime,pricetaxtotal,tax,invoicetype,invoicetypef7,invoicecode,invoiceno,issuedate,taxrate,asstactname,buyername,istaxdeduction,remark,billno,billstatus,serialno,currency,businesssource,amount,org,invoicestatus";
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        return Arrays.stream(invoices).collect(Collectors.toMap(i -> i.getLong("id"), Function.identity()));
    }

    protected void createBOTPRelation(String targetEntityName, List<Long> billIds) {
        if (ObjectUtils.isEmpty(billIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", billIds);
        DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"query_latest_bills", (String)targetEntityName, (String)"id,inventry.invid", (QFilter[])new QFilter[]{filter}, (String)"");
        ArrayList deleteBotpParamList = new ArrayList(8);
        HashMap<Long, List> needSaveBotpMap = new HashMap<Long, List>(8);
        for (Row row : billDataSet) {
            Long billId = row.getLong("id");
            Long invoiceId = row.getLong("inventry.invid");
            HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
            paramMap.put("srcBillId", invoiceId);
            paramMap.put("tarBillId", billId);
            deleteBotpParamList.add(paramMap);
            List tempInvoiceIds = needSaveBotpMap.getOrDefault(billId, new ArrayList(8));
            tempInvoiceIds.add(invoiceId);
            needSaveBotpMap.put(billId, tempInvoiceIds);
        }
        for (Map map : deleteBotpParamList) {
            long srcBillId = (Long)map.get("srcBillId");
            long tarBillId = (Long)map.get("tarBillId");
            InvoiceHelper.deleteRelation((String)targetEntityName, (Long)tarBillId, (Long)srcBillId);
        }
        if (!needSaveBotpMap.isEmpty()) {
            BillRelationBuilder billRelationBuilder = new BillRelationBuilder("ap_invoice", targetEntityName);
            for (Map.Entry entrySet : needSaveBotpMap.entrySet()) {
                billRelationBuilder.saveRelation((Collection)entrySet.getValue(), (Long)entrySet.getKey());
            }
        }
    }
}

