/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.assign;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoice.assign.FinApAssignInvoiceServiceImpl;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class InvoiceAssignFinApServiceImpl
extends FinApAssignInvoiceServiceImpl {
    @Override
    protected void handleAssign(AssignInvoiceParam assignInvoiceParam) {
        DynamicObject[] finApBills = this.getFinApBills(assignInvoiceParam.getBillIds());
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(assignInvoiceParam.getInvoiceIds());
        List<Object> matchRecordIds = this.invoiceMatchFin(assignInvoiceParam, finApBills, invoiceMap.values().toArray(new DynamicObject[0]));
        this.afterAssignWriteBack(assignInvoiceParam, matchRecordIds, false);
        if (assignInvoiceParam.isCreateBOTP()) {
            this.createBOTPRelation("ap_finapbill", assignInvoiceParam.getBillIds());
        }
    }

    @Override
    protected void handleAntiAssign(AssignInvoiceParam assignInvoiceParam) {
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(assignInvoiceParam.getInvoiceIds());
        Set orgIds = invoiceMap.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and(new QFilter("inventry.invid", "in", assignInvoiceParam.getInvoiceIds()));
        filter.and(new QFilter("inventry.i_srctype", "=", (Object)InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue()));
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_invassignfin", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, Set<Long>> bill4InvoiceMap = new HashMap<Long, Set<Long>>(8);
        for (Row finApRow : finApDataSet) {
            Long billId = finApRow.getLong("id");
            Set invoiceIds = bill4InvoiceMap.getOrDefault(billId, new HashSet(8));
            invoiceIds.add(finApRow.getLong("inventry.invid"));
            bill4InvoiceMap.put(billId, invoiceIds);
        }
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        deleteParam.setBill4InvoiceMap(bill4InvoiceMap).setOperateKey(assignInvoiceParam.getOperateKey()).setDeleteInvRow(true).setAppId(assignInvoiceParam.getAppId());
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
    }

    @Override
    protected String getISrcType() {
        return InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue();
    }

    @Override
    protected void autoAssign(AssignInvoiceParam assignInvoiceParam) {
        throw new KDBizException("not support.");
    }

    @Override
    protected void autoAntiAssign(AssignInvoiceParam assignInvoiceParam) {
        throw new KDBizException("not support.");
    }
}

