/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.collect;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.fi.ap.business.invoice.Invoice4CloudResolveService;
import kd.fi.ap.business.invoice.collect.AbstractCollectInvoiceService;
import kd.fi.ap.vo.CloudInvoiceResultVO;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class NoSrcCollectInvServiceImpl
extends AbstractCollectInvoiceService {
    @Override
    protected Map<String, DynamicObject> analysisInvoiceData(DynamicObject[] entities) {
        if (!this.isForm) {
            return new HashMap<String, DynamicObject>(8);
        }
        String actionId = this.collectParam.getActionId();
        Map returnData = this.collectParam.getReturnData();
        Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
        List<DynamicObject> downloadInvoices = resolveService.importInvoice4Cloud(this.collectParam.getFormView(), returnData, actionId);
        ConfigCache.clear();
        if (downloadInvoices.isEmpty()) {
            return new HashMap<String, DynamicObject>(2);
        }
        return downloadInvoices.stream().collect(Collectors.toMap(inv -> inv.getString("serialno"), Function.identity()));
    }

    @Override
    protected void beforeCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        if (ObjectUtils.isEmpty(invoiceMap)) {
            this.collectParam.getFormView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9700\u8981\u7684\u53d1\u7968\u6570\u636e\u5df2\u7ecf\u4e0b\u8f7d\u3002", (String)"NoSrcCollectInvServiceImpl_0", (String)"fi-ap-business", (Object[])new Object[0]));
        }
    }

    @Override
    protected CloudInvoiceResultVO processResultVO(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("NoSrcCollectInvServiceImpl processResultVO begin");
        CloudInvoiceResultVO resultVO = super.processResultVO(entities, invoiceMap);
        if (this.isForm) {
            List<String> serialNos = this.getOriginalSerialNos(this.collectParam.getReturnData());
            resultVO.getUnSaveSerialNos().addAll(serialNos);
        }
        return resultVO;
    }
}

