/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.collect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.Invoice4CloudResolveService;
import kd.fi.ap.business.invoice.collect.AbstractCollectInvoiceService;
import kd.fi.ap.business.pojo.InvoiceResolveParam;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;

public class ReplaceApplyCollectInvServiceImpl
extends AbstractCollectInvoiceService {
    @Override
    protected Map<String, DynamicObject> analysisInvoiceData(DynamicObject[] entities) {
        logger.info("ReplaceApplyCollectInvServiceImpl analysisInvoiceData begin.");
        List<DynamicObject> invoices = new ArrayList<DynamicObject>(16);
        String actionId = this.collectParam.getActionId();
        Map returnData = this.collectParam.getReturnData();
        if (this.isForm) {
            Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
            invoices = resolveService.importInvoice4Cloud(this.collectParam.getFormView(), returnData, actionId);
        } else {
            List<DynamicObject> savedInvoices = this.replaceApplyOperateToSaveInv(entities);
            invoices.addAll(savedInvoices);
        }
        return invoices.stream().collect(Collectors.toMap(inv -> inv.getString("serialno"), Function.identity()));
    }

    @Override
    protected void beforeCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("ReplaceApplyCollectInvServiceImpl beforeCollectInvoice begin.");
        if (!this.isForm) {
            return;
        }
        List<String> originalSerialNos = this.getOriginalSerialNos(this.collectParam.getReturnData());
        HashSet<String> needRemoveSerialNos = new HashSet<String>(2);
        IDataModel model = this.collectParam.getFormView().getModel();
        DynamicObjectCollection oldInvEntry = model.getEntryEntity("oldinventry");
        DynamicObjectCollection newInvEntry = model.getEntryEntity("newinventry");
        Set serialNoSet = newInvEntry.stream().map(invEntry -> invEntry.getString("n_serialno")).collect(Collectors.toSet());
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
            String invoiceMessage;
            DynamicObject invoice = entrySet.getValue();
            String serialNo = invoice.getString("serialno");
            originalSerialNos.remove(serialNo);
            String invoiceNo = invoice.getString("invoiceno");
            String invoiceCode = invoice.getString("invoicecode");
            String string = invoiceMessage = ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s", (String)"ReplaceApplyCollectInvServiceImpl_0", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"ReplaceApplyCollectInvServiceImpl_1", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo, invoiceCode);
            if (oldInvEntry.isEmpty() || ((DynamicObject)oldInvEntry.get(0)).getLong("o_currency.id") != invoice.getLong("currency.id")) {
                builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u65b0\u53d1\u7968\u7ed3\u7b97\u5e01\u4e0e\u539f\u53d1\u7968\u7ed3\u7b97\u5e01[%2$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReplaceApplyCollectInvServiceImpl_2", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage, ((DynamicObject)oldInvEntry.get(0)).getString("o_currency.name")));
                builder.append('\n');
                needRemoveSerialNos.add(serialNo);
            }
            if (newInvEntry.isEmpty() || !serialNoSet.contains(serialNo)) continue;
            builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"ReplaceApplyCollectInvServiceImpl_3", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
            builder.append('\n');
            needRemoveSerialNos.add(serialNo);
        }
        if (!originalSerialNos.isEmpty()) {
            originalSerialNos.removeIf(invoiceMap::containsKey);
            if (!originalSerialNos.isEmpty()) {
                DynamicObject org = (DynamicObject)model.getValue("org");
                HashMap<Long, String> orgForSerialMap = new HashMap<Long, String>(2);
                orgForSerialMap.put(org.getLong("id"), String.join((CharSequence)",", originalSerialNos));
                List invoiceVOS = CallCloudHelper.queryCloudInvoice(orgForSerialMap);
                for (InvoiceVO invoiceVO : invoiceVOS) {
                    String invoiceNo = invoiceVO.getInvoiceNo();
                    String invoiceCode = invoiceVO.getInvoiceCode();
                    String invoiceMessage = ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s", (String)"ReplaceApplyCollectInvServiceImpl_4", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"ReplaceApplyCollectInvServiceImpl_5", (String)"fi-ap-business", (Object[])new Object[0]), invoiceNo, invoiceCode);
                    builder.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"ReplaceApplyCollectInvServiceImpl_6", (String)"fi-ap-business", (Object[])new Object[0]), invoiceMessage));
                    builder.append('\n');
                }
            }
        }
        if (builder.length() > 0) {
            this.collectParam.getFormView().showErrorNotification(String.valueOf(builder));
        }
        for (String removeSerialNo : needRemoveSerialNos) {
            invoiceMap.remove(removeSerialNo);
        }
    }

    @Override
    protected void writeBackBills(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("ReplaceApplyCollectInvServiceImpl writeBackBills begin.");
        if (this.isForm && !invoiceMap.isEmpty()) {
            IDataModel model = this.collectParam.getFormView().getModel();
            ArrayList<Long> finApBillIds = new ArrayList<Long>(8);
            HashMap<Long, String> applyBillNoMap = new HashMap<Long, String>(8);
            DynamicObjectCollection oldInvEntry = model.getEntryEntity("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                long finApBillId = oldInvRow.getLong("o_apbillid");
                long applyBillId = oldInvRow.getLong("o_applybillid");
                String applyBillNo = oldInvRow.getString("o_applybillno");
                if (finApBillId != 0L) {
                    finApBillIds.add(finApBillId);
                }
                if (applyBillId == 0L) continue;
                applyBillNoMap.put(applyBillId, applyBillNo);
            }
            DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
            DynamicObject replaceBill = model.getDataEntity(true);
            DynamicObjectCollection newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
            Map invoiceTypeMap = InvoiceTypeHelper.getInvoiceTypeMap();
            for (Map.Entry<String, DynamicObject> entrySet : invoiceMap.entrySet()) {
                int index = model.createNewEntryRow("newinventry");
                DynamicObject newInvRow = (DynamicObject)newInvEntry.get(index);
                DynamicObject downloadInv = entrySet.getValue();
                newInvRow.set("n_srctype", (Object)ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue());
                newInvRow.set("n_invid", (Object)downloadInv.getLong("id"));
                newInvRow.set("n_serialno", (Object)downloadInv.getString("serialno"));
                this.fillUpUnDbFieldValue(newInvRow, downloadInv, invoiceTypeMap);
                if (finApBills.isEmpty()) continue;
                if (finApBills.size() == 1) {
                    newInvRow.set("n_apbillno", (Object)((DynamicObject)finApBills.get(0)).getString("billno"));
                    newInvRow.set("n_apbillid", (Object)((DynamicObject)finApBills.get(0)).getLong("id"));
                    newInvRow.set("n_usedamt", (Object)downloadInv.getBigDecimal("unrelatedamt"));
                    continue;
                }
                HashSet<String> finApBillNos = new HashSet<String>(8);
                for (DynamicObject finApBill : finApBills) {
                    finApBillNos.add(finApBill.getString("billno"));
                    int sonIndex = model.insertEntryRow("newinventry", index);
                    DynamicObject sonOldInvRow = (DynamicObject)model.getEntryEntity("newinventry").get(sonIndex);
                    sonOldInvRow.set("n_invid", downloadInv.get("id"));
                    sonOldInvRow.set("n_serialno", downloadInv.get("serialno"));
                    sonOldInvRow.set("n_srctype", (Object)ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue());
                    this.fillUpUnDbFieldValue(sonOldInvRow, downloadInv, invoiceTypeMap);
                    sonOldInvRow.set("n_apbillno", (Object)finApBill.getString("billno"));
                    sonOldInvRow.set("n_apbillid", (Object)finApBill.getLong("id"));
                }
                String finApBillNosJson = String.join((CharSequence)",", finApBillNos);
                newInvRow.set("n_apbillno", (Object)(finApBillNosJson.length() > 255 ? finApBillNosJson.substring(0, 255) : finApBillNosJson));
            }
            if (applyBillNoMap.size() == 1) {
                DynamicObjectCollection newinventry = model.getEntryEntity("newinventry");
                Map.Entry next = applyBillNoMap.entrySet().iterator().next();
                for (DynamicObject row : newinventry) {
                    row.set("n_applybillid", next.getKey());
                    row.set("n_applybillno", next.getValue());
                }
            }
        }
        if (!this.isForm) {
            DynamicObjectCollection newInvEntry;
            HashSet<Long> invoiceIds = new HashSet<Long>(32);
            for (DynamicObject replaceBill : entities) {
                newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
                for (DynamicObject newInvRow : newInvEntry) {
                    if (!ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype"))) continue;
                    invoiceIds.add(newInvRow.getLong("n_invid"));
                }
            }
            if (invoiceIds.isEmpty()) {
                return;
            }
            for (DynamicObject replaceBill : entities) {
                newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
                for (DynamicObject newInvRow : newInvEntry) {
                    String iSrcType = newInvRow.getString("n_srctype");
                    String invBillNo = newInvRow.getString("n_invbillno");
                    if (!ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType) || !ObjectUtils.isEmpty((Object)invBillNo)) continue;
                    String serialNo = newInvRow.getString("n_serialno");
                    DynamicObject savedInvoice = invoiceMap.get(serialNo);
                    if (savedInvoice == null) {
                        String opKey = "save".equals(this.collectParam.getOperateKey()) ? ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ReplaceApplyCollectInvServiceImpl_7", (String)"fi-ap-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ReplaceApplyCollectInvServiceImpl_8", (String)"fi-ap-business", (Object[])new Object[0]);
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u53d1\u7968\u53f7\u7801\u3001\u53d1\u7968\u4ee3\u7801\u7684\u6536\u7968\u5355\uff0c%s\u5931\u8d25\u3002", (String)"ReplaceApplyCollectInvServiceImpl_9", (String)"fi-ap-business", (Object[])new Object[]{opKey}));
                    }
                    newInvRow.set("n_invid", (Object)savedInvoice.getLong("id"));
                    newInvRow.set("n_invbillno", (Object)savedInvoice.getString("billno"));
                }
            }
        }
    }

    @Override
    protected void afterCollectInvoice(DynamicObject[] entities, Map<String, DynamicObject> invoiceMap) {
        logger.info("ReplaceApplyCollectInvServiceImpl afterCollectInvoice begin.");
        if (this.isForm && !invoiceMap.isEmpty()) {
            IFormView formView = this.collectParam.getFormView();
            ReplaceInvoiceHelper.refreshReplaceNewInvEntry((IFormView)formView, new HashSet(2), invoiceMap.keySet());
        }
        if (!this.isForm) {
            HashMap<Long, String> needAuditInvoiceMap = new HashMap<Long, String>(8);
            for (DynamicObject replaceBill : entities) {
                DynamicObjectCollection newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
                for (DynamicObject newInvRow : newInvEntry) {
                    if (newInvRow.getLong("pid") != 0L || !"submit".equals(this.collectParam.getOperateKey()) || !ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype"))) continue;
                    needAuditInvoiceMap.put(newInvRow.getLong("n_invid"), String.valueOf(newInvRow.getLong("n_invid")));
                }
            }
            this.executeAuditForInvoice(needAuditInvoiceMap, entities);
            SaveServiceHelper.save((DynamicObject[])entities);
        }
    }

    private List<DynamicObject> replaceApplyOperateToSaveInv(DynamicObject[] entities) {
        logger.info("ReplaceApplyCollectInvServiceImpl replaceApplyOperateToSaveInv begin");
        ArrayList<DynamicObject> savedInvoices = new ArrayList<DynamicObject>(32);
        if (ObjectUtils.isEmpty((Object[])entities)) {
            return savedInvoices;
        }
        Map orgForSerialMap = InvoiceHelper.getOrgForSerialMap((DynamicObject[])entities);
        logger.info("ReplaceApplyCollectInvServiceImpl replaceApplyOperateToSaveInv orgForSerialMap : " + orgForSerialMap);
        List invoiceVOS = CallCloudHelper.queryCloudInvoice((Map)orgForSerialMap);
        if (ObjectUtils.isEmpty((Object)invoiceVOS)) {
            return savedInvoices;
        }
        Map invoiceVOMap = invoiceVOS.stream().collect(Collectors.toMap(InvoiceVO::getSerialNo, Function.identity()));
        Set<String> hasInDbInvoiceSerialNos = this.getHasInDbInvoiceSerialNos(entities);
        Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
        for (DynamicObject replaceBill : entities) {
            List<InvoiceVO> tempInvoiceVOs;
            HashMap<String, Long> serialNoToIdMap = new HashMap<String, Long>(8);
            DynamicObjectCollection newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                String serialNo;
                if (!ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype")) || ObjectUtils.isEmpty((Object)(serialNo = newInvRow.getString("n_serialno"))) || hasInDbInvoiceSerialNos.contains(serialNo)) continue;
                serialNoToIdMap.put(serialNo, newInvRow.getLong("n_invid"));
            }
            if (serialNoToIdMap.isEmpty() || (tempInvoiceVOs = invoiceVOMap.entrySet().stream().filter(e1 -> serialNoToIdMap.containsKey(e1.getKey())).map(Map.Entry::getValue).collect(Collectors.toList())).isEmpty()) continue;
            String asstactType = replaceBill.getString("asstacttype");
            DynamicObject asstact = replaceBill.getDynamicObject("asstact");
            InvoiceResolveParam resolveParam = new InvoiceResolveParam();
            resolveParam.setAppId(this.collectParam.getAppId()).setOrgId(replaceBill.getLong("org.id")).setBizType("bd_supplier".equals(asstactType) ? "PUR" : "FEE").setSerialNoMap(serialNoToIdMap).setAsstactType(asstactType).setAsstactId(asstact.getLong("id")).setSrcCollect(true).setNeedSave(true);
            List<DynamicObject> invoices = resolveService.genInvoice(resolveParam, tempInvoiceVOs);
            savedInvoices.addAll(invoices);
        }
        logger.info("ReplaceApplyCollectInvServiceImpl replaceApplyOperateToSaveInv savedInvoices size : " + savedInvoices.size());
        return savedInvoices;
    }

    private Set<String> getHasInDbInvoiceSerialNos(DynamicObject[] entities) {
        HashSet<String> serialNos = new HashSet<String>(16);
        for (DynamicObject replaceBill : entities) {
            DynamicObjectCollection invEntry = replaceBill.getDynamicObjectCollection("newinventry");
            for (DynamicObject invRow : invEntry) {
                if (ObjectUtils.isEmpty((Object)invRow.getString("n_serialno"))) continue;
                serialNos.add(invRow.getString("n_serialno"));
            }
        }
        HashSet<String> hasInDbSerialNos = new HashSet<String>(16);
        if (!serialNos.isEmpty()) {
            DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"queryInvoice", (String)"ap_invoice", (String)"id,serialno", (QFilter[])new QFilter[]{new QFilter("serialno", "in", serialNos)}, (String)"");
            for (Row invoice : invoiceDataSet) {
                hasInDbSerialNos.add(invoice.getString("serialno"));
            }
        }
        return hasInDbSerialNos;
    }

    private void fillUpUnDbFieldValue(DynamicObject newInvRow, DynamicObject downloadInv, Map<String, DynamicObject> invoiceTypeMap) {
        String invoicetype = downloadInv.getString("invoicetype");
        String typeNo = InvoiceType.getTypeNo((String)invoicetype);
        DynamicObject invTypeF7 = invoiceTypeMap.get(typeNo == null ? invoicetype : typeNo);
        newInvRow.set("n_invoicetypef7", (Object)invTypeF7);
        newInvRow.set("n_currency", (Object)downloadInv.getDynamicObject("currency"));
        newInvRow.set("n_invoicecode", (Object)downloadInv.getString("invoicecode"));
        newInvRow.set("n_invoiceno", (Object)downloadInv.getString("invoiceno"));
        newInvRow.set("n_issuedate", (Object)downloadInv.getDate("issuedate"));
        newInvRow.set("n_receivedate", (Object)downloadInv.getDate("receivedate"));
        newInvRow.set("n_buyername", (Object)downloadInv.getString("buyername"));
        newInvRow.set("n_asstactname", (Object)downloadInv.getString("asstactname"));
        newInvRow.set("n_amount", (Object)downloadInv.getBigDecimal("amount"));
        newInvRow.set("n_tax", (Object)downloadInv.getBigDecimal("tax"));
        newInvRow.set("n_pricetaxtotal", (Object)downloadInv.getBigDecimal("pricetaxtotal"));
        newInvRow.set("n_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)downloadInv));
        newInvRow.set("n_istaxdeduction", (Object)downloadInv.getBoolean("istaxdeduction"));
        newInvRow.set("n_invoicestatus", (Object)downloadInv.getString("invoicestatus"));
        newInvRow.set("n_remark", (Object)downloadInv.getString("remark"));
    }
}

