/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.delinv;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public abstract class AbstractInvEntryDeleteService
implements IInvoiceEntryDeleteService {
    protected static final Log logger = LogFactory.getLog(AbstractInvEntryDeleteService.class);

    @Override
    public void deleteInvoiceRow(InvEntryDeleteParam deleteParam) {
        if (ObjectUtils.isEmpty((Object)deleteParam) || ObjectUtils.isEmpty(deleteParam.getBill4InvoiceMap())) {
            return;
        }
        logger.info("AbstractInvEntryDeleteService deleteInvoiceRow begin,deleteParam is : " + deleteParam);
        try (TXHandle txHandle = TX.required();){
            try {
                Map<Long, Set<Long>> bill4InvoiceMap = deleteParam.getBill4InvoiceMap();
                this.addCtrlControl(bill4InvoiceMap);
                logger.info("AbstractInvEntryDeleteService deleteInvoiceRow bill4InvoiceMap.size = " + bill4InvoiceMap.size());
                DynamicObject[] bills = this.getBizBills(bill4InvoiceMap.keySet());
                this.executeDelete(deleteParam, bills);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                throw ex;
            }
        }
        logger.info("AbstractInvEntryDeleteService deleteInvoiceRow end");
    }

    protected abstract String getEntityName();

    protected abstract String getBillSelectors();

    protected abstract void executeDelete(InvEntryDeleteParam var1, DynamicObject[] var2);

    private void addCtrlControl(Map<Long, Set<Long>> bill4InvoiceMap) {
        HashSet invoiceIds = new HashSet(32);
        for (Map.Entry<Long, Set<Long>> entrySet : bill4InvoiceMap.entrySet()) {
            invoiceIds.addAll(entrySet.getValue());
        }
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_invoice", (String)"ap_delete_invRow", invoiceIds, (boolean)false);
        ConcurrencyCtrlUtil.addCtrlInTX((String)this.getEntityName(), (String)"ap_delete_invRow", new HashSet<Long>(bill4InvoiceMap.keySet()), (boolean)false);
    }

    private DynamicObject[] getBizBills(Set<Long> billIds) {
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)this.getBillSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    protected void deleteBOTPRelation(String targetName, List<Map<String, Long>> paramList) {
        if (ObjectUtils.isEmpty(paramList)) {
            return;
        }
        for (Map<String, Long> paramMap : paramList) {
            long srcBillId = paramMap.get("srcBillId");
            long tarBillId = paramMap.get("tarBillId");
            InvoiceHelper.deleteRelation((String)targetName, (Long)tarBillId, (Long)srcBillId);
        }
    }

    protected void invoiceExecuteDeleteOp(Long[] invoiceIds) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isreffin", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"ap_invoice", (Object[])invoiceIds, (OperateOption)option);
        OperationHelper.assertResult((OperationResult)result);
    }
}

