/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoice.delinv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAdjustDiffService;
import kd.fi.ap.business.invoice.articulate.IInvoiceArticulateService;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.invoice.delinv.AbstractInvEntryDeleteService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.InvoiceAdjustEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.vo.InvoiceAdjustParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;

public class FinApInvEntryDeleteServiceImpl
extends AbstractInvEntryDeleteService {
    private final Map<Long, Map<Long, BigDecimal>> finAp4InvoiceOccupyMap = new HashMap<Long, Map<Long, BigDecimal>>(8);

    @Override
    protected void executeDelete(InvEntryDeleteParam deleteParam, DynamicObject[] bills) {
        logger.info("FinApInvEntryDeleteServiceImpl executeDelete begin.");
        Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap = this.executeUnInvoiceMatch(deleteParam, bills, deleteParam.getBill4InvoiceMap());
        logger.info("FinApInvEntryDeleteServiceImpl executeDelete fin4InvRowMap : " + fin4InvRowMap);
        this.afterWriteBackInvAndFin(deleteParam, fin4InvRowMap);
        logger.info("FinApInvEntryDeleteServiceImpl executeDelete afterWriteBackInvAndFin end");
        this.constructBillBOTPRelation(deleteParam, bills);
        logger.info("FinApInvEntryDeleteServiceImpl executeDelete constructBillBOTPRelation end.");
        logger.info("FinApInvEntryDeleteServiceImpl executeDelete end.");
    }

    private void afterWriteBackInvAndFin(InvEntryDeleteParam deleteParam, Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap) {
        logger.info("FinApInvEntryDeleteServiceImpl afterWriteBackInvAndFin begin");
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)this.getFinApSelectors(deleteParam), (QFilter[])new QFilter[]{new QFilter("id", "in", fin4InvRowMap.keySet())});
        Map<String, Set<Long>> invRowTypeMap = this.writeBackFinApBill(deleteParam, finApBills, fin4InvRowMap);
        if (this.isHandAdjustDiff(deleteParam.getOperateKey()) || deleteParam.isOnlyReleaseAmt()) {
            SaveServiceHelper.save((DynamicObject[])finApBills);
            return;
        }
        logger.info("FinApInvEntryDeleteServiceImpl executeDelete executeAdjustDiff begin.");
        InvoiceAdjustEnum invoiceAdjustEnum = this.isAutoAntiAssign(deleteParam.getOperateKey()) ? InvoiceAdjustEnum.ROLLBACK : InvoiceAdjustEnum.ROLLBACKTHENADJUST;
        InvoiceAdjustParam invoiceAdjustParam = new InvoiceAdjustParam(invoiceAdjustEnum);
        invoiceAdjustParam.setOperateKey(deleteParam.getOperateKey());
        InvoiceAdjustDiffService adjustDiffService = (InvoiceAdjustDiffService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOCIEADJUST.getValue());
        adjustDiffService.executeAdjustDiff(finApBills, invoiceAdjustParam);
        logger.info("FinApInvEntryDeleteServiceImpl executeDelete executeAdjustDiff end.");
        this.saveFinApBill(deleteParam, finApBills);
        Map<Long, Set<Long>> billNeedRelease4InvoiceMap = this.getReturnMap(fin4InvRowMap);
        this.writeBackInvoice(deleteParam, finApBills, billNeedRelease4InvoiceMap, invRowTypeMap);
        List<Long> needAgainAssignApBillIds = this.getNeedAgainAssignFinApIds(deleteParam, finApBills, billNeedRelease4InvoiceMap);
        if (!needAgainAssignApBillIds.isEmpty()) {
            logger.info("FinApInvEntryDeleteServiceImpl executeDelete assignInvoiceService begin.");
            AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
            HashSet<String> needAutoOccupySrcTypes = new HashSet<String>(2);
            needAutoOccupySrcTypes.add(InvoiceSrcTypeEnum.INVOICECOLLECT.getValue());
            if (!this.finAp4InvoiceOccupyMap.isEmpty()) {
                needAutoOccupySrcTypes.add(InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue());
            }
            assignInvoiceParam.setBillIds(needAgainAssignApBillIds).setAutoAssign(true).setNeedAutoOccupySrcTypes(needAutoOccupySrcTypes).setCreateBOTP(false).setFinAp4InvoiceOccupyMap(this.finAp4InvoiceOccupyMap);
            IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPASSIGNINVOICE.getValue());
            assignInvoiceService.assign(assignInvoiceParam);
            this.finAp4InvoiceOccupyMap.clear();
            logger.info("FinApInvEntryDeleteServiceImpl executeDelete assignInvoiceService end.");
        }
        logger.info("FinApInvEntryDeleteServiceImpl afterWriteBackInvAndFin end");
    }

    private Map<Long, List<FinApInvoiceRowVO>> executeUnInvoiceMatch(InvEntryDeleteParam deleteParam, DynamicObject[] bills, Map<Long, Set<Long>> bill4InvoiceMap) {
        logger.info("FinApInvEntryDeleteServiceImpl executeUnInvoiceMatch begin.");
        Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap = this.getFin4InvRowMap(bills, bill4InvoiceMap, deleteParam.getOperateKey());
        HashMap<Long, List<FinApInvoiceRowVO>> needUnArticulateFin4InvRowMap = new HashMap<Long, List<FinApInvoiceRowVO>>(8);
        for (DynamicObject bill : bills) {
            if ("delete".equals(deleteParam.getOperateKey()) || "deleteinventry".equals(deleteParam.getOperateKey()) && "A".equals(bill.getString("billstatus"))) continue;
            long billId = bill.getLong("id");
            needUnArticulateFin4InvRowMap.put(billId, fin4InvRowMap.get(billId));
        }
        List<Long> needUnArticulateRecordIds = this.getNeedUnArticulateRecordIds(deleteParam, bills, needUnArticulateFin4InvRowMap);
        logger.info("FinApInvEntryDeleteServiceImpl executeUnInvoiceMatch needUnArticulateRecordIds : " + needUnArticulateRecordIds);
        if (!needUnArticulateRecordIds.isEmpty()) {
            IInvoiceArticulateService articulateService = (IInvoiceArticulateService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOICEARTICULATEFINAP.getValue());
            articulateService.unArticulate(needUnArticulateRecordIds);
            logger.info("FinApInvEntryDeleteServiceImpl executeUnInvoiceMatch end.");
        }
        return fin4InvRowMap;
    }

    private List<Long> getNeedUnArticulateRecordIds(InvEntryDeleteParam deleteParam, DynamicObject[] bills, Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap) {
        HashSet<Long> needUnArticulateRecordIds = new HashSet<Long>(64);
        HashSet<Long> allNeedReleaseAmtInvoiceIds = new HashSet<Long>(8);
        ArrayList<Long> maybeWriteOffFinApIds = new ArrayList<Long>(8);
        for (Map.Entry<Long, List<FinApInvoiceRowVO>> entrySet : fin4InvRowMap.entrySet()) {
            List<FinApInvoiceRowVO> invoiceRowVOS = entrySet.getValue();
            if (ObjectUtils.isEmpty(invoiceRowVOS)) {
                maybeWriteOffFinApIds.add(entrySet.getKey());
                continue;
            }
            for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                if (!invoiceRowVO.isDeleteRow()) continue;
                allNeedReleaseAmtInvoiceIds.add(invoiceRowVO.getInvId());
            }
        }
        Set<Long> orgIds = Arrays.stream(bills).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        needUnArticulateRecordIds.addAll(this.getFinApSelfArticulate(maybeWriteOffFinApIds, orgIds));
        if (allNeedReleaseAmtInvoiceIds.isEmpty()) {
            return new ArrayList<Long>(needUnArticulateRecordIds);
        }
        this.getRecordIdsByInvoiceArticulateFin(orgIds, fin4InvRowMap, allNeedReleaseAmtInvoiceIds, needUnArticulateRecordIds);
        this.getRecordIdsByInvoiceSelf(orgIds, fin4InvRowMap, allNeedReleaseAmtInvoiceIds, needUnArticulateRecordIds);
        HashSet<Long> restReleaseAmtInvoiceIds = new HashSet<Long>(8);
        for (Map.Entry<Long, List<FinApInvoiceRowVO>> entrySet : fin4InvRowMap.entrySet()) {
            List<FinApInvoiceRowVO> invoiceRowVOS = entrySet.getValue();
            BigDecimal restInvUseAmt = null;
            HashSet<Long> restInvoiceIds = new HashSet<Long>(8);
            for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                if (invoiceRowVO.isDeleteRow() || BigDecimal.ZERO.compareTo(invoiceRowVO.getiUseAmt()) == 0) continue;
                restInvUseAmt = restInvUseAmt == null ? invoiceRowVO.getiUseAmt() : restInvUseAmt.add(invoiceRowVO.getiUseAmt());
                restInvoiceIds.add(invoiceRowVO.getInvId());
            }
            if (restInvUseAmt == null || restInvUseAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                if (!restInvoiceIds.contains(invoiceRowVO.getInvId())) continue;
                restReleaseAmtInvoiceIds.add(invoiceRowVO.getInvId());
                invoiceRowVO.setDeleteRow(true);
            }
        }
        if (!restReleaseAmtInvoiceIds.isEmpty()) {
            this.getRecordIdsByInvoiceArticulateFin(orgIds, fin4InvRowMap, restReleaseAmtInvoiceIds, needUnArticulateRecordIds);
            this.getRecordIdsByInvoiceSelf(orgIds, fin4InvRowMap, restReleaseAmtInvoiceIds, needUnArticulateRecordIds);
        }
        this.processBillSelfRecordIds(orgIds, fin4InvRowMap, needUnArticulateRecordIds);
        if (!deleteParam.isOnlyReleaseAmt()) {
            needUnArticulateRecordIds.addAll(this.getRecordIdsByNoNeedDeleteInvRow(deleteParam, bills, fin4InvRowMap));
        }
        return new ArrayList<Long>(needUnArticulateRecordIds);
    }

    private Set<Long> getFinApSelfArticulate(List<Long> maybeWriteOffFinApIds, Set<Long> orgIds) {
        HashSet<Long> needUnArticulateRecordIds = new HashSet<Long>(8);
        if (!maybeWriteOffFinApIds.isEmpty()) {
            QFilter filter = new QFilter("org", "in", orgIds);
            filter.and(new QFilter("writeofftypeid", "=", (Object)1893666267970144256L));
            DataSet asMainRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_record_as_mian", (String)"ap_matchrecord_verify", (String)"id", (QFilter[])new QFilter[]{filter, new QFilter("entry.billid", "in", maybeWriteOffFinApIds)}, (String)"");
            DataSet asAssRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_record_as_ass", (String)"ap_matchrecord_verify", (String)"id", (QFilter[])new QFilter[]{filter, new QFilter("entry.assbillid", "in", maybeWriteOffFinApIds)}, (String)"");
            DataSet recordDataSet = asMainRecordDataSet.union(asAssRecordDataSet).distinct();
            for (Row row : recordDataSet) {
                needUnArticulateRecordIds.add(row.getLong("id"));
            }
        }
        return needUnArticulateRecordIds;
    }

    private void getRecordIdsByInvoiceArticulateFin(Set<Long> orgIds, Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap, Set<Long> allNeedReleaseAmtInvoiceIds, Set<Long> needUnArticulateRecordIds) {
        String selectors = "id,wfseq,entry.billtype,entry.billid,entry.assbilltype,entry.assbillid,entry.matchamt,entry.assmatchamt";
        QFilter filter = new QFilter("entry.billid", "in", allNeedReleaseAmtInvoiceIds);
        filter.and(new QFilter("entry.assbillid", "in", fin4InvRowMap.keySet()));
        filter.and(new QFilter("writeofftypeid", "=", (Object)1893667005572058112L));
        filter.and(new QFilter("org", "in", orgIds));
        DataSet invMatchFinRecords = QueryServiceHelper.queryDataSet((String)"query_finap_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter}, (String)"");
        if (!invMatchFinRecords.hasNext()) {
            return;
        }
        HashMap<String, String> wfSeq4InvoiceMap = new HashMap<String, String>(8);
        for (Row record : invMatchFinRecords) {
            Long recordId = record.getLong("id");
            if (needUnArticulateRecordIds.contains(recordId)) continue;
            String wfSeq = record.getString("wfseq");
            Long invoiceId = record.getLong("entry.billid");
            Long finApBillId = record.getLong("entry.assbillid");
            List<FinApInvoiceRowVO> invoiceRowVOS = fin4InvRowMap.get(finApBillId);
            if (ObjectUtils.isEmpty(invoiceRowVOS)) continue;
            for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                if (!invoiceRowVO.isDeleteRow() || invoiceRowVO.getInvId() != invoiceId.longValue()) continue;
                String key = finApBillId + "_" + invoiceId;
                wfSeq4InvoiceMap.put(key, wfSeq);
                needUnArticulateRecordIds.add(recordId);
            }
        }
        QFilter filter1 = new QFilter("wfseq", "in", wfSeq4InvoiceMap.values());
        filter1.and(new QFilter("writeofftypeid", "=", (Object)1893666802358029312L));
        filter1.and(new QFilter("org", "in", orgIds));
        filter1.and(QFilter.of((String)"entry.billid != entry.assbillid", (Object[])new Object[0]));
        DataSet sameSeqRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_same_seq", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter1}, (String)"");
        if (sameSeqRecordDataSet.hasNext()) {
            Map invSelf4RecordIdMap;
            HashMap<String, Map> sameSeqInvSelf4RecordIdMap = new HashMap<String, Map>(8);
            HashMap<String, BigDecimal> invRecord4MatchAmtMap = new HashMap<String, BigDecimal>(16);
            for (Row record : sameSeqRecordDataSet) {
                Long recordId = record.getLong("id");
                if (needUnArticulateRecordIds.contains(recordId)) continue;
                String wfSeq = record.getString("wfseq");
                Long mainInvId = record.getLong("entry.billid");
                BigDecimal mainMatchAmt = record.getBigDecimal("entry.matchamt");
                Long asstInvId = record.getLong("entry.assbillid");
                BigDecimal asstMatchAmt = record.getBigDecimal("entry.assmatchamt");
                invSelf4RecordIdMap = sameSeqInvSelf4RecordIdMap.getOrDefault(wfSeq, new HashMap(8));
                List asstInvoice4RecordMaps = invSelf4RecordIdMap.getOrDefault(mainInvId, new ArrayList(8));
                HashMap<Long, Long> asstInvoice4RecordMap = new HashMap<Long, Long>(4);
                asstInvoice4RecordMap.put(asstInvId, recordId);
                asstInvoice4RecordMaps.add(asstInvoice4RecordMap);
                invSelf4RecordIdMap.put(mainInvId, asstInvoice4RecordMaps);
                List mainInvoice4RecordMaps = invSelf4RecordIdMap.getOrDefault(asstInvId, new ArrayList(8));
                HashMap<Long, Long> mainInvoice4RecordMap = new HashMap<Long, Long>(4);
                mainInvoice4RecordMap.put(mainInvId, recordId);
                mainInvoice4RecordMaps.add(mainInvoice4RecordMap);
                invSelf4RecordIdMap.put(asstInvId, mainInvoice4RecordMaps);
                sameSeqInvSelf4RecordIdMap.put(wfSeq, invSelf4RecordIdMap);
                invRecord4MatchAmtMap.put(recordId + "_" + mainInvId, mainMatchAmt);
                invRecord4MatchAmtMap.put(recordId + "_" + asstInvId, asstMatchAmt);
            }
            for (Map.Entry<Long, List<FinApInvoiceRowVO>> entrySet : fin4InvRowMap.entrySet()) {
                Long finApBillId = entrySet.getKey();
                List<FinApInvoiceRowVO> invoiceRowVOS = entrySet.getValue();
                Map invoiceRowVOMap = invoiceRowVOS.stream().collect(Collectors.toMap(FinApInvoiceRowVO::getInvId, Function.identity()));
                for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                    String wfSeq;
                    if (!invoiceRowVO.isDeleteRow() || ObjectUtils.isEmpty((Object)(wfSeq = (String)wfSeq4InvoiceMap.get(finApBillId + "_" + invoiceRowVO.getInvId()))) || ObjectUtils.isEmpty((Object)(invSelf4RecordIdMap = (Map)sameSeqInvSelf4RecordIdMap.get(wfSeq))) || invSelf4RecordIdMap.get(invoiceRowVO.getInvId()) == null) continue;
                    List otherInvoice4RecordMaps = (List)invSelf4RecordIdMap.get(invoiceRowVO.getInvId());
                    for (Map otherInvoice4RecordMap : otherInvoice4RecordMaps) {
                        for (Map.Entry entrySet1 : otherInvoice4RecordMap.entrySet()) {
                            Long otherInvId = (Long)entrySet1.getKey();
                            Long recordId = (Long)entrySet1.getValue();
                            needUnArticulateRecordIds.add(recordId);
                            FinApInvoiceRowVO otherInvoiceRow = (FinApInvoiceRowVO)invoiceRowVOMap.get(otherInvId);
                            if (otherInvoiceRow == null || otherInvoiceRow.isDeleteRow()) continue;
                            BigDecimal matchAmt = (BigDecimal)invRecord4MatchAmtMap.get(recordId + "_" + otherInvId);
                            BigDecimal newIUseAmt = otherInvoiceRow.getiUseAmt().subtract(matchAmt);
                            if (BigDecimal.ZERO.compareTo(newIUseAmt) == 0) {
                                otherInvoiceRow.setDeleteRow(true);
                                continue;
                            }
                            otherInvoiceRow.setiUseAmt(newIUseAmt).setReleaseAmt(true);
                        }
                    }
                }
            }
        }
        logger.info("FinApInvEntryDeleteServiceImpl getRecordIdsByInvoiceMatchFin needUnArticulateRecordIds : " + needUnArticulateRecordIds);
    }

    private void getRecordIdsByInvoiceSelf(Set<Long> orgIds, Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap, Set<Long> allNeedReleaseAmtInvoiceIds, Set<Long> needUnArticulateRecordIds) {
        String selectors = "id,wfseq,entry.billtype,entry.billid,entry.assbilltype,entry.assbillid,entry.matchamt,entry.assmatchamt";
        QFilter filter = new QFilter("entry.assbillid", "in", allNeedReleaseAmtInvoiceIds);
        filter.and(new QFilter("writeofftypeid", "=", (Object)1893666802358029312L));
        filter.and(QFilter.of((String)"entry.billid != entry.assbillid", (Object[])new Object[0]));
        filter.and(new QFilter("org", "in", orgIds));
        DataSet invMainSelfRecords = QueryServiceHelper.queryDataSet((String)"query_invself_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter}, (String)"");
        QFilter filter1 = new QFilter("entry.billid", "in", allNeedReleaseAmtInvoiceIds);
        filter1.and(new QFilter("writeofftypeid", "=", (Object)1893666802358029312L));
        filter1.and(QFilter.of((String)"entry.billid != entry.assbillid", (Object[])new Object[0]));
        filter1.and(new QFilter("org", "in", orgIds));
        DataSet invAsstSelfRecords = QueryServiceHelper.queryDataSet((String)"query_invself_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter1}, (String)"");
        DataSet invoiceSelfMatchRecordDataSet = invMainSelfRecords.union(invAsstSelfRecords);
        if (!invoiceSelfMatchRecordDataSet.hasNext()) {
            return;
        }
        HashMap<String, Map> sameWfSeqInvSelfMatch4RecordIdMap = new HashMap<String, Map>(8);
        HashMap<Long, Set> inv4WfSeqMap = new HashMap<Long, Set>(16);
        HashMap<String, BigDecimal> invoice4RecordAmtMap = new HashMap<String, BigDecimal>(16);
        for (Row record : invoiceSelfMatchRecordDataSet) {
            Set wfSeqs;
            String wfSeq = record.getString("wfseq");
            Long recordId = record.getLong("id");
            if (needUnArticulateRecordIds.contains(recordId)) continue;
            Long mainBillId = record.getLong("entry.billid");
            BigDecimal mainMatchAmt = record.getBigDecimal("entry.matchamt");
            Long assBillId = record.getLong("entry.assbillid");
            BigDecimal asstMatchAmt = record.getBigDecimal("entry.assmatchamt");
            Map invoiceSelfMatch4RecordIdMap = sameWfSeqInvSelfMatch4RecordIdMap.getOrDefault(wfSeq, new HashMap(16));
            List asst4RecordIdMaps = invoiceSelfMatch4RecordIdMap.getOrDefault(mainBillId, new ArrayList(8));
            HashMap<Long, Long> asst4RecordIdMap = new HashMap<Long, Long>(2);
            asst4RecordIdMap.put(assBillId, recordId);
            asst4RecordIdMaps.add(asst4RecordIdMap);
            invoiceSelfMatch4RecordIdMap.put(mainBillId, asst4RecordIdMaps);
            List main4RecordIdMaps = invoiceSelfMatch4RecordIdMap.getOrDefault(assBillId, new ArrayList(8));
            HashMap<Long, Long> main4RecordIdMap = new HashMap<Long, Long>(2);
            main4RecordIdMap.put(mainBillId, recordId);
            main4RecordIdMaps.add(main4RecordIdMap);
            invoiceSelfMatch4RecordIdMap.put(assBillId, main4RecordIdMaps);
            sameWfSeqInvSelfMatch4RecordIdMap.put(wfSeq, invoiceSelfMatch4RecordIdMap);
            if (allNeedReleaseAmtInvoiceIds.contains(mainBillId)) {
                wfSeqs = inv4WfSeqMap.getOrDefault(mainBillId, new HashSet(4));
                wfSeqs.add(wfSeq);
                inv4WfSeqMap.put(mainBillId, wfSeqs);
            }
            if (allNeedReleaseAmtInvoiceIds.contains(assBillId)) {
                wfSeqs = inv4WfSeqMap.getOrDefault(assBillId, new HashSet(4));
                wfSeqs.add(wfSeq);
                inv4WfSeqMap.put(assBillId, wfSeqs);
            }
            invoice4RecordAmtMap.put(recordId + "_" + mainBillId, mainMatchAmt);
            invoice4RecordAmtMap.put(recordId + "_" + assBillId, asstMatchAmt);
        }
        QFilter filter2 = new QFilter("wfseq", "in", sameWfSeqInvSelfMatch4RecordIdMap.keySet());
        filter2.and(new QFilter("writeofftypeid", "=", (Object)1893667005572058112L));
        filter2.and(new QFilter("org", "in", orgIds));
        DataSet invoiceMatchFinApDataSet = QueryServiceHelper.queryDataSet((String)"query_invoice_match_finap", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter2}, (String)"");
        HashMap<Long, Map> finAp4SameSeqInvRecordIdMap = new HashMap<Long, Map>(8);
        for (Row record : invoiceMatchFinApDataSet) {
            Long recordId = record.getLong("id");
            if (needUnArticulateRecordIds.contains(recordId)) continue;
            String wfSeq = record.getString("wfseq");
            Long invoiceId = record.getLong("entry.billid");
            Long finApBillId = record.getLong("entry.assbillid");
            Map sameSeq4InvRecordIdMap = finAp4SameSeqInvRecordIdMap.getOrDefault(finApBillId, new HashMap(8));
            List invRecordIdMaps = sameSeq4InvRecordIdMap.getOrDefault(wfSeq, new ArrayList(8));
            HashMap<Long, Long> invRecordIdMap = new HashMap<Long, Long>(2);
            invRecordIdMap.put(invoiceId, recordId);
            invRecordIdMaps.add(invRecordIdMap);
            sameSeq4InvRecordIdMap.put(wfSeq, invRecordIdMaps);
            finAp4SameSeqInvRecordIdMap.put(finApBillId, sameSeq4InvRecordIdMap);
        }
        for (Map.Entry<Long, List<FinApInvoiceRowVO>> entrySet : fin4InvRowMap.entrySet()) {
            Long finApBillId = entrySet.getKey();
            List<FinApInvoiceRowVO> invoiceRowVOS = entrySet.getValue();
            Map invoiceRowVOMap = invoiceRowVOS.stream().collect(Collectors.toMap(FinApInvoiceRowVO::getInvId, Function.identity()));
            Map sameSeq4InvRecordIdMap = (Map)finAp4SameSeqInvRecordIdMap.get(finApBillId);
            for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                Set wfSeqs;
                if (!invoiceRowVO.isDeleteRow() || ObjectUtils.isEmpty((Object)(wfSeqs = (Set)inv4WfSeqMap.get(invoiceRowVO.getInvId())))) continue;
                for (String wfSeq : wfSeqs) {
                    List invRecordIdMaps;
                    List otherInv4RecordIdMaps;
                    Map invoiceSelfMatch4RecordIdMap = (Map)sameWfSeqInvSelfMatch4RecordIdMap.get(wfSeq);
                    if (ObjectUtils.isEmpty((Object)invoiceSelfMatch4RecordIdMap) || ObjectUtils.isEmpty((Object)(otherInv4RecordIdMaps = (List)invoiceSelfMatch4RecordIdMap.get(invoiceRowVO.getInvId())))) continue;
                    for (Map otherInv4RecordIdMap : otherInv4RecordIdMaps) {
                        for (Map.Entry entrySet1 : otherInv4RecordIdMap.entrySet()) {
                            Long otherInvId = (Long)entrySet1.getKey();
                            Long recordId = (Long)entrySet1.getValue();
                            FinApInvoiceRowVO otherInvoiceRowVo = (FinApInvoiceRowVO)invoiceRowVOMap.get(otherInvId);
                            if (otherInvoiceRowVo == null) continue;
                            BigDecimal matchAmt = (BigDecimal)invoice4RecordAmtMap.get(recordId + "_" + otherInvId);
                            if (!otherInvoiceRowVo.isDeleteRow()) {
                                BigDecimal newIUseAmt = otherInvoiceRowVo.getiUseAmt().subtract(matchAmt);
                                if (BigDecimal.ZERO.compareTo(newIUseAmt) == 0) {
                                    otherInvoiceRowVo.setDeleteRow(true);
                                } else {
                                    otherInvoiceRowVo.setiUseAmt(newIUseAmt).setReleaseAmt(true);
                                }
                            }
                            needUnArticulateRecordIds.add(recordId);
                        }
                    }
                    if (ObjectUtils.isEmpty((Object)sameSeq4InvRecordIdMap) || ObjectUtils.isEmpty(sameSeq4InvRecordIdMap.get(wfSeq)) || ObjectUtils.isEmpty((Object)(invRecordIdMaps = (List)sameSeq4InvRecordIdMap.get(wfSeq)))) continue;
                    for (Map invRecordIdMap : invRecordIdMaps) {
                        if (ObjectUtils.isEmpty(invRecordIdMap.get(invoiceRowVO.getInvId()))) continue;
                        Long recordId = (Long)invRecordIdMap.get(invoiceRowVO.getInvId());
                        needUnArticulateRecordIds.add(recordId);
                    }
                }
            }
        }
        logger.info("FinApInvEntryDeleteServiceImpl getRecordIdsByInvoiceSelfMatch needUnArticulateRecordIds : " + needUnArticulateRecordIds);
    }

    private void processBillSelfRecordIds(Set<Long> orgIds, Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap, Set<Long> needUnMatchRecordIds) {
        HashSet<Long> releaseInvIds = new HashSet<Long>(16);
        HashSet<Long> invEmptyFinApIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<FinApInvoiceRowVO>> entrySet : fin4InvRowMap.entrySet()) {
            Long finApBillId = entrySet.getKey();
            List<FinApInvoiceRowVO> invoiceRowVOS = entrySet.getValue();
            int remainSize = 0;
            for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                if (invoiceRowVO.isDeleteRow()) {
                    releaseInvIds.add(invoiceRowVO.getInvId());
                    continue;
                }
                ++remainSize;
            }
            if (remainSize != 0) continue;
            invEmptyFinApIds.add(finApBillId);
        }
        this.getRecordIdsByEmptyFinApSelfMatch(orgIds, invEmptyFinApIds, needUnMatchRecordIds);
        logger.info("FinApInvEntryDeleteServiceImpl processBillSelfMatchRecordIds needUnMatchRecordIds1 : " + needUnMatchRecordIds);
        this.getRecordIdsByEmptyInvoiceSelfMatch(orgIds, releaseInvIds, needUnMatchRecordIds);
        logger.info("FinApInvEntryDeleteServiceImpl processBillSelfMatchRecordIds needUnMatchRecordIds2 : " + needUnMatchRecordIds);
    }

    private void getRecordIdsByEmptyFinApSelfMatch(Set<Long> orgIds, Set<Long> invEmptyFinApIds, Set<Long> needUnMatchRecordIds) {
        DataSet otherFinAsstSelfRecordDataSet;
        DataSet otherFinMainSelfRecordDataSet;
        DataSet otherFinRecordDataSet;
        if (invEmptyFinApIds.isEmpty()) {
            return;
        }
        String selectors = "id,writeofftypeid,entry.billid,entry.assbillid";
        QFilter filter = new QFilter("entry.billid", "in", invEmptyFinApIds);
        filter.and(new QFilter("writeofftypeid", "=", (Object)1893666267970144256L));
        filter.and(new QFilter("org", "in", orgIds));
        DataSet finMainSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_finap_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter}, (String)"");
        QFilter filter1 = new QFilter("entry.assbillid", "in", invEmptyFinApIds);
        filter1.and(new QFilter("writeofftypeid", "=", (Object)1893666267970144256L));
        filter1.and(new QFilter("org", "in", orgIds));
        DataSet finAsstSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_finap_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter1}, (String)"");
        DataSet finSelfRecordDataSet = finMainSelfRecordDataSet.union(finAsstSelfRecordDataSet).distinct();
        if (!finSelfRecordDataSet.hasNext()) {
            return;
        }
        HashSet<Long> otherFinApIds = new HashSet<Long>(8);
        for (Row record : finSelfRecordDataSet) {
            long asstBillId;
            long recordId = record.getLong("id");
            if (needUnMatchRecordIds.contains(recordId)) continue;
            long mainBillId = record.getLong("entry.billid");
            if (mainBillId == (asstBillId = record.getLong("entry.assbillid").longValue())) {
                needUnMatchRecordIds.add(recordId);
                continue;
            }
            if (invEmptyFinApIds.contains(mainBillId)) {
                otherFinApIds.add(asstBillId);
            }
            if (!invEmptyFinApIds.contains(asstBillId)) continue;
            otherFinApIds.add(mainBillId);
        }
        if (!otherFinApIds.isEmpty() && (otherFinRecordDataSet = (otherFinMainSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_finapself_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", otherFinApIds), new QFilter("org", "in", orgIds)}, (String)"")).union(otherFinAsstSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_finapself_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", otherFinApIds), new QFilter("org", "in", orgIds)}, (String)"")).distinct()).hasNext()) {
            HashMap<Long, Map> otherFinMatchType4RecordIdMap = new HashMap<Long, Map>(8);
            for (Row record : otherFinRecordDataSet) {
                List recordIds;
                Long recordId = record.getLong("id");
                if (needUnMatchRecordIds.contains(recordId)) continue;
                Long writeOffTypeId = record.getLong("writeofftypeid");
                Long mainBillId = record.getLong("entry.billid");
                Long assBillId = record.getLong("entry.assbillid");
                if (1893666267970144256L == writeOffTypeId) {
                    Map mainType4RecordMap = otherFinMatchType4RecordIdMap.getOrDefault(mainBillId, new HashMap(4));
                    Map asstBill4RecordMap = mainType4RecordMap.getOrDefault(writeOffTypeId, new HashMap(2));
                    recordIds = asstBill4RecordMap.getOrDefault(assBillId, new ArrayList(8));
                    recordIds.add(recordId);
                    asstBill4RecordMap.put(assBillId, recordIds);
                    mainType4RecordMap.put(writeOffTypeId, asstBill4RecordMap);
                    otherFinMatchType4RecordIdMap.put(mainBillId, mainType4RecordMap);
                }
                Map asstType4RecordMap = otherFinMatchType4RecordIdMap.getOrDefault(assBillId, new HashMap(4));
                Map mainBill4RecordMap = asstType4RecordMap.getOrDefault(writeOffTypeId, new HashMap(2));
                recordIds = mainBill4RecordMap.getOrDefault(mainBillId, new ArrayList(8));
                recordIds.add(recordId);
                mainBill4RecordMap.put(mainBillId, recordIds);
                asstType4RecordMap.put(writeOffTypeId, mainBill4RecordMap);
                otherFinMatchType4RecordIdMap.put(assBillId, asstType4RecordMap);
            }
            for (Long otherFinApId : otherFinApIds) {
                Map sameType4RecordIdMap = (Map)otherFinMatchType4RecordIdMap.get(otherFinApId);
                if (ObjectUtils.isEmpty((Object)sameType4RecordIdMap) || sameType4RecordIdMap.size() > 1) continue;
                for (Map.Entry entrySet : sameType4RecordIdMap.entrySet()) {
                    Long writeOffTypeId = (Long)entrySet.getKey();
                    if (1893667005572058112L == writeOffTypeId) continue;
                    Map otherFinAp4RecordIdMap = (Map)entrySet.getValue();
                    for (Map.Entry entrySet1 : otherFinAp4RecordIdMap.entrySet()) {
                        Long finApBillId = (Long)entrySet1.getKey();
                        if (!invEmptyFinApIds.contains(finApBillId) && !otherFinApId.equals(finApBillId)) continue;
                        needUnMatchRecordIds.addAll((Collection)entrySet1.getValue());
                    }
                }
            }
        }
    }

    private void getRecordIdsByEmptyInvoiceSelfMatch(Set<Long> orgIds, Set<Long> invoiceIds, Set<Long> needUnMatchRecordIds) {
        if (invoiceIds.isEmpty()) {
            return;
        }
        String selectors = "id,writeofftypeid,entry.billid,entry.assbillid";
        QFilter filter = new QFilter("entry.billid", "in", invoiceIds);
        filter.and(new QFilter("org", "in", orgIds));
        DataSet invMainSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_invself_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter}, (String)"");
        QFilter filter1 = new QFilter("entry.assbillid", "in", invoiceIds);
        filter1.and(new QFilter("org", "in", orgIds));
        DataSet invAsstSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_invself_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{filter1}, (String)"");
        DataSet invSelfRecordDataSet = invMainSelfRecordDataSet.union(invAsstSelfRecordDataSet).distinct();
        HashMap<Long, Map> invoiceMatchType4RecordIdMap = new HashMap<Long, Map>(8);
        for (Row record : invSelfRecordDataSet) {
            long recordId = record.getLong("id");
            long writeOffTypeId = record.getLong("writeofftypeid");
            if (needUnMatchRecordIds.contains(recordId) || 1893667005572058112L == writeOffTypeId) continue;
            long mainBillId = record.getLong("entry.billid");
            long asstBillId = record.getLong("entry.assbillid");
            Map mainInvSameType4RecordIdMap = invoiceMatchType4RecordIdMap.getOrDefault(mainBillId, new HashMap(2));
            Map asstInv4RecordMap = mainInvSameType4RecordIdMap.getOrDefault(writeOffTypeId, new HashMap(8));
            asstInv4RecordMap.put(asstBillId, recordId);
            mainInvSameType4RecordIdMap.put(writeOffTypeId, asstInv4RecordMap);
            invoiceMatchType4RecordIdMap.put(mainBillId, mainInvSameType4RecordIdMap);
            Map asstInvSameType4RecordIdMap = invoiceMatchType4RecordIdMap.getOrDefault(asstBillId, new HashMap(2));
            Map mainInv4RecordMap = asstInvSameType4RecordIdMap.getOrDefault(writeOffTypeId, new HashMap(8));
            mainInv4RecordMap.put(mainBillId, recordId);
            asstInvSameType4RecordIdMap.put(writeOffTypeId, mainInv4RecordMap);
            invoiceMatchType4RecordIdMap.put(asstBillId, asstInvSameType4RecordIdMap);
        }
        if (invoiceMatchType4RecordIdMap.isEmpty()) {
            return;
        }
        HashSet otherInvIds = new HashSet(invoiceMatchType4RecordIdMap.keySet());
        otherInvIds.removeIf(invoiceIds::contains);
        if (!otherInvIds.isEmpty()) {
            DataSet otherInvMainSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_inv_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", otherInvIds), new QFilter("org", "in", orgIds)}, (String)"");
            DataSet otherInvAsstSelfRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_inv_match", (String)"ap_matchrecord_verify", (String)selectors, (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", otherInvIds), new QFilter("org", "in", orgIds)}, (String)"");
            DataSet otherInvRecordDataSet = otherInvMainSelfRecordDataSet.union(otherInvAsstSelfRecordDataSet).distinct();
            for (Row record : otherInvRecordDataSet) {
                long recordId = record.getLong("id");
                if (needUnMatchRecordIds.contains(recordId)) continue;
                long writeOffTypeId = record.getLong("writeofftypeid");
                long mainBillId = record.getLong("entry.billid");
                long asstBillId = record.getLong("entry.assbillid");
                Map mainInvSameType4RecordIdMap = invoiceMatchType4RecordIdMap.getOrDefault(mainBillId, new HashMap(2));
                Map asstInv4RecordMap = mainInvSameType4RecordIdMap.getOrDefault(writeOffTypeId, new HashMap(8));
                asstInv4RecordMap.put(asstBillId, recordId);
                mainInvSameType4RecordIdMap.put(writeOffTypeId, asstInv4RecordMap);
                invoiceMatchType4RecordIdMap.put(mainBillId, mainInvSameType4RecordIdMap);
                Map asstInvSameType4RecordIdMap = invoiceMatchType4RecordIdMap.getOrDefault(asstBillId, new HashMap(2));
                Map mainInv4RecordMap = asstInvSameType4RecordIdMap.getOrDefault(writeOffTypeId, new HashMap(8));
                mainInv4RecordMap.put(mainBillId, recordId);
                asstInvSameType4RecordIdMap.put(writeOffTypeId, mainInv4RecordMap);
                invoiceMatchType4RecordIdMap.put(asstBillId, asstInvSameType4RecordIdMap);
            }
        }
        for (Long releaseInvId : invoiceIds) {
            Map writeOff4RecordMap = (Map)invoiceMatchType4RecordIdMap.get(releaseInvId);
            if (ObjectUtils.isEmpty((Object)writeOff4RecordMap)) continue;
            for (Map.Entry entrySet : writeOff4RecordMap.entrySet()) {
                Map releaseBill4RecordIdMap = (Map)entrySet.getValue();
                boolean isCanDeleteRecord = true;
                for (Map.Entry entrySet1 : releaseBill4RecordIdMap.entrySet()) {
                    Long otherBillId = (Long)entrySet1.getKey();
                    Map otherBillWriteOff4RecordMap = (Map)invoiceMatchType4RecordIdMap.get(otherBillId);
                    if (otherBillWriteOff4RecordMap.size() > 1) {
                        isCanDeleteRecord = false;
                        continue;
                    }
                    for (Map.Entry entrySet2 : otherBillWriteOff4RecordMap.entrySet()) {
                        Map releaseBillId4RecordMap = (Map)entrySet2.getValue();
                        for (Map.Entry entrySet3 : releaseBillId4RecordMap.entrySet()) {
                            Long releaseBillId = (Long)entrySet3.getKey();
                            if (releaseBillId.equals(releaseInvId) || releaseBillId.equals(otherBillId)) continue;
                            isCanDeleteRecord = false;
                            break;
                        }
                        if (!isCanDeleteRecord) continue;
                        needUnMatchRecordIds.addAll(releaseBillId4RecordMap.values());
                    }
                }
                if (!isCanDeleteRecord) continue;
                needUnMatchRecordIds.addAll(releaseBill4RecordIdMap.values());
            }
        }
    }

    private Set<Long> getRecordIdsByNoNeedDeleteInvRow(InvEntryDeleteParam deleteParam, DynamicObject[] bills, Map<Long, List<FinApInvoiceRowVO>> oldFin4InvRowMap) {
        HashMap<Long, List<FinApInvoiceRowVO>> fin4InvRowMap = new HashMap<Long, List<FinApInvoiceRowVO>>(8);
        HashSet<Long> allNeedReleaseAmtInvoiceIds = new HashSet<Long>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject bill : bills) {
            List<FinApInvoiceRowVO> invoiceRowVOS = oldFin4InvRowMap.get(bill.getLong("id"));
            HashMap<Long, FinApInvoiceRowVO> finApInvoiceRowVOMap = new HashMap<Long, FinApInvoiceRowVO>(8);
            for (FinApInvoiceRowVO invoiceRowVO : invoiceRowVOS) {
                finApInvoiceRowVOMap.put(invoiceRowVO.getInvId(), invoiceRowVO);
            }
            DynamicObjectCollection invEntry = bill.getDynamicObjectCollection("inventry");
            ArrayList<FinApInvoiceRowVO> finApInvoiceRowVOs = new ArrayList<FinApInvoiceRowVO>(8);
            HashMap<Long, BigDecimal> assignInvoice4AmtMap = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                String iSrcType = invRow.getString("i_srctype");
                FinApInvoiceRowVO oldFinApInvoiceRowVO = (FinApInvoiceRowVO)finApInvoiceRowVOMap.get(invId);
                if (oldFinApInvoiceRowVO == null || oldFinApInvoiceRowVO.isDeleteRow() || !InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType) && (!InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) || !"deleteinventry".equals(deleteParam.getOperateKey()))) continue;
                FinApInvoiceRowVO finApInvoiceRowVO = new FinApInvoiceRowVO();
                finApInvoiceRowVO.setInvId(invId).setReleaseAmt(true).setDeleteRow(true).setiUseAmt(oldFinApInvoiceRowVO.getiUseAmt());
                finApInvoiceRowVOs.add(finApInvoiceRowVO);
                allNeedReleaseAmtInvoiceIds.add(invId);
                if (!InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType)) continue;
                assignInvoice4AmtMap.put(invId, oldFinApInvoiceRowVO.getiUseAmt());
            }
            if (!finApInvoiceRowVOs.isEmpty()) {
                fin4InvRowMap.put(bill.getLong("id"), finApInvoiceRowVOs);
            }
            orgIds.add(bill.getLong("org.id"));
            if (assignInvoice4AmtMap.isEmpty()) continue;
            this.finAp4InvoiceOccupyMap.put(bill.getLong("id"), assignInvoice4AmtMap);
        }
        if (fin4InvRowMap.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> needUnMatchRecordIds = new HashSet<Long>(64);
        this.getRecordIdsByInvoiceArticulateFin(orgIds, fin4InvRowMap, allNeedReleaseAmtInvoiceIds, needUnMatchRecordIds);
        this.getRecordIdsByInvoiceSelf(orgIds, fin4InvRowMap, allNeedReleaseAmtInvoiceIds, needUnMatchRecordIds);
        logger.info("FinApInvEntryDeleteServiceImpl getRecordIdsByNoNeedDeleteInvRow needUnMatchRecordIds : " + needUnMatchRecordIds);
        logger.info("FinApInvEntryDeleteServiceImpl getRecordIdsByNoNeedDeleteInvRow fin4InvRowMap : " + fin4InvRowMap);
        return needUnMatchRecordIds;
    }

    private Map<Long, List<FinApInvoiceRowVO>> getFin4InvRowMap(DynamicObject[] bills, Map<Long, Set<Long>> bill4InvoiceMap, String operateKey) {
        HashMap<Long, List<FinApInvoiceRowVO>> fin4InvRowMap = new HashMap<Long, List<FinApInvoiceRowVO>>(8);
        for (DynamicObject bill : bills) {
            long invId;
            long billId = bill.getLong("id");
            Set<Long> deleteRowInvIds = bill4InvoiceMap.get(billId);
            DynamicObjectCollection invEntry = bill.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty() || ObjectUtils.isEmpty(deleteRowInvIds)) continue;
            ArrayList<FinApInvoiceRowVO> invoiceRowVOS = new ArrayList<FinApInvoiceRowVO>(8);
            if ("deleteinventry".equals(operateKey) && "A".equals(bill.getString("billstatus"))) {
                for (DynamicObject invRow : invEntry) {
                    invId = invRow.getLong("invid");
                    FinApInvoiceRowVO invoiceRowVO = new FinApInvoiceRowVO();
                    invoiceRowVO.setInvId(invId).setDeleteRow(deleteRowInvIds.contains(invId));
                    invoiceRowVOS.add(invoiceRowVO);
                }
            } else {
                for (DynamicObject invRow : invEntry) {
                    invId = invRow.getLong("invid");
                    BigDecimal iUsedAmt = invRow.getBigDecimal("i_usedamt");
                    FinApInvoiceRowVO invoiceRowVO = new FinApInvoiceRowVO();
                    invoiceRowVO.setInvId(invId).setiUseAmt(iUsedAmt);
                    if (deleteRowInvIds.contains(invId)) {
                        invoiceRowVO.setDeleteRow(true).setReleaseAmt(true);
                    }
                    invoiceRowVOS.add(invoiceRowVO);
                }
            }
            fin4InvRowMap.put(billId, invoiceRowVOS);
        }
        return fin4InvRowMap;
    }

    private void saveFinApBill(InvEntryDeleteParam deleteParam, DynamicObject[] finApBills) {
        if (!deleteParam.isSave()) {
            return;
        }
        if (deleteParam.isBillClose()) {
            SaveServiceHelper.save((DynamicObject[])finApBills);
        } else {
            InvoiceHelper.saveFinAndWriteBack((DynamicObject[])finApBills);
        }
    }

    private Map<String, Set<Long>> writeBackFinApBill(InvEntryDeleteParam deleteParam, DynamicObject[] finApBills, Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap) {
        HashMap<String, Set<Long>> invRowTypeMap = new HashMap<String, Set<Long>>(8);
        for (DynamicObject finApBill : finApBills) {
            Long finApBillId = finApBill.getLong("id");
            Map finApInvoiceRowVOMap = fin4InvRowMap.get(finApBillId).stream().collect(Collectors.toMap(FinApInvoiceRowVO::getInvId, Function.identity()));
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            Iterator iterator = invEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject invRow = (DynamicObject)iterator.next();
                long invId = invRow.getLong("invid");
                String iSrcType = invRow.getString("i_srctype");
                FinApInvoiceRowVO finApInvoiceRowVO = (FinApInvoiceRowVO)finApInvoiceRowVOMap.get(invId);
                if (finApInvoiceRowVO.isDeleteRow()) {
                    Set invoiceIds = invRowTypeMap.getOrDefault(iSrcType, new HashSet(8));
                    invoiceIds.add(invId);
                    invRowTypeMap.put(iSrcType, invoiceIds);
                    if (deleteParam.isDeleteInvRow()) {
                        iterator.remove();
                        continue;
                    }
                    invRow.set("i_usedamt", (Object)BigDecimal.ZERO);
                    continue;
                }
                if (!finApInvoiceRowVO.isDeleteRow() && finApInvoiceRowVO.isReleaseAmt() && !InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType) && !InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType)) {
                    invRow.set("i_usedamt", (Object)finApInvoiceRowVO.getiUseAmt());
                    continue;
                }
                if (InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType)) {
                    invRow.set("i_usedamt", (Object)BigDecimal.ZERO);
                    continue;
                }
                if (!InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) || !"deleteinventry".equals(deleteParam.getOperateKey())) continue;
                invRow.set("i_usedamt", (Object)BigDecimal.ZERO);
            }
            long number = invEntry.stream().filter(t -> "0".equals(t.getString("i_invoicetypef7.is_ele_invoice"))).count();
            finApBill.set("haspaperticket", (Object)(number > 0L ? Boolean.TRUE : Boolean.FALSE));
        }
        return invRowTypeMap;
    }

    private void constructBillBOTPRelation(InvEntryDeleteParam deleteParam, DynamicObject[] bills) {
        if (ObjectUtils.isEmpty((Object[])bills) || deleteParam.isNotDeleteBOTP()) {
            return;
        }
        ArrayList<Map<String, Long>> deleteBotpParamList = new ArrayList<Map<String, Long>>(8);
        HashSet<Long> finApBillIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            Long finApBillId = bill.getLong("id");
            DynamicObjectCollection invEntry = bill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                Long invId = invRow.getLong("invid");
                HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
                paramMap.put("srcBillId", invId);
                paramMap.put("tarBillId", finApBillId);
                deleteBotpParamList.add(paramMap);
            }
            finApBillIds.add(finApBillId);
        }
        QFilter filter = new QFilter("id", "in", finApBillIds);
        filter.and("billstatus", "!=", (Object)"A");
        DataSet finApBillDataSet = QueryServiceHelper.queryDataSet((String)"query_latest_finap", (String)"ap_finapbill", (String)"id,inventry.i_usedamt,inventry.invid", (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, List> needSaveBotpMap = new HashMap<Long, List>(8);
        for (Row finApRow : finApBillDataSet) {
            Long finApBillId = finApRow.getLong("id");
            Long invId = finApRow.getLong("inventry.invid");
            if (invId == 0L) continue;
            List tempInvoiceIds = needSaveBotpMap.getOrDefault(finApBillId, new ArrayList(8));
            tempInvoiceIds.add(invId);
            needSaveBotpMap.put(finApBillId, tempInvoiceIds);
        }
        this.deleteBOTPRelation("ap_finapbill", deleteBotpParamList);
        if (!needSaveBotpMap.isEmpty()) {
            BillRelationBuilder billRelationBuilder = new BillRelationBuilder("ap_invoice", "ap_finapbill");
            for (Map.Entry entrySet : needSaveBotpMap.entrySet()) {
                billRelationBuilder.saveRelation((Collection)entrySet.getValue(), (Long)entrySet.getKey());
            }
        }
    }

    private List<Long> getNeedAgainAssignFinApIds(InvEntryDeleteParam deleteParam, DynamicObject[] finApBills, Map<Long, Set<Long>> billNeedRelease4InvoiceMap) {
        ArrayList<Long> needAgainAssignApBillIds = new ArrayList<Long>(8);
        block0: for (DynamicObject finApBill : finApBills) {
            if ("A".equals(finApBill.getString("billstatus"))) continue;
            Set<Long> releaseInvIds = billNeedRelease4InvoiceMap.get(finApBill.getLong("id"));
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                String iSrcType = invRow.getString("i_srctype");
                if (!ObjectUtils.isEmpty(releaseInvIds) && releaseInvIds.contains(invRow.getLong("invid")) || !InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType) && (!InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) || !"deleteinventry".equals(deleteParam.getOperateKey()))) continue;
                needAgainAssignApBillIds.add(finApBill.getLong("id"));
                continue block0;
            }
        }
        return needAgainAssignApBillIds;
    }

    private void writeBackInvoice(InvEntryDeleteParam deleteParam, DynamicObject[] finApBills, Map<Long, Set<Long>> billNeedRelease4InvoiceMap, Map<String, Set<Long>> invRowTypeMap) {
        if (invRowTypeMap.isEmpty()) {
            return;
        }
        HashSet allInvoiceIds = new HashSet(32);
        invRowTypeMap.values().forEach(allInvoiceIds::addAll);
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)this.getInvoiceSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", allInvoiceIds)});
        Map invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
        Set orgIds = invoiceMap.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toSet());
        HashSet<Long> needUnAuditInvoiceIds = new HashSet<Long>(16);
        HashSet<Long> needUnDeleteInvoiceIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> needSaveInvoices = new ArrayList<DynamicObject>(16);
        List extendRowType = InvoiceHelper.getExtendSrcTypes();
        for (Map.Entry<String, Set<Long>> entry : invRowTypeMap.entrySet()) {
            DynamicObject invoice;
            String iSrcType = entry.getKey();
            Set<Long> invoiceIds = entry.getValue();
            if (InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue().equals(iSrcType)) {
                DynamicObject coordinateApBill22;
                Object filter;
                if (this.isAutoAntiAssign(deleteParam.getOperateKey())) {
                    filter = new QFilter("inventry.invid", "in", invoiceIds);
                    filter.and(new QFilter("inventry.i_srctype", "=", (Object)InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue()));
                    filter.and(new QFilter("org", "in", orgIds));
                    filter.and(new QFilter("billstatus", "!=", (Object)"A"));
                    DynamicObjectCollection coordinateApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billstatus,inventry.invid", (QFilter[])new QFilter[]{filter});
                    for (DynamicObject coordinateApBill22 : coordinateApBills) {
                        invoiceIds.remove(coordinateApBill22.getLong("inventry.invid"));
                    }
                    needUnAuditInvoiceIds.addAll(invoiceIds);
                    continue;
                }
                filter = new QFilter("inventry.invid", "in", invoiceIds);
                filter.and(new QFilter("inventry.i_srctype", "=", (Object)InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue()));
                filter.and(new QFilter("org", "in", orgIds));
                DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"queryapbyinv", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{filter}, (String)"id");
                HashSet<Long> noProcessCoorInvIds = new HashSet<Long>(8);
                for (Row row : invoiceDataSet) {
                    noProcessCoorInvIds.add(row.getLong("inventry.invid"));
                }
                coordinateApBill22 = invoiceIds.iterator();
                while (coordinateApBill22.hasNext()) {
                    DynamicObject deleteRowForInv;
                    Long invoiceId = (Long)coordinateApBill22.next();
                    if (noProcessCoorInvIds.contains(invoiceId) || (deleteRowForInv = (DynamicObject)invoiceMap.get(invoiceId)) == null) continue;
                    deleteRowForInv.set("isreffin", (Object)Boolean.FALSE);
                    deleteRowForInv.set("businesssource", (Object)" ");
                    needSaveInvoices.add(deleteRowForInv);
                }
                continue;
            }
            if (InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue().equals(iSrcType)) {
                for (Long invoiceId : invoiceIds) {
                    invoice = (DynamicObject)invoiceMap.get(invoiceId);
                    if (invoice == null) continue;
                    needSaveInvoices.add(invoice);
                }
                continue;
            }
            if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType)) {
                for (Long invoiceId : invoiceIds) {
                    invoice = (DynamicObject)invoiceMap.get(invoiceId);
                    if (invoice == null) continue;
                    needSaveInvoices.add(invoice);
                }
                continue;
            }
            if (InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(iSrcType) || extendRowType.contains(iSrcType)) {
                for (Long invoiceId : invoiceIds) {
                    invoice = (DynamicObject)invoiceMap.get(invoiceId);
                    if (deleteParam.isBillClose()) {
                        invoice.set("isreffin", (Object)Boolean.FALSE);
                        invoice.set("businesssource", (Object)" ");
                        needSaveInvoices.add(invoice);
                        continue;
                    }
                    needUnAuditInvoiceIds.add(invoiceId);
                    if (this.isAutoAntiAssign(deleteParam.getOperateKey())) continue;
                    needUnDeleteInvoiceIds.add(invoiceId);
                }
                continue;
            }
            if (!InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue().equals(iSrcType)) continue;
            needUnAuditInvoiceIds.addAll(invoiceIds);
            if (!"delete".equals(deleteParam.getOperateKey())) continue;
            needUnDeleteInvoiceIds.addAll(invoiceIds);
        }
        for (DynamicObject dynamicObject2 : needSaveInvoices) {
            String serialNo = dynamicObject2.getString("serialno");
            if (ObjectUtils.isEmpty((Object)serialNo)) continue;
            dynamicObject2.set("synstatus", (Object)"waitsynchro");
            dynamicObject2.set("changesynstatustime", (Object)new Date());
        }
        Set<Long> invoiceCollectInvIds = invRowTypeMap.get(InvoiceSrcTypeEnum.INVOICECOLLECT.getValue());
        for (DynamicObject finApBill : finApBills) {
            Set<Long> deleteInvoiceIds;
            if (!this.isAutoAntiAssign(deleteParam.getOperateKey()) || !finApBill.getBoolean("iswrittenoff") || ObjectUtils.isEmpty(deleteInvoiceIds = billNeedRelease4InvoiceMap.get(finApBill.getLong("id")))) continue;
            for (Long deleteInvoiceId : deleteInvoiceIds) {
                if (ObjectUtils.isEmpty(invoiceCollectInvIds) || !invoiceCollectInvIds.contains(deleteInvoiceId)) continue;
                needUnAuditInvoiceIds.add(deleteInvoiceId);
                needUnDeleteInvoiceIds.add(deleteInvoiceId);
            }
        }
        if (!needSaveInvoices.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needSaveInvoices.toArray(new DynamicObject[0]));
        }
        if (!needUnAuditInvoiceIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", needUnAuditInvoiceIds);
            qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_inv_status", (String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"");
            ArrayList<Long> invoiceIds = new ArrayList<Long>(16);
            for (Row invoiceRow : invoiceDataSet) {
                invoiceIds.add(invoiceRow.getLong("id"));
            }
            if (!invoiceIds.isEmpty()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"nocheckunaudit", (String)"ap_invoice", (Object[])invoiceIds.toArray(new Long[0]), (OperateOption)option);
                OperationHelper.assertResult((OperationResult)unAuditResult);
            }
        }
        if (!needUnDeleteInvoiceIds.isEmpty()) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_exist_inv", (String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", needUnDeleteInvoiceIds)}, (String)"");
            ArrayList<Long> invoiceIds = new ArrayList<Long>(16);
            for (Row invoiceRow : dataSet) {
                invoiceIds.add(invoiceRow.getLong("id"));
            }
            if (!invoiceIds.isEmpty()) {
                this.invoiceExecuteDeleteOp(invoiceIds.toArray(new Long[0]));
            }
        }
    }

    private boolean isAutoAntiAssign(String operateKey) {
        return "unaudit".equals(operateKey) || "unsubmit".equals(operateKey);
    }

    private boolean isHandAdjustDiff(String operateKey) {
        return "invdiffadjust".equals(operateKey);
    }

    private String getFinApSelectors(InvEntryDeleteParam deleteParam) {
        HashSet<String> fieldKeys = new HashSet<String>(64);
        fieldKeys.add("billstatus");
        fieldKeys.add("invid");
        fieldKeys.add("i_srctype");
        fieldKeys.add("i_usedamt");
        fieldKeys.add("i_invoicetypef7");
        fieldKeys.add("haspaperticket");
        if (!this.isHandAdjustDiff(deleteParam.getOperateKey())) {
            Set properties = PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false);
            fieldKeys.addAll(properties);
            Set invoiceAdjustSelectors = InvoiceHelper.getInvoiceAdjustSelectors();
            fieldKeys.addAll(invoiceAdjustSelectors);
        }
        return String.join((CharSequence)",", fieldKeys);
    }

    private Map<Long, Set<Long>> getReturnMap(Map<Long, List<FinApInvoiceRowVO>> fin4InvRowMap) {
        HashMap<Long, Set<Long>> billNeedRelease4InvoiceMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, List<FinApInvoiceRowVO>> entrySet : fin4InvRowMap.entrySet()) {
            Long finApBillId = entrySet.getKey();
            List<FinApInvoiceRowVO> invoiceRowVOS = entrySet.getValue();
            Set deleteInvoiceIds = invoiceRowVOS.stream().filter(FinApInvoiceRowVO::isDeleteRow).map(FinApInvoiceRowVO::getInvId).collect(Collectors.toSet());
            billNeedRelease4InvoiceMap.put(finApBillId, deleteInvoiceIds);
        }
        return billNeedRelease4InvoiceMap;
    }

    private String getInvoiceSelectors() {
        return "org,isreffin,businesssource,synstatus,changesynstatustime,serialno";
    }

    @Override
    protected String getEntityName() {
        return "ap_finapbill";
    }

    @Override
    protected String getBillSelectors() {
        return "org,i_srctype,invid,billstatus,i_invoicetypef7,haspaperticket,i_usedamt,i_srctype,iswrittenoff";
    }

    private static class FinApInvoiceRowVO {
        private long invId;
        private boolean isDeleteRow = false;
        private boolean isReleaseAmt = false;
        private BigDecimal iUseAmt = BigDecimal.ZERO;

        private FinApInvoiceRowVO() {
        }

        public long getInvId() {
            return this.invId;
        }

        public FinApInvoiceRowVO setInvId(long invId) {
            this.invId = invId;
            return this;
        }

        public boolean isDeleteRow() {
            return this.isDeleteRow;
        }

        public FinApInvoiceRowVO setDeleteRow(boolean deleteRow) {
            this.isDeleteRow = deleteRow;
            return this;
        }

        public boolean isReleaseAmt() {
            return this.isReleaseAmt;
        }

        public FinApInvoiceRowVO setReleaseAmt(boolean releaseAmt) {
            this.isReleaseAmt = releaseAmt;
            return this;
        }

        public BigDecimal getiUseAmt() {
            return this.iUseAmt;
        }

        public FinApInvoiceRowVO setiUseAmt(BigDecimal iUseAmt) {
            this.iUseAmt = iUseAmt;
            return this;
        }

        public String toString() {
            return "FinApInvoiceRowVO{invId=" + this.invId + ", isDeleteRow=" + this.isDeleteRow + ", isReleaseAmt=" + this.isReleaseAmt + ", iUseAmt=" + this.iUseAmt + '}';
        }
    }
}

