/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoicematch.IMatchBillLoader;
import kd.fi.ap.business.invoicematch.helper.MatchBillChainHelper;
import kd.fi.ap.business.invoicematch.helper.MatchBillLoaderParam;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.MatchBillChain;

public class MatchBillLoaderFactory {
    private static final Log logger = LogFactory.getLog(MatchBillLoaderFactory.class);

    public static IMatchBillLoader getLoader(String billEntity, MatchBillLoaderParam param) {
        LinkedList chains = MatchBillChainHelper.getChainData(param.getView().getPageCache()).getChains();
        Optional<MatchBillChain.MatchChain> findFirst = chains.stream().filter(meta -> meta.getBillEntity().equals(billEntity)).findFirst();
        if (findFirst.isPresent()) {
            return MatchBillLoaderFactory.createLoaderInstance(param, findFirst.get());
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6e32\u67d3\u63d2\u4ef6\u6ce8\u518c\u4fe1\u606f...", (String)"MatchBillLoaderFactory_0", (String)"fi-ap-business", (Object[])new Object[0]));
    }

    public static IMatchBillLoader getChainLoaders(String billEntity, MatchBillLoaderParam param) {
        MatchBillChain matchBillChain = MatchBillChainHelper.getChainData(param.getView().getPageCache());
        MatchBillChain.MatchChain chain = matchBillChain.getChain(billEntity);
        IMatchBillLoader loader = MatchBillLoaderFactory.createLoaderInstance(param, chain);
        String currentBillEntity = billEntity;
        MatchBillLoaderParam currentParam = param;
        EnumDirection direction = param.getDirection();
        while (matchBillChain.getSibling(currentBillEntity, direction) != null) {
            MatchBillChain.MatchChain sibling = matchBillChain.getSibling(currentBillEntity, direction);
            MatchBillLoaderParam siblingParam = MatchBillLoaderParam.copy(param);
            siblingParam.setMatchChain(sibling);
            IMatchBillLoader siblingLoader = MatchBillLoaderFactory.createLoaderInstance(siblingParam, sibling);
            currentBillEntity = sibling.getBillEntity();
            currentParam.setSiblingLoader(siblingLoader);
            currentParam = siblingParam;
        }
        return loader;
    }

    private static IMatchBillLoader createLoaderInstance(MatchBillLoaderParam param, MatchBillChain.MatchChain chain) {
        try {
            Class<?> forName = Class.forName(chain.getPlugin());
            Constructor<?> constructor = forName.getConstructor(MatchBillLoaderParam.class);
            return (IMatchBillLoader)constructor.newInstance(param);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("\u5b9e\u4f8b\u5316\u63d2\u4ef6\u5931\u8d25...", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f8b\u5316\u63d2\u4ef6\u5931\u8d25...", (String)"MatchBillLoaderFactory_1", (String)"fi-ap-business", (Object[])new Object[0]));
        }
    }
}

