/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.botp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.fi.ap.business.invoicematch.botp.IRelationConverter;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.Relation;

public abstract class AbstractRelationConverter
implements IRelationConverter {
    protected String entityKey;
    protected String entryKey;
    protected String targetEntityKey;
    protected EnumDirection direction;
    protected Long[] entryIds;

    public AbstractRelationConverter(String entityKey, String entryKey, String targetEntityKey, EnumDirection direction, Long[] entryIds) {
        this.entityKey = entityKey;
        this.entryKey = entryKey;
        this.targetEntityKey = targetEntityKey;
        this.direction = direction;
        this.entryIds = entryIds;
    }

    @Override
    public Set<Relation> getRelations() {
        HashSet<Relation> relations = new HashSet<Relation>(64);
        Map<Long, HashSet<Long>> relationMap = this.getRelationMap();
        Set<Map.Entry<Long, HashSet<Long>>> entrySet = relationMap.entrySet();
        for (Map.Entry<Long, HashSet<Long>> entry : entrySet) {
            HashSet<Long> value = entry.getValue();
            for (Long targetEntryId : value) {
                relations.add(new Relation(this.entityKey, entry.getKey(), this.targetEntityKey, targetEntryId, this.direction.name()));
            }
        }
        return relations;
    }

    protected abstract Map<Long, HashSet<Long>> getRelationMap();
}

