/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.form.IPageCache;
import kd.fi.ap.business.invoicematch.helper.EnumRelType;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.MatchBillChain;

public class MatchBillChainHelper {
    public static void initPageChainData(IPageCache pageCache) {
        pageCache.put("chainmapcache", JSON.toJSONString((Object)MatchBillChainHelper.getChainData()));
    }

    public static MatchBillChain.MatchChain getActiveChain(IPageCache pageCache) {
        String chainDataString = pageCache.get("chainmapcache");
        MatchBillChain matchBillChain = (MatchBillChain)JSON.parseObject((String)chainDataString, MatchBillChain.class);
        return (MatchBillChain.MatchChain)matchBillChain.getChainMap().get(matchBillChain.getActiveMatchTab());
    }

    public static MatchBillChain getChainData(IPageCache pageCache) {
        String chainDataString = pageCache.get("chainmapcache");
        return (MatchBillChain)JSON.parseObject((String)chainDataString, MatchBillChain.class);
    }

    public static MatchBillChain updateChainStatus(IPageCache pageCache, boolean equals, String ... keys) {
        MatchBillChain matchBillChain = MatchBillChainHelper.getChainData(pageCache);
        Map chainMap = matchBillChain.getChainMap();
        for (String key : keys) {
            MatchBillChain.MatchChain matchChain = (MatchBillChain.MatchChain)chainMap.get(key);
            matchChain.setHide(!equals);
        }
        pageCache.put("chainmapcache", JSON.toJSONString((Object)matchBillChain));
        return matchBillChain;
    }

    public static MatchBillChain removeChain(IPageCache pageCache, String billEntity) {
        MatchBillChain existChainData = MatchBillChainHelper.getChainData(pageCache);
        Map chainMap = existChainData.getChainMap();
        MatchBillChain.MatchChain removeChain = (MatchBillChain.MatchChain)chainMap.get(billEntity);
        MatchBillChain.MatchChain downSibling = existChainData.getSiblingWithOutHide(billEntity, EnumDirection.DOWN);
        MatchBillChain.MatchChain upSibling = existChainData.getSiblingWithOutHide(billEntity, EnumDirection.UP);
        if (downSibling != null) {
            downSibling.setPrev(upSibling);
        }
        if (upSibling != null) {
            upSibling.setNext(downSibling);
        }
        LinkedList chains = existChainData.getChains();
        chains.remove(removeChain);
        List<String> keys = MatchBillChainHelper.getKeys(removeChain);
        keys.forEach(chainMap::remove);
        pageCache.put("chainmapcache", JSON.toJSONString((Object)existChainData));
        return existChainData;
    }

    public static MatchBillChain addChain(IPageCache pageCache, MatchBillChain.MatchChain addChain, String prevBillEntity) {
        MatchBillChain matchBillChain = MatchBillChainHelper.getChainData(pageCache);
        LinkedList chains = matchBillChain.getChains();
        Map chainMap = matchBillChain.getChainMap();
        MatchBillChain.MatchChain upSibling = matchBillChain.getChain(prevBillEntity);
        int insertIndex = upSibling == null ? 0 : chains.indexOf(upSibling) + 1;
        chains.add(insertIndex, addChain);
        if (insertIndex > 0) {
            MatchBillChain.MatchChain upChain = (MatchBillChain.MatchChain)chains.get(insertIndex - 1);
            upChain.setNext(addChain);
            addChain.setPrev(upChain);
        }
        if (chains.size() > insertIndex + 1) {
            MatchBillChain.MatchChain downChain = (MatchBillChain.MatchChain)chains.get(insertIndex + 1);
            downChain.setPrev(addChain);
            addChain.setNext(downChain);
        }
        List<String> keys = MatchBillChainHelper.getKeys(addChain);
        keys.forEach(key -> chainMap.put(key, addChain));
        pageCache.put("chainmapcache", JSON.toJSONString((Object)matchBillChain));
        return matchBillChain;
    }

    public static MatchBillChain getChainData() {
        MatchBillChain billChain = new MatchBillChain();
        billChain.addChain(new MatchBillChain.MatchChain[]{MatchBillChain.NewChain().setBillEntity("pm_purorderbill").setEntryEntity("billentry").setEntryIdentifyPrefix("order").setF7Identify("orderentryseq").setPlugin("kd.fi.ap.business.invoicematch.PurOrderMatchBillLoader").setNextRelType(EnumRelType.BOTP.name()).setAmtKey("amountandtax").setQtyKey("qty"), MatchBillChain.NewChain().setBillEntity("im_purreceivebill").setEntryEntity("billentry").setEntryIdentifyPrefix("rec").setF7Identify("recentryseq").setPlugin("kd.fi.ap.business.invoicematch.PurRecMatchBillLoader").setNextRelType(EnumRelType.BOTP.name()).setPrevRelType(EnumRelType.BOTP.name()).setAmtKey("amountandtax").setQtyKey("qty"), MatchBillChain.NewChain().setBillEntity("im_purinbill").setEntryEntity("billentry").setEntryIdentifyPrefix("in").setF7Identify("inentryseq").setPlugin("kd.fi.ap.business.invoicematch.PurInMatchBillLoader").setPrevRelType(EnumRelType.BOTP.name()).setAmtKey("amountandtax").setQtyKey("qty")});
        LinkedList chains = billChain.getChains();
        billChain.setChainMap(MatchBillChainHelper.buildChainMap(chains));
        return billChain;
    }

    private static Map<String, MatchBillChain.MatchChain> buildChainMap(LinkedList<MatchBillChain.MatchChain> chains) {
        HashMap<String, MatchBillChain.MatchChain> chainMap = new HashMap<String, MatchBillChain.MatchChain>(64);
        for (MatchBillChain.MatchChain matchChain : chains) {
            List<String> keys = MatchBillChainHelper.getKeys(matchChain);
            for (String key : keys) {
                chainMap.put(key, matchChain);
            }
        }
        return chainMap;
    }

    private static List<String> getKeys(MatchBillChain.MatchChain matchChain) {
        ArrayList<String> keys = new ArrayList<String>(64);
        Collections.addAll(keys, matchChain.getBillEntity(), matchChain.getAddEntryIdentify(), matchChain.getDelEntryIdentify(), matchChain.getEntryEntity(), matchChain.getEntryIdentify(), matchChain.getEntryIdentifyPrefix(), matchChain.getF7Identify(), matchChain.getIdIdentify(), matchChain.getMatchAmtKey(), matchChain.getMatchQtyKey(), matchChain.getTabIdentify(), matchChain.getToolbarIdentify());
        return keys;
    }

    public static MatchBillChain setActiveMatchTab(IPageCache pageCache, String activeMatchTab) {
        MatchBillChain matchBillChain = MatchBillChainHelper.getChainData(pageCache);
        matchBillChain.setActiveMatchTab(activeMatchTab);
        pageCache.put("chainmapcache", JSON.toJSONString((Object)matchBillChain));
        return matchBillChain;
    }
}

