/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.vo.MatchResult;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.ap.vo.MatchSchemeEntryVO;
import kd.fi.ap.vo.MatchSchemeVO;

public class MatchSchemeConverter {
    public static MatchSchemeVO convertMatchSchemeToVO(Long matchSchemeId) {
        DynamicObject matchScheme = BusinessDataServiceHelper.loadSingle((Object)matchSchemeId, (String)"ap_matchscheme");
        return MatchSchemeConverter.convertMatchSchemeToVO(matchScheme);
    }

    public static MatchSchemeVO convertMatchSchemeToVO(DynamicObject matchScheme) {
        MatchSchemeVO matchSchemeVO = new MatchSchemeVO();
        matchSchemeVO.setSchemePK(Long.valueOf(matchScheme.getLong("id")));
        matchSchemeVO.setCreateOrg(matchScheme.getDynamicObject("createorg"));
        matchSchemeVO.setNumber(matchScheme.getString("number"));
        matchSchemeVO.setName(matchScheme.getString("name"));
        matchSchemeVO.setUseOrg(matchScheme.getDynamicObject("useorg"));
        matchSchemeVO.setCtrlstrategy(matchScheme.getString("ctrlstrategy"));
        matchSchemeVO.setApplicability(matchScheme.getString("applicability_tag"));
        matchSchemeVO.setRemark(matchScheme.getString("remark"));
        matchSchemeVO.setBiztype(matchScheme.getString("biztype"));
        matchSchemeVO.setTimeorder(matchScheme.getString("timeorder"));
        matchSchemeVO.setMatchmode(matchScheme.getString("matchmode"));
        matchSchemeVO.setMatchrule(matchScheme.getString("matchrule"));
        matchSchemeVO.setMatchtype(matchScheme.getString("matchtype"));
        matchSchemeVO.setPricetolerance(matchScheme.getBigDecimal("pricetolerance"));
        matchSchemeVO.setTaxtolerance(matchScheme.getBigDecimal("taxtolerance"));
        matchSchemeVO.setAmttolerance(matchScheme.getBigDecimal("amttolerance"));
        matchSchemeVO.setPricetaxtolerance(matchScheme.getBigDecimal("pricetaxtolerance"));
        matchSchemeVO.setIsmultiple(matchScheme.getBoolean("ismultiple"));
        ArrayList<MatchSchemeEntryVO> entryVoList = new ArrayList<MatchSchemeEntryVO>(8);
        DynamicObjectCollection entryCol = matchScheme.getDynamicObjectCollection("entry");
        for (DynamicObject entryInfo : entryCol) {
            String matchfield = entryInfo.getString("matchfield");
            if ("org".equals(matchfield) || "receivablessupp".equals(matchfield) || "entry.material".equals(matchfield)) continue;
            MatchSchemeEntryVO matchSchemeEntryVO = new MatchSchemeEntryVO();
            matchSchemeEntryVO.setIsforce(entryInfo.getBoolean("isforce"));
            matchSchemeEntryVO.setIspreset(entryInfo.getBoolean("ispreset"));
            matchSchemeEntryVO.setMappingfield(entryInfo.getString("mappingfield"));
            matchSchemeEntryVO.setMatchfield(matchfield);
            entryVoList.add(matchSchemeEntryVO);
        }
        matchSchemeVO.setMatchSchemeEntrys(entryVoList);
        return matchSchemeVO;
    }

    public static List<DynamicObject> convertVO2Dyn(List<MatchResult> matchResults) {
        Map<Long, List<MatchResult>> matchMap = matchResults.stream().collect(Collectors.groupingBy(MatchResult::getInvPk));
        ArrayList<DynamicObject> matchBillList = new ArrayList<DynamicObject>(matchMap.size());
        DynamicObjectType entryType = null;
        DynamicObjectType subentryType = null;
        for (Map.Entry<Long, List<MatchResult>> matchEntry : matchMap.entrySet()) {
            List<MatchResult> matchResultList = matchEntry.getValue();
            boolean isAllMatch = true;
            for (MatchResult matchResult : matchResultList) {
                List matchResultItemList = matchResult.getItems();
                if (matchResultItemList.isEmpty()) {
                    isAllMatch = false;
                    break;
                }
                BigDecimal curBaseqty = BigDecimal.ZERO;
                for (MatchResultItem matchResultItem : matchResultItemList) {
                    curBaseqty = curBaseqty.add(matchResultItem.getCurbaseqty());
                }
                if (matchResult.getBaseqty().compareTo(curBaseqty) == 0) continue;
                isAllMatch = false;
                break;
            }
            if (!isAllMatch) continue;
            MatchResult result = matchResultList.get(0);
            DynamicObject matchinvoice = BusinessDataServiceHelper.newDynamicObject((String)"ap_matchinvoice");
            matchinvoice.set("org", (Object)result.getOrgId());
            matchinvoice.set("asstactname", (Object)result.getAsstactname());
            matchinvoice.set("buyername", (Object)result.getBuyername());
            matchinvoice.set("invoicetype", (Object)result.getInvoicetype());
            matchinvoice.set("biztype", (Object)result.getBiztype());
            matchinvoice.set("billtype", (Object)result.getBilltype());
            matchinvoice.set("matchscheme", (Object)result.getMatchschemeId());
            matchinvoice.set("asstacttype", (Object)result.getAsstacttype());
            matchinvoice.set("asstact", (Object)result.getAsstactId());
            matchinvoice.set("currency", (Object)result.getCurrencyId());
            for (MatchResult matchResult : matchResultList) {
                if (entryType == null) {
                    EntryProp entryProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)matchinvoice.getDataEntityType().getName()).findProperty("entry");
                    entryType = entryProp.getDynamicCollectionItemPropertyType();
                }
                DynamicObject entry = new DynamicObject(entryType);
                entry.set("invoiceid", (Object)matchResult.getInvPk());
                entry.set("invoiceentryid", (Object)matchResult.getInvEntryPk());
                entry.set("invoicebillno", (Object)matchResult.getBillno());
                entry.set("invoicecode", (Object)matchResult.getInvoicecode());
                entry.set("invoiceno", (Object)matchResult.getInvoiceno());
                entry.set("material", (Object)matchResult.getMaterialId());
                entry.set("e_materialversion", (Object)matchResult.getMaterialversion());
                entry.set("spectype", (Object)matchResult.getSpectype());
                entry.set("measureunit", (Object)matchResult.getMeasureunit());
                entry.set("quantity", (Object)matchResult.getQuantity());
                entry.set("e_baseunit", (Object)matchResult.getBaseunit());
                entry.set("e_baseqty", (Object)matchResult.getBaseqty());
                entry.set("price", (Object)matchResult.getPrice());
                entry.set("e_amount", (Object)matchResult.getAmount());
                entry.set("taxrate", (Object)matchResult.getTaxrate());
                entry.set("e_tax", (Object)matchResult.getTax());
                entry.set("discountmode", (Object)matchResult.getDiscountmode());
                entry.set("discountrate", (Object)matchResult.getDiscountrate());
                entry.set("discountamt", (Object)matchResult.getDiscountamt());
                entry.set("e_pricetaxtotal", (Object)matchResult.getPricetaxtotal());
                entry.set("e_taxclass", (Object)matchResult.getTaxclass());
                entry.set("amountdiff", (Object)matchResult.getAmountdiff());
                entry.set("taxdiff", (Object)matchResult.getTaxdiff());
                entry.set("pricetaxtotaldiff", (Object)matchResult.getPricetaxtotaldiff());
                entry.set("entrylog", (Object)matchResult.getLogmsg());
                Map extMap = matchResult.getExtMap();
                for (Map.Entry extEntry : extMap.entrySet()) {
                    entry.set((String)extEntry.getKey(), extEntry.getValue());
                }
                List matchResultItemList = matchResult.getItems();
                for (MatchResultItem matchResultItem : matchResultItemList) {
                    if (subentryType == null) {
                        EntryProp subentryProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)matchinvoice.getDataEntityType().getName()).findProperty("subentry");
                        subentryType = subentryProp.getDynamicCollectionItemPropertyType();
                    }
                    DynamicObject subentry = new DynamicObject(subentryType);
                    subentry.set("orderbill", (Object)matchResultItem.getOrderbillno());
                    subentry.set("orderbillid", (Object)matchResultItem.getOrderId());
                    subentry.set("stockbill", (Object)matchResultItem.getBillno());
                    subentry.set("stockbillid", matchResultItem.getBillId());
                    subentry.set("stockentryid", matchResultItem.getEntryId());
                    subentry.set("s_material", (Object)matchResultItem.getMaterialId());
                    subentry.set("s_materialname", (Object)matchResultItem.getMaterialname());
                    subentry.set("unit", (Object)matchResultItem.getUnitId());
                    subentry.set("qty", (Object)matchResultItem.getQty());
                    subentry.set("baseunit", (Object)matchResultItem.getBaseunitId());
                    subentry.set("baseqty", (Object)matchResultItem.getBaseqty());
                    subentry.set("s_price", (Object)matchResultItem.getPrice());
                    subentry.set("s_taxrate", (Object)matchResultItem.getTaxrate());
                    subentry.set("uninvoicedqty", (Object)matchResultItem.getUninvoicedqty());
                    subentry.set("uninvoicedbaseqty", (Object)matchResultItem.getUninvoicedbaseqty());
                    subentry.set("curqty", (Object)matchResultItem.getCurqty());
                    subentry.set("curbaseqty", (Object)matchResultItem.getCurbaseqty());
                    subentry.set("uninvoicedamt", (Object)matchResultItem.getUninvoicedamt());
                    subentry.set("curamtandtax", (Object)matchResultItem.getCuramtandtax());
                    subentry.set("curtax", (Object)matchResultItem.getCurtax());
                    subentry.set("curamt", (Object)matchResultItem.getCuramt());
                    subentry.set("amount", (Object)matchResultItem.getAmount());
                    subentry.set("taxamount", (Object)matchResultItem.getTaxamount());
                    subentry.set("amountandtax", (Object)matchResultItem.getAmountandtax());
                    subentry.set("biztime", (Object)matchResultItem.getBiztime());
                    subentry.set("pricediff", (Object)matchResultItem.getPricediff());
                    Map extSubMap = matchResultItem.getExtSubMap();
                    for (Map.Entry extSubEntry : extSubMap.entrySet()) {
                        subentry.set((String)extSubEntry.getKey(), extSubEntry.getValue());
                    }
                    entry.getDynamicObjectCollection("subentry").add((Object)subentry);
                }
                matchinvoice.getDynamicObjectCollection("entry").add((Object)entry);
            }
            matchBillList.add(matchinvoice);
        }
        return matchBillList;
    }
}

