/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoicematch.helper.MutexLockInfoCache;
import kd.fi.ap.util.DateUtils;

public class MutexLockHelper {
    private static final Log logger = LogFactory.getLog(MutexLockHelper.class);
    private static final String DATA_OBJ_ID = "dataObjId";
    private static final String GROUP_ID = "groupId";
    private static final String ENTITY_KEY = "entityKey";
    private static final String OPERATION_KEY = "operationKey";
    private static final String IS_STRICT = "isStrict";

    public static void requireMutex(String entityKey, Set<Long> billIds, String operationKey) {
        boolean isStrict = true;
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityKey;
        ArrayList mutexRequireList = new ArrayList(billIds.size());
        for (Long billId : billIds) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(DATA_OBJ_ID, billId.toString());
            requireParam.put(GROUP_ID, netGroupId);
            requireParam.put(ENTITY_KEY, entityKey);
            requireParam.put(OPERATION_KEY, operationKey);
            requireParam.put(IS_STRICT, isStrict);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                Boolean required = (Boolean)mutexItem.getValue();
                if (required.booleanValue()) continue;
                Map lockInfo = dataMutex.getLockInfo(objId, netGroupId, entityKey);
                StringBuilder sb = new StringBuilder();
                if (lockInfo != null) {
                    String timeStr;
                    sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"MutexLockHelper_0", (String)"fi-ap-business", (Object[])new Object[0]));
                    Long userid = Long.valueOf((String)lockInfo.get("userid"));
                    DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userid, (String)"bos_user");
                    if (userObj != null) {
                        sb.append(userObj.getString("name"));
                    }
                    if ((timeStr = (String)lockInfo.get("lockedTime")) != null) {
                        long timeL = Long.parseLong(timeStr);
                        sb.append(ResManager.loadKDString((String)"\u5728", (String)"MutexLockHelper_1", (String)"fi-ap-business", (Object[])new Object[0])).append(DateUtils.formatString((Date)new Date(timeL), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"MutexLockHelper_2", (String)"fi-ap-business", (Object[])new Object[0]));
                    String opName = MutexLockInfoCache.getLockOperateName((String)lockInfo.get("opkey"));
                    if (StringUtils.isNotEmpty((String)opName)) {
                        sb.append(opName);
                    }
                } else {
                    sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a", (String)"MutexLockHelper_3", (String)"fi-ap-business", (Object[])new Object[0]));
                }
                throw new KDBizException(sb.toString());
            }
        }
        catch (IOException exception) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"MutexLockHelper_4", (String)"fi-ap-business", (Object[])new Object[]{exception.getMessage()}));
            throw new KDException((Throwable)exception, ec, new Object[0]);
        }
    }

    public static void batchRelease(String entityNumber, Set<Long> lockIDs, String operationKey) {
        String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + entityNumber;
        if (!lockIDs.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIDs.size());
            for (Long lockID : lockIDs) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(DATA_OBJ_ID, lockID.toString());
                requireParam.put(GROUP_ID, netGroupId);
                requireParam.put(ENTITY_KEY, entityNumber);
                requireParam.put(OPERATION_KEY, operationKey);
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + objId + "]\u4e92\u65a5\u9501\u5931\u8d25.");
                }
            }
            catch (IOException exception) {
                throw new KDException((Throwable)exception, new ErrorCode("MUTEX_RELEASE_ERROR", ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"MutexLockHelper_5", (String)"fi-ap-business", (Object[])new Object[]{exception.getMessage()})), new Object[0]);
            }
        }
    }
}

