/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.match;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.DecimalEdit;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ap.business.invoicematch.helper.MatchBillChainHelper;
import kd.fi.ap.business.invoicematch.match.IMatchAction;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.MatchActionParam;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.ap.vo.MatchResult;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class AbstractMatchAction
implements IMatchAction {
    protected MatchActionParam matchParam;
    protected MatchBillChain matchBillChain;
    protected final Set<Integer> delRelRows = new HashSet<Integer>(64);
    protected EnumDirection direction;

    public AbstractMatchAction(MatchActionParam matchParam) {
        this.matchParam = matchParam;
        this.matchBillChain = MatchBillChainHelper.getChainData(matchParam.getView().getPageCache());
        String chooseRule = (String)matchParam.getModel().getValue("chooserule");
        this.direction = chooseRule.equals("ORDER") ? EnumDirection.DOWN : EnumDirection.UP;
    }

    @Override
    public void match() {
        this.matchEntry();
        MatchResult matchResult = this.getCurrentMatchResult();
        this.freshMatchStatus(matchResult);
        String redisKey = "matchresultcache_" + this.getCurrentInvPk();
        this.matchParam.getView().getPageCache().put(redisKey, JSON.toJSONString((Object)matchResult));
    }

    protected void freshMatchStatus(MatchResult matchResult) {
        BigDecimal targetValue = (BigDecimal)this.matchParam.getModel().getValue("resulttarget", 0);
        Set entrySet = matchResult.getItemGroup().entrySet();
        this.matchParam.getView().setVisible(Boolean.FALSE, new String[]{"resultcurr0", "resultcurr1", "resultcurr2"});
        int i = 0;
        boolean matchFlag = true;
        for (Map.Entry entry : entrySet) {
            BigDecimal currentMatchTotal = ((List)entry.getValue()).stream().map(MatchResultItem::getMatchKey).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (targetValue.compareTo(BigDecimal.ZERO) == 0) {
                targetValue = currentMatchTotal;
            }
            String fieldKey = "resultcurr" + i++;
            this.matchParam.getModel().setValue(fieldKey, (Object)currentMatchTotal, 0);
            this.matchParam.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
            matchFlag = matchFlag && targetValue.compareTo(currentMatchTotal) == 0;
            DecimalEdit decimalEdit = (DecimalEdit)this.matchParam.getView().getControl(fieldKey);
            String localeValue = MetadataServiceHelper.getDataEntityType((String)((String)entry.getKey())).getDisplayName().getLocaleValue();
            decimalEdit.setCaption(new LocaleString(localeValue));
        }
        this.matchParam.getModel().setValue("resultstatus", (Object)(matchFlag && targetValue.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0), 0);
    }

    protected void setTargetValue() {
        EntryGrid grid = (EntryGrid)this.matchParam.getView().getControl("entry");
        int checkRowIndex = grid.getSelectRows().length > 0 ? grid.getSelectRows()[0] : 0;
        String matchType = (String)this.matchParam.getModel().getValue("matchtype");
        String targetValueField = matchType.equals("AMT") ? "pricetaxtotal" : "quantity";
        BigDecimal targetValue = (BigDecimal)this.matchParam.getModel().getValue(targetValueField, checkRowIndex);
        this.matchParam.getModel().setValue("resulttarget", (Object)targetValue, 0);
        this.matchParam.getView().setVisible(Boolean.valueOf(targetValue.compareTo(BigDecimal.ZERO) > 0), new String[]{"resulttarget"});
    }

    protected abstract void matchEntry();

    @Override
    public MatchResult getCurrentMatchResult() {
        MatchResult matchResult = MatchResult.New();
        Long invPk = this.getCurrentInvPk();
        ArrayList<MatchResultItem> items = new ArrayList<MatchResultItem>(64);
        String matchType = (String)this.matchParam.getModel().getValue("matchtype");
        for (MatchBillChain.MatchChain chain : this.matchBillChain.getChains()) {
            String entryIdentify = chain.getEntryIdentify();
            DynamicObjectCollection collection = this.matchParam.getModel().getEntryEntity(entryIdentify);
            List collect = collection.stream().filter(e -> e.getBigDecimal(chain.getMatchAmtKey()).compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            if (EmptyUtils.isNotEmpty(collect)) {
                for (DynamicObject rowEntity : collect) {
                    MatchResultItem item = new MatchResultItem(matchType, rowEntity.getBigDecimal(chain.getMatchAmtKey()), rowEntity.getBigDecimal(chain.getMatchQtyKey()), chain.getBillEntity(), (Object)rowEntity.getLong(chain.getIdIdentify()), (Object)rowEntity.getLong(chain.getBillIdIdentify()), rowEntity.getInt("seq") + 1);
                    items.add(item);
                }
                continue;
            }
            if (chain.isHide()) continue;
            items.add(new MatchResultItem(matchType, BigDecimal.ZERO, BigDecimal.ZERO, chain.getBillEntity(), (Object)0L, (Object)0L, 0));
        }
        matchResult.setItems(items);
        matchResult.setInvPk(invPk);
        return matchResult;
    }

    protected Map<String, Set<Long>> getRelationMap(Long pk) {
        Long invPk = this.getCurrentInvPk();
        DynamicObjectCollection entryList = this.matchParam.getModel().getEntryEntity("relentry");
        List remainRelList = entryList.stream().filter(e -> !this.delRelRows.contains(e.getInt("seq") - 1)).collect(Collectors.toList());
        HashMap<String, Set<Long>> relationMap = new HashMap<String, Set<Long>>(64);
        for (DynamicObject dyb : remainRelList) {
            Long invoicePk = dyb.getLong("relinvpk");
            if (!Objects.equals(invoicePk, invPk)) continue;
            Long srcEntryId = dyb.getLong("relsrcentryid");
            Long tgtEntryId = dyb.getLong("reltgtentryid");
            String relDirection = dyb.getString("reldirection");
            if (Objects.equals(srcEntryId, pk)) {
                Set srcSet = relationMap.getOrDefault(relDirection, new HashSet());
                srcSet.add(dyb.getLong("reltgtentryid"));
                relationMap.put(relDirection, srcSet);
                continue;
            }
            if (!Objects.equals(tgtEntryId, pk)) continue;
            Set tgtSet = relationMap.getOrDefault(EnumDirection.getReverse((String)relDirection).name(), new HashSet());
            tgtSet.add(dyb.getLong("relsrcentryid"));
            relationMap.put(EnumDirection.getReverse((String)relDirection).name(), tgtSet);
        }
        return relationMap;
    }

    protected Long getCurrentInvPk() {
        int[] selectRows = ((EntryGrid)this.matchParam.getView().getControl("entry")).getSelectRows();
        Object value = this.matchParam.getModel().getValue("invpk", ArrayUtils.isEmpty((int[])selectRows) ? 0 : selectRows[0]);
        return Long.parseLong(value.toString());
    }

    protected void clearMatchCache() {
        DynamicObjectCollection collection = this.matchParam.getModel().getEntryEntity("entry");
        for (DynamicObject dybEntry : collection) {
            for (MatchBillChain.MatchChain chain : this.matchBillChain.getChains()) {
                String redisKey = "entrymatchcache_".concat(dybEntry.getString("invpk")).concat(chain.getEntryIdentify());
                this.matchParam.getView().getPageCache().remove(redisKey);
            }
            this.matchParam.getView().getPageCache().remove("matchresultcache_" + dybEntry.getString("invpk"));
        }
    }

    protected void clearEntryData() {
        for (MatchBillChain.MatchChain matchChain : this.matchBillChain.getChains()) {
            this.matchParam.getModel().beginInit();
            this.matchParam.getModel().deleteEntryData(matchChain.getEntryIdentify());
            this.matchParam.getModel().endInit();
            this.matchParam.getView().updateView(matchChain.getEntryIdentify());
        }
    }

    protected void freshMatchTabView() {
        String chooseRule = (String)this.matchParam.getModel().getValue("chooserule");
        boolean onlyMatchOrder = chooseRule.equals("ORDER");
        Tab matchTab = (Tab)this.matchParam.getView().getControl("chainbilltab");
        String firstMatchTabKey = ((Control)matchTab.getItems().get(0)).getKey();
        EntryGrid grid = (EntryGrid)this.matchParam.getView().getControl("entry");
        int checkRowIndex = grid.getSelectRows().length > 0 ? grid.getSelectRows()[0] : 0;
        String invMatchRule = (String)this.matchParam.getModel().getValue("invmatchrule", checkRowIndex);
        Map chainMap = this.matchBillChain.getChainMap();
        MatchBillChain.MatchChain currentChain = onlyMatchOrder ? (MatchBillChain.MatchChain)chainMap.get(firstMatchTabKey) : (MatchBillChain.MatchChain)chainMap.get(invMatchRule.toLowerCase());
        matchTab.activeTab(currentChain.getTabIdentify());
        MatchBillChain.MatchChain ruleChain = (MatchBillChain.MatchChain)chainMap.get(invMatchRule.toLowerCase());
        int chainIndex = this.matchBillChain.getChains().indexOf(ruleChain);
        List tabItems = matchTab.getItems();
        for (Control tabItem : tabItems) {
            MatchBillChain.MatchChain matchChain = (MatchBillChain.MatchChain)chainMap.get(tabItem.getKey());
            if (matchChain == null) {
                this.matchParam.getView().setVisible(Boolean.FALSE, new String[]{tabItem.getKey()});
                continue;
            }
            int indexOf = this.matchBillChain.getChains().indexOf(matchChain);
            this.matchParam.getView().setVisible(Boolean.valueOf(indexOf <= chainIndex), new String[]{matchChain.getTabIdentify()});
            this.matchParam.getView().setVisible(Boolean.valueOf(!this.matchParam.isViewMode() && matchChain.equals((Object)currentChain)), new String[]{matchChain.getAddEntryIdentify(), matchChain.getDelEntryIdentify()});
            this.matchBillChain = MatchBillChainHelper.updateChainStatus(this.matchParam.getView().getPageCache(), indexOf <= chainIndex, matchChain.getTabIdentify());
        }
        this.matchBillChain = MatchBillChainHelper.setActiveMatchTab(this.matchParam.getView().getPageCache(), currentChain.getTabIdentify());
    }

    protected void refreshMatchKeyEnable() {
        String matchType = (String)this.matchParam.getModel().getValue("matchtype");
        for (MatchBillChain.MatchChain chain : this.matchBillChain.getChains()) {
            int entryRowCount = this.matchParam.getModel().getEntryRowCount(chain.getEntryIdentify());
            for (int i = 0; i < entryRowCount; ++i) {
                this.matchParam.getView().setEnable(Boolean.valueOf(matchType.equals("AMT") && !this.matchParam.isViewMode()), i, new String[]{chain.getMatchAmtKey()});
                this.matchParam.getView().setEnable(Boolean.valueOf(matchType.equals("QTY") && !this.matchParam.isViewMode()), i, new String[]{chain.getMatchQtyKey()});
            }
        }
    }
}

