/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.fi.ap.business.invoicematch.match.AbstractMatchAction;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.MatchActionParam;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.arapcommon.util.EmptyUtils;

public class DeleteMatchAction
extends AbstractMatchAction {
    private final Map<String, List<Integer>> deleteIndexGroup = new HashMap<String, List<Integer>>(64);

    public DeleteMatchAction(MatchActionParam matchParam) {
        super(matchParam);
    }

    private static int applyAsInt(Integer i) {
        return i;
    }

    @Override
    public void matchEntry() {
        Object eventParam = this.matchParam.getEventParam();
        if (eventParam instanceof BeforeDeleteRowEventArgs) {
            BeforeDeleteRowEventArgs evt = (BeforeDeleteRowEventArgs)this.matchParam.getEventParam();
            int[] rowIndexs = evt.getRowIndexs();
            String entryKey = evt.getEntryProp().getName();
            MatchBillChain.MatchChain matchChain = (MatchBillChain.MatchChain)this.matchBillChain.getChainMap().get(entryKey);
            List<DynamicObject> deleteEntries = IntStream.of(rowIndexs).mapToObj(iRow -> this.matchParam.getModel().getEntryEntity(evt.getEntryProp().getName(), iRow)).collect(Collectors.toList());
            this.deleteRecurse(matchChain, deleteEntries);
            for (Map.Entry<String, List<Integer>> keyVal : this.deleteIndexGroup.entrySet()) {
                this.matchParam.getModel().beginInit();
                this.matchParam.getModel().deleteEntryRows(keyVal.getKey(), keyVal.getValue().stream().mapToInt(DeleteMatchAction::applyAsInt).toArray());
                this.matchParam.getModel().endInit();
                this.matchParam.getView().updateView(keyVal.getKey());
            }
            this.refreshMatchKeyEnable();
            this.matchParam.getModel().deleteEntryRows("relentry", this.delRelRows.stream().mapToInt(DeleteMatchAction::applyAsInt).toArray());
        }
    }

    private void deleteRelEntry(MatchBillChain.MatchChain matchChain, DynamicObject rowEntity) {
        Long id = rowEntity.getLong(matchChain.getIdIdentify());
        MatchBillChain.MatchChain sibling = this.matchBillChain.getSibling(matchChain.getBillEntity(), this.direction);
        if (sibling != null) {
            DynamicObjectCollection entryEntity = this.matchParam.getModel().getEntryEntity("relentry");
            Long invPk = this.getCurrentInvPk();
            for (DynamicObject dyb : entryEntity) {
                Long relId = dyb.getLong("relsrcentryid");
                Long invoiceId = dyb.getLong("relinvpk");
                if (!Objects.equals(invoiceId, invPk) || !Objects.equals(relId, id)) continue;
                this.delRelRows.add(dyb.getInt("seq") - 1);
            }
        }
    }

    private void deleteRecurse(MatchBillChain.MatchChain matchChain, List<DynamicObject> rowEntities) {
        ArrayList<DynamicObject> siblingDelEntries = new ArrayList<DynamicObject>(64);
        List deleteEntryPks = rowEntities.stream().map(entry -> entry.getLong(matchChain.getIdIdentify())).collect(Collectors.toList());
        for (DynamicObject rowEntity : rowEntities) {
            String matchType = (String)this.matchParam.getModel().getValue("matchtype");
            int seq = rowEntity.getInt("seq") - 1;
            this.matchParam.getModel().setValue(matchChain.getMatchKey(matchType), (Object)BigDecimal.ZERO, seq);
            this.deleteIndexGroup.putIfAbsent(matchChain.getEntryIdentify(), new ArrayList(64));
            this.deleteIndexGroup.get(matchChain.getEntryIdentify()).add(seq);
        }
        MatchBillChain.MatchChain sibling = this.matchBillChain.getSibling(matchChain.getBillEntity(), this.direction);
        if (sibling != null) {
            DynamicObjectCollection siblingEntries = this.matchParam.getModel().getEntryEntity(sibling.getEntryIdentify());
            for (DynamicObject siblingEntry : siblingEntries) {
                String reverseDirection;
                Long siblingEntryPk = siblingEntry.getLong(sibling.getIdIdentify());
                Map<String, Set<Long>> siblingRelationMap = this.getRelationMap(siblingEntryPk);
                Set siblingReversePks = siblingRelationMap.getOrDefault(reverseDirection = EnumDirection.getReverse((String)this.direction.name()).name(), new HashSet(0));
                if (!deleteEntryPks.containsAll(siblingReversePks)) continue;
                siblingDelEntries.add(siblingEntry);
            }
        }
        for (DynamicObject rowEntity : rowEntities) {
            this.deleteRelEntry(matchChain, rowEntity);
        }
        if (EmptyUtils.isNotEmpty(siblingDelEntries) && sibling != null) {
            this.deleteRecurse(sibling, siblingDelEntries);
        }
    }
}

