/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.match;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.fi.ap.business.invoicematch.match.AbstractMatchAction;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.MatchActionParam;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ModifyMatchAction
extends AbstractMatchAction {
    public ModifyMatchAction(MatchActionParam matchParam) {
        super(matchParam);
    }

    @Override
    public void matchEntry() {
        ChangeData[] changeSet;
        String matchType;
        PropertyChangedArgs evt = (PropertyChangedArgs)this.matchParam.getEventParam();
        IDataEntityProperty property = evt.getProperty();
        String propertyName = property.getName();
        if (!propertyName.contains((matchType = (String)this.matchParam.getModel().getValue("matchtype")).toLowerCase())) {
            return;
        }
        MatchBillChain.MatchChain matchChain = (MatchBillChain.MatchChain)this.matchBillChain.getChainMap().get(propertyName);
        for (ChangeData changeData : changeSet = evt.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            BigDecimal matchNumber = (BigDecimal)changeData.getNewValue();
            DynamicObject rowEntity = this.matchParam.getModel().getEntryRowEntity(matchChain.getEntryIdentify(), rowIndex);
            if (propertyName.endsWith("qty")) {
                BigDecimal taxAndPrice = rowEntity.getBigDecimal(matchChain.getPriceAndTaxKey());
                BigDecimal unMatchQty = rowEntity.getBigDecimal(matchChain.getUnMatchQtyKey());
                BigDecimal amountAndTax = rowEntity.getBigDecimal(matchChain.getAmountAndTaxKey());
                BigDecimal quantity = rowEntity.getBigDecimal(matchChain.getQuantityKey());
                BigDecimal flow = matchNumber.compareTo(unMatchQty) == 0 ? amountAndTax.subtract(taxAndPrice.multiply(quantity)) : BigDecimal.ZERO;
                this.matchParam.getModel().setValue(matchChain.getMatchAmtKey(), (Object)taxAndPrice.multiply(matchNumber).add(flow), rowIndex);
            }
            this.matchSiblingChains(matchNumber, matchChain, rowEntity.getLong(matchChain.getIdIdentify()));
        }
    }

    private void matchSiblingChains(BigDecimal matchNumber, MatchBillChain.MatchChain chain, Long entryPk) {
        String matchType = (String)this.matchParam.getModel().getValue("matchtype");
        MatchBillChain.MatchChain siblingChain = this.matchBillChain.getSibling(chain.getBillEntity(), this.direction);
        if (siblingChain != null) {
            DynamicObjectCollection collection = this.matchParam.getModel().getEntryEntity(siblingChain.getEntryIdentify());
            BigDecimal tmpMatchNumber = matchNumber;
            for (DynamicObject siblingEntry : collection) {
                BigDecimal unMatchNumber;
                BigDecimal result;
                Long siblingPk;
                Map<String, Set<Long>> relationMap = this.getRelationMap(entryPk);
                Set relationPks = relationMap.getOrDefault(this.direction.name(), new HashSet());
                if (!relationPks.contains(siblingPk = Long.valueOf(siblingEntry.getLong(siblingChain.getIdIdentify())))) continue;
                int rowIndex = siblingEntry.getInt("seq") - 1;
                if (this.direction == EnumDirection.UP) {
                    tmpMatchNumber = this.matchParam.getModel().getEntityEntity(chain.getEntryIdentify()).stream().filter(e -> {
                        Set set = this.getRelationMap(e.getLong(chain.getIdIdentify())).getOrDefault(EnumDirection.UP.name(), new HashSet());
                        return EmptyUtils.isNotEmpty((Object)set) && CollectionUtils.isEqualCollection((Collection)set, (Collection)relationPks);
                    }).map(e -> e.getBigDecimal(chain.getMatchKey(matchType))).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                BigDecimal bigDecimal = result = (unMatchNumber = siblingEntry.getBigDecimal(siblingChain.getUnMatchKey(matchType))).compareTo(tmpMatchNumber) >= 0 ? tmpMatchNumber : unMatchNumber;
                if (matchType.equals("QTY")) {
                    BigDecimal taxAndPrice = siblingEntry.getBigDecimal(siblingChain.getPriceAndTaxKey());
                    BigDecimal amountAndTax = siblingEntry.getBigDecimal(siblingChain.getAmountAndTaxKey());
                    BigDecimal quantity = siblingEntry.getBigDecimal(siblingChain.getQuantityKey());
                    BigDecimal flow = tmpMatchNumber.compareTo(siblingEntry.getBigDecimal(siblingChain.getUnMatchQtyKey())) == 0 ? amountAndTax.subtract(taxAndPrice.multiply(quantity)) : BigDecimal.ZERO;
                    this.matchParam.getModel().setValue(siblingChain.getMatchAmtKey(), (Object)result.multiply(taxAndPrice).add(flow), rowIndex);
                }
                this.matchParam.getModel().setValue(siblingChain.getMatchKey(matchType), (Object)result, rowIndex);
                this.matchSiblingChains(result, siblingChain, siblingEntry.getLong(siblingChain.getIdIdentify()));
                tmpMatchNumber = tmpMatchNumber.subtract(result);
            }
        }
    }
}

