/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.match;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.business.invoicematch.match.AbstractInvMatchService;
import kd.fi.ap.vo.MatchResult;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.BillFieldMappingVO;

public class PurInMatchService
extends AbstractInvMatchService {
    @Override
    protected void getMatchSelector(Set<String> selectors) {
        selectors.add("biztime");
        selectors.add("settlecurrency.amtprecision");
        selectors.add("billentry.id");
        selectors.add("billentry.material");
        selectors.add("billentry.materialmasterid");
        selectors.add("billentry.materialname");
        selectors.add("billentry.unit");
        selectors.add("billentry.qty");
        selectors.add("billentry.baseunit");
        selectors.add("billentry.baseqty");
        selectors.add("billentry.price");
        selectors.add("billentry.remainjoinpriceqty");
        selectors.add("billentry.remainjoinpricebaseqty");
        selectors.add("billentry.returnqty");
        selectors.add("billentry.returnbaseqty");
        selectors.add("billentry.unverifyqty");
        selectors.add("billentry.unverifybaseqty");
        selectors.add("billentry.amount");
        selectors.add("billentry.taxrate");
        selectors.add("billentry.taxamount");
        selectors.add("billentry.amountandtax");
    }

    @Override
    protected MatchResultItem matchBill2Vo(DynamicObject bill, Set<BillFieldMappingVO> fieldMapping) {
        MatchResultItem item = super.matchBill2Vo(bill, fieldMapping);
        item.setMatchType("QTY");
        item.setBiztime(bill.getDate("biztime"));
        Integer amtprecision = bill.getInt("settlecurrency.amtprecision");
        item.setEntryId(bill.get("billentry.id"));
        item.setMaterialId(Long.valueOf(bill.getLong("billentry.materialmasterid")));
        item.setMaterialname(bill.getString("billentry.materialname"));
        item.setUnitId(Long.valueOf(bill.getLong("billentry.unit")));
        item.setQty(bill.getBigDecimal("billentry.qty"));
        item.setBaseunitId(Long.valueOf(bill.getLong("billentry.baseunit")));
        item.setBaseqty(bill.getBigDecimal("billentry.baseqty"));
        item.setPrice(bill.getBigDecimal("billentry.price"));
        BigDecimal uninvoicedbaseqty = bill.getBigDecimal("billentry.remainjoinpricebaseqty");
        BigDecimal unverifybaseqty = bill.getBigDecimal("billentry.unverifybaseqty");
        if (uninvoicedbaseqty.abs().compareTo(unverifybaseqty.abs()) > 0) {
            item.setUninvoicedbaseqty(unverifybaseqty);
            item.setUninvoicedqty(bill.getBigDecimal("billentry.unverifyqty"));
        } else {
            item.setUninvoicedbaseqty(uninvoicedbaseqty);
            BigDecimal uninvoicedqty = bill.getBigDecimal("billentry.remainjoinpriceqty");
            item.setUninvoicedqty(uninvoicedqty);
        }
        item.setAmount(bill.getBigDecimal("billentry.amount"));
        item.setTaxrate(bill.getBigDecimal("billentry.taxrate"));
        item.setTaxamount(bill.getBigDecimal("billentry.taxamount"));
        item.setAmountandtax(bill.getBigDecimal("billentry.amountandtax"));
        item.setUninvoicedamt(item.getUninvoicedqty().multiply(item.getPrice()).setScale((int)amtprecision, RoundingMode.HALF_UP));
        return item;
    }

    @Override
    protected QFilter getMatchBillFilter(MatchResult matchResult) {
        Long asstactId = matchResult.getAsstactId();
        QFilter filter = new QFilter("billentry.invoicesupplier.masterid", "=", (Object)asstactId);
        filter.and(new QFilter("billentry.entrysettleorg", "=", (Object)matchResult.getOrgId()));
        filter.and(new QFilter("settlecurrency", "=", (Object)matchResult.getCurrencyId()));
        filter.and(new QFilter("billentry.remainjoinpricebaseqty", "!=", (Object)BigDecimal.ZERO));
        filter.and(new QFilter("billentry.materialmasterid", "=", (Object)matchResult.getMaterialId()));
        String orderbillno = matchResult.getOrderbillno();
        if (EmptyUtils.isNotEmpty((Object)orderbillno)) {
            filter.and(new QFilter("billentry.mainbillentity", "=", (Object)"pm_purorderbill"));
            filter.and(new QFilter("billentry.mainbillnumber", "=", (Object)orderbillno));
        }
        return filter;
    }

    @Override
    protected String getMatchBillEntity() {
        return "im_purinbill";
    }
}

