/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.invoicematch.match;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.ap.business.invoicematch.IMatchBillLoader;
import kd.fi.ap.business.invoicematch.MatchBillLoaderFactory;
import kd.fi.ap.business.invoicematch.helper.MatchBillChainHelper;
import kd.fi.ap.business.invoicematch.helper.MatchBillLoaderParam;
import kd.fi.ap.business.invoicematch.match.AbstractMatchAction;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.vo.InvoiceMatchParam;
import kd.fi.ap.vo.MatchActionParam;
import kd.fi.ap.vo.MatchBillChain;

public class ViewModeAction
extends AbstractMatchAction {
    public ViewModeAction(MatchActionParam matchParam) {
        super(matchParam);
    }

    @Override
    protected void matchEntry() {
        this.clearEntryData();
        String chooseRule = (String)this.matchParam.getModel().getValue("chooserule");
        MatchBillChain.MatchChain currentChain = MatchBillChainHelper.getActiveChain(this.matchParam.getView().getPageCache());
        DynamicObject[] matchRecords = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)this.matchParam.getView().getPageCache().get("matchRecordCache"));
        List matchRecordEntry = Stream.of(matchRecords).map(match -> match.getDynamicObjectCollection("matchentry")).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> recordEntryGroup = matchRecordEntry.stream().collect(Collectors.groupingBy(entry -> entry.getLong("invpk")));
        Long invPk = this.getCurrentInvPk();
        Map<Long, DynamicObject> recordMap = ((List)recordEntryGroup.getOrDefault(invPk, new ArrayList())).stream().collect(Collectors.toMap(entry -> entry.getLong("billentryid"), entry -> entry));
        JSONObject customParamJson = (JSONObject)this.matchParam.getView().getFormShowParameter().getCustomParam("param");
        InvoiceMatchParam param = (InvoiceMatchParam)JSON.toJavaObject((JSON)customParamJson, InvoiceMatchParam.class);
        MatchBillLoaderParam loaderParam = MatchBillLoaderParam.New().setMatchChain(currentChain).setView(this.matchParam.getView()).setModel(this.matchParam.getModel()).setMatchParam(param).setEntryPks(recordMap.keySet().toArray()).setDirection(chooseRule.equals("ORDER") ? EnumDirection.DOWN : EnumDirection.UP);
        IMatchBillLoader loader = MatchBillLoaderFactory.getChainLoaders(currentChain.getBillEntity(), loaderParam);
        loader.loadDatas();
    }
}

