/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.journal;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.arapcommon.journal.BizDescriptionEnum;
import kd.fi.arapcommon.journal.convert.JournalAutoConverter;

public class PaidBillPushJournalConverter
extends JournalAutoConverter {
    protected Object getValue(String journalField, DynamicObject sourceBill, DynamicObject row) {
        if ("biztype".equals(journalField)) {
            return "ap_paidbill";
        }
        if ("prepaidamt".equals(journalField)) {
            if (row != null) {
                return row.getBigDecimal("e_actamt");
            }
            return sourceBill.getBigDecimal("actpayamt");
        }
        if ("localprepaidamt".equals(journalField)) {
            if (row != null) {
                return row.getBigDecimal("e_localamt");
            }
            return sourceBill.getBigDecimal("localamt");
        }
        if ("asstacttype".equals(journalField)) {
            return sourceBill.get("payeetype");
        }
        if ("asstact".equals(journalField)) {
            return sourceBill.get("payee");
        }
        if ("bizdescription".equals(journalField)) {
            return "202".equals(sourceBill.getString("paymenttype.biztype")) ? BizDescriptionEnum.paid.name() : BizDescriptionEnum.pay.name();
        }
        return super.getValue(journalField, sourceBill, row);
    }

    protected Set<String> getSourceBillSelectors() {
        HashSet<String> selectors = new HashSet<String>();
        if (this.entryKey != null) {
            selectors.add("e_actamt");
            selectors.add("e_localamt");
        } else {
            selectors.add("actpayamt");
            selectors.add("localamt");
        }
        selectors.add("payeetype");
        selectors.add("payee");
        selectors.add("paymenttype");
        selectors.addAll(this.getSourceBillDefaultSelectors());
        return selectors;
    }
}

