/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.errorcode.SystemErrorCode;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.init.InitServiceHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.AbstractOpService;
import kd.fi.arapcommon.service.BalanceService;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class InitAntiCloseImpl
extends AbstractOpService {
    private int BATCHCOUNT = 0;

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("org");
        lst.add("isfinishinit");
        lst.add("startperiod");
        lst.add("curperiod");
        lst.add("startdate");
        lst.add("currentdate");
        lst.add("entryentity");
        return lst;
    }

    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
        DynamicObject org = info.getDynamicObject("org");
        Date currentDate = info.getDate("currentdate");
        Date startDate = info.getDate("startdate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String startDateStr = sdf.format(startDate);
        if (!ObjectUtils.isEmpty((Object)currentDate) && startDate.compareTo(currentDate) < 0 || info.getDynamicObject("curperiod") != null && !info.getDynamicObject("startperiod").getPkValue().equals(info.getDynamicObject("curperiod").getPkValue())) {
            throw new KDBizException(SystemErrorCode.EXISTS_CLOSEACC_CANNOT_ANITCLOSE(), new Object[]{org.getLocaleString("name").getLocaleValue(), startDateStr});
        }
    }

    public void process(DynamicObject info) {
        super.process(info);
        Object orgPk = info.getDynamicObject("org").getPkValue();
        this.updateBill(orgPk, "ap_finapbill", true);
        this.updateBill(orgPk, "ap_busbill", true);
        this.updateBill(orgPk, "ap_paidbill", false);
        info.set("curperiod", null);
        info.set("currentdate", null);
        info.set("isfinishinit", (Object)Boolean.FALSE);
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
        if (!entrys.isEmpty()) {
            entrys.clear();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        DynamicObject closeAccountInfo = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)"ap_closeaccount", (String)"failedmessage");
        closeAccountInfo.set("entryentity", null);
        SaveServiceHelper.save((IDataEntityType)closeAccountInfo.getDataEntityType(), (Object[])new DynamicObject[]{closeAccountInfo});
        CloseRecordService closeRecordService = new CloseRecordService("ap");
        closeRecordService.deleteCloseRecordByAntiInit((Long)orgPk);
        BalanceService balanceService = new BalanceService("ap");
        balanceService.deleteBalanceByInit((Long)orgPk);
    }

    private void updateBill(Object orgPk, String entityKey, boolean isPeriod) {
        QFilter qFilter = new QFilter("org", "=", orgPk);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (isPeriod) {
            qFilter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        LinkedList<Long> ids = new LinkedList<Long>();
        if (this.BATCHCOUNT == 0) {
            this.BATCHCOUNT = InitServiceHelper.getInitBatchHandleCount();
        }
        try (DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"fi.ap.InitAntiCloseImpl", (String)entityKey, (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row bill : billDataSet) {
                ids.add(bill.getLong("id"));
                if (ids.size() != this.BATCHCOUNT) continue;
                this.doUpdateStatus(ids, entityKey);
                ids.clear();
            }
        }
        if (!ids.isEmpty()) {
            this.doUpdateStatus(ids, entityKey);
        }
    }

    private void doUpdateStatus(List<Long> ids, String entityKey) {
        DynamicObjectType subEntityType = EntityMetadataUtils.getSubEntityType((String)entityKey, (String)"id,billstatus, auditdate,auditor,bookdate,isvoucher");
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)subEntityType);
        List pks = ArApHelper.getPks((Object)bills);
        HashSet<Long> idSetHadRecords = new HashSet<Long>(64);
        List mainSettleIds = SettleRecordQueryHelper.getBillIdsHadSettlesByMain((String)"ap_settlerecord", (String)entityKey, (Object[])ids.toArray());
        idSetHadRecords.addAll(mainSettleIds);
        List asstSettleIds = SettleRecordQueryHelper.getBillIdsHadSettlesByAsst((String)"ap_settlerecord", (String)entityKey, (Object[])ids.toArray());
        idSetHadRecords.addAll(asstSettleIds);
        Map pushMap = BFTrackerServiceHelper.findDirtTargetBills((String)entityKey, (Long[])pks.toArray(new Long[0]));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ap_verifyrecord", "billid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ap_verifyrecord", "entry.e_billid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ap_bus_verifyrecord", "entry.billid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ap_bus_verifyrecord", "entry.assbillid"));
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>();
        for (DynamicObject bill : bills) {
            Object pk = bill.getPkValue();
            boolean exists = !ObjectUtils.isEmpty((Object)pushMap) && !ObjectUtils.isEmpty(pushMap.get(pk));
            boolean isVucher = false;
            if (EmptyUtils.isNotEmpty((Object)bill.getDataEntityType().getProperties().get((Object)"isvoucher"))) {
                isVucher = bill.getBoolean("isvoucher");
            }
            if (isVucher || idSetHadRecords.contains(pk) || exists) continue;
            bill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            bill.set("auditdate", null);
            bill.set("auditor", null);
            billList.add(bill);
        }
        if (!ObjectUtils.isEmpty(billList)) {
            DynamicObject[] billArray = billList.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])billArray);
            Object[] idArr = billList.stream().map(v -> v.get("id")).toArray(Object[]::new);
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"periodunaudit", (String)entityKey, (Object[])idArr, (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)opResult);
            new JournalService().deleteJournals(billArray);
        }
    }

    private Set<Long> getBillIdSetHadRecords(List<Long> ids, String recordNameKey, String column) {
        QFilter filter = new QFilter(column, "in", ids);
        DynamicObjectCollection records = QueryServiceHelper.query((String)recordNameKey, (String)column, (QFilter[])filter.toArray());
        return records.stream().map(bill -> bill.getLong(column)).collect(Collectors.toSet());
    }
}

