/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoice.Invoice4CloudResolveService;
import kd.fi.ap.business.pojo.InvoiceResolveParam;
import kd.fi.ap.errorcode.SystemErrorCode;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class InvoiceDownloadTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(InvoiceDownloadTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        logger.info("---InvoiceDownloadTask is begin! params = " + params);
        long orgPk = context.getOrgId();
        if (!EmptyUtils.isEmpty((Object)orgPk)) {
            String bizType = (String)params.get("biztype");
            String salerTaxNo = (String)params.get("salerTaxNo");
            if (EmptyUtils.isEmpty((Object)bizType)) {
                logger.info("---params is invalid--- params={orgPk:" + orgPk + ", biztype:" + bizType + ", salerTaxNos:" + salerTaxNo + "}");
                return;
            }
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgPk, (String)"bos_org", (String)"id, number, name");
            InitHelper init = new InitHelper(orgPk, "ap_init");
            if (ObjectUtils.isEmpty((Object)init.getStartDate())) {
                throw new KDBizException(SystemErrorCode.ORGNAME_NOT_FINISHSET(), new Object[]{org.getLocaleString("name").getLocaleValue()});
            }
            String beginDate = (String)params.get("beginDate");
            String endDate = (String)params.get("endDate");
            if (EmptyUtils.isEmpty((Object)beginDate) && EmptyUtils.isEmpty((Object)endDate)) {
                this.download(org, bizType, salerTaxNo);
            } else if (!EmptyUtils.isEmpty((Object)beginDate) && !EmptyUtils.isEmpty((Object)endDate)) {
                Date startTime = DateUtils.parseDate((String)beginDate, (String)"yyyy-MM-dd");
                Date endTime = DateUtils.parseDate((String)endDate, (String)"yyyy-MM-dd");
                if (endTime.compareTo(startTime) >= 0) {
                    this.download(org, bizType, salerTaxNo, startTime, endTime);
                } else {
                    logger.info("---date is invalid! beginDate = " + beginDate + ", endDate = " + endDate);
                }
            }
        } else {
            logger.info("---orgPk is invalid");
        }
        logger.info("---InvoiceDownloadTask is end");
    }

    private void download(DynamicObject org, String bizType, String taxNo) {
        Date endTime = DateUtils.truncateDate((Date)new Date());
        Date startTime = DateUtils.getNextDay((Date)endTime, (int)-1);
        this.download(org, bizType, taxNo, startTime, endTime);
    }

    private void download(DynamicObject org, String bizType, String taxNo, Date startTime, Date endTime) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((DynamicObject)org);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("buyerTaxNo", config.getTaxRegnum());
        param.put("salerTaxNo", taxNo);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("pageNo", 1);
        param.put("pageSize", 50);
        String invoiceTypes = StdConfig.get((String)"invoicecloud.invoiceTypes");
        param.put("invoiceTypes", invoiceTypes != null ? invoiceTypes : "1,2,3,4,5");
        String invoiceStatus = StdConfig.get((String)"invoicecloud.invoiceStatus");
        param.put("invoiceStatus", invoiceStatus != null ? invoiceStatus : "0,1,2,3,4");
        ArrayList<InvoiceVO> invoiceVOs = new ArrayList<InvoiceVO>();
        APIHelper.invDownload(param, invoiceVOs);
        if (!invoiceVOs.isEmpty()) {
            Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
            InvoiceResolveParam resolveParam = new InvoiceResolveParam();
            resolveParam.setOrgId(org.getLong("id")).setBizType(bizType);
            List<DynamicObject> downloadInv = resolveService.genInvoice(resolveParam, invoiceVOs);
            if (downloadInv.size() == 0) {
                logger.info("\u60a8\u9700\u8981\u7684\u53d1\u7968\u6570\u636e\u5df2\u7ecf\u4e0b\u8f7d!");
            } else {
                logger.info("\u6210\u529f\u4e0b\u8f7d\u53d1\u7968 " + downloadInv.size() + " \u5f20!");
            }
        } else {
            logger.info("\u6ca1\u6709\u60a8\u9700\u8981\u7684\u53d1\u7968\u6570\u636e!");
        }
    }

    public static void executeTask() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId("InvoiceDownloadTask");
        jobInfo.setName(ResManager.loadKDString((String)"\u6536\u7968\u5355\u4e0b\u8f7d\u5b9a\u65f6\u4efb\u52a1", (String)"InvoiceDownloadTask_0", (String)"fi-ap-business", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(InvoiceDownloadTask.class.getName());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("biztype", "PUR");
        params.put("salerTaxNo", "");
        jobInfo.setParams(params);
        JobClient.dispatch((JobInfo)jobInfo);
    }
}

