/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.task;

import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class OpLogCleanTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AbstractTask.class);
    private static final String OP_LOG_ENTITY = "ap_oplog";
    private static final String DAYS = "days";

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        LOGGER.info("--begin execute clean task--");
        int days = Integer.parseInt((String)arg1.get(DAYS));
        Instant endTime = Instant.now().minus(Duration.ofDays(days));
        QFilter endTimeFilter = new QFilter("optime", "<=", (Object)Date.from(endTime));
        QFilter[] filters = new QFilter[]{endTimeFilter};
        int deletedRows = DeleteServiceHelper.delete((String)OP_LOG_ENTITY, (QFilter[])filters);
        LOGGER.info(MessageFormat.format("--end execute clean task,deleted rows : {0}:--", deletedRows));
        int deletedApRpaLogRows = DeleteServiceHelper.delete((String)"ap_rpa_settlelog", (QFilter[])new QFilter[]{new QFilter("starttime", "<=", (Object)Date.from(endTime))});
        LOGGER.info(MessageFormat.format("--end execute clean deletedApRpaLogRows,deleted rows : {0}:--", deletedApRpaLogRows));
        int deletedArRpaLogRows = DeleteServiceHelper.delete((String)"ar_rpa_settlelog", (QFilter[])new QFilter[]{new QFilter("starttime", "<=", (Object)Date.from(endTime))});
        LOGGER.info(MessageFormat.format("--end execute clean deletedArRpaLogRows,deleted rows : {0}:--", deletedArRpaLogRows));
    }
}

