/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.task;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.util.StdConfig;

public class UpdateInvCloudTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpdateInvCloudTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String isSynchInvoiceCloud = StdConfig.get((String)"isSynchInvoiceCloud");
        if ("false".equalsIgnoreCase(isSynchInvoiceCloud)) {
            return;
        }
        QFilter qFilter = new QFilter("synstatus", "=", (Object)"waitsynchro");
        qFilter.and(new QFilter("serialno", "not in", Arrays.asList(" ", "")));
        Object days = map.get("days");
        Instant endTime = null;
        if (days == null) {
            endTime = Instant.now().minus(Duration.ofDays(7L));
        } else {
            int limitDays = Integer.parseInt((String)map.get("days"));
            endTime = Instant.now().minus(Duration.ofDays(limitDays));
        }
        qFilter.and(new QFilter("receivedate", ">=", (Object)Date.from(endTime)));
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object)invoices)) {
            return;
        }
        Object[] invoiceIds = (Long[])invoices.stream().map(invoice -> invoice.getLong("id")).toArray(Long[]::new);
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"synchrocloud", (String)"ap_invoice", (Object[])invoiceIds, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            LOGGER.info("UpdateInvCloudTask execute fail , message is \uff1a" + operationResult.getMessage());
        }
        LOGGER.info("UpdateInvCloudTask execute : UpdateInvCloudTask is over ");
    }
}

