/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.business.tolerance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.ap.business.tolerance.FormulaUtil;
import kd.fi.ap.business.tolerance.SourcebillInfoEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class ToleranceQueryUtil {
    public static DynamicObject[] queryToleranceSchemes() {
        DynamicObjectCollection toleranceAssigns = QueryServiceHelper.query((String)"ap_tolerance_assign", (String)"id,schemepk", null);
        Set schemepks = toleranceAssigns.stream().map(assign -> assign.getString("schemepk")).collect(Collectors.toSet());
        String selectFields = " controlpoint,controlmode,entryentity,  e_tolerancelimit, e_upperlimit, e_lowerlimit,  e_tolerancestrategy,e_conditiondesc,e_message";
        QFilter[] filters = new QFilter[]{new QFilter("status", "in", (Object)"C"), new QFilter("enable", "=", (Object)"1"), new QFilter("id", "in", schemepks)};
        DynamicObject[] toleranceSchemes = BusinessDataServiceHelper.load((String)"ap_tolerance_scheme", (String)selectFields, (QFilter[])filters, (String)"controlmode");
        return toleranceSchemes;
    }

    public static Map<String, BigDecimal> querySourceBills(ExtendedDataEntity[] datas, DynamicObject[] toleranceSchemes) {
        List<Map<String, List<String>>> allFieldsFromSchemes = ToleranceQueryUtil.getAllFieldsFromSchemes(toleranceSchemes);
        if (allFieldsFromSchemes.size() < 1) {
            return new HashMap<String, BigDecimal>();
        }
        Map<Object, Object> findSourceBills = new HashMap();
        findSourceBills = ToleranceQueryUtil.handleSingleNoSave(datas);
        if (findSourceBills.isEmpty()) {
            List<Long> billIdList = Arrays.stream(datas).map(data -> data.getDataEntity().getLong("id")).collect(Collectors.toList());
            Long[] billIds = billIdList.toArray(new Long[0]);
            String entityNumber = datas[0].getDataEntity().getDataEntityType().getName();
            findSourceBills = BOTPHelper.findSourceBills((String)entityNumber, (Long[])billIds);
            findSourceBills = ToleranceQueryUtil.handleCoreBill(datas, findSourceBills);
        }
        HashMap<String, BigDecimal> billMaps = new HashMap<String, BigDecimal>();
        for (Map.Entry<Object, Object> entry : findSourceBills.entrySet()) {
            String key;
            int i;
            String entityName = (String)entry.getKey();
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", entry.getValue())};
            if (allFieldsFromSchemes.get(0).size() > 0 && allFieldsFromSchemes.get(0).get(entityName) != null) {
                List headFields = allFieldsFromSchemes.get(0).get(entityName).stream().distinct().collect(Collectors.toList());
                headFields.add("id");
                DynamicObjectCollection head_sourceBills = QueryServiceHelper.query((String)entityName, (String)StringUtils.join(headFields, (String)","), (QFilter[])filters);
                for (DynamicObject head_sourceBill : head_sourceBills) {
                    for (i = 0; i < headFields.size() - 1; ++i) {
                        key = head_sourceBill.getString(headFields.size() - 1) + (String)headFields.get(i);
                        if (head_sourceBill.getBigDecimal((String)headFields.get(i)).compareTo(BigDecimal.ZERO) == 0) continue;
                        billMaps.put(key, head_sourceBill.getBigDecimal((String)headFields.get(i)));
                    }
                }
            }
            if (allFieldsFromSchemes.get(1).size() <= 0 || allFieldsFromSchemes.get(1).get(entityName) == null) continue;
            List entryFields = allFieldsFromSchemes.get(1).get(entityName).stream().distinct().collect(Collectors.toList());
            DynamicObjectCollection entry_sourceBills = QueryServiceHelper.query((String)entityName, (String)StringUtils.join(entryFields, (String)","), (QFilter[])filters);
            for (DynamicObject entry_sourceBill : entry_sourceBills) {
                for (i = 1; i < entryFields.size(); ++i) {
                    key = entry_sourceBill.getString(0) + (String)entryFields.get(i);
                    billMaps.put(key, entry_sourceBill.getBigDecimal((String)entryFields.get(i)));
                }
            }
        }
        return billMaps;
    }

    private static Map<String, HashSet<Long>> handleCoreBill(ExtendedDataEntity[] datas, Map<String, HashSet<Long>> findSourceBills) {
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection details = bill.getDynamicObjectCollection(SourcebillInfoEnum.valueOf(bill.getDataEntityType().getName()).getDetailentry());
            for (DynamicObject detail : details) {
                String billtype = detail.getString(SourcebillInfoEnum.valueOf(bill.getDataEntityType().getName()).getCorebilltype());
                Long billid = detail.getLong(SourcebillInfoEnum.valueOf(bill.getDataEntityType().getName()).getCorebillid());
                if (EmptyUtils.isEmpty((Object)billtype) || EmptyUtils.isEmpty((Object)billid)) continue;
                if (!findSourceBills.containsKey(billtype)) {
                    findSourceBills.put(billtype, new HashSet(1));
                }
                if (findSourceBills.get(billtype).contains(billid)) continue;
                findSourceBills.get(billtype).add(billid);
            }
        }
        return findSourceBills;
    }

    private static Map<String, HashSet<Long>> handleSingleNoSave(ExtendedDataEntity[] datas) {
        Long billPk;
        Map<String, HashSet<Long>> findSourceBills = new HashMap<String, HashSet<Long>>();
        if (datas.length == 1 && (billPk = Long.valueOf(datas[0].getDataEntity().getLong("id"))) == 0L) {
            DynamicObject[] dynObjs = new DynamicObject[]{datas[0].getDataEntity()};
            MainEntityType dataEntityType = (MainEntityType)datas[0].getDataEntity().getDataEntityType();
            String entityNumber = datas[0].getDataEntity().getDataEntityType().getName();
            ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
            dataEntitySet.Parse(dynObjs, dataEntityType);
            LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
            List items = linkSet.getItems();
            ConvertDataService reader = new ConvertDataService();
            for (LinkSetItemElement itemElement : items) {
                String key = itemElement.getLinkEntityKey();
                ExtendedDataEntity[] linkRows = dataEntitySet.FindByEntityKey(key);
                if (linkRows == null || linkRows.length <= 0) continue;
                for (ExtendedDataEntity linkRow : linkRows) {
                    Long sbillid = (Long)linkRow.getValue(key + "_sbillid");
                    Long tableId = (Long)linkRow.getValue(key + "_stableid");
                    TableDefine tableDefine = reader.loadTableDefine(tableId);
                    String sentityNumber = tableDefine.getEntityNumber();
                    findSourceBills = BOTPHelper.findSourceBills((String)sentityNumber, (Long)sbillid);
                    HashSet<Long> sbillidSet = new HashSet<Long>();
                    sbillidSet.add(sbillid);
                    findSourceBills.put(sentityNumber, sbillidSet);
                }
            }
        }
        return findSourceBills;
    }

    public static Set<Long> queryBotpOfNoSaveBill(DynamicObject obj, String entryKey, Long[] entryIds) {
        HashSet<Long> sourceBillList = new HashSet<Long>();
        String entityNumber = obj.getDataEntityType().getName();
        ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
        dataEntitySet.Parse(new DynamicObject[]{obj}, (MainEntityType)obj.getDataEntityType());
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
        List items = linkSet.getItems();
        for (LinkSetItemElement itemElement : items) {
            String key = itemElement.getLinkEntityKey();
            ExtendedDataEntity[] linkRows = dataEntitySet.FindByEntityKey(key);
            if (linkRows == null) continue;
            for (ExtendedDataEntity linkRow : linkRows) {
                Long sbillid = (Long)linkRow.getValue(key + "_sbillid");
                Long sid = (Long)linkRow.getValue(key + "_sid");
                sourceBillList.add(sid);
                sourceBillList.add(sbillid);
            }
        }
        return sourceBillList;
    }

    public static Set<Long> loadSourceRowIds(String controlParty, String entryTypeName, Long[] entryIds) {
        List bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)controlParty, (String)entryTypeName, (Long[])entryIds);
        HashSet<Long> sourceRowIds = new HashSet<Long>();
        List<Long> entryIdList = Arrays.asList(entryIds);
        for (BFRow bfRow : bfRows) {
            BFRowId id = bfRow.getId();
            BFRowId sid = bfRow.getSId();
            Long entryId = id.getEntryId();
            Long sentryId = sid.getEntryId();
            if (!entryIdList.contains(entryId)) {
                sourceRowIds.add(entryId);
            }
            if (entryIdList.contains(sentryId)) continue;
            sourceRowIds.add(sentryId);
        }
        return sourceRowIds;
    }

    public static Map<Long, HashSet<Long>> loadSourceRowId(String controlParty, String entryTypeName, Long[] entryIds) {
        List bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)controlParty, (String)entryTypeName, (Long[])entryIds);
        HashMap<Long, HashSet<Long>> idToSidMap = new HashMap<Long, HashSet<Long>>();
        List<Long> entryIdList = Arrays.asList(entryIds);
        for (BFRow bfRow : bfRows) {
            HashSet<Long> sidSet = new HashSet<Long>();
            BFRowId id = bfRow.getId();
            BFRowId sid = bfRow.getSId();
            Long entryId = id.getEntryId();
            Long sentryId = sid.getEntryId();
            if (entryIdList.contains(entryId)) {
                sidSet.add(sentryId);
                idToSidMap.put(entryId, sidSet);
                continue;
            }
            Set entries = idToSidMap.entrySet();
            for (Map.Entry entry : entries) {
                if (!((HashSet)entry.getValue()).contains(entryId)) continue;
                ((HashSet)idToSidMap.get(entry.getKey())).add(sentryId);
            }
        }
        return idToSidMap;
    }

    private static List<Map<String, List<String>>> getAllFieldsFromSchemes(DynamicObject[] toleranceSchemes) {
        ArrayList<Map<String, List<String>>> allFields = new ArrayList<Map<String, List<String>>>();
        HashMap<String, List<String>> headMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> entryMap = new HashMap<String, List<String>>();
        for (DynamicObject toleranceScheme : toleranceSchemes) {
            DynamicObjectCollection schemeDetails = toleranceScheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject schemeDetail : schemeDetails) {
                DynamicObject toleranceStrategy = schemeDetail.getDynamicObject("e_tolerancestrategy");
                DynamicObjectCollection strategyDetails = toleranceStrategy.getDynamicObjectCollection("strategyentry");
                for (DynamicObject strategyDetail : strategyDetails) {
                    List preFields;
                    String oppositeParty = strategyDetail.getDynamicObject("e_oppositeparty").getString("id");
                    String oppositeObjectDesc = strategyDetail.getString("e_oppositeobjectdesc");
                    String expression = FormulaUtil.getExpression(oppositeObjectDesc);
                    List<String> fields = FormulaUtil.getFields(expression);
                    if (FormulaUtil.isHead(oppositeParty, oppositeObjectDesc).booleanValue()) {
                        preFields = (List)headMap.get(oppositeParty);
                        if (preFields != null) {
                            preFields.addAll(fields);
                            continue;
                        }
                        headMap.put(oppositeParty, fields);
                        continue;
                    }
                    fields = ToleranceQueryUtil.matchEntryFileds(oppositeParty, fields);
                    preFields = (List)entryMap.get(oppositeParty);
                    if (preFields != null) {
                        preFields.addAll(fields);
                        continue;
                    }
                    entryMap.put(oppositeParty, fields);
                }
            }
        }
        allFields.add(headMap);
        allFields.add(entryMap);
        return allFields;
    }

    public static List<String> matchEntryFileds(String entityType, List<String> fields) {
        ArrayList<String> matchFields = new ArrayList<String>(fields.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        Map allFields = dataEntityType.getAllFields();
        for (String field : fields) {
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(field);
            if (property == null) continue;
            String name = property.getParent().getName();
            field = name.concat(".").concat(field);
            if (!matchFields.contains(name)) {
                matchFields.add(name);
            }
            if (matchFields.contains(field)) continue;
            matchFields.add(field);
        }
        return matchFields;
    }

    public static Map<String, BigDecimal> queryBills(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            String typeName = bill.getDataEntityType().getName();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)typeName);
            Set entitySet = dataEntityType.getAllEntities().keySet();
            for (String entity : entitySet) {
                if (entity.equals(typeName)) continue;
                DynamicObjectCollection collection = bill.getDynamicObjectCollection(entity);
                for (DynamicObject detail : collection) {
                    detail.getString("id");
                }
            }
        }
        return null;
    }
}

