/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class ApAbstractImport
implements IImportPlugin {
    protected Map<String, Object> data = null;
    protected String importtype = null;
    protected Map<String, Map<String, DynamicObject>> cachedF7 = new HashMap<String, Map<String, DynamicObject>>();
    protected long orgId = 0L;
    protected InitHelper init;
    protected long baseCurrencyId = 0L;
    protected int baseCurrencyPrecision = 2;

    public void init(Map<String, Object> arg0) {
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        this.data = data;
        this.importtype = (String)option.get("importtype");
        return super.beforeImportData(data, option, importlogs);
    }

    protected void checkOrg() {
        JSONObject value = (JSONObject)this.data.get("org");
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u5e94\u4ed8\u7ec4\u7ec7\u3002", (String)"ApAbstractImport_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        Optional<DynamicObject> orgOptional = this.getDynamicObjectByNumberOrName("bos_org", value, "id,number,name");
        if (!orgOptional.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"ApAbstractImport_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        value.put("number", (Object)orgOptional.get().getString("number"));
        String number = (String)value.get((Object)"number");
        this.orgId = this.cachedF7.get("bos_org").get(number).getLong("id");
        this.init = new InitHelper(this.orgId, "ap_init");
        if (this.init == null || this.init.getStartDate() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u5c1a\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ApAbstractImport_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        if (this.init.isFinishInit()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ApAbstractImport_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        DynamicObject baseCurrency = this.init.getStandardCurrency();
        this.baseCurrencyId = baseCurrency.getLong("id");
        this.baseCurrencyPrecision = baseCurrency.getInt("amtprecision");
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected void checkOrgNew() {
        JSONObject value = (JSONObject)this.data.get("org");
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u5e94\u4ed8\u7ec4\u7ec7\u3002", (String)"ApAbstractImport_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        Optional<DynamicObject> orgOptional = this.getDynamicObjectByNumberOrName("bos_org", value, "id,number,name");
        if (!orgOptional.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"ApAbstractImport_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        String number = orgOptional.get().getString("number");
        value.put("number", (Object)number);
        this.orgId = this.cachedF7.get("bos_org").get(number).getLong("id");
        this.init = new InitHelper(this.orgId, "ap_init");
        if (this.init == null || this.init.getStartDate() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u5c1a\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ApAbstractImport_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        DynamicObject baseCurrency = this.init.getStandardCurrency();
        this.baseCurrencyId = baseCurrency.getLong("id");
        this.baseCurrencyPrecision = baseCurrency.getInt("amtprecision");
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected String isMaterial() {
        String isMaterial = null;
        JSONObject billtype = (JSONObject)this.data.get("billtype");
        if (billtype != null) {
            Optional<DynamicObject> billTypeOptional = this.getDynamicObjectByNumberOrName("bos_billtype", billtype, "id,number,fieldcontrolentry.fieldkey,fieldcontrolentry.mustinput");
            if (!billTypeOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"ApAbstractImport_17", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            billtype.put("number", (Object)billTypeOptional.get().getString("number"));
            DynamicObjectCollection fieldcontrolentry = billTypeOptional.get().getDynamicObjectCollection("fieldcontrolentry");
            for (DynamicObject fieldcontrol : fieldcontrolentry) {
                String fieldkey = fieldcontrol.getString("fieldkey");
                if (("material".equals(fieldkey) || "e_material".equals(fieldkey)) && fieldcontrol.getBoolean("mustinput")) {
                    isMaterial = "true";
                    break;
                }
                if (!"expenseitem".equals(fieldkey) && !"e_expenseitem".equals(fieldkey) || !fieldcontrol.getBoolean("mustinput")) continue;
                isMaterial = "false";
                break;
            }
        }
        return isMaterial;
    }

    protected Optional<DynamicObject> getDynamicObjectByNumberOrName(String entityName, JSONObject data, String parameters) {
        String number = data.getString("number");
        String name = data.getString("name");
        QFilter filters = null;
        if (!EmptyUtils.isEmpty((Object)name)) {
            filters = new QFilter("name", "=", (Object)name);
        }
        if (!EmptyUtils.isEmpty((Object)number)) {
            if (filters == null) {
                filters = new QFilter("number", "=", (Object)number);
            } else {
                filters.and("number", "=", (Object)number);
            }
        }
        if (filters == null) {
            return Optional.empty();
        }
        return this.getDynamicObject(entityName, filters.toArray(), parameters);
    }

    protected Optional<DynamicObject> getDynamicObject(String entityName, QFilter[] filters, String parameters) {
        DynamicObject obj;
        for (QFilter filter : filters) {
            Optional<DynamicObject> cacheResult;
            if (!"number".equals(filter.getProperty()) || !(cacheResult = this.getDynamicObjectFromCache(entityName, filter.getValue().toString())).isPresent()) continue;
            return cacheResult;
        }
        Map<String, DynamicObject> entityCache = this.cachedF7.get(entityName);
        if (entityCache == null) {
            entityCache = new HashMap<String, DynamicObject>();
            this.cachedF7.put(entityName, entityCache);
        }
        if ((obj = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)parameters, (QFilter[])filters)) != null) {
            entityCache.put(obj.getString("number"), obj);
        }
        return Optional.ofNullable(obj);
    }

    private Optional<DynamicObject> getDynamicObjectFromCache(String entityName, String number) {
        if (EmptyUtils.isEmpty((Object)number)) {
            return Optional.empty();
        }
        DynamicObject result = null;
        if (this.cachedF7.get(entityName) != null) {
            result = this.cachedF7.get(entityName).get(number);
        }
        return Optional.ofNullable(result);
    }

    protected BigDecimal parseBigDecimal(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    protected boolean checkLength(String value, int length) {
        return value.length() > length;
    }

    protected void checkNull(String key, String title) {
        Object value = this.data.get(key);
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ApAbstractImport_4", (String)"fi-ap-formplugin", (Object[])new Object[]{title}));
        }
    }

    protected void checkDate(String key, String title, boolean required, Date min, Date max, Date defaultValue) throws ParseException {
        String strValue = (String)this.data.get("bizdate");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date value = df.parse(strValue);
        if (required && value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ApAbstractImport_4", (String)"fi-ap-formplugin", (Object[])new Object[]{title}));
        }
        if (min != null && value.compareTo(min) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5e94\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f%2$s\u3002", (String)"ApAbstractImport_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), title, df.format(min)));
        }
        if (max != null && value.compareTo(max) >= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u542f\u7528\u65e5\u671f%2$s\u3002", (String)"ApAbstractImport_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), title, df.format(max)));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    protected void checkEnum(String key, String title, boolean required, String[] enums, String defaultValue) {
        String value = (String)this.data.get(key);
        if (required && value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ApAbstractImport_4", (String)"fi-ap-formplugin", (Object[])new Object[]{title}));
        }
        if (value != null) {
            boolean hit = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!value.equals(enums[i])) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u8f93\u5165\u503c\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ApAbstractImport_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), title, value));
            }
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    protected void checkF7(String key, String title, boolean required, String defaultValue) {
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ApAbstractImport_4", (String)"fi-ap-formplugin", (Object[])new Object[]{title}));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        }
    }

    protected void checkText(String key, String title, boolean required, int length, String defaultValue) {
        String value = (String)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ApAbstractImport_4", (String)"fi-ap-formplugin", (Object[])new Object[]{title}));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
            return;
        }
        if (value != null && value.length() > length) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u5b57\u7b26\u6570\u5927\u4e8e\u6700\u5927\u957f\u5ea6%2$s\u3002", (String)"ApAbstractImport_9", (String)"fi-ap-formplugin", (Object[])new Object[0]), title, length));
        }
    }

    protected void checkEntryNull(String key, String title, JSONObject entry, int seq) {
        Object value = entry.get((Object)key);
        if (value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff1a\u8bf7\u8865\u5145%2$s\u3002", (String)"ApAbstractImport_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
    }

    protected void checkEntryEnum(String key, String title, JSONObject entry, int seq, boolean required, String[] enums, String defaultValue) {
        String value = (String)entry.get((Object)key);
        if (required && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff1a\u8bf7\u8865\u5145%2$s\u3002", (String)"ApAbstractImport_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
        if (value != null) {
            boolean hit = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!value.equals(enums[i])) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff1a%2$s\u7684\u8f93\u5165\u503c\u201c%3$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ApAbstractImport_11", (String)"fi-ap-formplugin", (Object[])new Object[0]), seq + 1, title, value));
            }
        }
        if (value == null && defaultValue != null) {
            entry.put(key, (Object)defaultValue);
        }
        if ("NULL".equals(entry.getString(key))) {
            entry.remove((Object)"discountrate");
        }
    }

    protected void checkEntryF7(String key, String title, JSONObject entry, int seq, boolean required, String defaultValue) {
        JSONObject value = (JSONObject)entry.get((Object)key);
        if (required && value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"ApAbstractImport_4", (String)"fi-ap-formplugin", (Object[])new Object[]{title}));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            entry.put(key, (Object)value);
        }
    }

    protected BigDecimal getEntryBigDecimal(JSONObject row, String key) {
        Object value = row.get((Object)key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    protected BigDecimal getBigDecimal(String key) {
        Object value = this.data.get(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    protected void checkEntryNullOrZero(String key, String title, JSONObject entry, int seq) {
        BigDecimal value = this.getEntryBigDecimal(entry, key);
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff1a\u8bf7\u8865\u5145%2$s\u3002", (String)"ApAbstractImport_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), seq + 1, title));
        }
    }

    protected boolean ispresent(JSONObject row, String ispresentField) {
        boolean ispresent = false;
        if (row.get((Object)ispresentField) != null) {
            ispresent = (Boolean)row.get((Object)ispresentField);
        }
        return ispresent;
    }

    protected DynamicObject getTaxRateByNameOrNumber(String name, String number) {
        QFilter[] filters = this.getQFilter("bd_taxrate", name, number);
        Optional<DynamicObject> taxRateOptional = this.getDynamicObjectFromDb("bd_taxrate", "id,taxrate", filters);
        return taxRateOptional.orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7a0e\u7387\u4fe1\u606f\u3002", (String)"ApAbstractImport_18", (String)"fi-ar-formplugin", (Object[])new Object[0])));
    }

    protected QFilter[] getQFilter(String entityName, String name, String number) {
        String numberName;
        QFilter filters = null;
        String string = numberName = "bd_operator".equals(entityName) ? "operatornumber" : "number";
        if (!EmptyUtils.isEmpty((Object)number)) {
            filters = new QFilter(numberName, "=", (Object)number);
        }
        if (!EmptyUtils.isEmpty((Object)name)) {
            QFilter nameFilter = new QFilter("name", "=", (Object)name);
            if (filters == null) {
                return nameFilter.toArray();
            }
            filters.and(nameFilter);
        }
        if (filters == null) {
            return new QFilter[0];
        }
        return filters.toArray();
    }

    protected Optional<DynamicObject> getDynamicObjectFromDb(String entityName, String properties, QFilter[] filters) {
        if (filters.length == 0) {
            return Optional.empty();
        }
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)properties, (QFilter[])filters);
        return Optional.ofNullable(result);
    }
}

