/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.init.ApInitHelper;
import kd.fi.ap.business.init.info.InitAmtPair;
import kd.fi.ap.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.FilterColumnHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.init.InitServiceHelper;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.vo.FilterColumnSetting;
import org.apache.commons.lang.StringUtils;

public class ApInitEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String adjExchCallBack = "adjExchCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        boolean isInit = (Boolean)this.getModel().getValue("isfinishinit");
        if (!isInit) {
            this.calcAsstactDetail();
        }
    }

    private void calcAsstactDetail() {
        IDataModel model = this.getModel();
        long orgPk = (Long)((DynamicObject)model.getValue("org")).getPkValue();
        List initEntryList = ApInitHelper.getInitEntryList((long)orgPk);
        if (initEntryList != null && !initEntryList.isEmpty()) {
            AbstractFormDataModel formDataModel = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = this.getEntryGridSetter();
            ArrayList<Object> rowObj = null;
            for (InitEntryInfo info : initEntryList) {
                rowObj = new ArrayList<Object>(vs.getFields().size());
                MergeKey mergeKey = info.getMergeKey();
                rowObj.add(mergeKey.getAsstActType());
                rowObj.add(mergeKey.getAsst());
                rowObj.add(mergeKey.getCurrency());
                InitAmtPair pair = (InitAmtPair)info.getAmtPair();
                rowObj.add(pair.getBizAmt());
                rowObj.add(pair.getFinAmt());
                rowObj.add(pair.getPaidAmt());
                BigDecimal finAmt = ObjectUtils.isEmpty((Object)pair.getFinAmt()) ? BigDecimal.ZERO : pair.getFinAmt();
                BigDecimal bizAmt = ObjectUtils.isEmpty((Object)pair.getBizAmt()) ? BigDecimal.ZERO : pair.getBizAmt();
                BigDecimal paidAmt = ObjectUtils.isEmpty((Object)pair.getPaidAmt()) ? BigDecimal.ZERO : pair.getPaidAmt();
                rowObj.add(finAmt.add(bizAmt).subtract(paidAmt));
                vs.addRow(rowObj.toArray());
            }
            formDataModel.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("submit".equals(operateKey)) {
            IDataModel m = this.getModel();
            m.deleteEntryData("entryentity");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult opResult = args.getOperationResult();
        String operateKey = op.getOperateKey().toLowerCase(Locale.ENGLISH);
        if ("submit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("reconciliation".equals(operateKey) && opResult.isSuccess()) {
            InitServiceHelper.reconciliation((boolean)false, (IFormView)this.getView(), null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int iRow = evt.getRowIndex();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String asstacttype = (String)this.getModel().getValue("asstacttype", iRow);
        Object asstactPk = ((DynamicObject)this.getModel().getValue("asstact", iRow)).getPkValue();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", iRow);
        String fieldName = evt.getFieldName();
        String entityKey = null;
        if ("invoiceamount".equals(fieldName)) {
            entityKey = "ap_finapbill";
        } else if ("businessamount".equals(fieldName)) {
            entityKey = "ap_busbill";
        } else if ("paymentamount".equals(fieldName)) {
            entityKey = "ap_paidbill";
        }
        if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)entityKey, (String)"47150e89000000ac")) {
            String entityName = MetadataServiceHelper.getDataEntityType((String)entityKey).getDisplayName().getLocaleValue();
            String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ApInitEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
            this.getView().showErrorNotification(message);
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(entityKey);
        ListFilterParameter lfp = new ListFilterParameter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", org.getPkValue()));
        filters.add(new QFilter("currency", "=", currency.getPkValue()));
        QFilter qf = new QFilter("masterid", "=", asstactPk);
        DynamicObjectCollection customers = QueryServiceHelper.query((String)asstacttype, (String)"id", (QFilter[])new QFilter[]{qf});
        if (!"ap_paidbill".equals(entityKey)) {
            filters.add(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
            if (!ObjectUtils.isEmpty((Object)customers)) {
                filters.add(new QFilter("asstact", "in", (Object)ArApHelper.getPks((Object)customers)));
            } else {
                filters.add(new QFilter("asstact", "=", asstactPk));
            }
        } else if (!ObjectUtils.isEmpty((Object)customers)) {
            filters.add(new QFilter("payee", "in", (Object)ArApHelper.getPks((Object)customers)));
        } else {
            filters.add(new QFilter("payee", "=", asstactPk));
        }
        lfp.setQFilters(filters);
        lsp.setListFilterParameter(lfp);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("commonfiltercolumns", FilterColumnHelper.toMap(this.setCommonFilterSetting(entityKey, filters, asstacttype, asstactPk)));
        HashMap<String, Boolean> summarySettingInfo = new HashMap<String, Boolean>();
        summarySettingInfo.put("pricetaxtotal", Boolean.TRUE);
        customParams.put("summarysetting", summarySettingInfo);
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        customParams.put("isPeriod", "true");
        lsp.setCustomParams(customParams);
        if ("ap_busbill".equals(entityKey)) {
            lsp.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u4ed8\u5355", (String)"ApInitEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        } else if ("ap_finapbill".equals(entityKey)) {
            lsp.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"ApInitEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        ShowType showType = this.getView().getFormShowParameter().getFormConfig().getShowType();
        lsp.getOpenStyle().setTargetKey(this.getView().getFormShowParameter().getOpenStyle().getTargetKey());
        lsp.getOpenStyle().setShowType(showType);
        lsp.setAppId(this.getView().getFormShowParameter().getAppId());
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<FilterColumnSetting> setCommonFilterSetting(String entityKey, List<QFilter> filters, String asstacttype, Object asstactPk) {
        ArrayList<FilterColumnSetting> filterInfos = new ArrayList<FilterColumnSetting>();
        for (QFilter filter : filters) {
            FilterColumnSetting filterInfo;
            String property = filter.getProperty();
            if (!"org".equals(property) && !"currency".equals(property) && !"billstatus".equals(property) || (filterInfo = FilterColumnHelper.createCommonFilterSetting((QFilter)filter, (String)entityKey)) == null) continue;
            if ("org".equals(property)) {
                filterInfo.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ApInitEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            filterInfos.add(filterInfo);
        }
        FilterColumnSetting asstactFilterInfo = new FilterColumnSetting("basecurrency", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"ApInitEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        String defaultAsstactValue = String.valueOf(asstactPk);
        DynamicObject asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstactPk, (String)asstacttype, (String)"name");
        if (asstact == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u6237\u6570\u636e\u4e22\u5931\uff0cid=%1$s\uff0c\u5f80\u6765\u6237\u7c7b\u578b=%2$s", (String)"ApInitEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), defaultAsstactValue, asstacttype));
        }
        asstactFilterInfo.addComboItem(asstact.getString("name"), defaultAsstactValue);
        asstactFilterInfo.setDefaultValue(defaultAsstactValue);
        filterInfos.add(asstactFilterInfo);
        return filterInfos;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String bill = "";
        String title = "";
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (StringUtils.equals((String)"bar_ap_busbill", (String)evt.getItemKey())) {
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ap_busbill", (String)"47150e89000000ac")) {
                String entityName = MetadataServiceHelper.getDataEntityType((String)"ap_busbill").getDisplayName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ApInitEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
                this.getView().showErrorNotification(message);
                return;
            }
            bill = "ap_busbill";
            title = ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u4ed8\u5355", (String)"ApInitEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)"bar_ap_finapbill", (String)evt.getItemKey())) {
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ap_finapbill", (String)"47150e89000000ac")) {
                String entityName = MetadataServiceHelper.getDataEntityType((String)"ap_finapbill").getDisplayName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ApInitEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
                this.getView().showErrorNotification(message);
                return;
            }
            bill = "ap_finapbill";
            title = ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"ApInitEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)"bar_ap_paidbill", (String)evt.getItemKey())) {
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ap_paidbill", (String)"47150e89000000ac")) {
                String entityName = MetadataServiceHelper.getDataEntityType((String)"ap_paidbill").getDisplayName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ApInitEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
                this.getView().showErrorNotification(message);
                return;
            }
            bill = "ap_paidbill";
            title = ResManager.loadKDString((String)"\u671f\u521d\u9884\u4ed8\u5355", (String)"ApInitEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)"bar_ap_adjexchbill", (String)evt.getItemKey())) {
            bill = "ap_adjustexch";
            title = ResManager.loadKDString((String)"\u671f\u521d\u8c03\u6c47", (String)"ApInitEdit_8", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        } else {
            if (StringUtils.equals((String)"antiinit_btn", (String)evt.getItemKey())) {
                if (org != null) {
                    Boolean isAdj;
                    ArrayList<Long> orgIds = new ArrayList<Long>(8);
                    orgIds.add(org.getLong("id"));
                    Map result = InitHelper.checkDataVolume((boolean)false, (boolean)false, orgIds);
                    boolean isOver = (Boolean)result.get("isOver");
                    String message = null;
                    String confirmTitle = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u91cf\u8f83\u5927\uff0c\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u8f83\u957f\u3002\u672c\u6b21\u64cd\u4f5c\u5c06\u540e\u53f0\u6267\u884c\uff0c\u6267\u884c\u7ed3\u679c\u4f1a\u7ed9\u64cd\u4f5c\u7528\u6237\u53d1\u9001\u6d88\u606f\u901a\u77e5\u3002", (String)"ApInitEdit_12", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                    if (isOver) {
                        long finBillCount = Long.parseLong(result.get("ap_finapbill").toString());
                        long busBillCount = Long.parseLong(result.get("ap_busbill").toString());
                        long paidBillCount = Long.parseLong(result.get("ap_paidbill").toString());
                        String periodMsg = ResManager.loadKDString((String)"\u671f\u521d\u5355\u636e\u6570\u91cf\uff1a", (String)"ApInitEdit_16", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                        String messageFin = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\uff1a%s\u5f20\uff1b", (String)"ApInitEdit_13", (String)"fi-ap-formplugin", (Object[])new Object[]{finBillCount});
                        String messageBus = ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u5355\uff1a%s\u5f20\uff1b", (String)"ApInitEdit_14", (String)"fi-ap-formplugin", (Object[])new Object[]{busBillCount});
                        String messagePaid = ResManager.loadKDString((String)"\u671f\u521d\u9884\u4ed8\u5355\uff1a%s\u5f20\uff1b", (String)"ApInitEdit_15", (String)"fi-ap-formplugin", (Object[])new Object[]{paidBillCount});
                        message = periodMsg + messageFin + messageBus + messagePaid;
                    }
                    if ((isAdj = this.participateInAdjExch(org.getLong("id"))) != null && isAdj.booleanValue()) {
                        String adjMessage = ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u4f1a\u81ea\u52a8\u5220\u9664\u5df2\u8c03\u6c47\u7684\u671f\u521d\u8c03\u6c47\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApInitEdit_9", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                        message = message + "\n" + adjMessage;
                    }
                    if (message == null) {
                        InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ap_init", (String)"initinitialize", (String)"anticloseinit", (boolean)false, (IFormView)this.getView(), (boolean)false);
                    } else {
                        String callBackListenerName = isOver ? "adjExchCallBackOver" : adjExchCallBack;
                        this.getView().showConfirm(confirmTitle, message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(callBackListenerName));
                    }
                }
                return;
            }
            if (StringUtils.equals((String)"finishinit_btn", (String)evt.getItemKey())) {
                ArrayList<Long> orgIds = new ArrayList<Long>(8);
                if (org != null) {
                    orgIds.add(org.getLong("id"));
                    Map result = InitHelper.checkDataVolume((boolean)false, (boolean)true, orgIds);
                    boolean isOver = (Boolean)result.get("isOver");
                    if (isOver) {
                        long finBillCount = Long.parseLong(result.get("ap_finapbill").toString());
                        long busBillCount = Long.parseLong(result.get("ap_busbill").toString());
                        long paidBillCount = Long.parseLong(result.get("ap_paidbill").toString());
                        String confirmTitle = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u91cf\u8f83\u5927\uff0c\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u8f83\u957f\u3002\u672c\u6b21\u64cd\u4f5c\u5c06\u540e\u53f0\u6267\u884c\uff0c\u6267\u884c\u7ed3\u679c\u4f1a\u7ed9\u64cd\u4f5c\u7528\u6237\u53d1\u9001\u6d88\u606f\u901a\u77e5\u3002", (String)"ApInitEdit_12", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                        String periodMsg = ResManager.loadKDString((String)"\u671f\u521d\u5355\u636e\u6570\u91cf\uff1a", (String)"ApInitEdit_16", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                        String messageFin = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\uff1a%s\u5f20\uff1b", (String)"ApInitEdit_13", (String)"fi-ap-formplugin", (Object[])new Object[]{finBillCount});
                        String messageBus = ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u5355\uff1a%s\u5f20\uff1b", (String)"ApInitEdit_14", (String)"fi-ap-formplugin", (Object[])new Object[]{busBillCount});
                        String messagePaid = ResManager.loadKDString((String)"\u671f\u521d\u9884\u4ed8\u5355\uff1a%s\u5f20\uff1b", (String)"ApInitEdit_15", (String)"fi-ap-formplugin", (Object[])new Object[]{paidBillCount});
                        String message = periodMsg + messageFin + messageBus + messagePaid;
                        this.getView().showConfirm(confirmTitle, message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("submitCallBack"));
                    } else {
                        InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ap_init", (String)"initinitialize", (String)"submit", (boolean)true, (IFormView)this.getView(), (boolean)false);
                    }
                }
                return;
            }
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        lsp.setBillFormId(bill);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setCaption(title);
        customParams.put("isPeriod", "true");
        customParams.put("dateFilter", Boolean.TRUE);
        customParams.put("bizSystem", "AP");
        if (!ObjectUtils.isEmpty((Object)org)) {
            customParams.put("initOrg", org.getPkValue());
        }
        lsp.setCustomParams(customParams);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (isOK && Objects.equals(callBackID, adjExchCallBack)) {
            InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ap_init", (String)"initinitialize", (String)"anticloseinit", (boolean)false, (IFormView)this.getView(), (boolean)false);
            return;
        }
        if (isOK && Objects.equals(callBackID, "adjExchCallBackOver")) {
            InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ap_init", (String)"initinitialize", (String)"anticloseinit", (boolean)false, (IFormView)this.getView(), (boolean)true);
            return;
        }
        if (isOK && Objects.equals(callBackID, "submitCallBack")) {
            InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ap_init", (String)"initinitialize", (String)"submit", (boolean)true, (IFormView)this.getView(), (boolean)true);
        }
    }

    private TableValueSetter getEntryGridSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        EntryGrid mainGrid = (EntryGrid)this.getControl("entryentity");
        List fieldEdits = mainGrid.getFieldEdits();
        for (FieldEdit field : fieldEdits) {
            vs.addField(field.getKey(), new Object[0]);
        }
        return vs;
    }

    private Boolean participateInAdjExch(Long orgId) {
        AdjExchService adjExchService = new AdjExchService("ap");
        Boolean param = adjExchService.getIsParticipateInAdjExch(orgId);
        return param;
    }

    private Set<Long> getDataPk() {
        HashSet<Long> ids = new HashSet<Long>(8);
        Long id = (Long)this.getModel().getValue("id");
        ids.add(id);
        return ids;
    }
}

