/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ApInitList4Upgrade
extends AbstractListPlugin {
    private static String selector = "id, org, standardcurrency, exratetable, periodtype, startperiod, curperiod, startdate, currentdate, isfinishinit";

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        if ("upgrade".equals(key)) {
            this.upgrade();
        }
    }

    private void upgrade() {
        this.delNotExistOrg();
        this.doUpgrade();
    }

    private void delNotExistOrg() {
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", null);
        List orgPks = orgMap.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter qFilter = new QFilter("org", "not in", orgPks);
        Object[] inits = BusinessDataServiceHelper.load((String)"ap_init", (String)"id", (QFilter[])new QFilter[]{qFilter});
        Map initMap = BusinessDataServiceHelper.loadFromCache((String)"ap_init", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object[])inits)) {
            List pks = initMap.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ap_init"), (Object[])pks.toArray());
        }
    }

    private void doUpgrade() {
        QFilter filter = QFilter.isNull((String)"periodtype");
        filter.or(new QFilter("periodtype", "=", (Object)0));
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"ap_init", (String)selector, (QFilter[])new QFilter[]{filter}, (String)"isfinishinit");
        if (inits.length > 0) {
            ArrayList<DynamicObject> updateInits = new ArrayList<DynamicObject>();
            ArrayList<Object> delPks = new ArrayList<Object>();
            for (DynamicObject init : inits) {
                if (init.getBoolean("isfinishinit")) {
                    updateInits.add(this.setInit(init));
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)init.getDate("startdate"))) {
                    delPks.add(init.getPkValue());
                    continue;
                }
                updateInits.add(this.setInit(init));
            }
            if (!delPks.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ap_init"), (Object[])delPks.toArray());
            }
            if (!updateInits.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateInits.toArray(new DynamicObject[0]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"ApInitList4Upgrade_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            ((ListView)this.getView()).refresh();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"ApInitList4Upgrade_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject setInit(DynamicObject init) {
        Map bdPeriodTypeMap;
        DynamicObject periodtype = init.getDynamicObject("periodtype");
        if (periodtype == null && (periodtype = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bd_period_type")) == null && !ObjectUtils.isEmpty((Object)(bdPeriodTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period_type", (String)"id, number", null)))) {
            periodtype = bdPeriodTypeMap.values().toArray(new DynamicObject[0])[0];
        }
        if (!ObjectUtils.isEmpty((Object)periodtype)) {
            init.set("periodtype", (Object)periodtype);
            Date startdate = init.getDate("startdate");
            Date currentdate = init.getDate("currentdate");
            long pkValue = periodtype.getLong("id");
            DynamicObject periodByDate = this.getPeriodByDate(pkValue, startdate);
            if (periodByDate != null) {
                init.set("startperiod", (Object)periodByDate);
            }
            if (!ObjectUtils.isEmpty((Object)currentdate) && startdate.getTime() != currentdate.getTime()) {
                init.set("curperiod", (Object)this.getPeriodByDate(pkValue, currentdate));
            } else if (init.getBoolean("isfinishinit")) {
                init.set("curperiod", (Object)init.getDynamicObject("startperiod"));
            } else {
                init.set("curperiod", null);
            }
        }
        return init;
    }

    private DynamicObject getPeriodByDate(long periodTypeId, Date date) {
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }
}

