/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.vo.MatchSchemeExecuteTaskParam;

public class ApMatchSchemeEdit
extends AbstractBillPlugIn {
    public static final String APPLICABILITY = "applicability";
    public static final String APPLICABILITYDESC = "applicabilitydesc";
    public static final String EXCEPLAN = "exceplan";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{APPLICABILITY, APPLICABILITYDESC, EXCEPLAN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setMatchField();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (APPLICABILITYDESC.equals(key)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"ap_invoice");
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
            String fldNodes = SerializationUtils.toJsonString((Object)srcBillNode);
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl(APPLICABILITY);
            String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
            this.showConditionForm(conditionJson, mainType.getName(), false, fldNodes, key);
        } else if (EXCEPLAN.equals(key)) {
            this.showExcePlanPage();
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        model.setValue(APPLICABILITYDESC, model.getValue(APPLICABILITY));
        this.setMatchField();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid control;
        int[] selectRow;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        IDataModel model = this.getModel();
        if ("deleteentry".equals(key) && ((selectRow = (control = (EntryGrid)this.getControl("entry")).getSelectRows())[0] == 0 || selectRow[0] == 1 || selectRow[0] == 2)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e25\u683c\u5339\u914d\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApMatchSchemeEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (APPLICABILITYDESC.equals(actionId)) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            this.setFilterValueByReturnData(returnData, actionId, APPLICABILITY);
        } else if ("newshedule".equals(actionId)) {
            DynamicObject scheduleInfo = (DynamicObject)closedCallBackEvent.getReturnData();
            this.newScheduleCloseCallBack(scheduleInfo);
        }
    }

    private void setFilterValueByReturnData(String returnData, String actionId, String largeTextNumber) {
        LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl(largeTextNumber);
        this.receiveCondition(returnData, "", largeTextNumber, largeTextEdit.getTagFieldKey(), actionId);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String tagFidKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(tagFidKey, (Object)conditionJson);
                this.getModel().setValue(conditionFldKey, (Object)condition.getExprDesc());
                if (condition.getExprDesc().length() > 255) {
                    this.getModel().setValue(descFldKey, (Object)condition.getExprDesc().substring(0, 255));
                } else {
                    this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData;
        Object newValue;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (APPLICABILITYDESC.equals(key) && StringUtils.isBlank((Object)(newValue = (changeData = e.getChangeSet())[0].getNewValue()))) {
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl(APPLICABILITY);
            String tagFieldKey = largeTextEdit.getTagFieldKey();
            this.getModel().setValue(tagFieldKey, (Object)"");
            this.getModel().setValue(APPLICABILITY, (Object)"");
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("disable".equals(operateKey)) {
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"isforce", "matchfield", "mappingfield"});
            this.getView().setEnable(Boolean.FALSE, 1, new String[]{"isforce", "matchfield", "mappingfield"});
            this.getView().setEnable(Boolean.FALSE, 2, new String[]{"isforce", "matchfield", "mappingfield"});
        }
    }

    private void setMatchField() {
        IDataModel model = this.getModel();
        DynamicObject entryData = new DynamicObject(this.getModel().getEntryEntity("entry").getDynamicObjectType());
        if (ObjectUtils.isEmpty((Object)model.getEntryEntity("entry"))) {
            model.batchCreateNewEntryRow("entry", entryData, 5);
            model.setValue("matchfield", (Object)"org", 0);
            model.setValue("isforce", (Object)Boolean.FALSE, 0);
            model.setValue("ispreset", (Object)Boolean.TRUE, 0);
            model.setValue("mappingfield", (Object)"billentry.entrysettleorg", 0);
            model.setValue("matchfield", (Object)"receivablessupp", 1);
            model.setValue("isforce", (Object)Boolean.FALSE, 1);
            model.setValue("ispreset", (Object)Boolean.TRUE, 1);
            model.setValue("mappingfield", (Object)"supplier", 1);
            model.setValue("matchfield", (Object)"entry.material", 2);
            model.setValue("isforce", (Object)Boolean.FALSE, 2);
            model.setValue("ispreset", (Object)Boolean.TRUE, 2);
            model.setValue("mappingfield", (Object)"billentry.material", 2);
            model.setValue("matchfield", (Object)"entry.measureunit", 3);
            model.setValue("isforce", (Object)Boolean.FALSE, 3);
            model.setValue("ispreset", (Object)Boolean.TRUE, 3);
            model.setValue("mappingfield", (Object)"billentry.unit", 3);
            model.setValue("matchfield", (Object)"entry.taxrateid", 4);
            model.setValue("isforce", (Object)Boolean.FALSE, 4);
            model.setValue("ispreset", (Object)Boolean.TRUE, 4);
            model.setValue("mappingfield", (Object)"billentry.taxrateid", 4);
        }
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"isforce", "matchfield", "mappingfield"});
        this.getView().setEnable(Boolean.FALSE, 1, new String[]{"isforce", "matchfield", "mappingfield"});
        this.getView().setEnable(Boolean.FALSE, 2, new String[]{"isforce", "matchfield", "mappingfield"});
    }

    private void showExcePlanPage() {
        IBillModel billmodel = (IBillModel)this.getModel();
        long id = (Long)billmodel.getValue("id");
        if (StringUtils.isBlank((Object)id) || id == 0L) {
            String tableName = billmodel.getDataEntityType().getAlias();
            long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
            id = ids[0];
            billmodel.getDataEntity().set("id", (Object)id);
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sch_schedule");
        String scheduleId = (String)this.getView().getModel().getValue("sheduleplanid");
        if (scheduleId != null && scheduleId.trim().length() != 0) {
            parameter.setPkId((Object)scheduleId);
            parameter.setStatus(OperationStatus.EDIT);
        } else {
            parameter.setStatus(OperationStatus.ADDNEW);
            MatchSchemeExecuteTaskParam param = new MatchSchemeExecuteTaskParam(Collections.singletonList(id), "ap");
            parameter.setCustomParam("paramjsonstr", (Object)SerializationUtils.toJsonString((Object)param));
            parameter.setCustomParam("taskclassname", (Object)"kd.fi.arapcommon.task.MatchSchemeExecuteTask");
            parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5339\u914d\u65b9\u6848\u6267\u884c\u8ba1\u5212", (String)"ApMatchSchemeEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("tasknumber", (Object)("ap_matchexec" + System.currentTimeMillis()));
            DynamicObject executor = (DynamicObject)billmodel.getValue("executor");
            if (executor != null) {
                parameter.setCustomParam("executor", executor.get("id"));
            }
        }
        parameter.setCustomParam("taskappnumber", (Object)"ap");
        parameter.setCustomParam("taskdefineid", (Object)this.getExecClassName("ap"));
        parameter.setHasRight(true);
        parameter.setCustomParam("frombiz", (Object)"true");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newshedule"));
        StyleCss css1 = new StyleCss();
        css1.setWidth("1000");
        css1.setHeight("700");
        parameter.getOpenStyle().setInlineStyleCss(css1);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getExecClassName(String appId) {
        String taskdefineid;
        QFilter filter = new QFilter("classname", "=", (Object)"kd.fi.arapcommon.task.MatchSchemeExecuteTask");
        filter.and("appid", "=", (Object)appId);
        DynamicObject[] taskDefines = BusinessDataServiceHelper.load((String)"sch_taskdefine", (String)"id", (QFilter[])filter.toArray(), null);
        if (null != taskDefines && taskDefines.length > 0) {
            taskdefineid = taskDefines[0].getString("id");
        } else {
            DynamicObject taskDyn = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
            taskDyn.set("appid", (Object)appId);
            taskDyn.set("name", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5339\u914d\u65b9\u6848\u8c03\u5ea6\u4f5c\u4e1a", (String)"ApMatchSchemeEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            taskDyn.set("number", (Object)("ApMatxhSchemeExceTask-" + appId));
            taskDyn.set("classname", (Object)"kd.fi.arapcommon.task.MatchSchemeExecuteTask");
            DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDyn});
            taskdefineid = result[0].getString("id");
        }
        return taskdefineid;
    }

    private void newScheduleCloseCallBack(DynamicObject scheduleInfo) {
        if (scheduleInfo != null) {
            String planid = (String)scheduleInfo.get("id");
            this.getModel().setValue("sheduleplanid", (Object)planid);
            String txtdesc = (String)scheduleInfo.get("txtdesc");
            if (StringUtils.isNotEmpty((CharSequence)txtdesc) && txtdesc.length() > 153) {
                txtdesc = txtdesc.substring(0, 150) + "...";
            }
            this.getModel().setValue(EXCEPLAN, (Object)txtdesc);
        }
    }
}

