/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.PushAndSave;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.formplugin.ApBaseEdit;
import kd.fi.ap.formplugin.formservice.payapply.ApplyPayBillImportHelper;
import kd.fi.ap.helper.BaseDataHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;

public class ApplyPayBillEdit
extends ApBaseEdit {
    private ApplyPayBillImportHelper importHelper;
    private BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();
    private boolean isCopyEntryRow = false;
    private Map<String, Object> splitRowMap = new HashMap<String, Object>(16);
    private DynamicObject settlementType;

    private ApplyPayBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new ApplyPayBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_assacct"});
        this.addClickListeners(new String[]{"e_corebillno"});
        this.addClickListeners(new String[]{"sameinfo_view", "sameinfo_ignore", "refund_view", "refund_ignore"});
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap2"});
        this.filterMaterialVersion();
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        this.getImportHelper().afterImportData(e);
    }

    private void setCalculatorAmt(IBillModel m) {
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        DynamicObject destCurrency = (DynamicObject)m.getValue("settlecurrency");
        int localprecision = destCurrency.getInt("amtprecision");
        DynamicObjectCollection entry = m.getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            BigDecimal LocalApprovedAmt;
            BigDecimal localApplyAmount;
            BigDecimal e_applyAmount = (BigDecimal)m.getValue("e_applyamount", i);
            BigDecimal e_approvedAmt = (BigDecimal)m.getValue("e_approvedamt", i);
            if (e_approvedAmt.compareTo(BigDecimal.ZERO) == 0) {
                e_approvedAmt = e_applyAmount;
                m.setValue("e_approvedamt", (Object)e_applyAmount, i);
            }
            if ("1".equals(quotation)) {
                localApplyAmount = e_applyAmount.divide(exchangeRate, localprecision, RoundingMode.HALF_UP);
                LocalApprovedAmt = e_approvedAmt.divide(exchangeRate, localprecision, RoundingMode.HALF_UP);
            } else {
                localApplyAmount = e_applyAmount.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP);
                LocalApprovedAmt = e_approvedAmt.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP);
            }
            m.setValue("e_appseleamount", (Object)localApplyAmount, i);
            m.setValue("e_approvedseleamt", (Object)LocalApprovedAmt, i);
        }
    }

    private void setHeadAmt(IBillModel m) {
        DynamicObjectCollection entry = m.getEntryEntity("entry");
        BigDecimal applyamount = BigDecimal.ZERO;
        BigDecimal appseleamount = BigDecimal.ZERO;
        BigDecimal approvalamount = BigDecimal.ZERO;
        BigDecimal aprseleamount = BigDecimal.ZERO;
        for (int i = 0; i < entry.size(); ++i) {
            applyamount = applyamount.add((BigDecimal)this.getModel().getValue("e_applyamount", i));
            appseleamount = appseleamount.add((BigDecimal)this.getModel().getValue("e_appseleamount", i));
            approvalamount = approvalamount.add((BigDecimal)this.getModel().getValue("e_approvedamt", i));
            aprseleamount = aprseleamount.add((BigDecimal)this.getModel().getValue("e_approvedseleamt", i));
            Object settlementtype = this.getModel().getValue("e_settlementtype", i);
            if (!ObjectUtils.isEmpty((Object)settlementtype) || m.isFromImport()) continue;
            this.getModel().setValue("e_settlementtype", (Object)BaseDataHelper.getDefaultSettleType(), i);
        }
        this.getModel().setValue("applyamount", (Object)applyamount);
        this.getModel().setValue("appseleamount", (Object)appseleamount);
        this.getModel().setValue("approvalamount", (Object)approvalamount);
        this.getModel().setValue("aprseleamount", (Object)aprseleamount);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ap_payapply", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        } else if (Objects.equals(callBackID, "executeClose") && isOK) {
            OperateOption option = OperateOption.create();
            String customValue = e.getCustomVaule();
            if (!ObjectUtils.isEmpty((Object)customValue)) {
                option.setVariableValue("selectrows", customValue);
            }
            this.getView().invokeOperation("closepay", option);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid grid;
        String key;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (op instanceof Push || op instanceof PushAndSave) {
            Long pkValue = this.getModel().getDataEntity().getLong("id");
            HashSet<Long> billIds = new HashSet<Long>(1);
            billIds.add(pkValue);
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0025", null, (Object[])new Object[]{billIds});
        }
        if ("submit".equals(key = op.getOperateKey()) || "audit".equals(key)) {
            this.checkPayhold(key, args);
        }
        if ("push".equals(key)) {
            this.checkPayhold(args);
        }
        if ("copyentryrow".equals(key)) {
            grid = (EntryGrid)this.getControl("entry");
            int length = grid.getSelectRows().length;
            if (length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"ApplyPayBillEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        } else if ("splitentryrow".equals(key)) {
            grid = (EntryGrid)this.getControl("entry");
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u62c6\u5206\u3002", (String)"ApplyPayBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
            this.splitRowMap.put("e_corebilltype", this.getModel().getValue("e_corebilltype", selectRows[0]));
            this.splitRowMap.put("e_corebillno", this.getModel().getValue("e_corebillno", selectRows[0]));
            this.splitRowMap.put("e_corebillentryseq", this.getModel().getValue("e_corebillentryseq", selectRows[0]));
            this.splitRowMap.put("e_corebillid", this.getModel().getValue("e_corebillid", selectRows[0]));
            this.splitRowMap.put("e_corebillentryid", this.getModel().getValue("e_corebillentryid", selectRows[0]));
            this.splitRowMap.put("e_conbillentity", this.getModel().getValue("e_conbillentity", selectRows[0]));
            this.splitRowMap.put("e_conbillnumber", this.getModel().getValue("e_conbillnumber", selectRows[0]));
            this.splitRowMap.put("e_conbillrownum", this.getModel().getValue("e_conbillrownum", selectRows[0]));
            this.splitRowMap.put("e_conbillid", this.getModel().getValue("e_conbillid", selectRows[0]));
            this.splitRowMap.put("e_conbillentryid", this.getModel().getValue("e_conbillentryid", selectRows[0]));
        } else if ("closepay".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        if (model.isFromImport()) {
            return;
        }
        DynamicObject applyorg = (DynamicObject)this.getModel().getValue("applyorg");
        if (ObjectUtils.isEmpty((Object)applyorg) && !ObjectUtils.isEmpty((Object)(applyorg = OrgHelper.getAuthorizedBankOrg((String)"ap", (String)"ap_payapply", (String)"47156aff000000ac")))) {
            this.getModel().setValue("applyorg", (Object)applyorg.getLong("id"));
        }
        if (ObjectUtils.isEmpty((Object)applyorg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"ApplyPayBillEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setOrgByUser(applyorg);
        this.setCurrencyByApplyOrg();
        this.getModel().setValue("e_settlementtype", (Object)BaseDataHelper.getDefaultSettleType(), 0);
        if (!"true".equals(this.getPageCache().get("isWebApi"))) {
            this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String key = args.getOperateKey();
        this.fillToolBar();
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        if ("unclosepay".equals(args.getOperateKey()) && !operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        if ("submit".equals(args.getOperateKey()) || "save".equals(args.getOperateKey())) {
            Map<Object, List<DynamicObject>> entryFroupMap = this.getRefundWarnMap();
            if (entryFroupMap.size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"refundflex"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"refundflex"});
            }
        }
        Object billStatus = this.getModel().getValue("billstatus");
        if (("submit".equals(key) || "save".equals(key) || "refresh".equals(key) || "collectinvoice".equals(key)) && ("A".equals(billStatus) || "B".equals(billStatus))) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0024", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
        if ("updatevalidator".equals(key) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("pushupdate");
        }
        if (("closepay".equals(key) || "unclosePay".equalsIgnoreCase(key)) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (Objects.equals(key, "unaudit") && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void fillToolBar() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_del", "bar_save", "bar_submit", "bar_audit", "bar_submitandnew", "baritemap1", "bar_businesspro", "bar_more", "barmore"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"bar_new", "bar_del", "bar_save", "bar_submit", "bar_audit", "bar_submitandnew", "baritemap1", "bar_businesspro", "bar_more", "barmore", "bar_unaudit"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_new", "bar_del", "bar_save", "bar_submit", "bar_submitandnew", "bar_more", "barmore"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_apgeneratevoucher"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_new", "bar_submit", "bar_audit", "bar_more", "barmore"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_apgeneratevoucher"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue()) || billStatus.equals("E")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_new", "bar_audit", "baritemap1", "bar_businesspro", "bar_more", "barmore", "bar_apgeneratevoucher"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit"});
        } else if (billStatus.equals("D")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_new", "bar_audit", "baritemap1", "bar_businesspro", "bar_more", "barmore"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit", "bar_unaudit", "baritemap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_apgeneratevoucher"});
        }
        if (billStatus.equals("E") || billStatus.equals("D")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_assign", "bar_antiassign"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_assign", "bar_antiassign"});
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_assacct": {
                this.assacctShowF7();
                break;
            }
            case "e_corebillno": {
                this.showCoreBillF7();
                break;
            }
            case "sameinfo_view": {
                Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0024", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
                if (sameBillInfo != null && !sameBillInfo.isEmpty()) {
                    ArrayList sameBillNos = new ArrayList(sameBillInfo.values());
                    ListShowParameter parameter = new ListShowParameter();
                    parameter.setBillFormId("ap_payapply");
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    QFilter qFilter = new QFilter("billno", "in", sameBillNos.get(0));
                    parameter.getListFilterParameter().setFilter(qFilter);
                    parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
                    this.getView().showForm((FormShowParameter)parameter);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
                    break;
                }
            }
            case "sameinfo_ignore": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
                break;
            }
            case "refund_view": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"refund_view"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"refund_ignore"});
                Map<Object, List<DynamicObject>> entryFroupMap = this.getRefundWarnMap();
                if (entryFroupMap.size() <= 0) break;
                StringBuilder str = new StringBuilder();
                str.append('\n');
                for (Map.Entry<Object, List<DynamicObject>> entry : entryFroupMap.entrySet()) {
                    str.append(ResManager.loadKDString((String)"\u7b2c", (String)"ApplyPayBillEdit_25", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    List<DynamicObject> refEntrys = entry.getValue();
                    for (int i = 0; i < refEntrys.size(); ++i) {
                        DynamicObject warnEntry = refEntrys.get(i);
                        String seq = warnEntry.getString("seq");
                        if (i == refEntrys.size() - 1) {
                            str.append(seq).append(ResManager.loadKDString((String)"\u884c\uff1a", (String)"ApplyPayBillEdit_26", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                            String asstantName = warnEntry.getString("e_asstact.name");
                            String asstBankName = warnEntry.getString("e_assacct");
                            String bankName = warnEntry.getString("e_bebank.name");
                            bankName = bankName == null ? "" : bankName;
                            String strAsstact = String.format(ResManager.loadKDString((String)"\u5f80\u6765\u6237\uff1a%1$s ;\u5f80\u6765\u8d26\u6237\uff1a%2$s ;\u5f80\u6765\u94f6\u884c\uff1a%3$s \u3002", (String)"ApplyPayBillEdit_27", (String)"fi-ap-formplugin", (Object[])new Object[0]), asstantName, asstBankName, bankName);
                            str.append(strAsstact).append('\n');
                            continue;
                        }
                        str.append(seq).append('\u3001');
                    }
                }
                Label label = (Label)this.getView().getControl("refund_labelap");
                String message = ResManager.loadKDString((String)"\u672c\u5355\u7684\u90e8\u5206\u5f80\u6765\u8d26\u6237\u5728\u534a\u5e74\u5185\u66fe\u53d1\u751f\u8fc7\u94f6\u884c\u9000\u7968\u4e1a\u52a1\uff0c\u5b58\u5728\u518d\u6b21\u9000\u7968\u98ce\u9669\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u3002%s", (String)"ApplyPayBillEdit_17", (String)"fi-ap-formplugin", (Object[])new Object[]{str.toString()});
                label.setText(message);
                break;
            }
            case "refund_ignore": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"refund_view"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"refund_ignore"});
                Label label = (Label)this.getView().getControl("refund_labelap");
                String message = ResManager.loadKDString((String)"\u672c\u5355\u7684\u90e8\u5206\u5f80\u6765\u8d26\u6237\u5728\u534a\u5e74\u5185\u66fe\u53d1\u751f\u8fc7\u94f6\u884c\u9000\u7968\u4e1a\u52a1\uff0c\u5b58\u5728\u518d\u6b21\u9000\u7968\u98ce\u9669\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u3002", (String)"ApplyPayBillEdit_18", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                label.setText(message);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_submit".equals(key) || "bar_audit".equals(key) || "bar_submitandnew".equals(key)) {
            List result = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0080", null, (Object[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            if (result != null && result.size() > 0) {
                String submitTitle = ResManager.loadKDString((String)"\u63d0\u4ea4\u6b64\u5355\u636e\uff0c\u4f1a\u5bfc\u81f4\u8d85\u8fc7\u4f9b\u5e94\u5546\u4f59\u989d\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u5e76\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"ApplyPayBillEdit_15", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                String auditTitle = ResManager.loadKDString((String)"\u5ba1\u6838\u6b64\u5355\u636e\uff0c\u4f1a\u5bfc\u81f4\u8d85\u8fc7\u4f9b\u5e94\u5546\u4f59\u989d\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u5e76\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"ApplyPayBillEdit_16", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                String title = "bar_audit".equals(key) ? auditTitle : submitTitle;
                String url = "https://vip.kingdee.com/article/542281522032911872?productLineId=2&isKnowledge=2";
                OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this);
                operationConfirmHelper.openOperateConfirmByActionId(title, "", result, false, key, url);
            } else if ("bar_submit".equals(key)) {
                this.getView().invokeOperation("submit");
            } else if ("bar_audit".equals(key)) {
                this.getView().invokeOperation("audit");
            } else {
                this.getView().invokeOperation("submitandnew");
            }
        }
        if ("bar_m_closepay".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl("entry");
            int[] rows = grid.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u660e\u7ec6\u884c\u6570\u636e\u3002", (String)"ApplyPayBillEdit_21", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            ArrayList<Long> selectRows = new ArrayList<Long>(rows.length);
            ArrayList<Integer> closetRows = new ArrayList<Integer>(rows.length);
            for (int row : rows) {
                String closestatus = (String)this.getModel().getValue("e_closestatus", row);
                if ("A".equals(closestatus)) {
                    Long entryId = (Long)this.getModel().getValue("entry.id", row);
                    selectRows.add(entryId);
                    continue;
                }
                closetRows.add(row + 1);
            }
            if (closetRows.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u5173\u95ed\u72b6\u6001\u4e3a\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u91cd\u590d\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ApplyPayBillEdit_22", (String)"fi-ap-formplugin", (Object[])new Object[]{((Object)closetRows).toString()}));
                return;
            }
            if (selectRows.size() > 0) {
                this.showCloseConfirm(SerializationUtils.toJsonString(selectRows));
            }
        }
        if ("closepay".equals(key)) {
            this.showCloseConfirm("");
        }
    }

    private Map<Object, List<DynamicObject>> getRefundWarnMap() {
        HashMap<Object, List<DynamicObject>> entryFroupMap = new HashMap<Object, List<DynamicObject>>(8);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys != null && entrys.size() > 0) {
            ArrayList<Long> asstactIdList = new ArrayList<Long>(entrys.size());
            ArrayList<Long> bankIdList = new ArrayList<Long>(entrys.size());
            ArrayList<String> assacctNameList = new ArrayList<String>(entrys.size());
            ArrayList<DynamicObject> isPushCasList = new ArrayList<DynamicObject>(entrys.size());
            for (DynamicObject entry : entrys) {
                BigDecimal ePaidAmt = entry.getBigDecimal("e_paidamt");
                BigDecimal eApproveAmt = entry.getBigDecimal("e_approvedamt");
                if (ePaidAmt.abs().compareTo(eApproveAmt.abs()) >= 0) continue;
                Long asstactId = entry.getLong("e_asstact.id");
                String assacctName = entry.getString("e_assacct");
                Long bankId = entry.getLong("e_bebank.id");
                asstactIdList.add(asstactId);
                bankIdList.add(bankId);
                assacctNameList.add(assacctName);
                isPushCasList.add(entry);
            }
            QFilter filter = new QFilter("billstatus", "=", (Object)"F").and("bizdate", ">", (Object)DateUtils.getLastDay((Date)new Date(), (int)180)).and("payeebanknum", "in", assacctNameList).and("payeebank", "in", bankIdList).and("payee", "in", asstactIdList);
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"payeebanknum,payeebank,payee", (QFilter[])new QFilter[]{filter});
            Map<Object, List<DynamicObject>> payGroupMap = payBills.stream().collect(Collectors.groupingBy(p -> p.getLong("payee") + p.getString("payeebanknum") + p.getLong("payeebank")));
            for (Map.Entry<Object, List<DynamicObject>> payEntry : payGroupMap.entrySet()) {
                DynamicObject paybill = payEntry.getValue().get(0);
                Long PayAsstactId = paybill.getLong("payee");
                Long payBankId = paybill.getLong("payeebank");
                String payAssacctName = paybill.getString("payeebanknum");
                for (DynamicObject entry : isPushCasList) {
                    Long asstactId = entry.getLong("e_asstact.id");
                    String assacctName = entry.getString("e_assacct");
                    Long bankId = entry.getLong("e_bebank.id");
                    if (!asstactId.equals(PayAsstactId) || !bankId.equals(payBankId) || !assacctName.equals(payAssacctName)) continue;
                    String groupKey = asstactId + assacctName + bankId;
                    ArrayList<DynamicObject> groupEntrys = (ArrayList<DynamicObject>)entryFroupMap.get(groupKey);
                    if (groupEntrys != null) {
                        groupEntrys.add(entry);
                    } else {
                        groupEntrys = new ArrayList<DynamicObject>(1);
                        groupEntrys.add(entry);
                    }
                    entryFroupMap.put(groupKey, groupEntrys);
                }
            }
        }
        return entryFroupMap;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "assaccount": {
                this.closeassaccountF7(returnData);
                break;
            }
            case "coreBill": {
                this.closecoreBill(returnData);
                break;
            }
            case "bar_submit": {
                if (returnData == null) break;
                this.getView().invokeOperation("submit");
                break;
            }
            case "bar_audit": {
                if (returnData == null) break;
                this.getView().invokeOperation("audit");
                break;
            }
            case "bar_submitandnew": {
                if (returnData == null) break;
                this.getView().invokeOperation("submitandnew");
            }
        }
    }

    private void closecoreBill(Object returnData) {
        ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
    }

    private void showCloseConfirm(String selectRows) {
        DynamicObjectCollection invEntry = this.getModel().getEntryEntity("inventry");
        String confirmMessage = ResManager.loadKDString((String)"\u5173\u95ed\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPayBillEdit_23", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (!invEntry.isEmpty()) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
            int payRowNumber = 0;
            int unCloseRowNum = 0;
            for (DynamicObject applyRow : entry) {
                if (applyRow.getBigDecimal("lockedamt").compareTo(BigDecimal.ZERO) != 0) {
                    ++payRowNumber;
                }
                if (!"A".equals(applyRow.getString("e_closestatus"))) continue;
                ++unCloseRowNum;
            }
            if ((long)payRowNumber == 0L) {
                List selectRowList;
                Set invoiceIds = invEntry.stream().map(inv -> inv.getLong("invid")).collect(Collectors.toSet());
                DataSet invoiceDatSet = QueryServiceHelper.queryDataSet((String)"query_invoice", (String)"ap_invoice", (String)"isreffin,businesssource,unrelatedamt,pricetaxtotal,isvoucher,ismatched", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)}, (String)"");
                int matchInvoiceNumber = 0;
                for (Row invRow : invoiceDatSet) {
                    if (!"ap_payapply".equals(invRow.getString("businesssource")) || invRow.getBigDecimal("unrelatedamt").compareTo(invRow.getBigDecimal("pricetaxtotal")) != 0 || invRow.getBoolean("isvoucher").booleanValue() || invRow.getBoolean("ismatched").booleanValue()) continue;
                    ++matchInvoiceNumber;
                }
                boolean isAllClose = true;
                if (!ObjectUtils.isEmpty((Object)selectRows) && (selectRowList = (List)SerializationUtils.fromJsonString((String)selectRows, List.class)).size() != unCloseRowNum) {
                    isAllClose = false;
                }
                if (isAllClose && matchInvoiceNumber > 0) {
                    confirmMessage = ResManager.loadKDString((String)"\u5173\u95ed\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u4e14\u5173\u95ed\u540e\u5c06\u91ca\u653e\u53d1\u7968\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPayBillEdit_24", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                }
            }
        }
        this.getView().showConfirm(confirmMessage, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("executeClose"), null, selectRows);
    }

    private void closeassaccountF7(Object returnData) {
        int curentrow = this.getModel().getEntryCurrentRowIndex("entry");
        String assacttype = this.getModel().getValue("e_asstacttype", curentrow).toString();
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            if (assacttype.equals("bd_customer") || assacttype.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)assacttype, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue("e_assacct", (Object)row.getString("bankaccount"), curentrow);
                    this.getModel().setValue("e_bebank", (Object)row.getLong("bank.id"), curentrow);
                    break;
                }
            } else if (assacttype.equals("bos_user")) {
                DynamicObject payeerInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount");
                if (!ObjectUtils.isEmpty((Object)payeerInfo)) {
                    this.getModel().setValue("e_assacct", (Object)payeerInfo.getString("payeraccount"), curentrow);
                    this.getModel().setValue("e_bebank", (Object)payeerInfo.getLong("payerbank.id"), curentrow);
                }
            } else {
                DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank.id,bank.bebank");
                if (!ObjectUtils.isEmpty((Object)account)) {
                    this.getModel().setValue("e_assacct", (Object)account.getString("bankaccountnumber"), curentrow);
                }
                if (!ObjectUtils.isEmpty((Object)account) && !ObjectUtils.isEmpty((Object)account.getDynamicObject("bank.bebank"))) {
                    this.getModel().setValue("e_bebank", account.getDynamicObject("bank.bebank").getPkValue(), curentrow);
                }
            }
        }
    }

    private void assacctShowF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("e_asstact", currrow);
        AsstactHelper.assacctShowF7((DynamicObject)basedata, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void showCoreBillF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("entry");
        String corebilltype = (String)this.getModel().getValue("e_corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)corebilltype, (IFormView)this.getView(), (String)this.getPluginName());
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        this.setAsstactCaption();
        Label label = (Label)this.getView().getControl("refund_labelap");
        String message = ResManager.loadKDString((String)"\u672c\u5355\u7684\u90e8\u5206\u5f80\u6765\u8d26\u6237\u5728\u534a\u5e74\u5185\u66fe\u53d1\u751f\u8fc7\u94f6\u884c\u9000\u7968\u4e1a\u52a1\uff0c\u5b58\u5728\u518d\u6b21\u9000\u7968\u98ce\u9669\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u3002", (String)"ApplyPayBillEdit_19", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        label.setText(message);
        Map<Object, List<DynamicObject>> entryFroupMap = this.getRefundWarnMap();
        if (entryFroupMap.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"refundflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"refundflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"refund_view"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"refund_ignore"});
        }
        this.fillToolBar();
        String payCurrencyVisable = StdConfig.get((String)"newApplyPayCurrency");
        if ("true".equals(payCurrencyVisable)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"paycurrency"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"paycurrency"});
        }
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (ObjectUtils.isEmpty((Object)billType)) {
            return;
        }
        String customerCaption = ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546", (String)"ApplyPayBillEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"ApplyPayBillEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getControl("e_asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("ap_payapply_BT_S".equals(billType.getString("number"))) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int iRow = changeData[0].getRowIndex();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        switch (key) {
            case "settleorg": {
                this.settleOrgChanged(newValue);
                break;
            }
            case "billtype": {
                this.setAsstactCaption();
                if (newValue != null) break;
                this.getModel().beginInit();
                this.getModel().setValue("billtype", oldValue);
                this.getModel().endInit();
                this.getView().updateView("billtype");
                return;
            }
            case "applydate": {
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"applydate", (Object)oldValue);
                break;
            }
            case "exratedate": {
                if (!Objects.isNull(newValue)) break;
                this.getModel().setValue("exratedate", (Object)new Date());
                return;
            }
            case "exratetable": {
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                this.getModel().setValue("exratetable", oldValue);
                break;
            }
            case "settlecurrency": {
                DynamicObjectCollection invEntries = this.getModel().getEntryEntity("inventry");
                if (!invEntries.isEmpty() && (ObjectUtils.isEmpty((Object)newValue) || ((DynamicObject)newValue).getLong("id") != ((DynamicObject)invEntries.get(0)).getLong("i_currency.id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u7ed3\u7b97\u5e01\u4e0e\u53d1\u7968\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ApplyPayBillEdit4Inv_27", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("settlecurrency", oldValue);
                    break;
                }
                if (EmptyUtils.isEmpty((Object)this.getModel().getValue("sourcebilltype"))) {
                    this.getModel().setValue("paycurrency", this.getModel().getValue("settlecurrency"));
                }
            }
            case "paycurrency": {
                if (oldValue == null || newValue == null) break;
                int oldPrecision = ((DynamicObject)oldValue).getInt("amtprecision");
                int newPrecision = ((DynamicObject)newValue).getInt("amtprecision");
                BigDecimal amount = (BigDecimal)this.getModel().getValue("applyamount");
                if (oldPrecision == newPrecision || amount.compareTo(BigDecimal.ZERO) == 0) break;
                IBillModel model = (IBillModel)this.getModel();
                this.setCalculatorAmt(model);
                this.setHeadAmt(model);
                break;
            }
            case "e_asstact": {
                this.asstactChanged(changeData);
                break;
            }
            case "e_applyamount": {
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                if (ObjectUtils.isEmpty((Object)settleCurrency)) {
                    this.getModel().setValue("e_applyamount", (Object)BigDecimal.ZERO, iRow);
                    this.getModel().setValue("e_payamount", (Object)BigDecimal.ZERO, iRow);
                    if (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) != 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ed3\u7b97\u5e01\u3002", (String)"ApplyPayBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                BigDecimal applyamount = (BigDecimal)newValue;
                this.reserictApplyAmount(applyamount, iRow);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("e_applyamount", "applyamount");
                map.put("e_appseleamount", "appseleamount");
                this.applyamountChanged(map);
                this.getModel().setValue("e_approvedamt", (Object)applyamount, iRow);
                this.setCalculatorAmt((IBillModel)this.getModel());
                this.setHeadAmt((IBillModel)this.getModel());
                break;
            }
            case "e_approvedamt": {
                BigDecimal approvedAmt = (BigDecimal)this.getModel().getValue("e_approvedamt", iRow);
                BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
                DynamicObject settleCurrency_1 = (DynamicObject)this.getModel().getValue("settlecurrency");
                String quotation = (String)this.getModel().getValue("quotation");
                if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    quotation = "0";
                }
                if (ObjectUtils.isEmpty((Object)settleCurrency_1)) {
                    this.getModel().setValue("e_applyamount", (Object)BigDecimal.ZERO, iRow);
                    this.getModel().setValue("e_payamount", (Object)BigDecimal.ZERO, iRow);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ed3\u7b97\u5e01\u3002", (String)"ApplyPayBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    return;
                }
                int amtPrecision = settleCurrency_1.getInt("amtprecision");
                if ("1".equals(quotation)) {
                    this.getModel().setValue("e_approvedseleamt", (Object)approvedAmt.divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP), iRow);
                } else {
                    this.getModel().setValue("e_approvedseleamt", (Object)approvedAmt.multiply(exchangeRate).setScale(amtPrecision, RoundingMode.HALF_UP), iRow);
                }
                HashMap<String, String> entrymap = new HashMap<String, String>();
                entrymap.put("e_approvedamt", "approvalamount");
                entrymap.put("e_approvedseleamt", "aprseleamount");
                this.applyamountChanged(entrymap);
                break;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"ApplyPayBillEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setCalculatorAmt((IBillModel)this.getModel());
                this.setHeadAmt((IBillModel)this.getModel());
                break;
            }
            case "e_payamount": {
                this.getModel().setValue("e_applyamount", newValue, iRow);
                break;
            }
            case "e_material": {
                this.getModel().setValue("e_materialversion", null, iRow);
                this.materialChanged(changeData);
                break;
            }
            case "e_corebilltype": {
                this.getModel().setValue("e_corebillno", null, iRow);
                this.getModel().setValue("e_corebillentryseq", null, iRow);
            }
        }
    }

    private void settleOrgChanged(Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("settlecurrency", null);
        } else {
            InitHelper initHelper = new InitHelper(((DynamicObject)newValue).getLong("id"), "ap_init");
            DynamicObject currency = initHelper.getStandardCurrency();
            if (ObjectUtils.isEmpty((Object)currency)) {
                this.getModel().setValue("settlecurrency", null);
            } else {
                this.getModel().setValue("settlecurrency", currency.getPkValue());
            }
            DynamicObject exrateTable = initHelper.getExrateTable();
            if (!ObjectUtils.isEmpty((Object)exrateTable)) {
                this.getModel().setValue("exratetable", exrateTable.getPkValue());
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("e_applyamount", "applyamount");
        map.put("e_approvedamt", "approvalamount");
        map.put("e_approvedseleamt", "aprseleamount");
        map.put("e_appseleamount", "appseleamount");
        this.applyamountChanged(map);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("e_applyamount", "applyamount");
        map.put("e_approvedamt", "approvalamount");
        map.put("e_approvedseleamt", "aprseleamount");
        map.put("e_appseleamount", "appseleamount");
        this.applyamountChanged(map);
        if ("entry".equals(entryProp.getName())) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
                if (!this.isCopyEntryRow) {
                    if (this.settlementType == null) {
                        this.settlementType = BaseDataHelper.getDefaultSettleType();
                    }
                    this.getModel().setValue("e_settlementtype", (Object)this.settlementType, row.getRowIndex());
                } else {
                    BigDecimal applyAmount = (BigDecimal)this.getModel().getValue("e_applyamount", row.getRowIndex());
                    this.getModel().setValue("e_approvedamt", (Object)applyAmount, row.getRowIndex());
                }
                if (this.splitRowMap.isEmpty()) continue;
                this.getModel().setValue("e_corebilltype", this.splitRowMap.get("e_corebilltype"), row.getRowIndex());
                this.getModel().setValue("e_corebillno", this.splitRowMap.get("e_corebillno"), row.getRowIndex());
                this.getModel().setValue("e_corebillentryseq", this.splitRowMap.get("e_corebillentryseq"), row.getRowIndex());
                this.getModel().setValue("e_corebillid", this.splitRowMap.get("e_corebillid"), row.getRowIndex());
                this.getModel().setValue("e_corebillentryid", this.splitRowMap.get("e_corebillentryid"), row.getRowIndex());
                this.getModel().setValue("e_conbillentity", this.splitRowMap.get("e_conbillentity"), row.getRowIndex());
                this.getModel().setValue("e_conbillnumber", this.splitRowMap.get("e_conbillnumber"), row.getRowIndex());
                this.getModel().setValue("e_conbillrownum", this.splitRowMap.get("e_conbillrownum"), row.getRowIndex());
                this.getModel().setValue("e_conbillid", this.splitRowMap.get("e_conbillid"), row.getRowIndex());
                this.getModel().setValue("e_conbillentryid", this.splitRowMap.get("e_conbillentryid"), row.getRowIndex());
                this.splitRowMap.clear();
            }
        }
    }

    private void applyamountChanged(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            int count = this.getModel().getEntryRowCount("entry");
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < count; ++i) {
                amount = amount.add((BigDecimal)this.getModel().getValue(entry.getKey(), i));
            }
            this.getModel().setValue(entry.getValue(), (Object)amount);
        }
    }

    private void asstactChanged(ChangeData[] data) {
        int row = data[0].getRowIndex();
        Object propValue = data[0].getNewValue();
        if (!ObjectUtils.isEmpty((Object)propValue)) {
            DynamicObject dydata = (DynamicObject)propValue;
            Map map = AsstactHelper.getaccbebankMap((DynamicObject)dydata);
            this.getModel().setValue("e_assacct", map.get("account"), row);
            this.getModel().setValue("e_bebank", map.get("bebank"), row);
            if (map.get("settlementtypeid") != null) {
                this.getModel().setValue("e_settlementtype", map.get("settlementtypeid"), row);
            } else {
                long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
                this.getModel().setValue("e_settlementtype", (Object)settleTypeId, row);
            }
        } else {
            this.getModel().setValue("e_assacct", null, row);
            this.getModel().setValue("e_bebank", null, row);
            this.getModel().setValue("e_settlementtype", (Object)ArApSettleTypeHelper.getDefaultSettleType(), row);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        int count = model.getEntryRowCount("entry");
        for (int i = 0; i < count; ++i) {
            model.setValue("e_approvedamt", model.getValue("e_applyamount", i), i);
            model.setValue("e_approvedseleamt", model.getValue("e_appseleamount", i), i);
        }
        model.setValue("approvalamount", model.getValue("applyamount"));
        model.setValue("aprseleamount", model.getValue("appseleamount"));
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    private void setCurrencyByApplyOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        if (!ObjectUtils.isEmpty((Object)org)) {
            this.init = new InitHelper(org.getLong("id"), "ap_init");
            DynamicObject currency = this.init.getStandardCurrency();
            this.getModel().setValue("paycurrency", (Object)currency);
            this.getModel().setValue("settlecurrency", (Object)currency);
            DynamicObject exrateTable = this.init.getExrateTable();
            if (!ObjectUtils.isEmpty((Object)exrateTable)) {
                this.getModel().setValue("exratetable", exrateTable.getPkValue());
                this.getModel().setValue("exchangerate", (Object)1);
            }
        }
    }

    private void reserictApplyAmount(BigDecimal eApplyAmount, int iRow) {
        BigDecimal ePayAmount = (BigDecimal)this.getModel().getValue("e_payamount", iRow);
        if (ePayAmount.compareTo(BigDecimal.ZERO) > 0 && ePayAmount.compareTo(eApplyAmount) < 0) {
            this.getModel().setValue("e_applyamount", (Object)ePayAmount, iRow);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.fillToolBar();
        this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        Object billStatus = this.getModel().getValue("billstatus");
        if ("B".equals(billStatus) || "A".equals(billStatus)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0024", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
    }

    private void setOrgByUser(DynamicObject org) {
        long orgId = org.getLong("id");
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("settleorg")) && org.getBoolean("fisaccounting")) {
            this.getModel().setValue("settleorg", (Object)orgId);
        }
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("purorg")) && org.getBoolean("fispurchase")) {
            this.getModel().setValue("purorg", (Object)orgId);
        }
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("payorg")) && org.getBoolean("fisbankroll")) {
            this.getModel().setValue("payorg", (Object)orgId);
        }
    }

    private void materialChanged(ChangeData[] data) {
        int row = data[0].getRowIndex();
        Object propValue = data[0].getNewValue();
        if (propValue != null) {
            DynamicObject material = (DynamicObject)propValue;
            this.getModel().setValue("e_spectype", (Object)material.getString("modelnum"), row);
        } else {
            this.getModel().setValue("e_spectype", null, row);
        }
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            if (EmptyUtils.isNotEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void sameBillWarn(Map<String, List<String>> sameBillInfo) {
        if (sameBillInfo == null || sameBillInfo.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"sameinfoflex"});
        ArrayList<List<String>> sameBillNos = new ArrayList<List<String>>(sameBillInfo.values());
        Label label = (Label)this.getView().getControl("sameinfo_labelap");
        String message = ResManager.loadKDString((String)"\u91cd\u590d\u4ed8\u6b3e\u98ce\u9669\u63d0\u9192\uff1a", (String)"FinApBillEdit_31", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        label.setText(message.concat(ExecCtrlHelper.getSameBillMessage((List)((List)sameBillNos.get(0)), (boolean)true)));
    }

    private void checkPayhold(String key, BeforeDoOperationEventArgs args) {
        String operateKey = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ApplyPayBillEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String errorTitle = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"ApplyPayBillEdit_9", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String errorMessageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7b2c%2$d\u884c\uff0c\u6536\u6b3e\u4f9b\u5e94\u5546\u201c%3$s\u201d\u5df2\u4ed8\u6b3e\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8%4$s\u3002", (String)"ApplyPayBillEdit_11", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if ("audit".equals(key)) {
            operateKey = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ApplyPayBillEdit_8", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            errorTitle = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25", (String)"ApplyPayBillEdit_10", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
        ArrayList<Long> asstactList = new ArrayList<Long>(8);
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject asstact;
            DynamicObject entry = (DynamicObject)entries.get(i);
            if (!"bd_supplier".equals(entry.getString("e_asstacttype")) || ObjectUtils.isEmpty((Object)(asstact = entry.getDynamicObject("e_asstact")))) continue;
            Long id = asstact.getLong("id");
            asstactList.add(id);
        }
        Map asstactRes = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactList), new QFilter("payhold", "=", (Object)Boolean.TRUE)});
        if (!ObjectUtils.isEmpty((Object)asstactRes)) {
            ArrayList<String> errorMsgs = new ArrayList<String>(8);
            for (int i = 0; i < entries.size(); ++i) {
                Long id;
                DynamicObject asstact;
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (!"bd_supplier".equals(entry.getString("e_asstacttype")) || ObjectUtils.isEmpty((Object)(asstact = entry.getDynamicObject("e_asstact"))) || !asstactRes.containsKey(id = Long.valueOf(asstact.getLong("id")))) continue;
                String billno = (String)this.getModel().getValue("billno");
                String asstactName = asstact.getString("name");
                String message = String.format(errorMessageTemplate, billno, i + 1, asstactName, operateKey);
                errorMsgs.add(message);
            }
            if (errorMsgs.size() > 1) {
                HashMap<String, Object> customParam = new HashMap<String, Object>(2);
                customParam.put("title", errorTitle);
                customParam.put("errorMsg", errorMsgs);
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_operationresult");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.getCustomParams().putAll(customParam);
                parameter.setShowTitle(false);
                this.getView().showForm(parameter);
            } else {
                this.getView().showErrorNotification((String)errorMsgs.get(0));
            }
            args.setCancel(true);
        }
    }

    private void checkPayhold(BeforeDoOperationEventArgs args) {
        String operateKey = ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"ApplyPayBillEdit_12", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String errorTitle = ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25", (String)"ApplyPayBillEdit_13", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String errorMessageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7b2c%2$d\u884c\uff0c\u6536\u6b3e\u4f9b\u5e94\u5546\u201c%3$s\u201d\u5df2\u4ed8\u6b3e\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8%4$s\u3002", (String)"ApplyPayBillEdit_14", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
        ArrayList<Long> asstactList = new ArrayList<Long>(8);
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            if (!"bd_supplier".equals(entry.getString("e_asstacttype"))) {
                return;
            }
            DynamicObject asstact = entry.getDynamicObject("e_asstact");
            if (ObjectUtils.isEmpty((Object)asstact)) continue;
            Long id = asstact.getLong("id");
            asstactList.add(id);
        }
        if (ObjectUtils.isEmpty(asstactList)) {
            return;
        }
        Map asstactRes = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactList), new QFilter("payhold", "=", (Object)Boolean.FALSE)});
        if (!ObjectUtils.isEmpty((Object)asstactRes)) {
            return;
        }
        ArrayList<String> errorMsgs = new ArrayList<String>(8);
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject asstact = entry.getDynamicObject("e_asstact");
            if (ObjectUtils.isEmpty((Object)asstact)) continue;
            String billno = (String)this.getModel().getValue("billno");
            String asstactName = asstact.getString("name");
            String message = String.format(errorMessageTemplate, billno, i + 1, asstactName, operateKey);
            errorMsgs.add(message);
        }
        if (errorMsgs.size() > 1) {
            HashMap<String, Object> customParam = new HashMap<String, Object>(2);
            customParam.put("title", errorTitle);
            customParam.put("errorMsg", errorMsgs);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_operationresult");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.getCustomParams().putAll(customParam);
            parameter.setShowTitle(false);
            this.getView().showForm(parameter);
        } else {
            this.getView().showErrorNotification((String)errorMsgs.get(0));
        }
        args.setCancel(true);
    }
}

