/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAssignService;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.ap.piaozone.ShowInvoiceCloudPageUtil;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ApplyPayBillEdit4Inv
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String INVOICE_PAGE_SELECT_INVOICE = "selectInvoice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"invasstactinfo_ignore"});
    }

    public void itemClick(ItemClickEvent e) {
        String key = e.getItemKey();
        if ("i_deleteentry".equals(key)) {
            this.deleteInvEntry();
        } else if ("i_sysinvstatus".equals(key)) {
            this.synInvoiceStatus();
        } else if ("bar_assign".equals(key)) {
            this.showAssignInvoiceList();
        } else if ("i_replaceinvoice".equals(key)) {
            this.replaceInvoice();
        } else if ("bar_viewreplaceinv".equals(key)) {
            long billId = this.getModel().getDataEntity().getLong("id");
            HashSet<Long> orgIds = new HashSet<Long>(2);
            orgIds.add(this.getModel().getDataEntity().getLong("settleorg.id"));
            ReplaceInvoiceHelper.viewReplaceInvoiceList((IFormView)this.getView(), orgIds, Collections.singletonList(billId));
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("invasstactinfo_ignore".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
        }
    }

    public void afterBindData(EventObject e) {
        this.invoiceAsstactWarn();
        if ("D".equals(this.getModel().getValue("billstatus")) || "E".equals(this.getModel().getValue("billstatus"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_antiassign"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate op = (AbstractOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if ("toviewinvoice".equals(operateKey)) {
            boolean isPrePayInvoice = (Boolean)this.getModel().getValue("isprepayinvoice");
            if (!isPrePayInvoice) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u201c\u5230\u7968\u9884\u4ed8\u201d\u6253\u5f00\u65f6\uff0c\u624d\u53ef\u67e5\u770b\u53d1\u7968\u3002", (String)"ApplyPayBillEdit4Inv_17", (String)"fi-ap-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno")));
                e.setCancel(true);
            } else if (this.getModel().getEntryEntity("inventry").isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u53d1\u7968\u3002", (String)"ApplyPayBillEdit4Inv_18", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "save": 
                case "submit": 
                case "unsubmit": 
                case "assign": {
                    String waring = FinApBillHelper.supplierWarnTips((String)"ap_payapply", (List)operationResult.getSuccessPkIds(), (String)operateKey);
                    if (StringUtils.isNotEmpty((String)waring)) {
                        this.getView().showSuccessNotification(waring, Integer.valueOf(10000));
                    }
                }
                case "deleteinventry": 
                case "antiassign": 
                case "assignsave": {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
        if ("collectinvoice".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            this.showInvoiceAssistant();
        }
        if ("toviewinvoice".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            ShowInvoiceCloudPageUtil.viewInvoice((IFormView)this.getView(), (long)this.getModel().getDataEntity().getLong("id"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection invoiceEntries;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        Object newValue = changeData[0].getNewValue();
        int currentIndex = changeData[0].getRowIndex();
        if ("e_asstact".equals(key) && (invoiceEntries = this.getModel().getEntryEntity("inventry")).size() > 0) {
            long collectRowNumber = invoiceEntries.stream().filter(invEntry -> ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invEntry.getString("i_srctype"))).count();
            if (collectRowNumber == (long)invoiceEntries.size()) {
                HashMap<String, Number> customValueMap = new HashMap<String, Number>(2);
                customValueMap.put("e_asstact", newValue == null ? 0L : ((DynamicObject)newValue).getLong("id"));
                customValueMap.put("currentIndex", currentIndex);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u3001\u5207\u6362\u6536\u6b3e\u4f9b\u5e94\u5546\u4f1a\u6e05\u7a7a\u53d1\u7968\u660e\u7ec6\u884c\u6240\u6709\u53d1\u7968\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPayBillEdit4Inv_15", (String)"fi-ap-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isChangeAsstact"), null, JsonUtils.objToJson(customValueMap));
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
                ((DynamicObject)entry.get(currentIndex)).set("e_asstact", oldValue);
                this.getView().updateView("e_asstact", currentIndex);
            } else {
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
                ((DynamicObject)entry.get(currentIndex)).set("e_asstact", oldValue);
                this.getView().updateView("e_asstact", currentIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u884c\u6765\u6e90\u4e0d\u5168\u4e3a\u201c\u53d1\u7968\u91c7\u96c6\u201d\u7684\u53d1\u7968\u884c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3001\u5207\u6362\u5f80\u6765\u6237\u3002", (String)"ApplyPayBillEdit4Inv_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        DynamicObjectCollection invoiceEntries;
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        if (rowIndex == -1) {
            return;
        }
        if ("e_asstacttype".equals(key) && (invoiceEntries = this.getModel().getEntryEntity("inventry")).size() > 0) {
            long collectRowNumber = invoiceEntries.stream().filter(invEntry -> ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invEntry.getString("i_srctype"))).count();
            if (collectRowNumber == (long)invoiceEntries.size()) {
                HashMap<String, Object> customValueMap = new HashMap<String, Object>(2);
                customValueMap.put("e_asstacttype", value);
                customValueMap.put("currentIndex", rowIndex);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5f80\u6765\u7c7b\u578b\u4f1a\u6e05\u7a7a\u53d1\u7968\u660e\u7ec6\u884c\u6240\u6709\u53d1\u7968\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPayBillEdit4Inv_20", (String)"fi-ap-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isChangeAsstactType"), null, JsonUtils.objToJson(customValueMap));
                e.setCancel(true);
                this.getView().updateView(key, rowIndex);
            } else {
                e.setCancel(true);
                this.getView().updateView(key, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u884c\u6765\u6e90\u4e0d\u5168\u4e3a\u201c\u53d1\u7968\u91c7\u96c6\u201d\u7684\u53d1\u7968\u884c\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u5f80\u6765\u7c7b\u578b\u3002", (String)"ApplyPayBillEdit4Inv_21", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if ((Objects.equals(callBackID, "isDeleteAllEntry") || Objects.equals(callBackID, "isChangeAsstact") || Objects.equals(callBackID, "isChangeAsstactType")) && isOK) {
            this.changeAsstactToClearInvEntry(callBackID, e.getCustomVaule());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (actionId.startsWith(INVOICE_PAGE_SELECT_INVOICE) && !ObjectUtils.isEmpty((Object)returnData)) {
            InvoiceCollectParam collectParam = new InvoiceCollectParam();
            collectParam.setActionId(actionId);
            collectParam.setFormView(this.getView());
            collectParam.setReturnData((Map)returnData);
            ICollectInvoiceService collectService = (ICollectInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.PAYAPPLYCOLLECT.getValue());
            collectService.collectInvoice(collectParam);
        }
        if ("invoiceF7".equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            InvoiceAssignService assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue());
            assignService.closedCallBack((AbstractFormPlugin)this, actionId, e.getReturnData());
        }
        if ("replaceinvconfirm".equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
            for (int selectRow : selectRows) {
                invoiceIds.add((Long)this.getModel().getValue("invid", selectRow));
            }
            this.openReplaceInvPage(invoiceIds, Boolean.parseBoolean(String.valueOf(returnData)));
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("entry".equals(e.getEntryProp().getName())) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
            int[] rowIndexs = e.getRowIndexs();
            DynamicObjectCollection invEntry = this.getModel().getEntryEntity("inventry");
            if (entry.size() == rowIndexs.length && !invEntry.isEmpty()) {
                long collectRowNumber = invEntry.stream().filter(invRow -> ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype"))).count();
                if (collectRowNumber == (long)invEntry.size()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u3001\u5207\u6362\u6536\u6b3e\u4f9b\u5e94\u5546\u4f1a\u6e05\u7a7a\u53d1\u7968\u660e\u7ec6\u884c\u6240\u6709\u53d1\u7968\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPayBillEdit4Inv_15", (String)"fi-ap-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isDeleteAllEntry"), null, JsonUtils.objToJson((Object)rowIndexs));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u884c\u6765\u6e90\u4e0d\u5168\u4e3a\u201c\u53d1\u7968\u91c7\u96c6\u201d\u7684\u53d1\u7968\u884c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3001\u5207\u6362\u5f80\u6765\u6237\u3002", (String)"ApplyPayBillEdit4Inv_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                e.setCancel(true);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.realTimeSetInvoiceValue();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    private void replaceInvoice() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApplyPayBillEdit4Inv_28", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        String errorMessage = ResManager.loadKDString((String)"\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\u624d\u5141\u8bb8\u6362\u7968\uff1a1.\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff1b2.\u53d1\u7968\u660e\u7ec6\u4e0d\u4e3a\u7a7a\uff1b3.\u4ed8\u6b3e\u7533\u8bf7\u5355\u5173\u8054\u7684\u6362\u7968\u8bb0\u5f55\u5df2\u5ba1\u6838\uff1b4.\u6240\u9009\u53d1\u7968\u5173\u8054\u7684\u6362\u7968\u8bb0\u5f55\u5df2\u5ba1\u6838\u3002", (String)"ApplyPayBillEdit4Inv_29", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (!"C".equals(this.getModel().getValue("billstatus"))) {
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        for (int selectRow : selectRows) {
            invoiceIds.add((Long)this.getModel().getValue("invid", selectRow));
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        HashSet<Long> orgIds = new HashSet<Long>(2);
        orgIds.add(org.getLong("id"));
        long billId = this.getModel().getDataEntity().getLong("id");
        Map onTheWayApplyIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_payapply", orgIds, Collections.singletonList(billId));
        if (!onTheWayApplyIdsMap.isEmpty()) {
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        Map onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_invoice", orgIds, invoiceIds);
        if (!onTheWayInvoiceIdsMap.isEmpty()) {
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("inventry.invid", "in", invoiceIds), new QFilter("billstatus", "=", (Object)"C"), new QFilter("inventry.i_usedamt", "!=", (Object)BigDecimal.ZERO)}, (String)"");
        HashMap<Long, Set> inv4FinApIdsMap = new HashMap<Long, Set>(8);
        boolean isAssignMoreFinAp = false;
        for (Row row : finApDataSet) {
            Long finApBillId = row.getLong("id");
            Long invId = row.getLong("inventry.invid");
            Set finApBillIds = inv4FinApIdsMap.getOrDefault(invId, new HashSet(2));
            finApBillIds.add(finApBillId);
            if (finApBillIds.size() > 1) {
                isAssignMoreFinAp = true;
                break;
            }
            inv4FinApIdsMap.put(invId, finApBillIds);
        }
        if (isAssignMoreFinAp) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ap_replaceinvconfirm");
            showParameter.setShowTitle(false);
            showParameter.setShowClose(false);
            showParameter.getCustomParams().put("invoiceids", JsonUtils.objToJson(invoiceIds));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "replaceinvconfirm"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else {
            this.openReplaceInvPage(invoiceIds, true);
        }
    }

    private void openReplaceInvPage(List<Long> oldInvIds, boolean isReplaceAllAp) {
        InvoiceHelper.updateInvoiceStatus((Long[])oldInvIds.toArray(new Long[0]));
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setFormId("ap_replaceinvapply");
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        billShowParameter.setCustomParam("oldinvids", (Object)JsonUtils.objToJson(oldInvIds));
        if (!isReplaceAllAp) {
            billShowParameter.setCustomParam("finapbillid", (Object)"0");
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("i_billno".equals(key)) {
            BillShowParameter param = new BillShowParameter();
            param.setPkId(this.getModel().getValue("invid", e.getRowIndex()));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("ap_invoice");
            this.getView().showForm((FormShowParameter)param);
        } else if ("i_invoiceno".equals(key)) {
            HashSet<String> serialNoSet = new HashSet<String>(2);
            String serialNo = (String)this.getModel().getValue("i_serialno", e.getRowIndex());
            if (EmptyUtils.isNotEmpty((Object)serialNo)) {
                String[] split = org.apache.commons.lang3.StringUtils.split((String)serialNo, (String)",");
                serialNoSet.addAll(Arrays.asList(split));
            }
            ShowInvoiceCloudPageUtil.viewInvoice((IFormView)this.getView(), (long)this.getModel().getDataEntity().getLong("id"), serialNoSet);
        }
    }

    private void realTimeSetInvoiceValue() {
        DynamicObjectCollection invEntry = this.getModel().getEntryEntity("inventry");
        if (invEntry.isEmpty()) {
            return;
        }
        Set invoiceIds = invEntry.stream().map(invRow -> invRow.getLong("invid")).collect(Collectors.toSet());
        String selectors = "id,serialno,billno,taxrate,invoicetype,invoicetypef7,invoicecode,currency,currency,invoiceno,issuedate,pricetaxtotal,tax,amount,asstactname,buyername,istaxdeduction,remark,invoicestatus";
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        Map invoiceBillMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
        for (DynamicObject invRow2 : invEntry) {
            long invId = invRow2.getLong("invid");
            DynamicObject invoice = (DynamicObject)invoiceBillMap.get(invId);
            if (invoice == null) continue;
            invRow2.set("i_billno", (Object)invoice.getString("billno"));
            invRow2.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)invoice));
            invRow2.set("i_invoicetypef7", invoice.get("invoicetypef7"));
            invRow2.set("i_invoicecode", invoice.get("invoicecode"));
            invRow2.set("i_currency", invoice.get("currency"));
            invRow2.set("i_invoiceno", invoice.get("invoiceno"));
            invRow2.set("i_invoicedate", invoice.get("issuedate"));
            invRow2.set("i_pricetaxtotal", invoice.get("pricetaxtotal"));
            invRow2.set("i_tax", invoice.get("tax"));
            invRow2.set("i_amount", invoice.get("amount"));
            invRow2.set("i_asstactname", invoice.get("asstactname"));
            invRow2.set("i_buyername", invoice.get("buyername"));
            invRow2.set("i_istaxdeduction", invoice.get("istaxdeduction"));
            invRow2.set("i_remark", invoice.get("remark"));
            invRow2.set("i_invoicestatus", invoice.get("invoicestatus"));
        }
        this.getView().updateView("inventry");
    }

    private void deleteInvEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ApplyPayBillEdit4Inv_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        Long invPk = (Long)this.getModel().getValue("invid", selectRows[0]);
        QFilter filter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"));
        filter.and(new QFilter("inventry.invid", "=", (Object)invPk));
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"ap_payapply", (String)"id", (QFilter[])new QFilter[]{filter});
        boolean invExist = QueryServiceHelper.exists((String)"ap_invoice", (Object)invPk);
        if (invoice != null && invExist) {
            OperateOption operateOption = OperateOption.create();
            HashSet<Long> invPks = new HashSet<Long>(2);
            invPks.add(invPk);
            operateOption.setVariableValue("invPks", JSONObject.toJSONString(invPks));
            OperationResult result = this.getView().invokeOperation("deleteinventry", operateOption);
            OperationHelper.assertResult((OperationResult)result);
        } else {
            this.getModel().deleteEntryRow("inventry", selectRows[0]);
            if (this.getModel().getEntryEntity("inventry").isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
            }
        }
    }

    private void showInvoiceAssistant() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        HashSet<String> asstactTypes = new HashSet<String>(2);
        HashSet<Long> asstactIds = new HashSet<Long>(8);
        for (DynamicObject applyRow : entry) {
            asstactIds.add(applyRow.getLong("e_asstact.masterid"));
            asstactTypes.add(applyRow.getString("e_asstacttype"));
        }
        if (asstactIds.isEmpty() || asstactIds.contains(0L) || asstactTypes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ApplyPayBillEdit4Inv_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        if (asstactIds.size() > 1 || asstactTypes.size() > 1) {
            String message = ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u4ee5\u4e0b\u524d\u63d0\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApplyPayBillEdit4Inv_22", (String)"fi-ap-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u660e\u7ec6\u884c\u5f80\u6765\u7c7b\u578b\u9700\u4e3a\u4f9b\u5e94\u5546\u3001\u5ba2\u6237\u6216\u5458\u5de5\uff1b", (String)"ApplyPayBillEdit4Inv_23", (String)"fi-ap-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u5f80\u6765\u7c7b\u578b\u9700\u4e00\u81f4\uff1b", (String)"ApplyPayBillEdit4Inv_24", (String)"fi-ap-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u6536\u6b3e\u4f9b\u5e94\u5546\u9700\u4e00\u81f4\u3002", (String)"ApplyPayBillEdit4Inv_3", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message, Integer.valueOf(7000));
            return;
        }
        if ("bos_org".equals(((DynamicObject)entry.get(0)).getString("e_asstacttype"))) {
            ItemClassEdit asstact = (ItemClassEdit)this.getControl("e_asstact");
            String asstName = asstact.getProperty().getDisplayName().getLocaleValue();
            String message = ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u4ee5\u4e0b\u524d\u63d0\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApplyPayBillEdit4Inv_22", (String)"fi-ap-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u660e\u7ec6\u884c\u5f80\u6765\u7c7b\u578b\u9700\u4e3a\u4f9b\u5e94\u5546\u3001\u5ba2\u6237\u6216\u5458\u5de5\uff1b", (String)"ApplyPayBillEdit4Inv_23", (String)"fi-ap-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u5f80\u6765\u7c7b\u578b\u9700\u4e00\u81f4\uff1b", (String)"ApplyPayBillEdit4Inv_24", (String)"fi-ap-formplugin", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"3.%1$s\u9700\u4e00\u81f4\u3002", (String)"ApplyPayBillEdit4Inv_25", (String)"fi-ap-formplugin", (Object[])new Object[0]), asstName);
            this.getView().showTipNotification(message, Integer.valueOf(7000));
            return;
        }
        CallCloudHelper.showInvoiceAssistant((AbstractFormPlugin)this);
    }

    private void showAssignInvoiceList() {
        DynamicObject applyBill = this.getModel().getDataEntity(true);
        boolean isExist = QueryServiceHelper.exists((String)"ap_payapply", (Object)applyBill.getLong("id"));
        if (!isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u518d\u6307\u5b9a\u53d1\u7968\u3002", (String)"ApplyPayBillEdit4Inv_19", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        InvoiceAssignService assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue());
        ListShowParameter lsp = assignService.showInvoiceF7(this.getView(), new DynamicObject[]{applyBill});
        if (lsp != null) {
            HashSet<Long> finPks = new HashSet<Long>(2);
            finPks.add(this.getModel().getDataEntity().getLong("id"));
            this.getPageCache().put("finPks", JsonUtils.objToJson(finPks));
            this.getPageCache().put("businessSource", "ap_payapply");
            lsp.setCustomParam("applyassign", (Object)"true");
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invoiceF7"));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void invoiceAsstactWarn() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
        boolean hasConfigWarn = false;
        DynamicObject org = (DynamicObject)this.getModel().getValue("applyorg");
        if (org != null) {
            HashSet<Long> orgIds = new HashSet<Long>(1);
            Long orgId = org.getLong("id");
            orgIds.add(orgId);
            Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
            DynamicObject config = (DynamicObject)configByOrg.get(orgId);
            hasConfigWarn = EmptyUtils.isEmpty((Object)config) || config != null && ("2".equals(config.getString("identicalpartyinvcom")) || "".equals(config.getString("identicalpartyinvcom")));
        }
        DynamicObjectCollection invEntry = this.getModel().getEntryEntity("inventry");
        if (!hasConfigWarn || invEntry.isEmpty()) {
            return;
        }
        Set invoiceIds = invEntry.stream().map(invRow -> invRow.getLong("invid")).collect(Collectors.toSet());
        String asstactName = "";
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (!entry.isEmpty()) {
            asstactName = ((DynamicObject)entry.get(0)).getString("e_asstact.name");
        }
        QFilter filter = new QFilter("id", "in", invoiceIds);
        filter.and(new QFilter("asstactname", "=", (Object)asstactName));
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (invoiceCollection.isEmpty()) {
            Label label = (Label)this.getView().getControl("invasstactinfo_labelap");
            label.setText(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u6536\u6b3e\u4f9b\u5e94\u5546\u4e0e\u5f00\u7968\u516c\u53f8\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"ApplyPayBillEdit4Inv_8", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"invasstactinfoflex"});
        }
    }

    private void synInvoiceStatus() {
        EntryGrid invEntryGrid = (EntryGrid)this.getControl("inventry");
        int[] selectRows = invEntryGrid.getSelectRows();
        Set<Object> invoiceIds = new HashSet(8);
        DynamicObjectCollection invEntrys = this.getModel().getEntryEntity("inventry");
        if (selectRows != null && selectRows.length > 0) {
            for (int row : selectRows) {
                DynamicObject invEntry = (DynamicObject)invEntrys.get(row);
                long invId = invEntry.getLong("invid");
                if (invId == 0L) continue;
                invoiceIds.add(invId);
            }
        } else if (invEntrys.size() > 0) {
            invoiceIds = invEntrys.stream().filter(t -> t.getLong("invid") > 0L).map(t -> t.getLong("invid")).collect(Collectors.toSet());
        }
        if (invEntrys.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5173\u8054\u6536\u7968\u5355\u65e0\u9700\u540c\u6b65\u3002", (String)"ApplyPayBillEdit4Inv_9", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,invoicestatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        if (invoices.isEmpty() || invoiceIds.size() != invoices.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff0c\u518d\u540c\u6b65\u72b6\u6001\u3002", (String)"ApplyPayBillEdit4Inv_26", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errorInfos = new ArrayList<String>(8);
        for (DynamicObject invoiceRow : invoices) {
            String billNo = invoiceRow.getString("billno");
            String invoiceStatus = invoiceRow.getString("invoicestatus");
            Long invId = invoiceRow.getLong("id");
            if (ObjectUtils.isEmpty((Object)invoiceStatus)) {
                errorInfos.add(String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355\uff1a%s \u53d1\u7968\u72b6\u6001\u4e3a\u7a7a\u65e0\u9700\u540c\u6b65\u72b6\u6001\u3002", (String)"ApplyPayBillEdit4Inv_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), billNo));
                invoiceIds.remove(invId);
                continue;
            }
            if ("0".equals(invoiceStatus)) continue;
            errorInfos.add(String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355\uff1a%s \u975e\u6b63\u5e38\u53d1\u7968\u72b6\u6001\u65e0\u9700\u540c\u6b65\u72b6\u6001\u3002", (String)"ApplyPayBillEdit4Inv_11", (String)"fi-ap-formplugin", (Object[])new Object[0]), billNo));
            invoiceIds.remove(invId);
        }
        if (!invoiceIds.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("sendwarnmsg", "false");
            OperationResult result = OperationServiceHelper.executeOperate((String)"updateinvstatus", (String)"ap_invoice", (Object[])invoiceIds.toArray(new Object[0]), (OperateOption)option);
            if (result.isSuccess()) {
                DataSet latestInvoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_inv", (String)"ap_invoice", (String)"id,invoicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)}, (String)"");
                HashMap<Long, String> latestInvStatusMap = new HashMap<Long, String>(8);
                for (Row latestInv : latestInvoiceDataSet) {
                    latestInvStatusMap.put(latestInv.getLong("id"), latestInv.getString("invoicestatus"));
                }
                DynamicObjectCollection invEntry = this.getModel().getEntryEntity("inventry");
                for (int i = 0; i < invEntry.size(); ++i) {
                    long invId = ((DynamicObject)invEntry.get(i)).getLong("invid");
                    if (!invoiceIds.contains(invId)) continue;
                    this.getModel().setValue("i_invoicestatus", latestInvStatusMap.get(invId), i);
                }
                if (errorInfos.isEmpty()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"ApplyPayBillEdit4Inv_13", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u5173\u6ce8\u53d1\u7968\u72b6\u6001\u53d8\u5316\u3002", (String)"ApplyPayBillEdit4Inv_12", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
        if (errorInfos.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String errorInfo : errorInfos) {
            sb.append(errorInfo).append('\n');
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u540c\u6b65\u5b8c\u6210\u3002", (String)"ApplyPayBillEdit4Inv_14", (String)"fi-ap-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
        }
    }

    private void changeAsstactToClearInvEntry(String callBackID, String customValue) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long applyId = dataEntity.getLong("id");
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((String)"ap_payapply", (String)"id,inventry.invid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)applyId)});
        if ("isChangeAsstact".equals(callBackID)) {
            Map customValueMap = (Map)JsonUtils.jsonToObj((String)customValue, Map.class);
            long newAsstactId = Long.parseLong(String.valueOf(customValueMap.get("e_asstact")));
            int currentIndex = (Integer)customValueMap.get("currentIndex");
            Object asstactType = this.getModel().getValue("e_asstacttype", currentIndex);
            DynamicObject asstact = null;
            if (!ObjectUtils.isEmpty((Object)asstactType) && newAsstactId != 0L) {
                asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)newAsstactId, (String)String.valueOf(asstactType));
            }
            if (applyBill == null || applyBill.getDynamicObjectCollection("inventry").isEmpty()) {
                dataEntity.getDynamicObjectCollection("inventry").clear();
                this.getView().updateView("inventry");
                this.getModel().setValue("e_asstact", (Object)asstact, currentIndex);
                this.getView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
            } else {
                OperationResult saveResult = this.getView().invokeOperation("save");
                OperationHelper.assertResult((OperationResult)saveResult);
                Set invPks = applyBill.getDynamicObjectCollection("inventry").stream().map(inv -> inv.getLong("invid")).collect(Collectors.toSet());
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("invPks", JSONObject.toJSONString(invPks));
                OperationResult deleteInvRowResult = OperationServiceHelper.executeOperate((String)"deleteinventry", (String)"ap_payapply", (Object[])new Long[]{applyId}, (OperateOption)option);
                if (deleteInvRowResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                    this.getModel().setValue("e_asstact", (Object)asstact, currentIndex);
                } else {
                    OperationHelper.assertResult((OperationResult)deleteInvRowResult);
                }
            }
        } else if ("isChangeAsstactType".equals(callBackID)) {
            Map customValueMap = (Map)JsonUtils.jsonToObj((String)customValue, Map.class);
            Object eAsstactType = customValueMap.get("e_asstacttype");
            int currentIndex = (Integer)customValueMap.get("currentIndex");
            if (applyBill == null || applyBill.getDynamicObjectCollection("inventry").isEmpty()) {
                dataEntity.getDynamicObjectCollection("inventry").clear();
                this.getView().updateView("inventry");
                this.getModel().setValue("e_asstacttype", eAsstactType, currentIndex);
                this.getView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
            } else {
                OperationResult saveResult = this.getView().invokeOperation("save");
                OperationHelper.assertResult((OperationResult)saveResult);
                Set invPks = applyBill.getDynamicObjectCollection("inventry").stream().map(inv -> inv.getLong("invid")).collect(Collectors.toSet());
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("invPks", JSONObject.toJSONString(invPks));
                OperationResult deleteInvRowResult = OperationServiceHelper.executeOperate((String)"deleteinventry", (String)"ap_payapply", (Object[])new Long[]{applyId}, (OperateOption)option);
                if (deleteInvRowResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                    this.getModel().setValue("e_asstacttype", eAsstactType, currentIndex);
                } else {
                    OperationHelper.assertResult((OperationResult)deleteInvRowResult);
                }
            }
        } else {
            if (applyBill == null || applyBill.getDynamicObjectCollection("inventry").isEmpty()) {
                dataEntity.getDynamicObjectCollection("inventry").clear();
                this.getView().updateView("inventry");
                this.getView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
            } else {
                Set invPks = applyBill.getDynamicObjectCollection("inventry").stream().map(inv -> inv.getLong("invid")).collect(Collectors.toSet());
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("invPks", JSONObject.toJSONString(invPks));
                OperationResult deleteInvRowResult = this.getView().invokeOperation("deleteinventry", option);
                if (deleteInvRowResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                } else {
                    OperationHelper.assertResult((OperationResult)deleteInvRowResult);
                    return;
                }
            }
            int[] rowIndexs = (int[])JsonUtils.jsonToObj((String)customValue, int[].class);
            this.getModel().deleteEntryRows("entry", rowIndexs);
        }
    }
}

