/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalJouMappingInfo;

public class BalJouMapperEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save", "refresh"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("app".equals(key)) {
            this.initData();
        }
    }

    private void initData() {
        this.getModel().deleteEntryData("entryentity");
        BalJouMapper mapper = BalJouMapper.getMapper((boolean)this.isAp());
        ArrayList<String> fields = new ArrayList<String>();
        MainEntityType journalDataEntityType = MetadataServiceHelper.getDataEntityType((String)mapper.getJournalEntityKey());
        DataEntityPropertyCollection journalProps = journalDataEntityType.getProperties();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (IDataEntityProperty prop : journalProps) {
            LocaleString displayName = prop.getDisplayName();
            if (displayName == null) continue;
            LocaleString dis = new LocaleString(displayName.getLocaleValue() + "(" + prop.getName() + ")");
            items.add(new ComboItem(dis, prop.getName()));
            fields.add(prop.getName());
        }
        ComboEdit balanceCombo = (ComboEdit)this.getControl("journalfield");
        balanceCombo.setComboItems(items);
        MainEntityType balanceDataEntityType = MetadataServiceHelper.getDataEntityType((String)mapper.getBalanceEntityKey());
        DataEntityPropertyCollection balanceProps = balanceDataEntityType.getProperties();
        List<String> ignoreFields = this.getBalanceIgnoreFields();
        for (IDataEntityProperty prop : balanceProps) {
            BalJouMappingInfo.CalculateType calculateType;
            LocaleString displayName;
            String balanceField = prop.getName();
            if (ignoreFields.contains(balanceField) || (displayName = prop.getDisplayName()) == null) continue;
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("balancedisplayfield", (Object)(displayName.getLocaleValue() + "(" + balanceField + ")"), rowIndex);
            this.getModel().setValue("balancefield", (Object)balanceField, rowIndex);
            String journalField = mapper.getJournalField(balanceField);
            if (ObjectUtils.isEmpty((Object)journalField)) {
                if (fields.contains(balanceField)) {
                    this.getModel().setValue("journalfield", (Object)journalField, rowIndex);
                }
            } else {
                this.getModel().setValue("journalfield", (Object)journalField, rowIndex);
            }
            if ((calculateType = mapper.getCalculateType(balanceField)) == null) {
                if (prop instanceof AmountProp) {
                    this.getModel().setValue("relation", (Object)BalJouMappingInfo.CalculateType.SUM.toString(), rowIndex);
                } else {
                    this.getModel().setValue("relation", (Object)BalJouMappingInfo.CalculateType.DIMENSION.toString(), rowIndex);
                }
            } else {
                this.getModel().setValue("relation", (Object)calculateType.toString(), rowIndex);
            }
            this.getModel().setValue("formula", (Object)mapper.getFormula(balanceField), rowIndex);
        }
    }

    private List<String> getBalanceIgnoreFields() {
        ArrayList<String> ignoreFields = new ArrayList<String>();
        ignoreFields.add("id");
        ignoreFields.add("creator");
        ignoreFields.add("billno");
        ignoreFields.add("billstatus");
        ignoreFields.add("modifier");
        ignoreFields.add("auditor");
        ignoreFields.add("modifytime");
        ignoreFields.add("auditdate");
        ignoreFields.add("createtime");
        ignoreFields.add("appname");
        ignoreFields.add("startdate");
        ignoreFields.add("stopdate");
        ignoreFields.add("closeid");
        return ignoreFields;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refresh".equals(key)) {
            this.initData();
        }
    }

    private boolean isAp() {
        return "ap".equals(this.getModel().getValue("app"));
    }
}

