/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.arapcommon.balance.BalanceRebuildService;
import kd.fi.arapcommon.journal.CheckJournalService;
import kd.fi.arapcommon.journal.JournalCheckResult;
import kd.fi.arapcommon.journal.JournalRebuildService;
import kd.fi.arapcommon.journal.JournalService;

public class BalanceRebuildFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkjournal", "rebuildbalance", "rebuildjournal", "repair"});
        Toolbar control = (Toolbar)this.getControl("advcontoolbarap");
        control.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("repair".equals(itemKey)) {
            this.repair();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "checkjournal": {
                this.checkJournal();
                break;
            }
            case "rebuildbalance": {
                this.rebuildBalance();
                break;
            }
            case "rebuildjournal": {
                this.rebuildJournal();
                break;
            }
        }
    }

    private void repair() {
        DynamicObjectCollection errorEntry = this.getModel().getEntryEntity("errorentry");
        JournalService journalService = new JournalService();
        for (DynamicObject errRow : errorEntry) {
            DynamicObject[] bills;
            String errType = errRow.getString("errortype");
            String entityKey = errRow.getString("billtype");
            String billno = errRow.getString("billno");
            if ("NoJournal".equals(errType)) {
                QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billno)};
                bills = BusinessDataServiceHelper.load((String)entityKey, (String)"id", (QFilter[])filters);
                journalService.pushAndSaveJournals(bills);
                continue;
            }
            if ("RepetitiveJournals".equals(errType)) {
                QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billno)};
                bills = BusinessDataServiceHelper.load((String)entityKey, (String)"id", (QFilter[])filters);
                journalService.deleteJournals(bills);
                journalService.pushAndSaveJournals(bills);
                continue;
            }
            if (!"NoSourceBill".equals(errType)) continue;
            long journalId = Long.parseLong(billno);
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)journalId)};
            DeleteServiceHelper.delete((String)entityKey, (QFilter[])filters);
        }
        this.getModel().deleteEntryData("errorentry");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f\u3002", (String)"BalanceRebuildFormPlugin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
    }

    private Long[] getOrgIds() {
        DynamicObjectCollection orgCollection = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgCollection.isEmpty()) {
            return new Long[0];
        }
        Long[] orgIds = new Long[orgCollection.size()];
        for (int i = 0; i < orgCollection.size(); ++i) {
            Long orgId;
            orgIds[i] = orgId = (Long)((DynamicObject)orgCollection.get(i)).getDynamicObject("fbasedataid").getPkValue();
        }
        return orgIds;
    }

    private void rebuildJournal() {
        this.requireOrgNotNull();
        Date date = (Date)this.getModel().getValue("date");
        String app = (String)this.getModel().getValue("app");
        Long[] orgIds = this.getOrgIds();
        JournalRebuildService journalRebuildService = new JournalRebuildService(Arrays.asList(orgIds), date, new Date());
        journalRebuildService.rebuild(app);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u6c34\u91cd\u5efa\u6210\u529f\u3002", (String)"BalanceRebuildFormPlugin_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
    }

    private void rebuildBalance() {
        Long[] orgIds;
        this.requireOrgNotNull();
        Date date = (Date)this.getModel().getValue("date");
        String app = (String)this.getModel().getValue("app");
        for (Long org : orgIds = this.getOrgIds()) {
            BalanceRebuildService service = new BalanceRebuildService(org, date, app);
            service.rebuild();
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f59\u989d\u91cd\u7b97\u6210\u529f\u3002", (String)"BalanceRebuildFormPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
    }

    private void checkJournal() {
        this.requireOrgNotNull();
        Date date = (Date)this.getModel().getValue("date");
        String app = (String)this.getModel().getValue("app");
        Long[] orgIds = this.getOrgIds();
        CheckJournalService checkService = new CheckJournalService(orgIds, date, new Date(), app);
        List results = checkService.check(app);
        this.clearEntryValue("errorentry");
        if (results.size() != 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[]{"billtype", "billno", "errortype", "supplement"});
            for (int i = results.size() - 1; i >= 0; --i) {
                String billType = ((JournalCheckResult)results.get(i)).getBillType();
                String billNo = ((JournalCheckResult)results.get(i)).getBillNo();
                String errorType = ((JournalCheckResult)results.get(i)).getErrorType();
                String supplement = ((JournalCheckResult)results.get(i)).getSupplement();
                vs.addRow(new Object[]{billType, billNo, errorType, supplement});
            }
            model.batchCreateNewEntryRow("errorentry", vs);
            model.endInit();
            this.getView().updateView("errorentry");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u6d41\u6c34\u5b8c\u6210\u3002", (String)"BalanceRebuildFormPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
    }

    private void requireOrgNotNull() {
        Long[] orgIds = this.getOrgIds();
        if (orgIds.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceRebuildFormPlugin_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void clearEntryValue(String entryEntity) {
        this.getModel().deleteEntryData(entryEntity);
    }
}

