/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;

class BizCountGroup {
    protected String groupName;
    protected BigDecimal beginAmount;
    protected BigDecimal endAmount;
    protected String color;

    public BizCountGroup(String groupName, BigDecimal beginAmount, BigDecimal endAmount, String color) {
        this.groupName = groupName;
        this.beginAmount = beginAmount;
        this.endAmount = endAmount;
        this.color = color;
    }

    public boolean match(BigDecimal amount) {
        if (this.beginAmount == null) {
            return this.endAmount.compareTo(amount) > 0;
        }
        if (this.endAmount == null) {
            return this.beginAmount.compareTo(amount) < 0;
        }
        return this.beginAmount.compareTo(amount) <= 0 && this.endAmount.compareTo(amount) >= 0;
    }

    public static List<BizCountGroup> getDefaultGroups() {
        ArrayList<BizCountGroup> defaultGroupList = new ArrayList<BizCountGroup>();
        defaultGroupList.add(new BizCountGroup(ResManager.loadKDString((String)"\u5927\u4e8e100\u4e07", (String)"BizCountAnalysisPlugin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), new BigDecimal(1000000), null, "#3CB371"));
        defaultGroupList.add(new BizCountGroup(ResManager.loadKDString((String)"50\uff5e100\u4e07", (String)"BizCountAnalysisPlugin_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), new BigDecimal(500000), new BigDecimal(1000000), "#1E90FF"));
        defaultGroupList.add(new BizCountGroup(ResManager.loadKDString((String)"\u5c0f\u4e8e50\u4e07", (String)"BizCountAnalysisPlugin_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), null, new BigDecimal(500000), "#FFCC00"));
        return defaultGroupList;
    }
}

