/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.form.field.DateEdit;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusApPeriodBillEdit
extends AbstractBillPlugIn {
    private InitHelper init;
    private boolean onlyExist = false;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createNewModel();
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ObjectUtils.isEmpty((Object)this.init) && ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            return;
        }
        if (((Boolean)this.getModel().getValue("isPeriod")).booleanValue()) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            if (this.init == null) {
                this.creatInit();
            }
            this.bindData();
            this.fillToolBar();
        }
    }

    private void fillToolBar() {
        if (this.onlyExist) {
            return;
        }
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit"});
        }
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
        }
    }

    private void bindData() {
        if (this.init.getStartDate() == null) {
            return;
        }
        Date startDate = this.init.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMaxDate(lastDay);
    }

    private void creatInit() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = (Long)org.getPkValue();
        this.init = new InitHelper(orgId, "ap_init");
    }

    private void createNewModel() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ApFinCoreBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = (Long)org.getPkValue();
        if (((Boolean)model.getValue("isPeriod")).booleanValue()) {
            this.init = new InitHelper(orgId, "ap_init");
            if (ObjectUtils.isEmpty((Object)this.init.getStartDate())) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BusApPeriodBillEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
                this.getView().showErrorNotification(msg);
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_save4woff"});
                this.onlyExist = true;
                return;
            }
            this.createByInit();
            boolean isFinishInit = this.init.isFinishInit();
            if (isFinishInit) {
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"BusApPeriodBillEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
                this.getView().showErrorNotification(msg);
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_save4woff"});
                this.onlyExist = true;
                return;
            }
        }
    }

    private void createByInit() {
        DynamicObject cur = this.init.getStandardCurrency();
        this.getModel().setValue("currency", cur.getPkValue());
        this.getModel().setValue("basecurrency", cur.getPkValue());
        this.getModel().setValue("exchangerate", (Object)1);
        this.getModel().setValue("exratetable", this.init.getExrateTable().getPkValue());
        Date startDate = this.init.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        this.getModel().setValue("bizdate", (Object)lastDay);
        this.getModel().setValue("duedate", (Object)lastDay);
        this.getModel().setValue("exratedate", (Object)lastDay);
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        if (((Boolean)model.getValue("isPeriod")).booleanValue()) {
            DynamicObject org = (DynamicObject)model.getValue("org");
            long orgId = (Long)org.getPkValue();
            this.init = new InitHelper(orgId, "ap_init");
            Date startDate = this.init.getStartDate();
            Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
            this.getModel().setValue("bizdate", (Object)lastDay);
            this.getModel().setValue("exratedate", (Object)lastDay);
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                this.getModel().setValue("duedate", (Object)lastDay);
            }
            if (this.init.isFinishInit()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher"});
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u590d\u5236\u671f\u521d\u5355\u636e\u3002", (String)"BusApPeriodBillEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
                this.getView().showErrorNotification(msg);
            }
        }
    }
}

