/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.fi.ap.formplugin.ApAbstractImport;
import kd.fi.ap.helper.BaseDataHelper;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;

public class BusBillImport
extends ApAbstractImport {
    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            boolean isPeriod = this.isPeriod(data);
            this.checkOrgNew();
            this.checkText("remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BusBillImport_17", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, 255, null);
            data.remove("billstatus");
            if (isPeriod) {
                if (this.init.isFinishInit()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"BusBillImport_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"BusBillImport_23", (String)"fi-ap-formplugin", (Object[])new Object[0]), true, null, this.init.getStartDate(), null);
            } else {
                Date currentDate = this.init.getCurrentDate();
                if (ObjectUtils.isEmpty((Object)currentDate)) {
                    currentDate = this.init.getStartDate();
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"BusBillImport_23", (String)"fi-ap-formplugin", (Object[])new Object[0]), true, currentDate, null, null);
            }
            JSONObject currencyData = (JSONObject)data.get("currency");
            Optional<DynamicObject> currencyOptional = this.getDynamicObjectByNumberOrName("bd_currency", currencyData, "id,number,name,amtprecision,priceprecision");
            if (!currencyOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u5e01\u201d\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"BusBillImport_22", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            int amtprecision = currencyOptional.get().getInt("amtprecision");
            int priceprecision = currencyOptional.get().getInt("priceprecision");
            currencyData.put("number", (Object)currencyOptional.get().getString("number"));
            this.checkExchangeRate(currencyOptional.get().getLong("id"));
            String asstacttype = (String)data.get("asstacttype");
            if (ObjectUtils.isEmpty((Object)asstacttype)) {
                data.put("asstacttype", "bd_supplier");
            }
            this.checkNull("asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"BusBillImport_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.checkAsstAct();
            this.checkF7("paycond", ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"BusBillImport_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("settlementtype", ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"BusBillImport_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("purorg", ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7", (String)"BusBillImport_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("purdept", ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4", (String)"BusBillImport_8", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("purchaser", ResManager.loadKDString((String)"\u91c7\u8d2d\u5458", (String)"BusBillImport_9", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            boolean includeTax = this.includeTax(data);
            data.put("isincludetax", includeTax);
            JSONArray entryList = (JSONArray)data.get("entry");
            if (entryList != null) {
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject entry = (JSONObject)entryList.get(i);
                    String isMaterial = this.isMaterial();
                    if ("false".equals(isMaterial)) {
                        this.checkEntryNull("e_expenseitem", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"BusBillImport_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                    } else if ("true".equals(isMaterial)) {
                        this.checkEntryNull("e_material", ResManager.loadKDString((String)"\u7269\u6599", (String)"BusBillImport_11", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        this.checkEntryNull("e_measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"BusBillImport_12", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        this.checkEntryF7("e_measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"BusBillImport_12", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i, false, null);
                    }
                    if (entry.get((Object)"e_quantity") == null) {
                        entry.put("e_quantity", (Object)0);
                    }
                    if (entry.get((Object)"e_unitprice") == null) {
                        entry.put("e_unitprice", (Object)0);
                    }
                    this.checkEntryEnum("e_discountmode", ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f", (String)"BusBillImport_13", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i, false, new String[]{"PERCENT", "PERUNIT", "NULL"}, "NULL");
                    if (!this.ispresent(entry, "e_ispresent")) {
                        if (includeTax) {
                            this.checkEntryNullOrZero("e_taxunitprice", ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u5f00\u542f\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7", (String)"BusBillImport_19", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        } else {
                            this.checkEntryNullOrZero("e_unitprice", ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u5173\u95ed\u65f6\uff0c\u5355\u4ef7", (String)"BusBillImport_20", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        }
                        this.sumEntryAmt(entry, amtprecision, priceprecision, includeTax);
                        continue;
                    }
                    entry.put("e_unitprice", (Object)BigDecimal.ZERO);
                    entry.put("e_taxunitprice", (Object)BigDecimal.ZERO);
                }
                this.sumHeadAmt();
                data.put("isperiod", isPeriod);
            }
        }
        catch (Exception exc) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            return false;
        }
        return true;
    }

    private void checkAsstAct() {
        JSONObject value = (JSONObject)this.data.get("asstact");
        if (value == null) {
            return;
        }
        Optional<DynamicObject> assactTypeOptional = this.getDynamicObjectByNumberOrName(this.data.get("asstacttype").toString(), value, "id,number,name");
        if (!assactTypeOptional.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"BusBillImport_15", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        value.put("number", (Object)assactTypeOptional.get().getString("number"));
    }

    private void checkExchangeRate(long currencyId) throws ParseException {
        JSONObject currency = (JSONObject)this.data.get("currency");
        JSONObject baseCurrency = (JSONObject)this.data.get("basecurrency");
        if (currency.get((Object)"number").equals(baseCurrency.get((Object)"number"))) {
            this.data.put("exchangerate", "1");
            return;
        }
        BigDecimal value = this.parseBigDecimal(this.data.get("exchangerate"));
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            String strValue = (String)this.data.get("bizdate");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date bizDate = df.parse(strValue);
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)currencyId, (Long)this.baseCurrencyId, (Long)this.orgId, (Date)bizDate);
            this.data.put("exchangerate", exchangeRate);
        }
    }

    private void sumHeadAmt() {
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxloc = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        BigDecimal uninvoicedlocamt = BigDecimal.ZERO;
        JSONArray entryList = (JSONArray)this.data.get("entry");
        for (int i = 0; i < entryList.size(); ++i) {
            JSONObject row = (JSONObject)entryList.get(i);
            BigDecimal epricetaxtotal = this.parseBigDecimal(row.get((Object)"e_pricetaxtotal"));
            BigDecimal epricetaxtotalBase = this.parseBigDecimal(row.get((Object)"e_pricetaxtotalbase"));
            BigDecimal eamount = this.parseBigDecimal(row.get((Object)"e_amount"));
            BigDecimal eamountBase = this.parseBigDecimal(row.get((Object)"e_localamt"));
            BigDecimal etax = this.parseBigDecimal(row.get((Object)"e_tax"));
            BigDecimal etaxloc = this.parseBigDecimal(row.get((Object)"e_taxlocalamt"));
            BigDecimal euninvoicedamt = this.parseBigDecimal(row.get((Object)"e_uninvoicedamt"));
            BigDecimal euninvoicedlocamt = this.parseBigDecimal(row.get((Object)"e_uninvoicedlocamt"));
            pricetaxtotal = pricetaxtotal.add(epricetaxtotal);
            pricetaxtotalBase = pricetaxtotalBase.add(epricetaxtotalBase);
            amount = amount.add(eamount);
            amountBase = amountBase.add(eamountBase);
            tax = tax.add(etax);
            taxloc = taxloc.add(etaxloc);
            uninvoicedamt = uninvoicedamt.add(euninvoicedamt);
            uninvoicedlocamt = uninvoicedlocamt.add(euninvoicedlocamt);
        }
        this.data.put("pricetaxtotal", pricetaxtotal);
        this.data.put("pricetaxtotalbase", pricetaxtotalBase);
        this.data.put("amount", amount);
        this.data.put("localamt", amountBase);
        this.data.put("tax", tax);
        this.data.put("taxlocamt", taxloc);
        this.data.put("uninvoicedamt", uninvoicedamt);
        this.data.put("uninvoicedlocamt", uninvoicedlocamt);
    }

    protected void sumEntryAmt(JSONObject row, int amtprecision, int priceprecision, boolean includeTax) {
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        BigDecimal quantity = this.getEntryBigDecimal(row, "e_quantity");
        row.put("e_uninvoicedqty", (Object)quantity.toPlainString());
        JSONObject value = (JSONObject)row.get((Object)"taxrateid");
        BigDecimal taxRate = BigDecimal.ZERO;
        if (value != null) {
            DynamicObject taxRateInfo = this.getTaxRateByNameOrNumber(value.getString("name"), value.getString("number"));
            Object taxrate = taxRateInfo.get("taxrate");
            if (taxrate != null) {
                taxRate = (BigDecimal)taxrate;
            }
        } else {
            taxRate = this.getEntryBigDecimal(row, "taxrate");
        }
        PriceLocalCalculator localCalculator = null;
        String discountMode = (String)row.get((Object)"e_discountmode");
        BigDecimal discountRate = this.getEntryBigDecimal(row, "e_discountrate");
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal taxunitprice = this.getEntryBigDecimal(row, "e_taxunitprice");
            calculator = new TaxUnitPriceCalculator(quantity, taxunitprice, taxRate, discountMode, discountRate, amtprecision);
        } else {
            BigDecimal unitprice = this.getEntryBigDecimal(row, "e_unitprice");
            calculator = new UnitPriceCalculator(quantity, unitprice, taxRate, discountMode, discountRate, amtprecision);
        }
        localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, this.baseCurrencyPrecision);
        localCalculator.calculate();
        row.put("e_unitprice", (Object)localCalculator.getUnitprice());
        row.put("e_actunitprice", (Object)localCalculator.getActunitprice());
        row.put("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
        row.put("e_discountamount", (Object)localCalculator.getDiscountamount());
        row.put("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
        row.put("e_tax", (Object)localCalculator.getTax());
        row.put("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
        row.put("e_amount", (Object)localCalculator.getAmount());
        row.put("e_localamt", (Object)localCalculator.getAmountlocal());
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        row.put("e_pricetaxtotal", (Object)recamount);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        row.put("e_pricetaxtotalbase", (Object)reclocalamt);
        row.put("e_uninvoicedqty", (Object)quantity);
        row.put("e_uninvoicedamt", (Object)recamount);
        row.put("e_uninvoicedlocamt", (Object)reclocalamt);
    }

    protected boolean isPeriod(Map<String, Object> data) {
        if (data.get("isperiod") != null) {
            return (Boolean)data.get("isperiod");
        }
        return true;
    }

    protected boolean includeTax(Map<String, Object> data) {
        boolean include = false;
        if (data.get("isincludetax") != null) {
            include = (Boolean)data.get("isincludetax");
        }
        return include;
    }
}

