/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.PushAndSave;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BillTypeEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.fin.ApEditInBulkService;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.formplugin.formservice.fin.FinApBillAmtCalculateHandler;
import kd.fi.ap.formplugin.formservice.fin.FinApBillClickHandler;
import kd.fi.ap.formplugin.formservice.fin.FinApBillFormHelper;
import kd.fi.ap.formplugin.formservice.fin.FinApBillImportHelper;
import kd.fi.ap.formplugin.formservice.fin.FinApBillPlanEntryHelper;
import kd.fi.ap.formplugin.formservice.fin.FinApBillPropertyChangeHandler;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.mservice.assign.ApDeleteInvEntryService;
import kd.fi.ap.vo.ApInvDeleteParam;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.ArApBaseAllocationPlugin;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.form.FxLocalAmtHandler;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.MaterialFilterHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.service.plan.split.PlanRowSplitService;
import kd.fi.arapcommon.service.plan.split.helper.ConditionServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.sdk.fi.ar.extpoint.plan.IPlanRowSplit;
import org.apache.commons.lang.StringUtils;

public class FinApBillEdit
extends ArApBaseAllocationPlugin
implements EntryGridBindDataListener {
    private InitHelper initInfo;
    private boolean isValidatePass = true;
    private boolean isCopyEntryRow = false;
    private Map<String, Object> suppliersMap;
    private FinApBillPropertyChangeHandler propertyChangeHandler;
    private FinApBillClickHandler clickAndItemClickHandler;
    private FinApBillAmtCalculateHandler amtCalculateHandler;
    private FxLocalAmtHandler fxLocalAmtHandler;
    private Map<String, Object> splitRowMap = new HashMap<String, Object>(16);
    private PluginProxy<IPlanRowSplit> planSplitPlugin;
    private FinApBillImportHelper importHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterBillType();
        this.filterMaterial();
        this.filterMaterialVersion();
        this.filterMeasureUnit();
        this.filterTaxrate();
        this.filterPayProperty();
        this.filterConfiguredCode();
        this.filterAsstact();
        this.filterInvoiceBizType();
        this.addClickListeners(new String[]{"payeebanknum", "settleinfo_view", "settleinfo_ignore", "sameinfo_view", "sameinfo_ignore", "invasstactinfo_ignore", "presettleinfo_view", "presettleinfo_ignore"});
        this.addClickListeners(new String[]{"corebilltype", "corebillno"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("detailentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        boolean isOrgFinished;
        boolean isPeriod;
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        boolean bl = isPeriod = parameter.getCustomParam("isPeriod") != null && (Boolean)parameter.getCustomParam("isPeriod") != false;
        if (model.isFromImport()) {
            return;
        }
        this.setDefaultOrg();
        boolean isHasAuthOrg = this.checkHasAuthOrg();
        if (!isHasAuthOrg) {
            return;
        }
        boolean isOrgInit = this.checkOrgIsInit();
        if (!isOrgInit) {
            return;
        }
        if (isPeriod && (isOrgFinished = this.checkOrgIsFinished())) {
            return;
        }
        this.setHeadDefaultValue();
        this.setPlanEntryDefaultValue();
    }

    public void afterLoadData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        Object billStatus = this.getModel().getValue("billstatus");
        if ("B".equals(billStatus) || "A".equals(billStatus)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0023", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        this.setHeadValueForCopy();
        this.setHeadAmtAndEntryInfoForCopy();
        this.resetPremiumInfo();
        model.deleteEntryData("inventry");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IBillModel model = (IBillModel)this.getModel();
        Boolean isPeriod = (Boolean)model.getValue("isperiod");
        if (isPeriod.booleanValue()) {
            this.fillToolBarForPeriod();
        } else {
            this.fillToolBar();
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        this.loadInitInfo();
        this.materialSettleHideButten();
        if (isPeriod.booleanValue()) {
            this.setDatePropRangeForPeriod();
        } else {
            this.setDatePropRange();
        }
        BookDateHelper.setBookDateRange((IFormView)this.getView(), (boolean)false);
        if (isPeriod.booleanValue()) {
            return;
        }
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtypeid");
        if (EmptyUtils.isNotEmpty((Object)sourceBillType) && EmptyUtils.isNotEmpty((Object)billtype) && "ApFin_borr_BT_S".equals(billtype.getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_copy"});
        }
        this.paySettleWarn();
        this.controlVisibleForMTO();
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        this.setAsstactCaption();
        this.getView().setVisible(Boolean.FALSE, new String[]{"taxdeductionflex"});
        this.invAsstactWarn();
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
        String ignoreTypes = StdConfig.get((String)"ignore.billTypes");
        String billTypeNum = this.getModel().getDataEntity().getString("billtypeid.number");
        if (ignoreTypes != null && ignoreTypes.contains(billTypeNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"istaxdeduction"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"istaxdeduction"});
            this.taxDeductionWarn();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.initPropertyChangeHandler();
        this.propertyChangeHandler.propertyChanged(e);
    }

    private void initPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new FinApBillPropertyChangeHandler((AbstractBillPlugIn)this);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("detailentry")) {
            this.deleteDetailEntry(e.getRowIndexs());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if (e.getEntryProp().getName().equals("detailentry")) {
            this.calculatePlanEntryAndSetHeadDueDate();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        block6: {
            super.afterAddRow(e);
            String entryName = e.getEntryProp().getName();
            if (!"detailentry".equals(entryName)) break block6;
            if (this.isCopyEntryRow) {
                for (RowDataEntity row : e.getRowDataEntities()) {
                    this.calculateAllAmtByDetailEntry(row.getRowIndex(), "", BigDecimal.ZERO);
                    if (this.splitRowMap.isEmpty()) continue;
                    this.getModel().setValue("corebilltype", this.splitRowMap.get("corebilltype"), row.getRowIndex());
                    this.getModel().setValue("corebillno", this.splitRowMap.get("corebillno"), row.getRowIndex());
                    this.getModel().setValue("corebillid", this.splitRowMap.get("corebillid"), row.getRowIndex());
                    this.getModel().setValue("corebillentryseq", this.splitRowMap.get("corebillentryseq"), row.getRowIndex());
                    this.getModel().setValue("corebillentryid", this.splitRowMap.get("corebillentryid"), row.getRowIndex());
                    this.getModel().setValue("e_conbillentity", this.splitRowMap.get("e_conbillentity"), row.getRowIndex());
                    this.getModel().setValue("e_conbillnumber", this.splitRowMap.get("e_conbillnumber"), row.getRowIndex());
                    this.getModel().setValue("e_conbillrownum", this.splitRowMap.get("e_conbillrownum"), row.getRowIndex());
                    this.getModel().setValue("e_conbillid", this.splitRowMap.get("e_conbillid"), row.getRowIndex());
                    this.getModel().setValue("e_conbillentryid", this.splitRowMap.get("e_conbillentryid"), row.getRowIndex());
                    this.getModel().setValue("groupnumber", this.splitRowMap.get("groupnumber"), row.getRowIndex());
                    this.getModel().setValue("groupseq", this.splitRowMap.get("groupseq"), row.getRowIndex());
                    this.getModel().setValue("e_sourcebillid", this.splitRowMap.get("e_sourcebillid"), row.getRowIndex());
                    this.getModel().setValue("e_sourcebillentryid", this.splitRowMap.get("e_sourcebillentryid"), row.getRowIndex());
                    this.getModel().setValue("e_splitdimensionid", this.splitRowMap.get("e_splitdimensionid"), row.getRowIndex());
                    this.splitRowMap.clear();
                }
            } else {
                if (this.suppliersMap == null || this.suppliersMap.size() == 0) {
                    this.suppliersMap = FinApBillHelper.setSuppliersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
                }
                Object invoiceSupplierId = this.suppliersMap.get("invoiceSupplierId");
                Object deliverSupplierId = this.suppliersMap.get("deliverSupplierId");
                for (RowDataEntity row : e.getRowDataEntities()) {
                    int rowIndex = row.getRowIndex();
                    if (EmptyUtils.isNotEmpty((Object)invoiceSupplierId) && !"0".equals(invoiceSupplierId)) {
                        this.getModel().setValue("e_invoicesupplierid", invoiceSupplierId, rowIndex);
                    }
                    if (!EmptyUtils.isNotEmpty((Object)deliverSupplierId) || "0".equals(deliverSupplierId)) continue;
                    this.getModel().setValue("e_deliversupplierid", deliverSupplierId, rowIndex);
                }
            }
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        BizExtendHelper.afterImportDataApExt((ImportDataEventArgs)e, (Object)((Object)this.getImportHelper()), (IDataModel)this.getModel());
    }

    private void initClickHandler() {
        if (this.clickAndItemClickHandler == null) {
            this.clickAndItemClickHandler = new FinApBillClickHandler((AbstractBillPlugIn)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.initClickHandler();
        this.clickAndItemClickHandler.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.initClickHandler();
        this.clickAndItemClickHandler.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "editinbulk": {
                Map returnMap = (Map)returnData;
                if (ObjectUtils.isEmpty((Object)returnMap)) {
                    return;
                }
                DynamicObjectCollection returnEntrys = (DynamicObjectCollection)returnMap.get("entrys");
                Map srcEntryRowMap = (Map)returnMap.get("srcEntryRowMap");
                ApEditInBulkService editInBulkService = new ApEditInBulkService(this.getView(), this.getPluginName());
                editInBulkService.returnParent(returnEntrys, srcEntryRowMap);
                this.getPageCache().put("iseditinbulk", "true");
                this.calculateAllocationDetail();
                this.getView().updateView();
                break;
            }
            case "assaccount": {
                this.closeassaccountF7(returnData);
                break;
            }
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"detailentry", (Object)returnData);
                this.getView().updateView("detailentry");
                break;
            }
            case "refresh": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "ap_totaladjust": {
                Map resultMap = (Map)returnData;
                OperateOption option = OperateOption.create();
                if (resultMap == null) break;
                Map adjustMap = (Map)resultMap.get("resultMap");
                option.setVariableValue("adjusttotalamt", adjustMap.get("adjusttotalamt").toString());
                option.setVariableValue("adjusttotaltaxamt", adjustMap.get("adjusttotaltaxamt").toString());
                option.setVariableValue("adjusttype", adjustMap.get("adjusttype").toString());
                Map extFiledsMap = (Map)resultMap.get("extFiledsMap");
                if (extFiledsMap != null && extFiledsMap.size() > 0) {
                    for (Map.Entry entry : extFiledsMap.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        option.setVariableValue(key, value.toString());
                    }
                }
                this.getView().invokeOperation("billmodify", option);
                break;
            }
            case "ap_totaldiscount": {
                Map discountMap = (Map)returnData;
                if (!EmptyUtils.isNotEmpty((Object)discountMap)) break;
                this.setEntryDiscountAmt(discountMap);
                break;
            }
            case "operationConfirm": {
                if (e.getReturnData() == null) break;
                DynamicObject finApBill = this.getModel().getDataEntity();
                if (finApBill.getBoolean("istanspay")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8f6c\u4ed8\u4e1a\u52a1\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u51b2\u9500\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinApBillEdit_29", (String)"fi-ap-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("writeoff"));
                    break;
                }
                this.getView().invokeOperation("writeoff");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        IFormView view = this.getView();
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "writeoff") && isOK) {
            view.invokeOperation("writeoff");
        } else if ("biztype".equals(callBackID)) {
            if (isOK) {
                String type = (String)this.getModel().getValue("asstacttype");
                if ("bd_supplier".equals(type)) {
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("asstact");
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (!this.isVmi(bizType, supplier)) {
                        this.getModel().setValue("asstact", null);
                    }
                }
                this.clearEntry();
                this.calculateAllAmtByHead();
            } else {
                String biztypeId = this.getPageCache().get("OLDBIZTYPEID");
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)biztypeId)) {
                    this.getModel().beginInit();
                    this.getModel().setValue("biztype", (Object)Long.parseLong(biztypeId));
                    this.getModel().endInit();
                    this.getView().updateView("biztype");
                }
            }
            this.getPageCache().remove("OLDBIZTYPEID");
        } else if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            view.invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ap_finapbill", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        } else if ((Objects.equals(callBackID, "isClearInvEntry") || Objects.equals(callBackID, "isClearInvEntryByAsstType")) && isOK) {
            this.changeAsstactToClearInvEntry(callBackID, e.getCustomVaule());
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        this.controlEnableForMTO(entities);
    }

    private void changeAsstactToClearInvEntry(String callBackID, String customValue) {
        HashSet<Long> delRowIds = new HashSet<Long>(64);
        DynamicObjectCollection invEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("inventry");
        for (int i = invEntry.size() - 1; i >= 0; --i) {
            DynamicObject invRow = (DynamicObject)invEntry.get(i);
            if (ObjectUtils.isEmpty((Object)invRow.getString("i_billno"))) {
                invEntry.remove(i);
                continue;
            }
            delRowIds.add(invRow.getLong("invid"));
        }
        if (delRowIds.isEmpty()) {
            this.getView().updateView("inventry");
        } else {
            ApInvDeleteParam delParam = new ApInvDeleteParam();
            delParam.setByView(true);
            delParam.setDelRowIds(delRowIds);
            ApDeleteInvEntryService deleteInvEntryService = new ApDeleteInvEntryService();
            deleteInvEntryService.initDelParam(delParam);
            deleteInvEntryService.delApInvEntrys(new DynamicObject[]{this.getModel().getDataEntity(true)});
            this.getView().invokeOperation("refresh");
        }
        if ("isClearInvEntry".equals(callBackID)) {
            Object asstactType = this.getModel().getValue("asstacttype");
            DynamicObject asstact = null;
            if (!ObjectUtils.isEmpty((Object)asstactType)) {
                asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(customValue), (String)String.valueOf(asstactType));
            }
            this.getModel().setValue("asstact", asstact);
        } else {
            this.getModel().setValue("asstacttype", (Object)customValue);
        }
    }

    private void setDefaultOrg() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org) && !ObjectUtils.isEmpty((Object)(org = OrgHelper.getAuthorizedBankOrg((String)"ap", (String)"ap_finapbill", (String)"47156aff000000ac")))) {
            model.setValue("org", (Object)org.getLong("id"));
        }
    }

    private boolean checkHasAuthOrg() {
        boolean checkResult = true;
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            checkResult = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ApFinCoreBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        return checkResult;
    }

    private boolean checkOrgIsInit() {
        boolean checkResult = true;
        this.loadInitInfo();
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            IBillModel model = (IBillModel)this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"FinApBillEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.isValidatePass = false;
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkOrgIsFinished() {
        boolean checkResult = false;
        this.loadInitInfo();
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (this.initInfo.getInitId() != null && this.initInfo.isFinishInit()) {
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"FinApPeriodBillEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
            this.getView().showErrorNotification(msg);
            this.isValidatePass = false;
            checkResult = true;
        }
        return checkResult;
    }

    private void loadInitInfo() {
        if (this.initInfo == null) {
            IBillModel model = (IBillModel)this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            long orgId = (Long)org.getPkValue();
            this.initInfo = new InitHelper(orgId, "ap_init");
        }
    }

    private void setHeadDefaultValue() {
        DynamicObject org;
        boolean isPeriod;
        IBillModel model = (IBillModel)this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.getCustomParam("isPeriod") != null) {
            model.setValue("isperiod", parameter.getCustomParam("isPeriod"));
        }
        if (isPeriod = ((Boolean)model.getValue("isperiod")).booleanValue()) {
            DynamicObject cur = this.initInfo.getStandardCurrency();
            model.setValue("currency", cur.getPkValue());
            model.setValue("basecurrency", cur.getPkValue());
            model.setValue("exchangerate", (Object)1);
            model.setValue("exratetable", this.initInfo.getExrateTable().getPkValue());
            Date startDate = this.initInfo.getStartDate();
            Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
            model.setValue("bizdate", (Object)lastDay);
            model.setValue("exratedate", (Object)lastDay);
        } else {
            FinApBillFormHelper.createByInit(this.getModel(), this.getPageCache(), this.initInfo);
        }
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)false);
        long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
        if (settleTypeId != 0L) {
            model.setValue("settlementtype", (Object)settleTypeId);
        }
        if (EmptyUtils.isEmpty((Object)model.getValue("payorg")) && (org = (DynamicObject)model.getValue("org")).getBoolean("fisbankroll")) {
            model.setValue("payorg", org.getPkValue());
        }
        model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
        DynamicObject finBill = this.getModel().getDataEntity(true);
        DynamicObject splitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill);
        model.setValue("splitscheme", (Object)splitScheme);
        Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)finBill);
        model.setValue("termsdate", (Object)basicDate);
    }

    private void setPlanEntryDefaultValue() {
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void calculatePlanEntryAndSetHeadDueDate() {
        FinApBillPlanEntryHelper.calculatePlanEntryAndSetHeadDueDate(this.getView(), this.getPlanSplitPluginProvider());
    }

    private PluginProxy<IPlanRowSplit> getPlanSplitPluginProvider() {
        if (this.planSplitPlugin == null) {
            this.planSplitPlugin = PluginProxy.create((Object)PlanRowSplitService.getInstance(), IPlanRowSplit.class, (String)"FI_AP_PLANENTRY_SPLIT");
        }
        return this.planSplitPlugin;
    }

    private void setDatePropRange() {
        Date bizDate;
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            return;
        }
        Date currentDate = this.initInfo.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.initInfo.getStartDate();
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
            this.setWrittenOffBillBizDateRange();
        }
        if ((bizDate = (Date)this.getModel().getValue("bizdate")) == null) {
            bizDate = new Date();
        }
        DateEdit premDueDate = (DateEdit)this.getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDateControl = (DateEdit)this.getControl("duedate");
        headDueDateControl.setMinDate(bizDate);
        Date headDueDate = (Date)this.getView().getModel().getValue("duedate");
        if (headDueDate != null) {
            headDueDateControl.setMinDate(headDueDate);
        }
        DateEdit planDueDate = (DateEdit)this.getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void setDatePropRangeForPeriod() {
        if (this.initInfo.getStartDate() == null) {
            return;
        }
        Date startDate = this.initInfo.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DateEdit premDueDate = (DateEdit)this.getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDate = (DateEdit)this.getControl("duedate");
        headDueDate.setMinDate(bizDate);
        DateEdit planDueDate = (DateEdit)this.getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void setWrittenOffBillBizDateRange() {
        DateEdit writtenOffBillBizDate = (DateEdit)this.getView().getControl("bizdate");
        long sourcebillid = (Long)this.getModel().getValue("sourcebillid");
        DynamicObject srcBill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"bizdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourcebillid)});
        if (srcBill != null) {
            writtenOffBillBizDate.setMinDate(srcBill.getDate("bizdate"));
        }
    }

    private FinApBillAmtCalculateHandler getAmtCalculateHandler() {
        if (this.amtCalculateHandler == null) {
            this.amtCalculateHandler = new FinApBillAmtCalculateHandler(this.getView());
        }
        return this.amtCalculateHandler;
    }

    private void calculateAllAmtByHead() {
        this.getAmtCalculateHandler().calculateAllAmtByHead();
    }

    private void calculateAllAmtByDetailEntry(int index, String changeKey, Object oldValue) {
        this.getAmtCalculateHandler().calculateAllAmtByDetailEntry(index, changeKey, oldValue, this.isCopyEntryRow);
    }

    private void ifFxCalculate(int detailIndex, String key, BigDecimal oldValue, BeforeFieldPostBackEvent e) {
        this.getAmtCalculateHandler().ifFxCalculate(detailIndex, key, oldValue, e);
    }

    private void setHeadValueForCopy() {
        IBillModel model = (IBillModel)this.getModel();
        model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.loadInitInfo();
            boolean isPeriod = (Boolean)model.getValue("isperiod");
            if (isPeriod) {
                if (this.initInfo.isFinishInit()) {
                    this.isValidatePass = false;
                    String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u590d\u5236\u671f\u521d\u5355\u636e\u3002", (String)"FinApPeriodBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
                    this.getView().showErrorNotification(msg);
                    return;
                }
                Date startDate = this.initInfo.getStartDate();
                Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
                model.setValue("exratedate", (Object)lastDay);
                model.setValue("bizdate", (Object)lastDay);
            } else {
                Date currentDate = ObjectUtils.isEmpty((Object)this.initInfo.getCurrentDate()) ? this.initInfo.getStartDate() : this.initInfo.getCurrentDate();
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                if (bizDate == null) {
                    bizDate = new Date();
                }
                model.setValue("bizdate", (Object)(currentDate.after(bizDate) ? currentDate : bizDate));
            }
            BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)false);
            model.setValue("basecurrency", this.initInfo.getStandardCurrency().getPkValue());
        }
        DynamicObject finBill = model.getDataEntity(true);
        DynamicObject splitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill);
        model.setValue("splitscheme", (Object)splitScheme);
        Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)finBill);
        model.setValue("termsdate", (Object)basicDate);
    }

    private void setHeadAmtAndEntryInfoForCopy() {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal headTotalPriceTax = (BigDecimal)model.getValue("pricetaxtotal");
        BigDecimal headTotalPrice = (BigDecimal)model.getValue("amount");
        BigDecimal headTotalPriceTaxLocal = (BigDecimal)model.getValue("pricetaxtotalbase");
        int basePrecision = ((DynamicObject)model.getValue("basecurrency")).getInt("amtprecision");
        String quotation = (String)model.getValue("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        model.setValue("unsettleamount", (Object)headTotalPriceTax);
        model.setValue("unsettleamountbase", (Object)headTotalPriceTaxLocal);
        model.setValue("unverifyamount", (Object)headTotalPrice);
        model.setValue("uninvoicedamt", (Object)headTotalPriceTax);
        model.setValue("duedate", (Object)new Date());
        int detailEntrySize = model.getEntryRowCount("detailentry");
        for (int i = 0; i < detailEntrySize; ++i) {
            BigDecimal convertRate;
            BigDecimal entryTotalPriceTax = (BigDecimal)model.getValue("e_pricetaxtotal", i);
            BigDecimal priceTaxTotalBase = "1".equals(quotation) ? entryTotalPriceTax.divide(exchangeRate, basePrecision, RoundingMode.HALF_UP) : entryTotalPriceTax.multiply(exchangeRate).setScale(basePrecision, RoundingMode.HALF_UP);
            BigDecimal entryAmount = (BigDecimal)model.getValue("e_amount", i);
            BigDecimal quantity = (BigDecimal)model.getValue("quantity", i);
            BigDecimal baseUnitQty = (BigDecimal)model.getValue("e_baseunitqty", i);
            DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", i);
            if ((quantity.compareTo(BigDecimal.ZERO) == 0 || ObjectUtils.isEmpty((Object)quantity)) && !((Boolean)model.getValue("ispresent")).booleanValue()) {
                quantity = BigDecimal.valueOf(1L);
                model.setValue("quantity", (Object)quantity, i);
            }
            if (!(baseUnitQty.compareTo(BigDecimal.ZERO) != 0 && !ObjectUtils.isEmpty((Object)baseUnitQty) || ((Boolean)model.getValue("ispresent")).booleanValue() || ObjectUtils.isEmpty((Object)(convertRate = (BigDecimal)model.getValue("e_unitconvertrate", i))) || BigDecimal.ZERO.compareTo(convertRate) == 0)) {
                baseUnitQty = UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)convertRate, (DynamicObject)baseUnit);
                model.setValue("e_baseunitqty", (Object)baseUnitQty, i);
            }
            model.setValue("unverifyquantity", (Object)quantity, i);
            model.setValue("e_unverifybaseqty", (Object)baseUnitQty, i);
            model.setValue("e_unverifyamount", (Object)entryAmount, i);
            model.setValue("unlockamt", (Object)entryTotalPriceTax, i);
            model.setValue("unsettleamt", (Object)entryTotalPriceTax, i);
            model.setValue("unsettleamtbase", (Object)priceTaxTotalBase, i);
            model.setValue("e_uninvoicedamt", (Object)entryTotalPriceTax, i);
        }
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void resetPremiumInfo() {
        boolean srcIsPre;
        DynamicObjectCollection finApBills;
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object pkId = billShowParameter.getPkId();
        if (pkId != null && (finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"ispremium", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)})).size() > 0 && (srcIsPre = ((DynamicObject)finApBills.get(0)).getBoolean("ispremium"))) {
            this.getModel().setValue("premiumrate", (Object)0);
            this.getModel().setValue("premiumamt", (Object)BigDecimal.ZERO);
        }
    }

    private void filterAsstact() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bd_supplier".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    private void filterPayProperty() {
        BasedataEdit paypropertyF7 = (BasedataEdit)this.getControl("payproperty");
        paypropertyF7.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("detailentry");
            if (entryEntity == null || entryEntity.size() < 1) {
                return;
            }
            String srcType = (String)this.getModel().getValue("sourcebilltype");
            String billStatus = (String)this.getModel().getValue("billstatus");
            if ("ap_busbill".equals(srcType) || "ap_finapbill".equals(srcType) || "ar_finarbill".equals(srcType)) {
                Long srcId = Long.valueOf((String)this.getModel().getValue("e_sourcebillid", 0));
                QFilter idFilter = new QFilter("id", "=", (Object)srcId);
                DynamicObject bill = QueryServiceHelper.queryOne((String)srcType, (String)"payproperty.isbasedonamt", (QFilter[])idFilter.toArray());
                if (bill == null) {
                    return;
                }
                ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)bill.getBoolean("payproperty.isbasedonamt")));
            } else if (!"A".equals(billStatus)) {
                DynamicObject payproperty = (DynamicObject)this.getModel().getValue("payproperty");
                Boolean isbasedonamt = payproperty.getBoolean("isbasedonamt");
                ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)isbasedonamt));
            }
        });
    }

    private void filterBillType() {
        BillTypeEdit billType = (BillTypeEdit)this.getControl("billtypeid");
        billType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("number", "<>", (Object)"ApFin_borr_BT_S");
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    private void filterMaterial() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org) && LineTypeHelper.getParam((long)org.getLong("id"), (boolean)false).booleanValue()) {
            return;
        }
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("material");
        materialF7.addBeforeF7SelectListener(evt -> {
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtypeid");
            if (ObjectUtils.isEmpty((Object)billtype)) {
                return;
            }
            QFilter filter = null;
            if ("ApFin_pur_BT_S".equals(billtype.getString("number")) || "ApFin_product_BT_S".equals(billtype.getString("number"))) {
                filter = new QFilter("materialtype", "in", (Object)MaterialFilterHelper.getMaterialTypes());
            } else if ("ApFin_service_BT_S".equals(billtype.getString("number"))) {
                filter = new QFilter("materialtype", "=", (Object)"9");
            } else if ("ApFin_purfee_BT_S".equals(billtype.getString("number"))) {
                filter = new QFilter("materialtype", "=", (Object)"7");
            } else if ("ap_finapbill_asset_BT_S".equals(billtype.getString("number"))) {
                filter = new QFilter("materialtype", "=", (Object)"8");
            }
            if (filter != null) {
                ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                parameter.getQFilters().add(filter);
            }
        });
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"material", (String)"detailentry", (BasedataEdit)measureUnitEdit);
    }

    private void filterTaxrate() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("taxrateid");
        BaseDataHelper.taxratefilter((Date)bizdate, (BasedataEdit)taxrateF7);
    }

    private void filterInvoiceBizType() {
        BasedataEdit biztypeF7 = (BasedataEdit)this.getControl("invoicebiztype");
        biztypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("mulbiz.fbasedataid", "=", (Object)"83bfebc8000002ac");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    private void deleteDetailEntry(int[] rowIndexs) {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal deletePriceTaxTotalSum = BigDecimal.ZERO;
        BigDecimal deleteAmountSum = BigDecimal.ZERO;
        BigDecimal deleteTaxSum = BigDecimal.ZERO;
        BigDecimal deleteAdjustAmountSum = BigDecimal.ZERO;
        BigDecimal deletePriceTaxTotalBaseSum = BigDecimal.ZERO;
        BigDecimal deleteAmoutBaseSum = BigDecimal.ZERO;
        BigDecimal deleteTaxBaseSum = BigDecimal.ZERO;
        BigDecimal deleteAdjustAmountBaseSum = BigDecimal.ZERO;
        for (int rowIndex : rowIndexs) {
            deletePriceTaxTotalSum = deletePriceTaxTotalSum.add((BigDecimal)model.getValue("e_pricetaxtotal", rowIndex));
            deleteAmountSum = deleteAmountSum.add((BigDecimal)model.getValue("e_amount", rowIndex));
            deleteTaxSum = deleteTaxSum.add((BigDecimal)model.getValue("e_tax", rowIndex));
            deleteAdjustAmountSum = deleteAdjustAmountSum.add((BigDecimal)model.getValue("e_adjustamount", rowIndex));
            deletePriceTaxTotalBaseSum = deletePriceTaxTotalBaseSum.add((BigDecimal)model.getValue("e_pricetaxtotalbase", rowIndex));
            deleteAmoutBaseSum = deleteAmoutBaseSum.add((BigDecimal)model.getValue("e_amountbase", rowIndex));
            deleteTaxBaseSum = deleteTaxBaseSum.add((BigDecimal)model.getValue("e_taxlocalamt", rowIndex));
            deleteAdjustAmountBaseSum = deleteAdjustAmountBaseSum.add((BigDecimal)model.getValue("e_adjustlocalamt", rowIndex));
        }
        BigDecimal priceTaxTotal = ((BigDecimal)model.getValue("pricetaxtotal")).subtract(deletePriceTaxTotalSum);
        BigDecimal amount = ((BigDecimal)model.getValue("amount")).subtract(deleteAmountSum);
        BigDecimal tax = ((BigDecimal)model.getValue("tax")).subtract(deleteTaxSum);
        BigDecimal adjustAmount = ((BigDecimal)model.getValue("adjustamount")).subtract(deleteAdjustAmountSum);
        BigDecimal priceTaxTotalBase = ((BigDecimal)model.getValue("pricetaxtotalbase")).subtract(deletePriceTaxTotalBaseSum);
        BigDecimal amountBase = ((BigDecimal)model.getValue("amountbase")).subtract(deleteAmoutBaseSum);
        BigDecimal taxBase = ((BigDecimal)model.getValue("taxlocamt")).subtract(deleteTaxBaseSum);
        BigDecimal adjustAmountBase = ((BigDecimal)model.getValue("adjustlocalamt")).subtract(deleteAdjustAmountBaseSum);
        model.setValue("pricetaxtotal", (Object)priceTaxTotal);
        model.setValue("amount", (Object)amount);
        model.setValue("tax", (Object)tax);
        model.setValue("adjustamount", (Object)adjustAmount);
        model.setValue("pricetaxtotalbase", (Object)priceTaxTotalBase);
        model.setValue("amountbase", (Object)amountBase);
        model.setValue("taxlocamt", (Object)taxBase);
        model.setValue("adjustlocalamt", (Object)adjustAmountBase);
        model.setValue("unverifyamount", (Object)amount);
        model.setValue("unsettleamount", (Object)priceTaxTotal);
        model.setValue("uninvoicedamt", (Object)priceTaxTotal);
        model.setValue("unsettleamountbase", (Object)priceTaxTotalBase);
    }

    private void invAsstactWarn() {
        boolean hasConfigWarn = false;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            HashSet<Long> orgIds = new HashSet<Long>(1);
            Long orgId = org.getLong("id");
            orgIds.add(orgId);
            Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
            DynamicObject config = (DynamicObject)configByOrg.get(orgId);
            boolean bl = hasConfigWarn = EmptyUtils.isEmpty((Object)config) || config != null && ("2".equals(config.getString("identicalpartyinvcom")) || "".equals(config.getString("identicalpartyinvcom")));
            if (!hasConfigWarn) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"invasstactinfoflex"});
            }
        }
        DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstact");
        if (!hasConfigWarn || asstact == null) {
            return;
        }
        String asstName = asstact.getString("name");
        DynamicObjectCollection invEntrys = this.getModel().getEntryEntity("inventry");
        for (DynamicObject entry : invEntrys) {
            String invAsstName = entry.getString("i_asstactname");
            if (asstName.trim().equals(invAsstName.trim())) continue;
            ItemClassEdit asstactControl = (ItemClassEdit)this.getControl("asstact");
            String msg = ResManager.loadKDString((String)"\u5e94\u4ed8\u5355%s\u4e0e\u53d1\u7968\u5f00\u7968\u516c\u53f8\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillEdit_47", (String)"fi-ap-formplugin", (Object[])new Object[]{asstactControl.getDisplayName()});
            Label label = (Label)this.getView().getControl("invasstactinfo_labelap");
            label.setText(msg);
            this.getView().setVisible(Boolean.TRUE, new String[]{"invasstactinfoflex"});
            break;
        }
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        String asstactType = (String)this.getModel().getValue("asstacttype");
        String customerCaption = ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546", (String)"FinApBillEdit_36", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"FinApBillEdit_37", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getControl("asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("bd_supplier".equals(asstactType)) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    private void controlVisibleForMTO() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"configuredcode"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"tracknumber"});
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtypeid");
        if (EmptyUtils.isNotEmpty((Object)billtype) && "ApFin_borr_BT_S".equals(billtype.getString("number"))) {
            String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
            Long sourceBillId = (Long)this.getModel().getValue("sourcebillid");
            if ("ap_finapbill".equals(sourceBillType) && sourceBillId != 0L) {
                DynamicObject bill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"billtypeid.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
                String srcBillTypeId = bill.getString("billtypeid.number");
                if (!"ApFin_product_BT_S".equals(srcBillTypeId)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"configuredcode"});
                }
                if (!("ApFin_pur_BT_S".equals(srcBillTypeId) || "ApFin_product_BT_S".equals(srcBillTypeId) || "ApFin_fee_BT_S".equals(srcBillTypeId) || "ap_finapbill_asset_BT_S".equals(srcBillTypeId))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"tracknumber"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"configuredcode"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tracknumber"});
            }
        }
    }

    private void controlEnableForMTO(List<RowDataEntity> entries) {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (EmptyUtils.isNotEmpty((Object)sourceBillType)) {
            long billId;
            Map findSourceBills;
            for (int i = 0; i < entries.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"configuredcode"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"tracknumber"});
            }
            if ("ap_invoice".equals(sourceBillType) && (findSourceBills = BOTPHelper.findSourceBills((String)"ap_finapbill", (Long)(billId = ((Long)this.getModel().getValue("id")).longValue()))).size() == 1) {
                for (int i = 0; i < entries.size(); ++i) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"configuredcode"});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"tracknumber"});
                }
            }
        }
    }

    private boolean isVmi(DynamicObject bizType, DynamicObject asstact) {
        boolean isMatch = true;
        if (!ObjectUtils.isEmpty((Object)bizType) && !ObjectUtils.isEmpty((Object)asstact)) {
            String domain = bizType.getString("domain");
            DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
            boolean enableVmi = supplier.getBoolean("enablevmi");
            if (!enableVmi && "6".equals(domain)) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("detailentry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void filterConfiguredCode() {
        BasedataEdit billTypeF7 = (BasedataEdit)this.getControl("configuredcode");
        billTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("detailentry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isNotEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material.id", "=", (Object)materialId);
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void setEntryDiscountAmt(Map<String, Object> discountMap) {
        IDataModel m = this.getModel();
        DynamicObjectCollection entrys = m.getEntryEntity("detailentry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                boolean isPresent = ((DynamicObject)entrys.get(i)).getBoolean("ispresent");
                if (isPresent) continue;
                m.beginInit();
                m.setValue("discountamount", (Object)BigDecimal.ZERO, i);
                m.setValue("discountmode", (Object)"TOTAL", i);
                m.endInit();
                this.calculateAllAmtByDetailEntry(i, "discountamount", m.getValue("discountamount", i));
            }
            DiscountAmtHelper discountService = new DiscountAmtHelper();
            discountService.setEntryDiscountAmt(BillModelFactory.getModel((String)"ap_finapbill"), m, discountMap);
            entrys = m.getEntryEntity("detailentry");
            for (int i = 0; i < entrys.size(); ++i) {
                this.calculateAllAmtByDetailEntry(i, "discountamount", m.getValue("discountamount", i));
            }
            this.calculatePlanEntryAndSetHeadDueDate();
            this.calculateAllocationDetail();
        }
        this.getView().updateView("fs_amountinfo");
        this.getView().updateView("detailentry");
        this.getView().updateView("planentity");
        this.getView().updateView("allocationentry");
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        DynamicObjectCollection invoiceEntries;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int i = e.getRowIndex();
        if (i != -1) {
            IDataModel m = this.getModel();
            boolean isFXPriceTotal = (Boolean)m.getValue("isfxpricetaxtotal");
            boolean isFX = (Boolean)m.getValue("isfx");
            boolean isFxLocal = (Boolean)m.getValue("isfxlocal");
            switch (key) {
                case "discountrate": {
                    if (value == null) break;
                    this.verifDiscount(new BigDecimal(value.toString()), i, e);
                    break;
                }
                case "currency": 
                case "exratetable": 
                case "exratedate": {
                    this.verifHeadNull(value, key, e);
                    break;
                }
                case "e_pricetaxtotal": 
                case "e_amount": 
                case "e_tax": 
                case "e_adjustamount": {
                    if (!isFXPriceTotal && !isFX) break;
                    Object oldValue = m.getValue(key, i);
                    this.ifFxCalculate(i, key, (BigDecimal)oldValue, e);
                    break;
                }
                case "e_amountbase": 
                case "e_taxlocalamt": {
                    BigDecimal newValue;
                    boolean overRange;
                    if (!isFxLocal) break;
                    if (this.fxLocalAmtHandler == null) {
                        this.fxLocalAmtHandler = new FxLocalAmtHandler("ap_finapbill");
                    }
                    if (!(overRange = this.fxLocalAmtHandler.getFormToleranceServiceResult(i, key, newValue = !ObjectUtils.isEmpty((Object)value) ? new BigDecimal(e.getValue().toString()) : BigDecimal.ZERO, this.getModel()))) break;
                    String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u91d1\u989d\u672c\u4f4d\u5e01\u3001\u7a0e\u989d\u672c\u4f4d\u5e01\u3001\u5e94\u4ed8\u91d1\u989d\u672c\u4f4d\u5e01\u4e0e\u6309\u6c47\u7387\u8ba1\u7b97\u7684\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\uff08\u8def\u5f84\uff1a\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\uff09\u3002", (String)"FinApBillEdit_56", (String)"fi-ap-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"), i + 1);
                    this.getView().showErrorNotification(message);
                    this.getView().updateView(key, i);
                    e.setCancel(true);
                }
            }
        }
        if ("asstacttype".equals(key) && (invoiceEntries = this.getModel().getEntryEntity("inventry")).size() > 0) {
            List collectRows = invoiceEntries.stream().filter(invEntry -> InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(invEntry.getString("i_srctype"))).collect(Collectors.toList());
            if (collectRows.size() == invoiceEntries.size()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5f80\u6765\u7c7b\u578b\u4f1a\u6e05\u7a7a\u53d1\u7968\u660e\u7ec6\u884c\u6240\u6709\u53d1\u7968\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinApBillEdit_52", (String)"fi-ap-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("isClearInvEntryByAsstType"), null, String.valueOf(value));
                e.setCancel(true);
                this.getView().updateView(key);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u884c\u6765\u6e90\u4e0d\u5168\u4e3a\u201c\u53d1\u7968\u91c7\u96c6\u201d\u7684\u53d1\u7968\u884c\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u5f80\u6765\u7c7b\u578b\u3002", (String)"FinApBillEdit_53", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }

    private void verifHeadNull(Object value, String key, BeforeFieldPostBackEvent e) {
        if (value == null) {
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    private void verifDiscount(BigDecimal value, int i, BeforeFieldPostBackEvent e) {
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6b63\u6570\u3002", (String)"FinApBillEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView("discountrate", i);
            return;
        }
        if (DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("discountmode"))) {
            if (value.compareTo(new BigDecimal(100)) == 0 && ((Boolean)this.getModel().getValue("ispricetotal")).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"FinApBillEdit_25", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("discountrate", i);
                return;
            }
            if (value.compareTo(new BigDecimal(100)) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"FinApBillEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("discountrate", i);
            }
        }
    }

    private void closeassaccountF7(Object returnData) {
        String assacttype = this.getModel().getValue("asstacttype").toString();
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            if (assacttype.equals("bd_customer") || assacttype.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)assacttype, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue("payeebanknum", (Object)row.getString("bankaccount"));
                    this.getModel().setValue("bebank", (Object)row.getLong("bank.id"));
                    break;
                }
            } else if (assacttype.equals("bos_user")) {
                DynamicObject payeerInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount");
                if (!ObjectUtils.isEmpty((Object)payeerInfo)) {
                    this.getModel().setValue("payeebanknum", (Object)payeerInfo.getString("payeraccount"));
                    this.getModel().setValue("bebank", payeerInfo.getDynamicObject("payerbank").getPkValue());
                }
            } else {
                DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank.id,bank.bebank");
                if (!ObjectUtils.isEmpty((Object)account)) {
                    this.getModel().setValue("payeebanknum", (Object)account.getString("bankaccountnumber"));
                    this.getModel().setValue("bebank", account.getDynamicObject("bank.bebank").getPkValue());
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection planEntrys;
        Set splitDimensionIds;
        EntryGrid grid;
        String key;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (op instanceof Push || op instanceof PushAndSave) {
            Long pkValue = this.getModel().getDataEntity().getLong("id");
            HashSet<Long> billIds = new HashSet<Long>(1);
            billIds.add(pkValue);
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0018", null, (Object[])new Object[]{billIds});
        }
        if ("pushpayapply".equals(key = op.getOperateKey()) || "push".equals(key)) {
            this.checkPayhold(key, args);
        } else if (op instanceof Save || op instanceof Submit) {
            this.checkAmount(args);
        }
        if ("copyentryrow".equals(key)) {
            grid = (EntryGrid)this.getControl("detailentry");
            int length = grid.getSelectRows().length;
            if (length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"EntryCopyMsg_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("detailentry");
            boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
            String discountType = (String)this.getModel().getValue("discountmode", entryCurrentRowIndex);
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("discountrate", entryCurrentRowIndex);
            boolean isPresent = (Boolean)this.getModel().getValue("ispresent", entryCurrentRowIndex);
            if (isPriceTotal && "PERCENT".equals(discountType) && new BigDecimal("100").compareTo(discountRate) == 0 && !isPresent) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        }
        if ("splitrow".equals(key)) {
            grid = (EntryGrid)this.getControl("detailentry");
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u62c6\u5206\u3002", (String)"FinApBillEdit_54", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
            this.splitRowMap.put("corebilltype", this.getModel().getValue("corebilltype", selectRows[0]));
            this.splitRowMap.put("corebillno", this.getModel().getValue("corebillno", selectRows[0]));
            this.splitRowMap.put("corebillid", this.getModel().getValue("corebillid", selectRows[0]));
            this.splitRowMap.put("corebillentryseq", this.getModel().getValue("corebillentryseq", selectRows[0]));
            this.splitRowMap.put("corebillentryid", this.getModel().getValue("corebillentryid", selectRows[0]));
            this.splitRowMap.put("e_conbillentity", this.getModel().getValue("e_conbillentity", selectRows[0]));
            this.splitRowMap.put("e_conbillnumber", this.getModel().getValue("e_conbillnumber", selectRows[0]));
            this.splitRowMap.put("e_conbillrownum", this.getModel().getValue("e_conbillrownum", selectRows[0]));
            this.splitRowMap.put("e_conbillid", this.getModel().getValue("e_conbillid", selectRows[0]));
            this.splitRowMap.put("e_conbillentryid", this.getModel().getValue("e_conbillentryid", selectRows[0]));
            this.splitRowMap.put("groupnumber", this.getModel().getValue("groupnumber", selectRows[0]));
            this.splitRowMap.put("groupseq", this.getModel().getValue("groupseq", selectRows[0]));
            this.splitRowMap.put("e_sourcebillid", this.getModel().getValue("e_sourcebillid", selectRows[0]));
            this.splitRowMap.put("e_sourcebillentryid", this.getModel().getValue("e_sourcebillentryid", selectRows[0]));
            this.splitRowMap.put("e_splitdimensionid", this.getModel().getValue("e_splitdimensionid", selectRows[0]));
        }
        if ("newplanentry".equals(key) && (splitDimensionIds = (planEntrys = this.getModel().getEntryEntity("planentity")).stream().map(e -> e.getInt("p_splitdimensionid")).collect(Collectors.toSet())).size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5df2\u6309\u7167\u6838\u5fc3\u5355\u636e\u53f7\u6216\u62c6\u5206\u65b9\u6848\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u589e\u884c\u3002", (String)"FinApBillEdit_49", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("deleteplanentry".equals(key)) {
            int currentrow = this.getModel().getEntryCurrentRowIndex("planentity");
            DynamicObjectCollection planEntrys2 = this.getModel().getEntryEntity("planentity");
            int p_splitdimensionid = ((DynamicObject)planEntrys2.get(currentrow)).getInt("p_splitdimensionid");
            List cureentSplitDimensionIds = planEntrys2.stream().filter(e -> e.getInt("p_splitdimensionid") == p_splitdimensionid).collect(Collectors.toList());
            if (cureentSplitDimensionIds.size() == 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76f8\u540c\u62c6\u5206\u7ef4\u5ea6\u7684\u4ed8\u6b3e\u8ba1\u5212\u884c\u4e0d\u5141\u8bb8\u5168\u90e8\u5220\u9664\u3002", (String)"FinApBillEdit_50", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void checkAmount(BeforeDoOperationEventArgs args) {
        String settlestatus = (String)this.getModel().getValue("settlestatus");
        if (!"unsettle".equals(settlestatus)) {
            return;
        }
        BigDecimal sumpricetax = (BigDecimal)this.getModel().getValue("pricetaxtotal");
        BigDecimal pricetax = BigDecimal.ZERO;
        int count = this.getModel().getEntryRowCount("planentity");
        Object source = args.getSource();
        String operte = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"FinApBillEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (source instanceof Save) {
            operte = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"FinApBillEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        for (int i = 0; i < count; ++i) {
            pricetax = pricetax.add((BigDecimal)this.getModel().getValue("planpricetax", i));
        }
        if (sumpricetax.compareTo(pricetax) != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u4e2d\u201c\u5e94\u4ed8\u91d1\u989d\u201d\u5408\u8ba1\u4e0e\u6574\u5355\u201c\u5e94\u4ed8\u91d1\u989d\u201d\u4e00\u81f4\u624d\u80fd%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FinApBillEdit_8", (String)"fi-ap-formplugin", (Object[])new Object[]{operte}));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List billIds;
        String waring;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("submit".equals(key) || "unsubmit".equals(key) || "save".equals(key) || "unaudit".equals(key) || "audit".equals(key)) {
            this.fillToolBar();
            if (operationResult.isSuccess()) {
                this.paySettleWarn();
            }
        }
        if ("transpay".equals(key) && operationResult.isSuccess()) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("transferpaybill");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("pkIds", (Object)operationResult.getSuccessPkIds());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refresh");
            fsp.setCloseCallBack(closeCallBack);
            this.getView().showForm(fsp);
        }
        if ("transferall".equals(key) && operationResult.isSuccess()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ap_transferall");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("pkIds", (Object)operationResult.getSuccessPkIds());
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
            this.getView().showForm(showParameter);
        }
        if ("unaudit".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if ("audit".equals(key)) {
            if (operationResult.isSuccess()) {
                if ("invoice_is_null".equals(operationResult.getMessage())) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\uff0c\u5e76\u6839\u636e\u5e94\u4ed8\u5355\u662f\u5426\u53ef\u62b5\u6263\u8fdb\u9879\u7a0e\u66f4\u65b0\u4e86\u6536\u7968\u5355\u8fdb\u9879\u7a0e\u62b5\u6263\u6807\u8bc6\u3002", (String)"FinApBillEdit_17", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"FinApBillEdit_18", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                operationResult.setShowMessage(false);
            }
            this.getView().invokeOperation("refresh");
        }
        if ("assign".equals(key) && operationResult.isSuccess()) {
            String finBillUpdateTaxDeduction = (String)ConfigCache.get((String)"finBillUpdateTaxDeduction", (String)"finBillUpdateTaxDeduction", String.class);
            if ("true".equals(finBillUpdateTaxDeduction)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6839\u636e\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u8d44\u8d28\u548c\u53d1\u7968\u7c7b\u522b\u66f4\u65b0\u53d1\u7968\u7684\u53ef\u62b5\u6263\u6807\u8bc6\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"FinApBillEdit_19", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                operationResult.setShowMessage(false);
                ConfigCache.remove((String)"finBillUpdateTaxDeduction", (String)"finBillUpdateTaxDeduction");
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(waring = FinApBillHelper.supplierWarnTips((String)"ap_finapbill", (List)operationResult.getSuccessPkIds(), (String)key)))) {
                this.getView().showSuccessNotification(waring, Integer.valueOf(10000));
            }
        }
        if ("unsubmit".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if (Arrays.asList("save", "submit").contains(key)) {
            this.getView().updateView("allocationentry");
            if (operationResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        }
        if (!"refresh".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        }
        if ("submit".equals(key) || "save".equals(key)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0023", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
        if ("submit".equals(key) && operationResult.isSuccess()) {
            String waring2;
            billIds = operationResult.getSuccessPkIds();
            List warnMessageMap = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0066", new ArrayList(16), (Object[])new Object[]{billIds});
            if (!ObjectUtils.isEmpty((Object)warnMessageMap)) {
                this.getView().showTipNotification(StringUtils.join((Collection)warnMessageMap, (String)"\n"), Integer.valueOf(30000));
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(waring2 = FinApBillHelper.supplierWarnTips((String)"ap_finapbill", (List)billIds, (String)key)))) {
                this.getView().showSuccessNotification(waring2, Integer.valueOf(10000));
            }
        }
        if ("assignsave".equals(key) && operationResult.isSuccess() && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(waring = FinApBillHelper.supplierWarnTips((String)"ap_finapbill", (List)(billIds = operationResult.getSuccessPkIds()), (String)key)))) {
            this.getView().showSuccessNotification(waring, Integer.valueOf(10000));
        }
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
    }

    private void fillToolBar() {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_del", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_assign", "bar_antiassign", "bar_adjust", "bar_collect", "calculatetaxcbtn"});
        if (!this.isValidatePass) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_draw", "calculatetaxcbtn"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"bar_new", "bar_track", "bar_collect"});
        view.setEnable(Boolean.TRUE, new String[]{"bar_audit"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_del", "bar_submitandnew"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_settle"});
            view.setEnable(Boolean.TRUE, new String[]{"bar_submit"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_assign", "bar_audit", "bar_antiassign"});
            view.setEnable(Boolean.FALSE, new String[]{"bar_submit"});
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            boolean submitSettle = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ap_016");
            if (submitSettle) {
                view.setVisible(Boolean.TRUE, new String[]{"bar_settle"});
                view.setVisible(Boolean.FALSE, new String[]{"payapply", "push", "tblwriteoff", "liquidate", "transferpay", "transferall"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"calculatetaxcbtn"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_assign", "bar_antiassign", "bar_adjust", "bar_generatevoucher", "bar_audit", "bar_track", "bar_unaudit", "bar_settle", "payapply", "push", "tblwriteoff", "liquidate", "transferpay", "transferall"});
            view.setEnable(Boolean.FALSE, new String[]{"bar_audit"});
            view.setVisible(Boolean.FALSE, new String[]{"calculatetaxcbtn"});
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unaudit", "bar_submitandnew"});
        }
    }

    private void fillToolBarForPeriod() {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_save4writeoff", "bar_freeze", "bar_unfreeze"});
        if (!this.isValidatePass) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_save4writeoff", "bar_collect"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"bar_new", "bar_track"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_del", "bar_submitandnew"});
            view.setEnable(Boolean.TRUE, new String[]{"bar_submit"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_audit", "bar_submit", "bar_unsubmit"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_track", "bar_more"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_generatevoucher"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_track"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_new"});
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unaudit"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"bar_assign"});
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("subentryentity");
        this.getModel().deleteEntryData("detailentry");
        this.getModel().createNewEntryRow("detailentry");
    }

    private void paySettleWarn() {
        DynamicObjectCollection entries;
        this.getView().setVisible(Boolean.FALSE, new String[]{"settleinfoflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"presettleinfoflex"});
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean submitSettle = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ap_016");
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (submitSettle && !"B".equals(billStatus) && !"C".equals(billStatus)) {
            return;
        }
        if (!submitSettle && !"C".equals(billStatus)) {
            return;
        }
        BigDecimal unLockAmt = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = this.getModel().getEntryEntity("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            unLockAmt = unLockAmt.add(detailEntry.getBigDecimal("unlockamt"));
        }
        if (unLockAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Object asstacttype = this.getModel().getValue("asstacttype");
        DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstact");
        if (asstact == null) {
            ItemClassEdit asstactControl = (ItemClassEdit)this.getControl("asstact");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e2d%s\u5df2\u4e0d\u5b58\u5728\u3002", (String)"FinApBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[]{asstactControl.getDisplayName()}));
            return;
        }
        List baseDataIds = BaseDataHelper.getBaseDataIds((String)asstact.getDataEntityType().getName(), (long)asstact.getLong("masterid"));
        QFilter payFilter = new QFilter("entry.settleorg", "=", org.getPkValue());
        payFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"}).and("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE).and("itempayeetype", "=", asstacttype).and("itempayee", "in", (Object)baseDataIds).and("currency", "=", currency.getPkValue()).and("entry.e_unsettledamt", "<>", (Object)0).and("entry.e_unlockamt", "<>", (Object)0);
        QFilter extPayFilter = BizExtendHelper.addFinapPaySettleWarnFilter((IDataModel)this.getModel(), (String)"cas_paybill");
        if (extPayFilter != null) {
            payFilter.and(extPayFilter);
        }
        Object[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,settleorg,e_payableamt,e_unsettledamt,entry.e_paymenttype", (QFilter[])new QFilter[]{payFilter});
        QFilter paidFilter = new QFilter("org", "=", org.getPkValue());
        paidFilter.and("billstatus", "=", (Object)"C").and("billstatus", "=", (Object)"C").and("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE).and("payeetype", "=", asstacttype).and("payee", "in", (Object)baseDataIds).and("currency", "=", currency.getPkValue()).and("entry.e_unsettledamt", "<>", (Object)0);
        QFilter extPaidFilter = BizExtendHelper.addFinapPaySettleWarnFilter((IDataModel)this.getModel(), (String)"ap_paidbill");
        if (extPaidFilter != null) {
            paidFilter.and(extPaidFilter);
        }
        Object[] paidBills = BusinessDataServiceHelper.load((String)"ap_paidbill", (String)"id,e_actamt,e_unsettledamt", (QFilter[])new QFilter[]{paidFilter});
        if (ObjectUtils.isEmpty((Object[])payBills) && ObjectUtils.isEmpty((Object[])paidBills)) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"settleinfoflex"});
        int count = payBills.length + paidBills.length;
        HashSet<Long> preBillIds = new HashSet<Long>(16);
        BigDecimal payableAmt = BigDecimal.ZERO;
        BigDecimal unsettleAmt = BigDecimal.ZERO;
        BigDecimal prePayableAmt = BigDecimal.ZERO;
        BigDecimal preUnsettleAmt = BigDecimal.ZERO;
        for (Object payBill : payBills) {
            entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                DynamicObject settleOrg = entry.getDynamicObject("settleorg");
                DynamicObject paymentType = entry.getDynamicObject("e_paymenttype");
                if (settleOrg != null && org.getLong("id") == settleOrg.getLong("id") && paymentType != null && paymentType.getBoolean("ispartpayment")) {
                    unsettleAmt = unsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                    if ("202".equals(paymentType.getString("biztype"))) {
                        preUnsettleAmt = preUnsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                        prePayableAmt = prePayableAmt.add(entry.getBigDecimal("e_payableamt"));
                        preBillIds.add(payBill.getLong("id"));
                    }
                }
                payableAmt = payableAmt.add(entry.getBigDecimal("e_payableamt"));
            }
        }
        for (Object paidBill : paidBills) {
            entries = paidBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                payableAmt = payableAmt.add(entry.getBigDecimal("e_actamt"));
                unsettleAmt = unsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                preUnsettleAmt = preUnsettleAmt.add(entry.getBigDecimal("e_unsettledamt"));
                prePayableAmt = prePayableAmt.add(entry.getBigDecimal("e_actamt"));
                preBillIds.add(paidBill.getLong("id"));
            }
        }
        payableAmt = payableAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
        unsettleAmt = unsettleAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
        prePayableAmt = prePayableAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
        preUnsettleAmt = preUnsettleAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
        String msg = String.format(ResManager.loadKDString((String)"\u5df2\u4e3a\u60a8\u7b5b\u9009\u51fa\u80fd\u591f\u4e0e\u672c\u5355\u7ed3\u7b97\u7684\u4ed8\u6b3e\u5355%1$s\u7b14\uff0c\u5e94\u4ed8\u91d1\u989d\u5171\u8ba1\uff1a%2$s\uff0c\u53ef\u7ed3\u7b97\u91d1\u989d\uff1a%3$s\u3002", (String)"FinApBillEdit_13", (String)"fi-ap-formplugin", (Object[])new Object[0]), count, payableAmt, unsettleAmt);
        Label label = (Label)this.getView().getControl("settleinfo_labelap");
        label.setText(msg);
        if (preUnsettleAmt.compareTo(BigDecimal.ZERO) != 0) {
            String preMsg = String.format(ResManager.loadKDString((String)"\u5df2\u4e3a\u60a8\u7b5b\u9009\u51fa\u80fd\u591f\u4e0e\u672c\u5355\u7ed3\u7b97\u7684\u9884\u4ed8\u6b3e\u5355%1$s\u7b14\uff0c\u5e94\u4ed8\u91d1\u989d\u5171\u8ba1\uff1a%2$s\uff0c\u53ef\u7ed3\u7b97\u91d1\u989d\uff1a%3$s\u3002", (String)"FinApBillEdit_46", (String)"fi-ap-formplugin", (Object[])new Object[0]), preBillIds.size(), prePayableAmt, preUnsettleAmt);
            Label prelabel = (Label)this.getView().getControl("persettleinfo_labelap");
            prelabel.setText(preMsg);
            this.getView().setVisible(Boolean.FALSE, new String[]{"settleinfo_ignore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"presettleinfoflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"settleinfo_ignore"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"presettleinfoflex"});
        }
    }

    private FinApBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new FinApBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    private void sameBillWarn(Map<String, List<String>> sameBillInfo) {
        if (sameBillInfo == null || sameBillInfo.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"sameinfoflex"});
        ArrayList<List<String>> sameBillNos = new ArrayList<List<String>>(sameBillInfo.values());
        Label label = (Label)this.getView().getControl("sameinfo_labelap");
        String message = ResManager.loadKDString((String)"\u91cd\u590d\u4ed8\u6b3e\u98ce\u9669\u63d0\u9192\uff1a", (String)"FinApBillEdit_31", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        label.setText(message.concat(ExecCtrlHelper.getSameBillMessage((List)((List)sameBillNos.get(0)), (boolean)false)));
    }

    private void checkPayhold(String key, BeforeDoOperationEventArgs args) {
        String operateKey = ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7", (String)"FinApBillEdit_38", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String errorMessageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7ed3\u7b97\u4f9b\u5e94\u5546\u201c%2$s\u201d\u5df2\u4ed8\u6b3e\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8%3$s\u3002", (String)"FinApBillEdit_41", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if ("push".equals(key)) {
            operateKey = ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"FinApBillEdit_40", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        }
        if ("bd_supplier".equals(this.getModel().getValue("asstacttype"))) {
            DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstact");
            Long id = asstact.getLong("id");
            DynamicObject asstactRes = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("payhold", "=", (Object)Boolean.TRUE)});
            if (!ObjectUtils.isEmpty((Object)asstactRes)) {
                String billno = (String)this.getModel().getValue("billno");
                String asstactName = asstact.getString("name");
                String message = String.format(errorMessageTemplate, billno, asstactName, operateKey);
                this.getView().showErrorNotification(message);
                args.setCancel(true);
            }
        }
    }

    private void taxDeductionWarn() {
        boolean headTaxdeduction = (Boolean)this.getModel().getValue("istaxdeduction");
        DynamicObjectCollection invEntrys = this.getModel().getEntryEntity("inventry");
        boolean isNeedShowWarn = false;
        if (invEntrys != null && invEntrys.size() > 0) {
            DynamicObject invEntry;
            boolean iTax;
            Iterator iterator = invEntrys.iterator();
            while (iterator.hasNext() && !(isNeedShowWarn = (iTax = (invEntry = (DynamicObject)iterator.next()).getBoolean("i_istaxdeduction")) != headTaxdeduction)) {
            }
        }
        if (isNeedShowWarn) {
            String msg = ResManager.loadKDString((String)"\u201c\u8fdb\u9879\u7a0e\u62b5\u6263\u201d\u4e0e\u53d1\u7968\u660e\u7ec6\u884c\u201c\u53ef\u62b5\u6263\u201d\u4e0d\u5b8c\u5168\u4e00\u81f4\u3002\u82e5\u5df2\u542f\u7528\u5b58\u8d27\u6838\u7b97\uff0c\u201c\u8fdb\u9879\u7a0e\u62b5\u6263\u201d\u662f\u5426\u51c6\u786e\u5c06\u5f71\u54cd\u5b58\u8d27\u6210\u672c\u51c6\u786e\u6027\u3002\u8bf7\u6ce8\u610f\u68c0\u67e5\u3002", (String)"FinApBillEdit_48", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            Label label = (Label)this.getView().getControl("taxdeduction_labelap");
            label.setText(msg);
            this.getView().setVisible(Boolean.TRUE, new String[]{"taxdeductionflex"});
        }
    }

    private void materialSettleHideButten() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        int param = ArApHelper.getApSettleParam((Object)org.getLong("id"));
        if (1 == param) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"m_businesspro"});
        }
    }
}

