/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.ap.helper.ApHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;

@Deprecated
public class FinBillBaseEdit
extends AbstractBillPlugIn {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        IDataModel m = this.getModel();
        switch (key) {
            case "currency": 
            case "exratetable": 
            case "exratedate": {
                this.calculaterate(newValue, oldValue);
                break;
            }
            case "material": {
                this.materialChanged(changeData);
                break;
            }
            case "asstact": {
                this.asstactChanged(e, newValue);
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    return;
                }
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                if (asstactSettleTypeId == 0L) {
                    return;
                }
                m.setValue("settlementtype", (Object)asstactSettleTypeId);
                this.setPaymentCurrency();
            }
        }
    }

    private void setPaymentCurrency() {
        DynamicObject asstact = this.getModel().getDataEntity().getDynamicObject("asstact");
        if (ObjectUtils.isEmpty((Object)asstact)) {
            return;
        }
        String asstactType = asstact.getDataEntityType().getName();
        if (!"bd_supplier".equals(asstactType)) {
            this.setPaymentCurrencywithCurrency();
            return;
        }
        Object asstactPk = asstact.getPkValue();
        DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"paymentcurrency", (QFilter[])new QFilter[]{new QFilter("id", "=", asstactPk)});
        long paymentCurrencyId = asstactFieldValue.getLong("paymentcurrency");
        if (paymentCurrencyId == 0L) {
            this.setPaymentCurrencywithCurrency();
            return;
        }
        this.getModel().setValue("paymentcurrency", (Object)paymentCurrencyId);
    }

    private void setPaymentCurrencywithCurrency() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        this.getModel().setValue("paymentcurrency", (Object)currency);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "payeebanknum": {
                this.assacctShowF7();
                break;
            }
            case "corebillno": {
                this.showCoreBillF7();
            }
        }
    }

    private void showCoreBillF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("detailentry");
        String corebilltype = (String)this.getModel().getValue("corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)corebilltype, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void assacctShowF7() {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("asstact");
        AsstactHelper.assacctShowF7((DynamicObject)basedata, (IFormView)this.getView(), (String)this.getPluginName());
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int i = e.getRowIndex();
        switch (key) {
            case "discountrate": {
                this.verifDiscount(new BigDecimal(value.toString()), i, e);
                break;
            }
            case "currency": 
            case "exratetable": 
            case "exratedate": {
                this.verifHeadNull(value, key, e);
            }
        }
    }

    private void verifHeadNull(Object value, String key, BeforeFieldPostBackEvent e) {
        if (value == null) {
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    private void verifDiscount(BigDecimal value, int i, BeforeFieldPostBackEvent e) {
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6b63\u6570\u3002", (String)"FinBillBaseEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView("discountrate", i);
            return;
        }
        if (DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("discountmode")) && value.compareTo(new BigDecimal(100)) > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"FinBillBaseEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView("discountrate", i);
            return;
        }
    }

    private void asstactChanged(PropertyChangedArgs e, Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("asstactname", null);
            this.getModel().setValue("payeebanknum", null);
            this.getModel().setValue("bebank", null);
        } else {
            DynamicObject asstact = (DynamicObject)newValue;
            Map map = AsstactHelper.getaccbebankMap((DynamicObject)asstact);
            this.getModel().setValue("payeebanknum", map.get("account"));
            this.getModel().setValue("bebank", map.get("bebank"));
            this.getModel().setValue("asstactname", asstact.get("name"));
        }
    }

    private void calculaterate(Object newValue, Object oldValue) {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
        Date exrateDate = (Date)this.getModel().getValue("exratedate");
        if (destCurrency == null || srcCurrency == null || exratetable == null) {
            return;
        }
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exratetableId = exratetable.getLong("id");
        this.getView().setEnable(Boolean.valueOf(srcCurrencyId != destCurrencyId), new String[]{"exchangerate"});
        BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
        if (exchangeRate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"FinBillBaseEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void materialChanged(ChangeData[] data) {
        int row = data[0].getRowIndex();
        Object propValue = data[0].getNewValue();
        if (propValue != null) {
            IDataModel model;
            DynamicObject material = (DynamicObject)propValue;
            this.getModel().setValue("spectype", (Object)material.getString("modelnum"), row);
            if (material.getDynamicObject("baseunit") != null) {
                Object unitID = material.getDynamicObject("baseunit").getPkValue();
                model = this.getModel();
                model.setValue("measureunit", unitID, row);
                model.setValue("e_baseunit", unitID, row);
                model.setValue("e_unitconvertrate", (Object)BigDecimal.ONE, row);
                model.setValue("e_baseunitqty", model.getValue("quantity", row), row);
            }
            if (material.getDynamicObject("taxrate") != null) {
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                model = this.getModel();
                model.setValue("taxrateid", taxrateId, row);
            }
        } else {
            this.getModel().setValue("spectype", null, row);
            this.getModel().setValue("measureunit", null, row);
            this.getModel().setValue("e_baseunit", null, row);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "assaccount": {
                this.closeassaccountF7(returnData);
                break;
            }
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"detailentry", (Object)returnData);
            }
        }
    }

    private void closeassaccountF7(Object returnData) {
        String assacttype = this.getModel().getValue("asstacttype").toString();
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            if (assacttype.equals("bd_customer") || assacttype.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)assacttype, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    String actName = row.getLocaleString("accountname").getLocaleValue();
                    if (!ApHelper.isEmpty((Object)actName)) {
                        actName = cutstomer.getLocaleString("name").getLocaleValue();
                    }
                    this.getModel().setValue("payeebanknum", (Object)row.getString("bankaccount"));
                    this.getModel().setValue("bebank", (Object)row.getLong("bank.id"));
                    break;
                }
            } else if (assacttype.equals("bos_user")) {
                DynamicObject payeerInfo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount");
                if (!ObjectUtils.isEmpty((Object)payeerInfo)) {
                    this.getModel().setValue("payeebanknum", (Object)payeerInfo.getString("payeraccount"));
                    this.getModel().setValue("bebank", (Object)payeerInfo.getLong("payerbank"));
                }
            } else {
                DynamicObject account = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank.id,bank.bebank");
                if (!ObjectUtils.isEmpty((Object)account)) {
                    this.getModel().setValue("payeebanknum", (Object)account.getString("bankaccountnumber"));
                    this.getModel().setValue("bebank", account.getDynamicObject("bank.bebank").getPkValue());
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
        if (settleTypeId != 0L) {
            this.getModel().setValue("settlementtype", (Object)settleTypeId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }
}

