/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.fi.ap.formplugin.ApAbstractImport;
import kd.fi.ap.helper.BaseDataHelper;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;

public class FinBillImport
extends ApAbstractImport {
    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            boolean isPeriod = this.isPeriod(data);
            this.checkOrgNew();
            data.remove("billstatus");
            if (isPeriod) {
                String billtypenumber;
                JSONObject billtype = (JSONObject)data.get("billtypeid");
                if (billtype != null && "ApFin_borr_BT_S".equals(billtypenumber = billtype.getString("number"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u501f\u8d37\u9879\u8c03\u6574\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"FinBillImport_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                if (this.init.isFinishInit()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"FinBillImport_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"FinBillImport_25", (String)"fi-ap-formplugin", (Object[])new Object[0]), true, null, this.init.getStartDate(), null);
            } else {
                Date currentDate = this.init.getCurrentDate();
                if (ObjectUtils.isEmpty((Object)currentDate)) {
                    currentDate = this.init.getStartDate();
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"FinBillImport_25", (String)"fi-ap-formplugin", (Object[])new Object[0]), true, currentDate, null, null);
            }
            this.checkText("remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"FinBillImport_19", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, 255, null);
            JSONObject currencyData = (JSONObject)data.get("currency");
            Optional<DynamicObject> currencyOptional = this.getDynamicObjectByNumberOrName("bd_currency", currencyData, "id,number,name,amtprecision,priceprecision");
            if (!currencyOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u5e01\u201d\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"FinBillImport_23", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            int amtprecision = currencyOptional.get().getInt("amtprecision");
            int priceprecision = currencyOptional.get().getInt("priceprecision");
            currencyData.put("number", (Object)currencyOptional.get().getString("number"));
            this.checkExchangeRate(currencyOptional.get().getLong("id"));
            String asstacttype = (String)data.get("asstacttype");
            if (asstacttype == null) {
                data.put("asstacttype", "bd_supplier");
            }
            this.checkNull("asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"FinBillImport_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.checkAsstAct();
            this.checkF7("paycond", ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"FinBillImport_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("settlementtype", ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"FinBillImport_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("purorg", ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7", (String)"FinBillImport_8", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("purdept", ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4", (String)"FinBillImport_9", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            this.checkF7("purchaser", ResManager.loadKDString((String)"\u91c7\u8d2d\u5458", (String)"FinBillImport_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, null);
            boolean includeTax = this.includeTax(data);
            data.put("isincludetax", includeTax);
            JSONArray entryList = (JSONArray)data.get("detailentry");
            if (entryList != null) {
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject entry = (JSONObject)entryList.get(i);
                    String isMaterial = this.isMaterial();
                    if ("false".equals(isMaterial)) {
                        this.checkEntryNull("expenseitem", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"FinBillImport_11", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                    } else if ("true".equals(isMaterial)) {
                        this.checkEntryNull("material", ResManager.loadKDString((String)"\u7269\u6599", (String)"FinBillImport_12", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        this.checkEntryNull("measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"FinBillImport_13", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        this.checkEntryF7("measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"FinBillImport_13", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i, false, null);
                    }
                    if (entry.get((Object)"quantity") == null) {
                        entry.put("quantity", (Object)0);
                    }
                    if (entry.get((Object)"price") == null) {
                        entry.put("price", (Object)0);
                    }
                    this.checkEntryEnum("discountmode", ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f", (String)"FinBillImport_14", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i, false, new String[]{"PERCENT", "PERUNIT", "NULL"}, "NULL");
                    if (!this.ispresent(entry, "ispresent")) {
                        if (includeTax) {
                            this.checkEntryNullOrZero("pricetax", ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u5f00\u542f\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7", (String)"FinBillImport_21", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        } else {
                            this.checkEntryNullOrZero("price", ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u5173\u95ed\u65f6\uff0c\u5355\u4ef7", (String)"FinBillImport_22", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                        }
                        BigDecimal exchangerate = this.getBigDecimal("exchangerate");
                        this.sumEntryAmt(entry, exchangerate, amtprecision, priceprecision, includeTax);
                        continue;
                    }
                    entry.put("price", (Object)BigDecimal.ZERO);
                    entry.put("pricetax", (Object)BigDecimal.ZERO);
                }
                this.sumHeadAmt(amtprecision);
                JSONArray planEntryList = (JSONArray)data.get("planentity");
                if (entryList != null && planEntryList.size() > 0) {
                    BigDecimal exchanegRate = this.parseBigDecimal(data.get("exchangerate"));
                    BigDecimal sumpricetax = BigDecimal.ZERO;
                    for (int seq = 0; seq < planEntryList.size(); ++seq) {
                        JSONObject row = (JSONObject)planEntryList.get(seq);
                        BigDecimal planRowAmt = this.parseBigDecimal(row.get((Object)"planpricetax"));
                        sumpricetax = sumpricetax.add(planRowAmt);
                        row.put("planpricetaxloc", (Object)planRowAmt.multiply(exchanegRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_UP));
                        row.put("planlockedamt", (Object)"0");
                        row.put("unplanlockamt", (Object)planRowAmt.setScale(amtprecision, RoundingMode.HALF_UP));
                        row.put("plansettledamt", (Object)"0");
                        row.put("plansettledlocamt", (Object)"0");
                        row.put("unplansettleamt", (Object)planRowAmt.setScale(amtprecision, RoundingMode.HALF_UP));
                        row.put("unplansettlelocamt", (Object)planRowAmt.multiply(exchanegRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_UP));
                        String strValue = (String)row.get((Object)"planduedate");
                        Object dudateObject = data.get("duedate");
                        if (strValue != null && dudateObject != null) {
                            String duedateValue = dudateObject.toString();
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                            Date planduedate = df.parse(strValue);
                            Date duedate = df.parse(duedateValue);
                            if (duedate == null || planduedate.compareTo(duedate) <= 0) continue;
                            throw new KDBizException("");
                        }
                        row.put("planduedate", (Object)((String)data.get("duedate")));
                    }
                    if (sumpricetax.setScale(amtprecision, RoundingMode.HALF_UP).compareTo(this.parseBigDecimal(data.get("pricetaxtotal"))) != 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5e94\u4ed8\u91d1\u989d\u5408\u8ba1\u4e0e\u6574\u5355\u5e94\u4ed8\u91d1\u989d\u4e00\u81f4\u624d\u80fd\u4fdd\u5b58\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FinBillImport_15", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    }
                }
                data.put("isperiod", isPeriod);
            }
        }
        catch (Exception exc) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            return false;
        }
        return true;
    }

    private void checkAsstAct() {
        JSONObject value = (JSONObject)this.data.get("asstact");
        if (value == null) {
            return;
        }
        Optional<DynamicObject> assactTypeOptional = this.getDynamicObjectByNumberOrName(this.data.get("asstacttype").toString(), value, "id,number,name");
        if (!assactTypeOptional.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"FinBillImport_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        value.put("number", (Object)assactTypeOptional.get().getString("number"));
        String number = (String)value.get((Object)"number");
        this.data.put("asstactname", ((DynamicObject)((Map)this.cachedF7.get(this.data.get("asstacttype").toString())).get(number)).get("name"));
    }

    private void checkExchangeRate(long currencyId) throws ParseException {
        JSONObject currency = (JSONObject)this.data.get("currency");
        JSONObject baseCurrency = (JSONObject)this.data.get("basecurrency");
        if (currency.get((Object)"number").equals(baseCurrency.get((Object)"number"))) {
            this.data.put("exchangerate", "1");
            return;
        }
        BigDecimal value = this.parseBigDecimal(this.data.get("exchangerate"));
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            String strValue = (String)this.data.get("bizdate");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date bizDate = df.parse(strValue);
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)currencyId, (Long)this.baseCurrencyId, (Long)this.orgId, (Date)bizDate);
            this.data.put("exchangerate", exchangeRate);
        }
    }

    private void sumHeadAmt(int amtprecision) {
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unverifyamount = BigDecimal.ZERO;
        BigDecimal unsettleamount = BigDecimal.ZERO;
        BigDecimal unsettleamountBase = BigDecimal.ZERO;
        JSONArray entryList = (JSONArray)this.data.get("detailentry");
        for (int i = 0; i < entryList.size(); ++i) {
            JSONObject row = (JSONObject)entryList.get(i);
            BigDecimal epricetaxtotal = this.parseBigDecimal(row.get((Object)"e_pricetaxtotal"));
            BigDecimal epricetaxtotalBase = this.parseBigDecimal(row.get((Object)"e_pricetaxtotalbase"));
            BigDecimal eamount = this.parseBigDecimal(row.get((Object)"e_amount"));
            BigDecimal eamountBase = this.parseBigDecimal(row.get((Object)"e_amountbase"));
            BigDecimal etax = this.parseBigDecimal(row.get((Object)"e_tax"));
            BigDecimal eunverifyamount = this.parseBigDecimal(row.get((Object)"e_unverifyamount"));
            BigDecimal eunsettleamount = this.parseBigDecimal(row.get((Object)"unsettleamt"));
            BigDecimal eunsettleamountBase = this.parseBigDecimal(row.get((Object)"unsettleamtbase"));
            pricetaxtotal = pricetaxtotal.add(epricetaxtotal);
            pricetaxtotalBase = pricetaxtotalBase.add(epricetaxtotalBase);
            amount = amount.add(eamount);
            amountBase = amountBase.add(eamountBase);
            tax = tax.add(etax);
            unverifyamount = unverifyamount.add(eunverifyamount);
            unsettleamount = unsettleamount.add(eunsettleamount);
            unsettleamountBase = unsettleamountBase.add(eunsettleamountBase);
        }
        this.data.put("pricetaxtotal", pricetaxtotal);
        this.data.put("pricetaxtotalbase", pricetaxtotalBase);
        this.data.put("amount", amount);
        this.data.put("amountbase", amountBase);
        this.data.put("tax", tax);
        this.data.put("unverifyamount", unverifyamount);
        this.data.put("unsettleamount", unsettleamount);
        this.data.put("unsettleamountbase", unsettleamountBase);
    }

    protected void sumEntryAmt(JSONObject row, BigDecimal exchangerate, int amtprecision, int priceprecision, boolean includeTax) {
        BigDecimal taxRate = BigDecimal.ZERO;
        if (row.containsKey((Object)"taxrateid")) {
            JSONObject value = (JSONObject)row.get((Object)"taxrateid");
            if (value != null) {
                DynamicObject taxRateInfo = this.getTaxRateByNameOrNumber(value.getString("name"), value.getString("number"));
                Object taxrate = taxRateInfo.get("taxrate");
                if (taxrate != null) {
                    taxRate = (BigDecimal)taxrate;
                }
            } else {
                taxRate = this.getEntryBigDecimal(row, "taxrate");
            }
        } else {
            taxRate = this.getEntryBigDecimal(row, "taxrate");
        }
        BigDecimal quantity = this.getEntryBigDecimal(row, "quantity");
        PriceLocalCalculator localCalculator = null;
        String discountMode = row.getString("discountmode");
        BigDecimal discountRate = this.getEntryBigDecimal(row, "discountrate");
        UnitPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal taxunitprice = this.getEntryBigDecimal(row, "pricetax");
            calculator = new TaxUnitPriceCalculator(quantity, taxunitprice, taxRate, discountMode, discountRate, amtprecision);
        } else {
            calculator = new UnitPriceCalculator(quantity, this.getEntryBigDecimal(row, "price"), taxRate, discountMode, discountRate, amtprecision);
        }
        localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangerate, this.baseCurrencyPrecision);
        localCalculator.calculate();
        row.put("price", (Object)localCalculator.getUnitprice());
        row.put("pricetax", (Object)localCalculator.getTaxunitprice());
        row.put("actprice", (Object)localCalculator.getActunitprice());
        row.put("actpricetax", (Object)localCalculator.getActtaxunitprice());
        row.put("quantity", (Object)localCalculator.getQuantity());
        row.put("e_amount", (Object)localCalculator.getAmount());
        row.put("e_amountbase", (Object)localCalculator.getAmountlocal());
        row.put("e_tax", (Object)localCalculator.getTax());
        row.put("discountamount", (Object)localCalculator.getDiscountamount());
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        row.put("e_pricetaxtotal", (Object)recamount);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        row.put("e_pricetaxtotalbase", (Object)reclocalamt);
        row.put("unverifyquantity", (Object)quantity);
        row.put("e_unverifyamount", (Object)localCalculator.getAmount());
        row.put("unlockamt", (Object)recamount);
        row.put("unsettleamt", (Object)recamount);
        row.put("unsettleamtbase", (Object)reclocalamt);
    }

    protected boolean isPeriod(Map<String, Object> data) {
        if (data.get("isperiod") != null) {
            return (Boolean)data.get("isperiod");
        }
        return true;
    }

    protected boolean includeTax(Map<String, Object> data) {
        boolean include = false;
        if (data.get("isincludetax") != null) {
            include = (Boolean)data.get("isincludetax");
        }
        return include;
    }
}

