/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class InitSettingEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map custParams = parameter.getCustomParams();
        OperationStatus status = parameter.getStatus();
        Object pk = custParams.get("pk");
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            DynamicObject org;
            long orgId = RequestContext.get().getOrgId();
            Object target = custParams.get("SELECT_ORG_ID");
            if (target != null) {
                orgId = Long.parseLong(target.toString());
            }
            if (!ObjectUtils.isEmpty((Object)(org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org"))) && org.getBoolean("fisaccounting")) {
                this.getModel().setValue("orgs", (Object)new Object[]{orgId});
                this.orgsF7Changed(this.getModel().getValue("orgs"));
            }
        }
        if (OperationStatus.ADDNEW.equals((Object)status) && pk != null || OperationStatus.EDIT.equals((Object)status)) {
            DynamicObject exratetable;
            DynamicObject init = BusinessDataServiceHelper.loadSingle(pk, (String)"ap_init");
            this.getModel().setValue("orgs", (Object)new Object[]{init.getDynamicObject("org").getPkValue()});
            DynamicObject currency = init.getDynamicObject("standardcurrency");
            if (!EmptyUtils.isEmpty((Object)currency)) {
                this.getModel().setValue("standardcurrency", currency.getPkValue());
            }
            if (!EmptyUtils.isEmpty((Object)(exratetable = init.getDynamicObject("exratetable")))) {
                this.getModel().setValue("exratetable", exratetable.getPkValue());
            }
            this.getModel().setValue("periodtype", init.getDynamicObject("periodtype").getPkValue());
            this.getModel().setValue("startperiod", init.getDynamicObject("startperiod").getPkValue());
            this.getModel().setValue("settlemodel", (Object)init.getString("settlemodel"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.orgsF7();
        }
        this.startPeriodF7();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        if (newCustomerUseNewSettle) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"settlemodel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"settlemodel"});
        }
    }

    private void orgsF7() {
        MulBasedataEdit orgsF7 = (MulBasedataEdit)this.getControl("orgs");
        if (!ObjectUtils.isEmpty((Object)orgsF7)) {
            orgsF7.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    List permOrgIds = OrgHelper.getAuthorizedBankOrgIds((String)"ap", (String)"ap_init", (String)"47150e89000000ac");
                    DynamicObject[] inits = BusinessDataServiceHelper.load((String)"ap_init", (String)"org.id", (QFilter[])new QFilter[]{QFilter.isNotNull((String)"startdate")});
                    ArrayList<Long> orgIds = new ArrayList<Long>(inits.length);
                    for (DynamicObject init : inits) {
                        orgIds.add(init.getLong("org.id"));
                    }
                    if (!permOrgIds.isEmpty() && !orgIds.isEmpty()) {
                        permOrgIds.removeAll(orgIds);
                        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)permOrgIds));
                    }
                }
            });
        }
    }

    private void startPeriodF7() {
        BasedataEdit periodF7 = (BasedataEdit)this.getControl("startperiod");
        periodF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject type = (DynamicObject)this.getModel().getValue("periodtype");
            QFilter qFilter = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            if (!EmptyUtils.isEmpty((Object)type)) {
                qFilter = qFilter.and("periodtype", "=", type.getPkValue());
            }
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            AdjExchService adjExchService = new AdjExchService("ap");
            adjExchService.insertAdjExchRecord(this.getModel());
            if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
                this.getView().invokeOperation("save");
            } else {
                OperateOption option = OperateOption.create();
                option.setVariableValue("pk", parameter.getCustomParam("pk").toString());
                this.getView().invokeOperation("save", option);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("orgs".equals(key) && !ObjectUtils.isEmpty((Object)newValue)) {
            this.orgsF7Changed(newValue);
        }
        if ("periodtype".equals(key)) {
            this.getModel().setValue("startperiod", null);
        }
    }

    private void orgsF7Changed(Object newValue) {
        DynamicObject firstOrg = (DynamicObject)((DynamicObjectCollection)newValue).get(0);
        DynamicObject acctOrgSetting = this.getAcctOrgSetting(firstOrg.getLong("fbasedataid_id"));
        if (acctOrgSetting != null) {
            this.getModel().setValue("standardcurrency", (Object)acctOrgSetting.getLong("basecurrrency"));
            this.getModel().setValue("exratetable", (Object)acctOrgSetting.getLong("exratetable"));
        } else {
            this.getModel().setValue("standardcurrency", (Object)1L);
        }
    }

    private DynamicObject getAcctOrgSetting(Long orgId) {
        QFilter qFilter = new QFilter("baseacctorg", "=", (Object)orgId);
        return QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"exratetable,basecurrrency", (QFilter[])new QFilter[]{qFilter});
    }
}

