/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.errorcode.SystemErrorCode;
import kd.fi.ap.vo.CloudInvoiceResultVO;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;

public class InvCollectEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InvCollectEdit.class);
    private static final String INVOICE_PAGE_SELECT_INVOICE = "selectInvoice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List orgIds = OrgHelper.getAuthorizedBankOrgIds((String)appId, (String)"ap_invoice", (String)"47156aff000000ac");
            if (!orgIds.isEmpty()) {
                showParameter.setCustomParam("range", (Object)orgIds);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object orgPk = this.getView().getFormShowParameter().getCustomParam("orgPk");
        this.getModel().setValue("org", orgPk);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("org"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"InvCollectEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else if (!this.codeRuleIsExist(org.getString("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u201c\u6536\u7968\u5355\u7f16\u7801\u89c4\u5219\u201d\uff0c\u518d\u91c7\u96c6\u53d1\u7968\u3002", (String)"InvCollectEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else {
                long orgPk = org.getLong("id");
                InitHelper init = new InitHelper(orgPk, "ap_init");
                if (ObjectUtils.isEmpty((Object)init.getStartDate())) {
                    throw new KDBizException(SystemErrorCode.ORGNAME_NOT_FINISHSET(), new Object[]{org.getLocaleString("name").getLocaleValue()});
                }
                CallCloudHelper.showInvoiceAssistant((AbstractFormPlugin)this);
            }
        }
    }

    private boolean codeRuleIsExist(String orgPk) {
        DynamicObject inv = BusinessDataServiceHelper.newDynamicObject((String)"ap_invoice");
        return CodeRuleServiceHelper.isExist((String)"ap_invoice", (DynamicObject)inv, (String)orgPk);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId.startsWith(INVOICE_PAGE_SELECT_INVOICE)) {
            if (!ObjectUtils.isEmpty((Object)returnData)) {
                InvoiceCollectParam collectParam = new InvoiceCollectParam();
                collectParam.setActionId(actionId);
                collectParam.setFormView(this.getView());
                collectParam.setReturnData((Map)returnData);
                ICollectInvoiceService collectService = (ICollectInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.NOSRCCOLLECT.getValue());
                CloudInvoiceResultVO resultVO = collectService.collectInvoice(collectParam);
                logger.info("InvCollectEdit-----close\u8fd4\u56de\u7684\u53c2\u6570\u662f" + resultVO);
                this.getView().returnDataToParent((Object)JsonUtils.objToJson((Object)resultVO));
            }
            this.getView().close();
        }
    }
}

