/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAssignService;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.util.JsonUtils;

public class InvoiceList4Fin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(InvoiceList4Fin.class);
    private InvoiceAssignService assignService = new InvoiceAssignService();

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String key = e.getItemKey();
        if ("tbl_assign".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Set ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            this.getPageCache().put("invPks", JsonUtils.objToJson(ids));
            DynamicObject[] invoiceBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"billstatus,billno,org, asstacttype, receivablessupp, unrelatedamt,currency,invoicestatus,ismatched", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (invoiceBills.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceList4Fin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = this.assignService.showFinApF7(this.getView(), invoiceBills);
            if (lsp != null) {
                lsp.setCustomParam("apassign", (Object)"true");
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "finapbillF7"));
                this.getView().showForm((FormShowParameter)lsp);
            }
        } else if ("bar_viewreplaceinv".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Set ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_invoice", (String)"ap_invoice", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"");
            ArrayList<Long> billIds = new ArrayList<Long>(32);
            HashSet<Long> orgIds = new HashSet<Long>(8);
            for (Row row : finApDataSet) {
                orgIds.add(row.getLong("org"));
                billIds.add(row.getLong("id"));
            }
            ReplaceInvoiceHelper.viewReplaceInvoiceList((IFormView)this.getView(), orgIds, billIds);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("finapbillF7".equalsIgnoreCase(actionId)) {
            this.assignService.closedCallBack((AbstractFormPlugin)this, actionId, e.getReturnData());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if ("assign".equals(operateKey) || "antiassign".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        } else if ("inv4matchinv".equals(operateKey) && operationResult.isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Set ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            DynamicObject[] invoiceBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,ismatched,unrelatedamt,pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            HashSet<Object> matchIds = new HashSet<Object>(8);
            HashSet<Object> relatedIds = new HashSet<Object>(8);
            for (DynamicObject invoiceBill : invoiceBills) {
                if (invoiceBill.getBoolean("ismatched")) {
                    matchIds.add(invoiceBill.getPkValue());
                }
                if (invoiceBill.getBigDecimal("unrelatedamt").compareTo(invoiceBill.getBigDecimal("pricetaxtotal")) == 0) continue;
                relatedIds.add(invoiceBill.getPkValue());
            }
            if (matchIds.size() > 0 && matchIds.size() != invoiceBills.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u72b6\u6001\u4e0d\u540c\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5339\u914d\uff0c\u8bf7\u52fe\u9009\u5339\u914d\u72b6\u6001\u76f8\u540c\u7684\u6570\u636e\u91cd\u8bd5\u3002", (String)"InvoiceList4Fin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            if (relatedIds.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5173\u8054\u6307\u5b9a\u5e94\u4ed8\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5339\u914d\uff0c\u8bf7\u52fe\u9009\u672a\u5173\u8054\u6307\u5b9a\u5e94\u4ed8\u5355\u7684\u6570\u636e\u91cd\u8bd5\u3002", (String)"InvoiceList4Fin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap customParams = new HashMap(1);
            customParams.put("invids", ids);
            if (matchIds.size() == invoiceBills.length) {
                if (relatedIds.size() == invoiceBills.length) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5339\u914d\u5e76\u786e\u8ba4\u5e94\u4ed8\uff0c\u65e0\u9700\u5339\u914d\u3002", (String)"InvoiceList4Fin_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("ap_matchinvoice");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setCustomParams(customParams);
                this.getView().showForm((FormShowParameter)listShowParameter);
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ap_matchinvoice");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParams(customParams);
            this.getView().showForm(formShowParameter);
        } else if ("tblviewrecord".equals(operateKey) && operationResult.isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Set ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            DynamicObject[] invoiceBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,ismatched,unrelatedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            HashSet<Object> matchIds = new HashSet<Object>(8);
            for (DynamicObject invoiceBill : invoiceBills) {
                if (!invoiceBill.getBoolean("ismatched")) continue;
                matchIds.add(invoiceBill.getPkValue());
            }
            if (matchIds.size() != invoiceBills.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5339\u914d\u6570\u636e\uff0c\u8bf7\u52fe\u9009\u5df2\u5339\u914d\u6570\u636e\u540e\u91cd\u8bd5\u3002", (String)"InvoiceList4Fin_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            Map matchInvIds = BusinessDataServiceHelper.loadFromCache((String)"ap_matchinvoice", (String)"id,entry", (QFilter[])new QFilter[]{new QFilter("entry.invoiceid", "in", ids)});
            if (matchInvIds.size() == 1) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("ap_matchinvoice");
                billShowParameter.setStatus(OperationStatus.VIEW);
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                Long matchId = 0L;
                for (Map.Entry matchInvoice : matchInvIds.entrySet()) {
                    matchId = ((DynamicObject)matchInvoice.getValue()).getLong("id");
                }
                billShowParameter.setPkId((Object)matchId);
                this.getView().showForm((FormShowParameter)billShowParameter);
            } else {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("ap_matchinvoice");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap customParams = new HashMap(1);
                customParams.put("invids", ids);
                listShowParameter.setCustomParams(customParams);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }
}

