/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoicematch.helper.MatchSchemeConverter;
import kd.fi.ap.business.invoicematch.match.AbstractInvMatchService;
import kd.fi.ap.business.invoicematch.match.PurInMatchService;
import kd.fi.ap.vo.MatchResult;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.ap.vo.MatchSchemeVO;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class InvoiceMatchEdit
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(InvoiceMatchEdit.class);
    AbstractInvMatchService service = new PurInMatchService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        EntryGrid entryGridControl = (EntryGrid)this.getControl("entry");
        entryGridControl.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                InvoiceMatchEdit.this.sumSubEntry(row);
            }
        });
        BasedataEdit matchschemeF7 = (BasedataEdit)this.getControl("matchscheme");
        matchschemeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"ap_matchscheme", (Long)org.getLong("id"));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void sumSubEntry(int row) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        DynamicObjectCollection subentry = ((DynamicObject)entry.get(row)).getDynamicObjectCollection("subentry");
        BigDecimal sumqty = BigDecimal.ZERO;
        BigDecimal sumtax = BigDecimal.ZERO;
        BigDecimal sumamt = BigDecimal.ZERO;
        BigDecimal sumamtandtax = BigDecimal.ZERO;
        for (DynamicObject matchEntry : subentry) {
            BigDecimal curqty = matchEntry.getBigDecimal("curbaseqty");
            BigDecimal curamtandtax = matchEntry.getBigDecimal("curamtandtax");
            BigDecimal curtax = matchEntry.getBigDecimal("curtax");
            BigDecimal curamt = matchEntry.getBigDecimal("curamt");
            sumqty = sumqty.add(curqty);
            sumamtandtax = sumamtandtax.add(curamtandtax);
            sumtax = sumtax.add(curtax);
            sumamt = sumamt.add(curamt);
        }
        this.getModel().setValue("matchedqty", (Object)sumqty);
        this.getModel().setValue("matchedtaxandamt", (Object)sumamtandtax);
        this.getModel().setValue("matchedamt", (Object)sumamt);
        this.getModel().setValue("matchedtax", (Object)sumtax);
        Boolean ismatched = (Boolean)this.getModel().getValue("ismatched");
        if (ismatched.booleanValue()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List invids = (List)customParams.get("invids");
        if (ObjectUtils.isEmpty((Object)invids)) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cfmap", "bar_viewap"});
        List matchResults = this.service.mainDataInit(invids, null);
        IDataModel model = this.getModel();
        MatchResult result = (MatchResult)matchResults.get(0);
        model.setValue("asstactname", (Object)result.getAsstactname());
        model.setValue("buyername", (Object)result.getBuyername());
        model.setValue("asstacttype", (Object)result.getAsstacttype());
        model.setValue("asstact", (Object)result.getAsstactId());
        model.setValue("srcasstact", (Object)result.getAsstactId());
        Long orgId = result.getOrgId();
        model.setValue("org", (Object)orgId);
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"ap_matchscheme", (String)"id,createorg,isdefault", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)orgId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (scheme != null) {
            model.setValue("matchscheme", scheme.get("id"));
        }
        model.setValue("currency", (Object)result.getCurrencyId());
        model.setValue("biztype", (Object)result.getBiztype());
        model.setValue("invoicetype", (Object)result.getInvoicetype());
        model.setValue("invoicetypef7", (Object)result.getInvoicetypeId());
        Map extMap = result.getExtMap();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("invoiceid", new Object[0]);
        vs.addField("invoiceentryid", new Object[0]);
        vs.addField("invoicebillno", new Object[0]);
        vs.addField("invoicecode", new Object[0]);
        vs.addField("invoiceno", new Object[0]);
        vs.addField("material", new Object[0]);
        vs.addField("srcmaterial", new Object[0]);
        vs.addField("e_materialversion", new Object[0]);
        vs.addField("spectype", new Object[0]);
        vs.addField("e_invname", new Object[0]);
        vs.addField("e_invunit", new Object[0]);
        vs.addField("measureunit", new Object[0]);
        vs.addField("quantity", new Object[0]);
        vs.addField("price", new Object[0]);
        vs.addField("taxrate", new Object[0]);
        vs.addField("e_taxclass", new Object[0]);
        vs.addField("discountmode", new Object[0]);
        vs.addField("discountrate", new Object[0]);
        vs.addField("discountamt", new Object[0]);
        vs.addField("e_amount", new Object[0]);
        vs.addField("e_tax", new Object[0]);
        vs.addField("e_pricetaxtotal", new Object[0]);
        vs.addField("e_baseunit", new Object[0]);
        vs.addField("e_baseqty", new Object[0]);
        for (Map.Entry entry : extMap.entrySet()) {
            vs.addField((String)entry.getKey(), new Object[0]);
        }
        model.beginInit();
        int fieldsSize = vs.getFields().size();
        AbstractFormDataModel formDataModel = (AbstractFormDataModel)this.getModel();
        for (MatchResult matchResult : matchResults) {
            ArrayList<Object> rowObj = new ArrayList<Object>(fieldsSize);
            rowObj.add(matchResult.getInvPk());
            rowObj.add(matchResult.getInvEntryPk());
            rowObj.add(matchResult.getBillno());
            rowObj.add(matchResult.getInvoicecode());
            rowObj.add(matchResult.getInvoiceno());
            rowObj.add(matchResult.getMaterialId());
            rowObj.add(matchResult.getMaterialId());
            rowObj.add(matchResult.getMaterialversion());
            rowObj.add(matchResult.getSpectype());
            rowObj.add(matchResult.getInvname());
            rowObj.add(matchResult.getInvunit());
            rowObj.add(matchResult.getMeasureunit());
            rowObj.add(matchResult.getQuantity());
            rowObj.add(matchResult.getPrice());
            rowObj.add(matchResult.getTaxrate());
            rowObj.add(matchResult.getTaxclass());
            rowObj.add(matchResult.getDiscountmode());
            rowObj.add(matchResult.getDiscountrate());
            rowObj.add(matchResult.getDiscountamt());
            rowObj.add(matchResult.getAmount());
            rowObj.add(matchResult.getTax());
            rowObj.add(matchResult.getPricetaxtotal());
            rowObj.add(matchResult.getBaseunit());
            rowObj.add(matchResult.getBaseqty());
            for (Map.Entry entry : matchResult.getExtMap().entrySet()) {
                rowObj.add(entry.getValue());
            }
            vs.addRow(rowObj.toArray());
        }
        formDataModel.batchCreateNewEntryRow("entry", vs);
        model.endInit();
        this.getView().updateView("entry");
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        if (entryRowCount > 0) {
            this.sumSubEntry(0);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        switch (key) {
            case "asstact": {
                this.resetInvoiceEntries();
                break;
            }
            case "material": {
                this.materialChanged(changeData[0]);
                break;
            }
            case "curqty": {
                this.curqtyChanged(changeData[0]);
            }
        }
    }

    private void curqtyChanged(ChangeData changeData) {
        int currentIndex = changeData.getRowIndex();
        int parentRowIndex = changeData.getParentRowIndex();
        BigDecimal curqty = (BigDecimal)changeData.getNewValue();
        BigDecimal uninvoicedqty = (BigDecimal)this.getModel().getValue("uninvoicedqty", currentIndex, parentRowIndex);
        if (curqty.signum() != 0 && (curqty.signum() != uninvoicedqty.signum() || curqty.abs().compareTo(uninvoicedqty.abs()) > 0)) {
            this.getModel().setValue("curqty", changeData.getOldValue(), currentIndex, parentRowIndex);
            return;
        }
        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", currentIndex, parentRowIndex);
        DynamicObject baseunit = (DynamicObject)this.getModel().getValue("baseunit", currentIndex, parentRowIndex);
        DynamicObject material = (DynamicObject)this.getModel().getValue("s_material", currentIndex, parentRowIndex);
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)unit.getLong("id"), (Long)baseunit.getLong("id"));
        BigDecimal curbaseqty = UnitConvertHelper.getBaseunitqty((BigDecimal)curqty, (BigDecimal)unitRateConv, (DynamicObject)baseunit);
        this.getModel().setValue("curbaseqty", (Object)curbaseqty, currentIndex, parentRowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue("s_price", currentIndex, parentRowIndex);
        BigDecimal curMatchAmt = curqty.multiply(price);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        BigDecimal taxrate = (BigDecimal)this.getModel().getValue("s_taxrate", currentIndex, parentRowIndex);
        BigDecimal curMatchTax = curMatchAmt.multiply(taxrate).divide(new BigDecimal(100), currency.getInt("amtprecision"), 4);
        this.getModel().setValue("curamt", (Object)curMatchAmt, currentIndex, parentRowIndex);
        this.getModel().setValue("curtax", (Object)curMatchTax, currentIndex, parentRowIndex);
        this.getModel().setValue("curamtandtax", (Object)curMatchAmt.add(curMatchTax), currentIndex, parentRowIndex);
        this.sumSubEntry(parentRowIndex);
        BigDecimal amt = (BigDecimal)this.getModel().getValue("e_amount", parentRowIndex);
        BigDecimal tax = (BigDecimal)this.getModel().getValue("e_tax", parentRowIndex);
        BigDecimal matchedamt = (BigDecimal)this.getModel().getValue("matchedamt");
        BigDecimal matchedtax = (BigDecimal)this.getModel().getValue("matchedtax");
        BigDecimal amtdiff = amt.subtract(matchedamt);
        BigDecimal taxdiff = tax.subtract(matchedtax);
        this.getModel().setValue("amountdiff", (Object)amtdiff, parentRowIndex);
        this.getModel().setValue("taxdiff", (Object)taxdiff, parentRowIndex);
        this.getModel().setValue("pricetaxtotaldiff", (Object)amtdiff.add(taxdiff), parentRowIndex);
    }

    private void materialChanged(ChangeData changeData) {
        int currentIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        DynamicObject material = (DynamicObject)newValue;
        if (material != null) {
            this.getModel().setValue("spectype", (Object)material.getLocaleString("modelnum").getLocaleValue(), currentIndex);
            DynamicObject baseunit = material.getDynamicObject("baseunit");
            if (baseunit != null) {
                this.getModel().beginInit();
                this.getModel().setValue("measureunit", baseunit.getPkValue(), currentIndex);
                this.getModel().setValue("e_baseunit", baseunit.getPkValue(), currentIndex);
                BigDecimal quantity = (BigDecimal)this.getModel().getValue("quantity", currentIndex);
                if (quantity != null) {
                    BigDecimal precisionQty = quantity.setScale(baseunit.getInt("precision"), 4);
                    this.getModel().setValue("quantity", (Object)precisionQty, currentIndex);
                    this.getModel().setValue("e_baseqty", (Object)precisionQty, currentIndex);
                }
                this.getModel().endInit();
                this.getView().updateView("entry");
            }
        } else {
            this.getModel().setValue("spectype", (Object)"", currentIndex);
            this.getModel().setValue("measureunit", (Object)"", currentIndex);
            this.getModel().setValue("e_baseunit", (Object)"", currentIndex);
        }
        this.getModel().setValue("e_materialversion", (Object)"", currentIndex);
        this.resetInvoiceEntries();
    }

    private void resetInvoiceEntries() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryColl) {
            entry.getDynamicObjectCollection("subentry").clear();
        }
        this.getView().updateView();
        this.getModel().setValue("matchedqty", (Object)BigDecimal.ZERO);
        this.getModel().setValue("matchedtaxandamt", (Object)BigDecimal.ZERO);
        this.getModel().setValue("matchedamt", (Object)BigDecimal.ZERO);
        this.getModel().setValue("matchedtax", (Object)BigDecimal.ZERO);
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.resetDiffAmt(i);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("reset".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            BigDecimal baseqty = (BigDecimal)this.getModel().getValue("e_baseqty", rowIndex);
            int subentryCount = this.getModel().getEntryRowCount("subentry");
            for (int i = 0; i < subentryCount; ++i) {
                BigDecimal uninvoicedbaseqty = (BigDecimal)this.getModel().getValue("uninvoicedbaseqty", i, rowIndex);
                BigDecimal curbaseqty = baseqty.abs().subtract(uninvoicedbaseqty.abs()).signum() > 0 ? uninvoicedbaseqty : baseqty;
                DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", i, rowIndex);
                DynamicObject baseunit = (DynamicObject)this.getModel().getValue("baseunit", i, rowIndex);
                DynamicObject material = (DynamicObject)this.getModel().getValue("s_material", i, rowIndex);
                BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)unit.getLong("id"), (Long)baseunit.getLong("id"));
                BigDecimal curqty = UnitConvertHelper.getUnitQty((BigDecimal)curbaseqty, (BigDecimal)unitRateConv, (DynamicObject)unit);
                this.getModel().setValue("curqty", (Object)curqty, i, rowIndex);
                baseqty = baseqty.subtract(curbaseqty);
            }
        } else if ("automatch".equals(key) || "bar_automatch".equals(key)) {
            boolean isConfirm = false;
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry", i);
                DynamicObjectCollection subentryColl = entryRowEntity.getDynamicObjectCollection("subentry");
                if (subentryColl.isEmpty()) continue;
                isConfirm = true;
            }
            if (isConfirm) {
                this.getView().invokeOperation("matchconfirm");
            } else {
                this.getView().invokeOperation("automatch");
            }
        } else if ("bar_viewap".equals(key)) {
            HashSet<Object> ids = new HashSet<Object>(2);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                DynamicObjectCollection subentryColl = entry.getDynamicObjectCollection("subentry");
                for (DynamicObject subentry : subentryColl) {
                    ids.add(subentry.get("apbillid"));
                }
            }
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ap_finapbill");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter param = new ListFilterParameter();
            param.setFilter(new QFilter("id", "in", ids));
            parameter.setListFilterParameter(param);
            Object orgId = dataEntity.get("org.id");
            parameter.setCustomParam("initOrg", orgId);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("subentry".equals(entryProp.getName())) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            int subentryIndex = this.getModel().getEntryCurrentRowIndex("subentry");
            BigDecimal curamtandtax = (BigDecimal)this.getModel().getValue("curamtandtax", subentryIndex, entryCurrentRowIndex);
            BigDecimal pricetaxtotaldiff = (BigDecimal)this.getModel().getValue("pricetaxtotaldiff", entryCurrentRowIndex);
            this.getModel().setValue("pricetaxtotaldiff", (Object)pricetaxtotaldiff.add(curamtandtax), entryCurrentRowIndex);
            BigDecimal curamt = (BigDecimal)this.getModel().getValue("curamt", subentryIndex, entryCurrentRowIndex);
            BigDecimal amountdiff = (BigDecimal)this.getModel().getValue("amountdiff", entryCurrentRowIndex);
            this.getModel().setValue("amountdiff", (Object)amountdiff.add(curamt), entryCurrentRowIndex);
            BigDecimal curtax = (BigDecimal)this.getModel().getValue("curtax", subentryIndex, entryCurrentRowIndex);
            BigDecimal taxdiff = (BigDecimal)this.getModel().getValue("taxdiff", entryCurrentRowIndex);
            this.getModel().setValue("taxdiff", (Object)taxdiff.add(curtax), entryCurrentRowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("subentry".equals(entryProp.getName())) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            this.sumSubEntry(entryCurrentRowIndex);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry", entryCurrentRowIndex);
            DynamicObjectCollection subentryColl = entryRowEntity.getDynamicObjectCollection("subentry");
            if (subentryColl.isEmpty()) {
                this.resetDiffAmt(entryCurrentRowIndex);
            }
        }
    }

    private void resetDiffAmt(int entryCurrentRowIndex) {
        this.getModel().setValue("amountdiff", (Object)BigDecimal.ZERO, entryCurrentRowIndex);
        this.getModel().setValue("taxdiff", (Object)BigDecimal.ZERO, entryCurrentRowIndex);
        this.getModel().setValue("pricetaxtotaldiff", (Object)BigDecimal.ZERO, entryCurrentRowIndex);
        this.getModel().setValue("entrylog", (Object)BigDecimal.ZERO, entryCurrentRowIndex);
    }

    private List<Object> getInvIds() {
        ArrayList<Object> invIds = new ArrayList<Object>(8);
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            invIds.add(this.getModel().getValue("invoiceid", i));
        }
        return invIds;
    }

    private void fillMatchEntry(boolean isDel, MatchResult matchResult, int i) {
        IDataModel model = this.getModel();
        model.setValue("amountdiff", (Object)matchResult.getAmountdiff(), i);
        model.setValue("taxdiff", (Object)matchResult.getTaxdiff(), i);
        model.setValue("pricetaxtotaldiff", (Object)matchResult.getPricetaxtotaldiff(), i);
        model.setValue("entrylog", (Object)matchResult.getLogmsg(), i);
        List items = matchResult.getItems();
        if (items.isEmpty()) {
            return;
        }
        model.setEntryCurrentRowIndex("entry", i);
        if (isDel) {
            model.deleteEntryData("subentry");
        }
        Map extSubMap = ((MatchResultItem)items.get(0)).getExtSubMap();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("stockbill", new Object[0]);
        vs.addField("biztime", new Object[0]);
        vs.addField("stockbillid", new Object[0]);
        vs.addField("stockentryid", new Object[0]);
        vs.addField("s_material", new Object[0]);
        vs.addField("s_materialname", new Object[0]);
        vs.addField("unit", new Object[0]);
        vs.addField("qty", new Object[0]);
        vs.addField("baseunit", new Object[0]);
        vs.addField("baseqty", new Object[0]);
        vs.addField("s_price", new Object[0]);
        vs.addField("uninvoicedqty", new Object[0]);
        vs.addField("uninvoicedbaseqty", new Object[0]);
        vs.addField("uninvoicedamt", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("s_taxrate", new Object[0]);
        vs.addField("taxamount", new Object[0]);
        vs.addField("amountandtax", new Object[0]);
        vs.addField("curqty", new Object[0]);
        vs.addField("curbaseqty", new Object[0]);
        vs.addField("curamt", new Object[0]);
        vs.addField("curtax", new Object[0]);
        vs.addField("curamtandtax", new Object[0]);
        vs.addField("pricediff", new Object[0]);
        vs.addField("orderbill", new Object[0]);
        vs.addField("orderbillid", new Object[0]);
        for (Map.Entry entry : extSubMap.entrySet()) {
            vs.addField((String)entry.getKey(), new Object[0]);
        }
        model.beginInit();
        int fieldsSize = vs.getFields().size();
        AbstractFormDataModel formDataModel = (AbstractFormDataModel)this.getModel();
        formDataModel.setEntryCurrentRowIndex("entry", i);
        for (MatchResultItem item : items) {
            ArrayList<Object> rowObj = new ArrayList<Object>(fieldsSize);
            rowObj.add(item.getBillno());
            rowObj.add(item.getBiztime());
            rowObj.add(item.getBillId());
            rowObj.add(item.getEntryId());
            rowObj.add(item.getMaterialId());
            rowObj.add(item.getMaterialname());
            rowObj.add(item.getUnitId());
            rowObj.add(item.getQty());
            rowObj.add(item.getBaseunitId());
            rowObj.add(item.getBaseqty());
            BigDecimal subPrice = item.getPrice();
            rowObj.add(subPrice);
            rowObj.add(item.getUninvoicedqty());
            rowObj.add(item.getUninvoicedbaseqty());
            rowObj.add(item.getUninvoicedamt());
            rowObj.add(item.getAmount());
            rowObj.add(item.getTaxrate());
            rowObj.add(item.getTaxamount());
            rowObj.add(item.getAmountandtax());
            rowObj.add(item.getCurqty());
            rowObj.add(item.getCurbaseqty());
            rowObj.add(item.getCuramt());
            rowObj.add(item.getCurtax());
            rowObj.add(item.getCuramtandtax());
            BigDecimal pricediff = item.getPricediff();
            rowObj.add(pricediff);
            rowObj.add(item.getOrderbillno());
            rowObj.add(item.getOrderId());
            for (Map.Entry entry : item.getExtSubMap().entrySet()) {
                rowObj.add(entry.getValue());
            }
            vs.addRow(rowObj.toArray());
        }
        formDataModel.batchCreateNewEntryRow("subentry", vs);
        model.endInit();
        this.getView().updateView("subentry");
        this.sumSubEntry(i);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperationResult result;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entry");
            HashSet<Object> invIds = new HashSet<Object>(1);
            for (Object entry : entryColl) {
                invIds.add(entry.get("invoiceid"));
            }
            HashMap<Long, MatchResultItem> matchItemMap = new HashMap<Long, MatchResultItem>(16);
            for (DynamicObject entry : entryColl) {
                BigDecimal curbaseqty;
                BigDecimal baseqty = entry.getBigDecimal("e_baseqty");
                DynamicObjectCollection subentryColl = entry.getDynamicObjectCollection("subentry");
                for (DynamicObject subentry : subentryColl) {
                    curbaseqty = subentry.getBigDecimal("curbaseqty");
                    baseqty = baseqty.subtract(curbaseqty);
                    Object stockEntryId = subentry.get("stockentryid");
                    MatchResultItem item = (MatchResultItem)matchItemMap.get(stockEntryId);
                    if (item != null) {
                        item.setCurbaseqty(curbaseqty.add(item.getCurbaseqty()));
                        continue;
                    }
                    item = new MatchResultItem();
                    item.setEntryId(stockEntryId);
                    item.setCurbaseqty(curbaseqty);
                    item.setUninvoicedbaseqty(subentry.getBigDecimal("uninvoicedbaseqty"));
                    item.setBillno(subentry.getString("stockbill"));
                    matchItemMap.put((Long)stockEntryId, item);
                }
                if (baseqty.signum() != 0) {
                    args.setCancel(true);
                    DynamicObject[] invArr = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,billno,org,asstacttype,asstact,currency,invoicetype", (QFilter[])new QFilter[]{new QFilter("id", "in", invIds)});
                    OpLogServiceHelper.addLog((String)"ManualMatchInvoice", (Object)dataEntity, (DynamicObject[])invArr, (boolean)false);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u6ca1\u6709\u5b8c\u5168\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"InvoiceMatchEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                Iterator iterator = subentryColl.iterator();
                while (iterator.hasNext()) {
                    DynamicObject subentry;
                    subentry = (DynamicObject)iterator.next();
                    curbaseqty = subentry.getBigDecimal("curbaseqty");
                    if (curbaseqty.signum() != 0) continue;
                    iterator.remove();
                }
                this.getView().updateView("subentry");
            }
            DynamicObjectCollection matchColl = QueryServiceHelper.query((String)"ap_matchinvoice", (String)"id,entry.subentry.stockentryid stockentryid,entry.subentry.curbaseqty curbaseqty", (QFilter[])new QFilter[]{new QFilter("ismatched", "=", (Object)Boolean.FALSE), new QFilter("id", "!=", this.getModel().getValue("id")), new QFilter("entry.subentry.stockentryid", "in", matchItemMap.keySet())});
            for (DynamicObject matchRecord : matchColl) {
                Long stockentryid = matchRecord.getLong("stockentryid");
                BigDecimal curbaseqty = matchRecord.getBigDecimal("curbaseqty");
                MatchResultItem item = (MatchResultItem)matchItemMap.get(stockentryid);
                if (item == null) continue;
                item.setCurbaseqty(curbaseqty.add(item.getCurbaseqty()));
            }
            for (Map.Entry entry : matchItemMap.entrySet()) {
                MatchResultItem item = (MatchResultItem)entry.getValue();
                BigDecimal uninvoicedbaseqty = item.getUninvoicedbaseqty();
                BigDecimal curbaseqty = item.getCurbaseqty();
                if (curbaseqty.abs().compareTo(uninvoicedbaseqty.abs()) <= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u5355\u636e\uff1a%s\uff0c\u672c\u6b21\u5339\u914d\u57fa\u672c\u6570\u91cf\u8d85\u8fc7\u53ef\u5339\u914d\u7684\u6700\u5927\u989d\u5ea6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"InvoiceMatchEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[]{item.getBillno()}));
            }
        } else if ("cfmap".equals(key) && !(result = this.getView().invokeOperation("save")).isSuccess()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("showlist".equals(operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex("entry");
            BigDecimal matchedqty = (BigDecimal)this.getModel().getValue("matchedqty");
            BigDecimal baseqty = (BigDecimal)this.getModel().getValue("e_baseqty", index);
            if (baseqty.compareTo(matchedqty) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u91cf\u5df2\u7ecf\u5b8c\u5168\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u3002", (String)"InvoiceMatchEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            String billType = (String)this.getModel().getValue("billtype");
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)billType, (boolean)true, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entry");
            HashSet<Object> matchIds = new HashSet<Object>(1);
            DynamicObject entry = (DynamicObject)entryColl.get(index);
            DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentry");
            for (DynamicObject subentry : subEntryColl) {
                Object matchId = subentry.get("stockbillid");
                matchIds.add(matchId);
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter qfilter = new QFilter("billentry.entrysettleorg", "=", org.getPkValue());
            DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstact");
            qfilter.and(new QFilter("billentry.invoicesupplier.masterid", "=", asstact.get("masterid")));
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", index);
            qfilter.and(new QFilter("billentry.materialmasterid", "=", material.getPkValue()));
            qfilter.and(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            qfilter.and(new QFilter("settlecurrency", "=", currency.getPkValue()));
            qfilter.and(new QFilter("id", "not in", matchIds));
            Object orderbillno = this.getModel().getValue("orderbillno");
            if (EmptyUtils.isNotEmpty((Object)orderbillno)) {
                qfilter.and(new QFilter("billentry.mainbillentity", "=", (Object)"pm_purorderbill"));
                qfilter.and(new QFilter("billentry.mainbillnumber", "=", orderbillno));
            }
            if (baseqty.compareTo(BigDecimal.ZERO) > 0) {
                qfilter.and(new QFilter("billentry.remainjoinpricebaseqty", ">", (Object)BigDecimal.ZERO));
            } else {
                qfilter.and(new QFilter("billentry.remainjoinpricebaseqty", "<", (Object)BigDecimal.ZERO));
            }
            lfp.setFilter(qfilter);
            StringBuilder builder = new StringBuilder("MatchFilter:");
            builder.append(qfilter);
            logger.info(builder.toString());
            lsp.setListFilterParameter(lfp);
            lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "matchBillF7"));
            this.getView().showForm((FormShowParameter)lsp);
        } else if ("save".equals(operateKey)) {
            boolean isChanged = false;
            Object asstact = this.getModel().getValue("asstact");
            Object srcasstact = this.getModel().getValue("srcasstact");
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            HashMap<Long, Object[]> entryMap = new HashMap<Long, Object[]>(entryRowCount);
            for (int i2 = 0; i2 < entryRowCount; ++i2) {
                Long invEntryId = (Long)this.getModel().getValue("invoiceentryid", i2);
                Object material = this.getModel().getValue("material", i2);
                DynamicObject[] srcmaterial = this.getModel().getValue("srcmaterial", i2);
                entryMap.put(invEntryId, new Object[]{material, srcmaterial, i2});
            }
            if (ObjectUtils.nullSafeEquals((Object)asstact, (Object)srcasstact)) {
                for (Map.Entry entry : entryMap.entrySet()) {
                    Object[] v = (Object[])entry.getValue();
                    if (ObjectUtils.nullSafeEquals((Object)v[0], (Object)v[1])) continue;
                    isChanged = true;
                    break;
                }
            } else {
                isChanged = true;
            }
            if (isChanged) {
                DynamicObject[] invArr;
                QFilter filter = new QFilter("entry.id", "in", entryMap.keySet());
                String properties = "ismatched,receivablessupp,entry.material,entry.e_materialversion,entry.spectype,entry.measureunit,entry.quantity";
                for (DynamicObject inv : invArr = BusinessDataServiceHelper.load((String)"ap_invoice", (String)properties, (QFilter[])filter.toArray())) {
                    inv.set("receivablessupp", asstact);
                    DynamicObjectCollection entryColl = inv.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entryColl) {
                        Object[] changeDatas = (Object[])entryMap.get(entry.getLong("id"));
                        entry.set("material", changeDatas[0]);
                        int changeIndex = (Integer)changeDatas[2];
                        entry.set("e_materialversion", this.getModel().getValue("e_materialversion", changeIndex));
                        entry.set("spectype", this.getModel().getValue("spectype", changeIndex));
                        entry.set("measureunit", this.getModel().getValue("measureunit", changeIndex));
                        entry.set("quantity", this.getModel().getValue("quantity", changeIndex));
                    }
                }
                SaveServiceHelper.update((DynamicObject[])invArr);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_cfmap", "bar_viewap"});
        } else if ("automatch".equals(operateKey)) {
            DynamicObject matchScheme = (DynamicObject)this.getModel().getValue("matchscheme");
            if (matchScheme == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u65b9\u6848\u3002", (String)"InvoiceMatchEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            MatchSchemeVO matchSchemeVO = MatchSchemeConverter.convertMatchSchemeToVO((Long)matchScheme.getLong("id"));
            List results = this.service.mainDataInit(this.getInvIds(), matchSchemeVO);
            Map<Long, MatchResult> entryPKMap = results.stream().collect(Collectors.toMap(MatchResult::getInvEntryPk, i -> i));
            Object orderbillno = this.getModel().getValue("orderbillno");
            DynamicObject asstact = (DynamicObject)this.getModel().getValue("asstact");
            int count = this.getModel().getEntryRowCount("entry");
            results.clear();
            for (int i3 = 0; i3 < count; ++i3) {
                DynamicObject material;
                Long entryPK = (Long)this.getModel().getValue("invoiceentryid", i3);
                String billNo = (String)this.getModel().getValue("invoicebillno", i3);
                MatchResult matchResult = entryPKMap.get(entryPK);
                if (matchResult == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u7968\u5355\uff1a%s\uff0c\u5b58\u5728\u5df2\u5173\u8054\u5e94\u4ed8\u884c\uff0c\u65e0\u6cd5\u8fdb\u884c\u5339\u914d\u3002", (String)"InvoiceMatchEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[]{billNo}));
                }
                matchResult.setMatchResultPk((Long)this.getModel().getValue("id"));
                if (EmptyUtils.isNotEmpty((Object)orderbillno)) {
                    matchResult.setOrderbillno(orderbillno.toString());
                }
                if (EmptyUtils.isNotEmpty((Object)asstact)) {
                    matchResult.setAsstactId(Long.valueOf(asstact.getLong("masterid")));
                }
                if (EmptyUtils.isNotEmpty((Object)(material = (DynamicObject)this.getModel().getValue("material", i3)))) {
                    matchResult.setMaterialId(Long.valueOf(material.getLong("id")));
                    DynamicObject measureunit = (DynamicObject)this.getModel().getValue("measureunit", i3);
                    matchResult.setMeasureunit(Long.valueOf(measureunit.getLong("id")));
                    BigDecimal quantity = (BigDecimal)this.getModel().getValue("quantity", i3);
                    matchResult.setQuantity(quantity);
                    DynamicObject baseunit = (DynamicObject)this.getModel().getValue("e_baseunit", i3);
                    matchResult.setBaseunit(Long.valueOf(baseunit.getLong("id")));
                    BigDecimal baseqty = (BigDecimal)this.getModel().getValue("e_baseqty", i3);
                    matchResult.setBaseqty(baseqty);
                    Map schemeMap = matchResult.getSchemeMap();
                    schemeMap.put("entry.measureunit", measureunit.getLong("id"));
                    schemeMap.put("entry.material", material.getLong("id"));
                    schemeMap.put("receivablessupp", asstact.getLong("masterid"));
                }
                results.add(matchResult);
            }
            List matchResults = this.service.loadMatchBill(results, matchSchemeVO);
            for (int i4 = 0; i4 < matchResults.size(); ++i4) {
                MatchResult matchResult = (MatchResult)matchResults.get(i4);
                this.fillMatchEntry(true, matchResult, i4);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u7ed3\u675f\uff0c\u8bf7\u67e5\u770b\u5339\u914d\u7ed3\u679c\u3002", (String)"InvoiceMatchEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        } else if ("cfmap".equals(operateKey)) {
            this.getView().updateView();
        } else if ("matchconfirm".equals(operateKey)) {
            this.resetInvoiceEntries();
            this.getView().invokeOperation("automatch");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("matchBillF7".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection rowList = (ListSelectedRowCollection)returnData;
            if (rowList == null) {
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("entry");
            HashSet<Object> selectIds = new HashSet<Object>(rowList.size());
            HashSet<Object> selectEntryIds = new HashSet<Object>(rowList.size());
            for (ListSelectedRow listSelectedRow : rowList) {
                selectIds.add(listSelectedRow.getPrimaryKeyValue());
                selectEntryIds.add(listSelectedRow.getEntryPrimaryKeyValue());
            }
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            BigDecimal matchedqty = (BigDecimal)this.getModel().getValue("matchedqty");
            BigDecimal matchedamt = (BigDecimal)this.getModel().getValue("matchedamt");
            BigDecimal matchedtax = (BigDecimal)this.getModel().getValue("matchedtax");
            MatchResult matchResult = MatchResult.New();
            matchResult.setMatchResultPk((Long)this.getModel().getValue("id"));
            DynamicObject dataEntity = this.getModel().getEntryRowEntity("entry", index);
            matchResult.setCurrencyId(Long.valueOf(currency.getLong("id")));
            matchResult.setMaterialId(Long.valueOf(dataEntity.getLong("material.id")));
            matchResult.setMeasureunit(Long.valueOf(dataEntity.getLong("measureunit.id")));
            matchResult.setBaseqty(dataEntity.getBigDecimal("e_baseqty").subtract(matchedqty));
            matchResult.setAmount(dataEntity.getBigDecimal("e_amount").subtract(matchedamt));
            matchResult.setTax(dataEntity.getBigDecimal("e_tax").subtract(matchedtax));
            matchResult.setPrice(dataEntity.getBigDecimal("price"));
            this.service.loadMatchBill(matchResult, selectIds, selectEntryIds);
            this.fillMatchEntry(false, matchResult, index);
        }
    }
}

