/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.helper.InvoiceCardHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.DynamicListHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class InvoiceSellerEdit
extends AbstractBillPlugIn {
    private static final String btnok = "btnok";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (parentModel.getProperty(propName) == null) continue;
            Object propValue = parentModel.getValue(propName);
            if (propValue instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)propValue;
                model.setValue(propName, obj.getPkValue());
                continue;
            }
            model.setValue(propName, propValue);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btnok, "asstactname", "sellerbank", "selleracct"});
        Long orgId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("orgId"));
        this.filterAsstact(orgId);
    }

    private void filterAsstact(Long orgId) {
        BasedataEdit baseDataCtr = (BasedataEdit)this.getControl("asstact");
        baseDataCtr.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter baseDataFilter = BaseDataHelper.getBasedataFilter((String)showParameter.getBillFormId(), (long)orgId);
            showParameter.getListFilterParameter().getQFilters().add(baseDataFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        BasedataEdit control = null;
        switch (key) {
            case "asstactname": {
                control = (BasedataEdit)this.getControl("asstact");
                control.click();
                break;
            }
            case "sellerbank": {
                control = (BasedataEdit)this.getControl("sellerbankf7");
                control.click();
                break;
            }
            case "selleracct": {
                this.sellerAcctShowF7();
                break;
            }
            case "btnok": {
                this.btnOk();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "sellerAcctCallBack": {
                this.sellerAcctCallBack(returnData);
            }
        }
    }

    private void sellerAcctCallBack(Object returnData) {
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            DynamicObject payeerInfo;
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            DynamicObject basedata = (DynamicObject)this.getModel().getValue("asstact");
            String asstactType = basedata.getDataEntityType().getName();
            if (asstactType.equals("bd_customer") || asstactType.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)asstactType, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue("selleracct", (Object)row.getString("bankaccount"));
                    this.getModel().setValue("sellerbank", (Object)row.getString("bank.name"));
                    break;
                }
            } else if (asstactType.equals("bos_user") && !ObjectUtils.isEmpty((Object)(payeerInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount")))) {
                this.getModel().setValue("selleracct", (Object)payeerInfo.getString("payeraccount"));
                this.getModel().setValue("sellerbank", (Object)payeerInfo.getString("payerbank.name"));
            }
        }
    }

    private void sellerAcctShowF7() {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("asstact");
        if (ObjectUtils.isEmpty((Object)basedata)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u65b9\u3002", (String)"InvoiceSellerEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        String asstactType = basedata.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            DynamicObject[] infos = this.getErPayeeInfo(basedata);
            if (infos == null || infos.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u76f8\u5e94\u4eba\u5458\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"InvoiceSellerEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"er_payeer", (boolean)false, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            lfp.setFilter(new QFilter("payer", "=", basedata.getPkValue()));
            lsp.setListFilterParameter(lfp);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "sellerAcctCallBack");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        } else if ("bd_customer".equals(asstactType)) {
            DynamicObjectCollection coll = DynamicListHelper.getBankCollInfo((Object)basedata.getPkValue(), (String)asstactType);
            if (coll == null || coll.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u6237\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"InvoiceSellerEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = DynamicListHelper.getCustomerBankInfoShowParameter((Object)basedata.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "sellerAcctCallBack");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        } else if ("bd_supplier".equals(asstactType)) {
            DynamicObjectCollection coll = DynamicListHelper.getBankCollInfo((Object)basedata.getPkValue(), (String)asstactType);
            if (coll == null || coll.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"InvoiceSellerEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = DynamicListHelper.getSupplierBankInfoShowParameter((Object)basedata.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "sellerAcctCallBack");
            lsp.setCloseCallBack(closeCallBack);
            BizExtendHelper.payeeBankInfoFilter((ListFilterParameter)lsp.getListFilterParameter(), (IFormView)this.getView());
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void btnOk() {
        Map resultMap = InvoiceCardHelper.initSellerParamMap((IDataModel)this.getModel());
        this.getView().returnDataToParent((Object)resultMap);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "asstactname": {
                this.sellerChanged((String)newValue);
                break;
            }
            case "asstact": {
                this.sellerF7Changed(newValue);
                break;
            }
            case "sellerbankf7": {
                this.sellerbankf7Changed(newValue);
                break;
            }
        }
    }

    private void sellerChanged(String newValue) {
        IDataModel model = this.getModel();
        if (!EmptyUtils.isEmpty((Object)newValue)) {
            QFilter qFilter;
            String asstActType = (String)model.getValue("asstacttype");
            Map collMap = BusinessDataServiceHelper.loadFromCache((String)asstActType, (String)"id,status,enable", (QFilter[])new QFilter[]{qFilter = new QFilter("name", "=", (Object)newValue)});
            if (!ObjectUtils.isEmpty((Object)collMap)) {
                for (Map.Entry entrySet : collMap.entrySet()) {
                    DynamicObject dynamicObject = (DynamicObject)entrySet.getValue();
                    String status = dynamicObject.getString("status");
                    int enable = dynamicObject.getInt("enable");
                    if (enable != 1 || !BillStatusEnum.AUDIT.getValue().equals(status)) continue;
                    model.setValue("asstact", (Object)dynamicObject.getLong("id"));
                    break;
                }
            } else {
                model.setValue("asstact", null);
            }
        } else {
            model.setValue("asstact", null);
        }
    }

    private void sellerF7Changed(Object newValue) {
        IDataModel model = this.getModel();
        DynamicObject customer = (DynamicObject)newValue;
        if (customer != null && !"bos_user".equals(model.getValue("asstacttype"))) {
            customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)model.getValue("asstacttype").toString());
            model.setValue("sellertin", (Object)customer.getString("tx_register_no"));
            model.setValue("selleraddr", (Object)customer.getString("bizpartner_address"));
            model.setValue("sellertel", (Object)customer.getString("bizpartner_phone"));
            this.setBankInfo(customer);
            model.beginInit();
            model.setValue("asstactname", (Object)customer.getString("name"));
            model.endInit();
            this.getView().updateView("asstactname");
        } else {
            model.setValue("sellertin", null);
            model.setValue("selleraddr", null);
            model.setValue("sellertel", null);
            if (customer != null && "bos_user".equals(model.getValue("asstacttype"))) {
                model.setValue("asstactname", (Object)customer.getString("name"));
                DynamicObject erPayeeInfo = this.getErPayeeInfo(customer.getLong("id"), customer.getString("name"));
                if (erPayeeInfo != null) {
                    model.setValue("selleracct", (Object)erPayeeInfo.getString("payeraccount"));
                    model.setValue("sellerbank", (Object)erPayeeInfo.getDynamicObject("payerbank").getString("name"));
                    model.setValue("sellerbankf7", erPayeeInfo.getPkValue());
                } else {
                    model.setValue("selleracct", null);
                    model.setValue("sellerbank", null);
                    model.setValue("sellerbankf7", null);
                }
            }
        }
    }

    private void setBankInfo(DynamicObject customer) {
        String acctBank = null;
        String bank = null;
        DynamicObjectCollection bankColls = customer.getDynamicObjectCollection("entry_bank");
        if (bankColls != null && bankColls.size() > 0) {
            if (bankColls.size() == 1) {
                DynamicObject bankInfo = (DynamicObject)bankColls.get(0);
                acctBank = bankInfo.getString("bankaccount");
                bank = bankInfo.getString("bank.name");
            } else {
                for (int i = 0; i < bankColls.size(); ++i) {
                    DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                    if (bankInfo.getBoolean("isdefault_bank")) {
                        acctBank = bankInfo.getString("bankaccount");
                        bank = bankInfo.getString("bank.name");
                        break;
                    }
                    if (i != 0) continue;
                    acctBank = bankInfo.getString("bankaccount");
                    bank = bankInfo.getString("bank.name");
                }
            }
        }
        this.getModel().setValue("selleracct", acctBank);
        this.getModel().setValue("sellerbank", bank);
    }

    private void sellerbankf7Changed(Object newValue) {
        DynamicObject bank = (DynamicObject)newValue;
        if (bank != null) {
            this.getModel().setValue("sellerbank", bank.get("name"));
        }
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("name", "=", (Object)name);
        uFilter = uFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        uFilter.and(new QFilter("payer", "=", (Object)userId));
        QFilter[] qFilters = new QFilter[]{uFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        String orderBys = "isdefault desc";
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private DynamicObject[] getErPayeeInfo(DynamicObject basedata) {
        QFilter uFilter = new QFilter("name", "=", (Object)basedata.getString("name"));
        uFilter = uFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        uFilter.and(new QFilter("payer", "=", (Object)basedata.getLong("id")));
        QFilter[] qFilters = new QFilter[]{uFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        String orderBys = "isdefault desc";
        Map defaultAccountMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)orderBys);
        return defaultAccountMap.values().toArray(new DynamicObject[0]);
    }
}

